/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXPanel;
import pt.lsts.neptus.gui.system.SymbolLabel;
import pt.lsts.neptus.util.GuiUtils;

public class TaskSymbol
extends SymbolLabel {
    @Override
    protected void initialize() {
        this.setSize(10, 10);
        this.setPreferredSize(new Dimension(10, 10));
        super.initialize();
    }

    @Override
    public void paint(Graphics2D g, JXPanel c, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.scale((double)width / 10.0, (double)height / 10.0);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, 10.0, 10.0, 0.0, 0.0);
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fill(rect);
        if (this.isActive()) {
            GeneralPath sp = new GeneralPath();
            sp.moveTo(2.0f, 8.0f);
            sp.lineTo(8.0f, 2.0f);
            g2.setColor(this.getActiveColor());
            g2.draw(sp);
            g2.translate(6, 4);
            g2.rotate(Math.toRadians(45.0));
            sp = new GeneralPath();
            sp.moveTo(-2.5, 0.25);
            sp.lineTo(2.5, 0.25);
            sp.lineTo(2.5, -1.75);
            sp.lineTo(-2.5, -1.75);
            sp.closePath();
            g2.fill(sp);
            g2.draw(sp);
        }
    }

    public static void main(String[] args) {
        TaskSymbol symb1 = new TaskSymbol();
        symb1.setSize(50, 50);
        symb1.setActive(true);
        JXPanel panel = new JXPanel();
        panel.setBackground(Color.GRAY.darker());
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)((Object)symb1), (Object)"Center");
        GuiUtils.testFrame((JComponent)panel, "", 400, 400);
    }
}

