/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXPanel;
import pt.lsts.neptus.gui.system.SymbolLabel;
import pt.lsts.neptus.util.GuiUtils;

public class UAVSymbol
extends SymbolLabel {
    @Override
    protected void initialize() {
        this.active = true;
        this.setSize(10, 10);
        this.setPreferredSize(new Dimension(10, 10));
        super.initialize();
        this.blinkOnChange = false;
    }

    @Override
    public void paint(Graphics2D g, JXPanel c, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.scale((double)width / 10.0, (double)height / 10.0);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, 10.0, 10.0, 0.0, 0.0);
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fill(rect);
        if (this.isActive()) {
            GeneralPath sp = new GeneralPath();
            g2.translate(5, 5);
            g2.scale(0.5, 0.5);
            int width1 = 20;
            int height1 = width1 / 2;
            sp.moveTo(width1 / 4, height1 / 3);
            sp.lineTo(width1 / 4, height1 / 3);
            sp.curveTo(width1 / 2 + 1, height1 / 3, width1 / 2 + 1, -height1 / 8, width1 / 4, -height1 / 8);
            sp.lineTo(width1 / 4 - 2, -height1 / 8);
            sp.lineTo(width1 / 4 - 6, -height1 / 8 - 6);
            sp.lineTo(width1 / 4 - 8, -height1 / 8 - 6);
            sp.lineTo(width1 / 4 - 8, -height1 / 8);
            sp.lineTo(-width1 / 4 - 1, -height1 / 8);
            sp.lineTo(-width1 * 5 / 12, -height1 / 2);
            sp.lineTo(-width1 / 2, -height1 / 2);
            sp.lineTo(-width1 / 2, 0.0f);
            sp.lineTo(-width1 / 4, height1 / 3);
            sp.closePath();
            g2.setColor(this.getActiveColor());
            g2.fill(sp);
            g2.draw(sp);
        }
    }

    public static void main(String[] args) {
        UAVSymbol symb1 = new UAVSymbol();
        symb1.setActive(true);
        symb1.setSize(50, 50);
        JXPanel panel = new JXPanel();
        panel.setBackground(Color.BLACK);
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)((Object)symb1), (Object)"Center");
        GuiUtils.testFrame((JComponent)panel, "", 400, 400);
    }
}

