/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system.btn;

import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import pt.lsts.neptus.gui.system.img.MainIcon;
import pt.lsts.neptus.gui.system.img.SelectionIcon;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.GuiUtils;

public class SystemsSelectionAction
extends AbstractAction {
    private String tooltipPrefix = "";
    private Hashtable<SelectionType, Icon> icons = new Hashtable();
    private SelectionType current = SelectionType.MAIN;

    public SystemsSelectionAction(String tooltipPrefix, int iconSize) {
        this.tooltipPrefix = tooltipPrefix + (tooltipPrefix.length() == 0 || tooltipPrefix.endsWith(" ") ? "" : " ");
        if (iconSize < 10) {
            iconSize = 10;
        }
        this.icons.put(SelectionType.MAIN, new MainIcon(iconSize));
        this.icons.put(SelectionType.SELECTION, new SelectionIcon(iconSize));
        this.updateActionAndIcon();
    }

    public SystemsSelectionAction(String tooltipPrefix) {
        this(tooltipPrefix, 32);
    }

    public SystemsSelectionAction(int iconSize) {
        this("", iconSize);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.current = SelectionType.getNextSelectionTypeFromString(this.current.getType());
        this.updateActionAndIcon();
    }

    private void updateActionAndIcon() {
        this.putValue("SmallIcon", this.icons.get((Object)this.current));
        this.putValue("ShortDescription", this.tooltipPrefix + this.current.getType());
    }

    public SelectionType getSelectionType() {
        return this.current;
    }

    public static boolean getClearSelectionOption(ActionEvent ev) {
        return (ev.getModifiers() & 2) == 2;
    }

    public static void main(String[] args) {
        SystemsSelectionAction action = new SystemsSelectionAction(100);
        JButton but = new JButton(action);
        GuiUtils.testFrame(but);
    }

    public static enum SelectionType {
        MAIN(I18n.text("Main")),
        SELECTION(I18n.text("Selection"));

        private String type = "Main";

        private SelectionType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static SelectionType getSelectionTypeFromString(String type) {
            for (SelectionType elem : SelectionType.values()) {
                if (!elem.getType().equalsIgnoreCase(type)) continue;
                return elem;
            }
            return MAIN;
        }

        public static SelectionType getNextSelectionTypeFromString(String type) {
            boolean returnNext = false;
            for (SelectionType elem : SelectionType.values()) {
                if (returnNext) {
                    return elem;
                }
                if (!elem.getType().equalsIgnoreCase(type)) continue;
                returnNext = true;
            }
            return MAIN;
        }
    }
}

