/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system.img;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JButton;
import pt.lsts.neptus.util.GuiUtils;

public class SelectionIcon
implements Icon {
    protected boolean isSelectionOrMain = true;
    private double diam;
    private double margin;

    public SelectionIcon(int diameter, int margin) {
        this.diam = diameter;
        this.margin = margin;
    }

    public SelectionIcon(int diameter) {
        this(diameter, 0);
    }

    @Override
    public int getIconWidth() {
        return (int)(this.diam + this.margin * 2.0);
    }

    @Override
    public int getIconHeight() {
        return this.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics gr, int x, int y) {
        Graphics2D g2 = (Graphics2D)gr.create();
        g2.translate(x, y);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.scale((double)this.getIconWidth() / 32.0, (double)this.getIconHeight() / 32.0);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, 32.0, 32.0, 0.0, 0.0);
        g2.setColor(this.isSelectionOrMain ? new Color(255, 127, 0).brighter() : Color.GREEN.darker());
        g2.fill(rect);
        g2.translate(16, 16);
        g2.setColor(Color.WHITE);
        g2.setFont(new Font("Arial", 1, 30));
        if (this.isSelectionOrMain) {
            g2.drawString("S", -10, 10);
        } else {
            g2.drawString("M", -13, 10);
        }
    }

    public static void main(String[] args) {
        SelectionIcon icon = new SelectionIcon(100);
        JButton but = new JButton(icon);
        GuiUtils.testFrame(but);
    }
}

