/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system.selection;

import com.google.common.eventbus.Subscribe;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComboBoxUI;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.events.ConsoleEventNewSystem;
import pt.lsts.neptus.console.events.ConsoleEventVehicleStateChanged;
import pt.lsts.neptus.events.NeptusEvents;
import pt.lsts.neptus.i18n.I18n;

public class MainSystemSelectionCombo
extends JComboBox<String>
implements ItemListener {
    private static final Color DEFAULT_COLOR = new Color(12169023);
    private static final Color DEFAULT_SEL_COLOR = new Color(13156191);
    private static final Color CALIBRATION_COLOR = new Color(3174801);
    private static final Color CALIBRATION_SEL_COLOR = new Color(3835821);
    private static final Color ERROR_COLOR = new Color(10633022);
    private static final Color ERROR_SEL_COLOR = new Color(12143176);
    private static final Color SERVICE_COLOR = new Color(5748584);
    private static final Color SERVICE_SEL_COLOR = new Color(8109447);
    private static final Color MANEUVER_COLOR = new Color(13818442);
    private static final Color MANEUVER_SEL_COLOR = new Color(15199853);
    private static final Color BOOT_COLOR = new Color(1256146);
    private static final Color BOOT_SEL_COLOR = new Color(255);
    private static final Color DISCONNECTED_COLOR = new Color(0x757575);
    private static final Color DISCONNECTED_SEL_COLOR = new Color(9737628);
    private ConsoleLayout console;
    private Map<String, ConsoleEventVehicleStateChanged.STATE> systemState = new ConcurrentHashMap<String, ConsoleEventVehicleStateChanged.STATE>();

    public MainSystemSelectionCombo(ConsoleLayout console) {
        this.console = console;
        NeptusEvents.register(this, console);
        this.setSize(200, 50);
        this.setMinimumSize(new Dimension(200, 50));
        this.setMaximumSize(new Dimension(200, 50));
        this.setRenderer(new MainSystemRenderer());
        this.addItemListener(this);
        this.setFont(new Font("SansSerif", 0, 12));
        this.setUI((ComboBoxUI)new WindowsComboBoxUI());
        this.setFocusable(false);
    }

    @Subscribe
    public void onNewSystem(ConsoleEventNewSystem e) {
        this.systemState.put(e.getSystem().getVehicleId(), e.getSystem().getVehicleState());
        this.addItem(e.getSystem().getVehicleId());
    }

    @Subscribe
    public void onVehicleStateChanged(ConsoleEventVehicleStateChanged e) {
        try {
            this.systemState.put(e.getVehicle(), e.getState());
            if (this.console.getMainSystem().equals(e.getVehicle())) {
                switch (e.getState()) {
                    case SERVICE: {
                        this.setBackground(SERVICE_COLOR);
                        break;
                    }
                    case ERROR: {
                        this.setBackground(ERROR_COLOR);
                        break;
                    }
                    case CALIBRATION: {
                        this.setBackground(CALIBRATION_COLOR);
                        break;
                    }
                    case MANEUVER: {
                        this.setBackground(MANEUVER_COLOR);
                        break;
                    }
                    case TELEOPERATION: {
                        this.setBackground(MANEUVER_COLOR);
                        break;
                    }
                    case BOOT: {
                        this.setBackground(BOOT_COLOR);
                        break;
                    }
                    case DISCONNECTED: {
                        this.setBackground(DISCONNECTED_COLOR);
                        break;
                    }
                    default: {
                        this.setBackground(DEFAULT_COLOR);
                    }
                }
            }
            this.repaint();
        }
        catch (Exception e1) {
            NeptusLog.pub().warn((Object)e);
        }
    }

    @Subscribe
    public void onMainSystemChange(ConsoleEventMainSystemChange e) {
        try {
            this.setSelectedItem(e.getCurrent());
            switch (this.console.getSystem(e.getCurrent()).getVehicleState()) {
                case SERVICE: {
                    this.setBackground(SERVICE_COLOR);
                    break;
                }
                case ERROR: {
                    this.setBackground(ERROR_COLOR);
                    break;
                }
                case CALIBRATION: {
                    this.setBackground(CALIBRATION_COLOR);
                    break;
                }
                case MANEUVER: {
                    this.setBackground(MANEUVER_COLOR);
                    break;
                }
                case TELEOPERATION: {
                    this.setBackground(MANEUVER_COLOR);
                    break;
                }
                case BOOT: {
                    this.setBackground(BOOT_COLOR);
                    break;
                }
                case DISCONNECTED: {
                    this.setBackground(DISCONNECTED_COLOR);
                    break;
                }
                default: {
                    this.setBackground(DEFAULT_COLOR);
                    break;
                }
            }
        }
        catch (Exception e1) {
            NeptusLog.pub().warn((Object)e);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.console.setMainSystem(this.getSelectedItem().toString());
        }
    }

    private class MainSystemRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        public MainSystemRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setPreferredSize(new Dimension(270, 25));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            if (MainSystemSelectionCombo.this.systemState.isEmpty()) {
                return this;
            }
            if (isSelected) {
                if (MainSystemSelectionCombo.this.systemState.get(value) != null) {
                    switch ((ConsoleEventVehicleStateChanged.STATE)((Object)MainSystemSelectionCombo.this.systemState.get(value))) {
                        case SERVICE: {
                            this.setBackground(SERVICE_SEL_COLOR);
                            break;
                        }
                        case ERROR: {
                            this.setBackground(ERROR_SEL_COLOR);
                            break;
                        }
                        case CALIBRATION: {
                            this.setBackground(CALIBRATION_SEL_COLOR);
                            break;
                        }
                        case MANEUVER: {
                            this.setBackground(MANEUVER_SEL_COLOR);
                            break;
                        }
                        case TELEOPERATION: {
                            this.setBackground(MANEUVER_SEL_COLOR);
                            break;
                        }
                        case BOOT: {
                            this.setBackground(BOOT_SEL_COLOR);
                            break;
                        }
                        case DISCONNECTED: {
                            this.setBackground(DISCONNECTED_SEL_COLOR);
                            break;
                        }
                        default: {
                            this.setBackground(DEFAULT_SEL_COLOR);
                        }
                    }
                    this.setForeground(list.getSelectionForeground());
                }
            } else if (MainSystemSelectionCombo.this.systemState.get(value) != null) {
                switch ((ConsoleEventVehicleStateChanged.STATE)((Object)MainSystemSelectionCombo.this.systemState.get(value))) {
                    case SERVICE: {
                        this.setBackground(SERVICE_COLOR);
                        break;
                    }
                    case ERROR: {
                        this.setBackground(ERROR_COLOR);
                        break;
                    }
                    case CALIBRATION: {
                        this.setBackground(CALIBRATION_COLOR);
                        break;
                    }
                    case MANEUVER: {
                        this.setBackground(MANEUVER_COLOR);
                        break;
                    }
                    case TELEOPERATION: {
                        this.setBackground(MANEUVER_COLOR);
                        break;
                    }
                    case BOOT: {
                        this.setBackground(BOOT_COLOR);
                        break;
                    }
                    case DISCONNECTED: {
                        this.setBackground(DISCONNECTED_COLOR);
                        break;
                    }
                    default: {
                        this.setBackground(DEFAULT_COLOR);
                    }
                }
                this.setForeground(list.getForeground());
            }
            if (value != null) {
                this.setFont(new Font("SansSerif", 0, 12));
            }
            this.setText(" " + value.toUpperCase() + ": " + I18n.text(((ConsoleEventVehicleStateChanged.STATE)((Object)MainSystemSelectionCombo.this.systemState.get(value))).toString()));
            return this;
        }
    }
}

