/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.i18n;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.PoFile;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class I18n {
    public static final String I18N_BASE_LOCALIZATION = "conf/i18n/";
    protected String defaultLanguage;
    protected String language;
    protected static Pattern substitutionStringPattern = Pattern.compile("(%[\\w]+)");
    protected static I18n instance = null;
    protected static String appendedText = "";
    public static Pattern localeStringPattern = Pattern.compile("([a-z]{2})(_[A-Z]{2})?");
    protected PoFile po;

    private I18n(String language) {
        this.language = this.defaultLanguage = "en_US";
        this.po = null;
        this.language = language;
        this.init();
    }

    protected void init() {
        NeptusLog.pub().info((Object)("I18n (trying): " + this.language));
        File localizationDir = new File(I18N_BASE_LOCALIZATION + this.language);
        Matcher m = localeStringPattern.matcher(this.language);
        boolean found = false;
        if (new File(localizationDir, "neptus.po").canRead()) {
            found = true;
        } else if (new File("../conf/i18n/" + this.language, "neptus.po").canRead()) {
            found = true;
            localizationDir = new File("../conf/i18n/" + this.language);
        } else if (m.find() && (new File(I18N_BASE_LOCALIZATION + m.group(1), "neptus.po").canRead() || new File("../conf/i18n/" + m.group(1), "neptus.po").canRead())) {
            found = true;
            this.language = m.group(1);
            localizationDir = new File(I18N_BASE_LOCALIZATION + this.language);
            if (!localizationDir.exists()) {
                localizationDir = new File("../conf/i18n/" + this.language);
            }
            GeneralPreferences.language = this.language;
        } else {
            this.language = this.defaultLanguage;
            localizationDir = new File(I18N_BASE_LOCALIZATION + this.language);
            GeneralPreferences.language = this.language;
        }
        NeptusLog.pub().info((Object)("I18n (" + (found ? "found" : "using") + "):  " + this.language));
        if (new File(localizationDir, "neptus.po").canRead()) {
            this.po = new PoFile();
            try {
                this.po.load(new File(I18N_BASE_LOCALIZATION + this.language + "/neptus.po"));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.po = null;
            }
        }
    }

    protected static I18n getInstance() {
        if (instance == null) {
            String language = GeneralPreferences.language;
            if (language == null) {
                language = "en";
            }
            instance = new I18n(language);
            instance.applyI18nJavaStdComponentsOverrides();
        }
        return instance;
    }

    protected String localize(String key, String englishDefault) {
        String localized = englishDefault;
        if (this.po != null && this.po.getTranslation(key) != null) {
            localized = this.po.getTranslation(key);
        }
        return appendedText + localized;
    }

    protected String localizeAdvanced(String key, String englishDefault, Class<?> requester) {
        String localized = englishDefault;
        String requestingClass = requester.getName();
        if (requestingClass.contains("$")) {
            requestingClass = requestingClass.substring(0, requestingClass.indexOf("$"));
        }
        return appendedText + localized;
    }

    private void applyI18nJavaStdComponentsOverrides() {
        UIDefaults defaults = UIManager.getDefaults();
        defaults.put("Label.foreground", Color.black);
        defaults.put("Label.disabledForeground", new Color(51, 51, 51));
        defaults.put("TextArea.foreground", Color.black);
        defaults.put("TextArea.inactiveForeground", new Color(51, 51, 51));
        UIManager.put("OptionPane.yesButtonText", I18n.text("Yes"));
        UIManager.put("OptionPane.noButtonText", I18n.text("No"));
        UIManager.put("OptionPane.okButtonText", I18n.text("OK"));
        UIManager.put("OptionPane.cancelButtonText", I18n.text("Cancel"));
        UIManager.put("OptionPane.titleText", I18n.text("Select an Option"));
        UIManager.put("OptionPane.inputDialogTitle", I18n.text("Input"));
        UIManager.put("ProgressMonitor.progressText", I18n.text("Progress..."));
        UIManager.put("FileChooser.acceptAllFileFilterText", I18n.text("All Files"));
        UIManager.put("FileChooser.lookInLabelText", I18n.text("Look In:"));
        UIManager.put("FileChooser.cancelButtonText", I18n.text("Cancel"));
        UIManager.put("FileChooser.cancelButtonToolTipText", I18n.text("Cancel"));
        UIManager.put("FileChooser.openButtonText", I18n.text("Open"));
        UIManager.put("FileChooser.openButtonToolTipText", I18n.text("Open"));
        UIManager.put("FileChooser.saveButtonText", I18n.text("Save"));
        UIManager.put("FileChooser.saveButtonToolTipText", I18n.text("Save"));
        UIManager.put("FileChooser.updateButtonText", I18n.text("Update"));
        UIManager.put("FileChooser.updateButtonToolTipText", I18n.text("Update"));
        UIManager.put("FileChooser.helpButtonText", I18n.text("Help"));
        UIManager.put("FileChooser.helpButtonToolTipText", I18n.text("Help"));
        UIManager.put("FileChooser.newFolderToolTipText", I18n.text("New Folder"));
        UIManager.put("FileChooser.newFileToolTipText", I18n.text("New File"));
        UIManager.put("FileChooser.filesOfTypeLabelText", I18n.text("Files of Type:"));
        UIManager.put("FileChooser.fileNameLabelText", I18n.text("File Name:"));
        UIManager.put("FileChooser.folderNameLabelText", I18n.text("Folder Name:"));
        UIManager.put("FileChooser.listViewButtonToolTipText", I18n.text("List"));
        UIManager.put("FileChooser.listViewButtonAccessibleName", I18n.text("List"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", I18n.text("Details"));
        UIManager.put("FileChooser.detailsViewButtonAccessibleName", I18n.text("Details"));
        UIManager.put("FileChooser.upFolderToolTipText", I18n.text("Up One Level"));
        UIManager.put("FileChooser.upFolderAccessibleName", I18n.text("Up One Level"));
        UIManager.put("FileChooser.homeFolderToolTipText", I18n.textc("Home", "File system Home folder"));
        UIManager.put("FileChooser.homeFolderAccessibleName", I18n.textc("Home", "File system Home folder"));
        UIManager.put("FileChooser.desktopFolderToolTipText", I18n.text("Desktop"));
        UIManager.put("FileChooser.desktopFolderAccessibleName", I18n.text("Desktop"));
        UIManager.put("FileChooser.fileNameHeaderText", I18n.text("Name"));
        UIManager.put("FileChooser.fileSizeHeaderText", I18n.text("Size"));
        UIManager.put("FileChooser.fileTypeHeaderText", I18n.text("Type"));
        UIManager.put("FileChooser.fileDateHeaderText", I18n.text("Modified"));
        UIManager.put("FileChooser.fileAttrHeaderText", I18n.text("Attributes"));
        UIManager.put("FileChooser.openDialogTitleText", I18n.text("Open"));
        UIManager.put("PropertySheetPanel.okButtonText", I18n.text("OK"));
        UIManager.put("PropertySheetPanel.cancelButtonText", I18n.text("Cancel"));
        UIManager.put("ColorChooser.titleText", I18n.text("Pick a Color"));
        UIManager.put("ColorChooser.okText", I18n.text("OK"));
        UIManager.put("ColorChooser.cancelText", I18n.text("Cancel"));
        UIManager.put("ColorChooser.resetText", I18n.text("Reset"));
        UIManager.put("ColorChooser.sampleText", I18n.text("Sample Text"));
        UIManager.put("ColorChooser.previewText", I18n.text("Preview"));
        UIManager.put("ColorChooser.background", ColorUIResource.darkGray);
        UIManager.put("ColorChooser.swatchesNameText", I18n.text("Swatches"));
        UIManager.put("ColorChooser.hsvNameText", I18n.textc("HSV", "Color scheme"));
        UIManager.put("ColorChooser.hslNameText", I18n.textc("HSL", "Color scheme"));
        UIManager.put("ColorChooser.rgbNameText", I18n.textc("RGB", "Color scheme"));
        UIManager.put("ColorChooser.cmykNameText", I18n.textc("CMYK", "Color scheme"));
        UIManager.put("ColorChooser.swatchesRecentText", I18n.text("Recent:"));
        UIManager.put("ColorChooser.hsvHueText", I18n.text("Hue"));
        UIManager.put("ColorChooser.hsvSaturationText", I18n.text("Saturation"));
        UIManager.put("ColorChooser.hsvValueText", I18n.text("Value"));
        UIManager.put("ColorChooser.hsvTransparencyText", I18n.text("Transparency"));
        UIManager.put("ColorChooser.hslHueText", I18n.text("Hue"));
        UIManager.put("ColorChooser.hslSaturationText", I18n.text("Saturation"));
        UIManager.put("ColorChooser.hslLightnessText", I18n.text("Lightness"));
        UIManager.put("ColorChooser.hslTransparencyText", I18n.text("Transparency"));
        UIManager.put("ColorChooser.rgbRedText", I18n.text("Red"));
        UIManager.put("ColorChooser.rgbGreenText", I18n.text("Green"));
        UIManager.put("ColorChooser.rgbBlueText", I18n.text("Blue"));
        UIManager.put("ColorChooser.rgbAlphaText", I18n.text("Alpha"));
        UIManager.put("ColorChooser.colorCodeText", I18n.text("Color Code"));
        UIManager.put("ColorChooser.cmykCyanText", I18n.text("Cyan"));
        UIManager.put("ColorChooser.cmykMagentaText", I18n.text("Magenta"));
        UIManager.put("ColorChooser.cmykYellowText", I18n.text("Yellow"));
        UIManager.put("ColorChooser.cmykBlackText", I18n.text("Black"));
        UIManager.put("ColorChooser.cmykAlphaText", I18n.text("Alpha"));
        UIManager.put("AbstractUndoableEdit.redoText", I18n.text("Redo"));
        UIManager.put("AbstractUndoableEdit.undoText", I18n.text("Undo"));
    }

    public static String normalize(String text) {
        return text;
    }

    public static String text(String englishDefault) {
        return I18n.getInstance().localize(englishDefault, englishDefault);
    }

    public static String textc(String englishDefault, String context) {
        return I18n.getInstance().localize(I18n.normalize(englishDefault) + I18n.normalize(context), englishDefault);
    }

    @Deprecated
    public static String textf(String englishDefault) {
        return null;
    }

    @Deprecated
    public static String textfc(String englishDefault, String context) {
        return null;
    }

    public static String textf(String englishDefault, Object ... parameters) {
        return I18n.textfWorker(englishDefault, "", parameters);
    }

    public static String textfc(String englishDefault, String context, Object ... parameters) {
        return I18n.textfWorker(englishDefault, context, parameters);
    }

    public static String textmark(String englishDefault) {
        return englishDefault;
    }

    public static String textmarkc(String englishDefault, String context) {
        return englishDefault;
    }

    private static String textfWorker(String englishDefault, String context, Object ... parameters) {
        String text = I18n.getInstance().localize(I18n.normalize(englishDefault) + (context != null && context.length() > 0 ? I18n.normalize(context) : ""), englishDefault);
        Matcher matcher = substitutionStringPattern.matcher(englishDefault);
        int i = 0;
        LinkedHashMap<String, String> replaces = new LinkedHashMap<String, String>();
        while (matcher.find() && i < parameters.length) {
            replaces.put(matcher.group(1), parameters[i++].toString());
        }
        for (String k : replaces.keySet()) {
            text = text.replaceAll(k, (String)replaces.get(k));
        }
        return text;
    }

    public static String textAdvanced(String key, String englishDefault, Class<?> requester) {
        return I18n.getInstance().localizeAdvanced(key, englishDefault, requester);
    }

    public static void setDebugPrefix(String prefix) {
        appendedText = prefix;
    }

    public static void main(String[] args) {
        UIDefaults uiDefaults = UIManager.getDefaults();
        ArrayList<String> lst = new ArrayList<String>();
        Enumeration enum1 = uiDefaults.keys();
        while (enum1.hasMoreElements()) {
            lst.add(enum1.nextElement().toString());
        }
        Collections.sort(lst);
        for (Object e : lst) {
            Object val = uiDefaults.get(e);
            NeptusLog.pub().info((Object)("<###>[" + e.toString() + "]:[" + (null != val ? val.toString() : "(null)") + "]"));
        }
    }
}

