/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.i18n;

import com.l2fprod.common.propertysheet.DefaultProperty;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import pt.lsts.imc.Announce;
import pt.lsts.imc.Goto;
import pt.lsts.imc.Loiter;
import pt.lsts.imc.PlanControlState;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.console.events.ConsoleEventVehicleStateChanged;
import pt.lsts.neptus.console.plugins.SystemsList;
import pt.lsts.neptus.console.plugins.planning.MapPanel;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.system.SystemDisplayComparator;
import pt.lsts.neptus.i18n.Translate;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.tiles.Tile;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.FileUtil;

public class PluginsPotGenerator {
    protected static final String outFile = "conf/i18n//neptus.pot";
    protected static final String inFile = "dev-scripts/i18n/empty.pot";

    public static Vector<AbstractElement> mapElements() {
        return MapType.getMapElements();
    }

    public static Vector<Class<?>> enums() {
        Vector enums = new Vector();
        enums.add(Announce.SYS_TYPE.class);
        enums.add(ConsoleEventVehicleStateChanged.STATE.class);
        enums.add(ImcSystem.IMCAuthorityState.class);
        enums.add(Goto.SPEED_UNITS.class);
        enums.add(Loiter.TYPE.class);
        enums.add(MapPanel.PlacementEnum.class);
        enums.add(PlanControlState.STATE.class);
        enums.add(SystemDisplayComparator.OrderOptionEnum.class);
        enums.add(SystemsList.SortOrderEnum.class);
        enums.add(SystemsList.MilStd2525SymbolsFilledEnum.class);
        enums.add(VehicleType.SystemTypeEnum.class);
        enums.add(VehicleType.VehicleTypeEnum.class);
        enums.add(ManeuverLocation.Z_UNITS.class);
        enums.add(Tile.TileState.class);
        return enums;
    }

    public static List<String> customStrings() {
        ArrayList<String> strs = new ArrayList<String>();
        strs.add("Normal");
        strs.add("Map");
        strs.add("Infinite Rectangle");
        strs.add("Rows Plan");
        strs.add("Console Settings");
        return strs;
    }

    public static void listClasses(Vector<Class<?>> classes, String packageName, File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                if (packageName.isEmpty()) {
                    PluginsPotGenerator.listClasses(classes, f.getName(), f);
                    continue;
                }
                PluginsPotGenerator.listClasses(classes, packageName + "." + f.getName(), f);
                continue;
            }
            if (!FileUtil.getFileExtension(f).equals("java")) continue;
            String className = (packageName.isEmpty() ? "" : packageName + ".") + f.getName().substring(0, f.getName().indexOf("."));
            try {
                classes.add(Class.forName(className, false, Thread.currentThread().getContextClassLoader()));
            }
            catch (Exception e) {
            }
            catch (Error e) {
                // empty catch block
            }
        }
    }

    public static Vector<Class<?>> getAllClasses() {
        Vector classes = new Vector();
        PluginsPotGenerator.listClasses(classes, "", new File("src"));
        File pluginsDir = new File("plugins-dev");
        for (File f : pluginsDir.listFiles()) {
            PluginsPotGenerator.listClasses(classes, "", f);
        }
        return classes;
    }

    public static LinkedHashMap<String, DefaultProperty> getProperties(Class<?> clazz) {
        LinkedHashMap<String, DefaultProperty> props = new LinkedHashMap<String, DefaultProperty>();
        for (Field f : clazz.getFields()) {
            NeptusProperty a = f.getAnnotation(NeptusProperty.class);
            if (a == null) continue;
            String name = a.name();
            String desc = a.description();
            String category = a.category();
            if (a.name().length() == 0) {
                name = f.getName();
            }
            if (a.description().length() == 0) {
                desc = name;
            }
            if (category == null || category.length() == 0) {
                category = "Base";
            }
            props.put(name, PropertiesEditor.getPropertyInstance(name, category, String.class, "", true, desc));
        }
        return props;
    }

    public static String escapeQuotes(String text) {
        text = text.replaceAll("\"", "'");
        text = text.replaceAll("\n", "\\\\n");
        return text;
    }

    public static void main(String[] args) throws Exception {
        String line;
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outFile)));
        BufferedReader reader = new BufferedReader(new FileReader(new File(inFile)));
        while ((line = reader.readLine()) != null) {
            writer.write(line + "\n");
        }
        reader.close();
        Vector<Class<?>> classes = PluginsPotGenerator.getAllClasses();
        for (Class<?> c : classes) {
            try {
                PluginDescription pd = c.getAnnotation(PluginDescription.class);
                if (!pd.name().isEmpty()) {
                    writer.write("#: Name of plugin " + c.getName() + "\n");
                    writer.write("msgid \"" + PluginsPotGenerator.escapeQuotes(pd.name()) + "\"\n");
                    writer.write("msgstr \"\"\n\n");
                }
                if (!pd.description().isEmpty()) {
                    writer.write("#: Description of plugin " + c.getName() + "\n");
                    writer.write("msgid \"" + PluginsPotGenerator.escapeQuotes(pd.description()) + "\"\n");
                    writer.write("msgstr \"\"\n\n");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                LinkedHashMap<String, DefaultProperty> props = PluginsPotGenerator.getProperties(c);
                for (DefaultProperty dp : props.values()) {
                    writer.write("#: Property from " + c.getName() + "\n");
                    writer.write("msgid \"" + PluginsPotGenerator.escapeQuotes(dp.getName()) + "\"\n");
                    writer.write("msgstr \"\"\n\n");
                    if (dp.getShortDescription().equals(dp.getName())) continue;
                    writer.write("#: Description of property '" + dp.getDisplayName() + "' from " + c.getName() + "\n");
                    writer.write("msgid \"" + PluginsPotGenerator.escapeQuotes(dp.getShortDescription()) + "\"\n");
                    writer.write("msgstr \"\"\n\n");
                }
            }
            catch (Exception e) {
            }
            catch (Error e) {
            }
        }
        for (AbstractElement elem : PluginsPotGenerator.mapElements()) {
            writer.write("#: Map element type (class " + elem.getClass().getSimpleName() + ")\n");
            writer.write("msgid \"" + elem.getType() + "\"\n");
            writer.write("msgstr \"\"\n\n");
        }
        Vector<Class<?>> enums = PluginsPotGenerator.enums();
        Reflections ref = new Reflections("pt.lsts.neptus.plugins", new Scanner[0]);
        for (Class clazz : ref.getTypesAnnotatedWith(Translate.class)) {
            if (clazz.getEnumConstants() == null) continue;
            enums.add(clazz);
        }
        for (Class clazz : enums) {
            for (Object o : clazz.getEnumConstants()) {
                String name = clazz.getSimpleName();
                if (clazz.getEnclosingClass() != null) {
                    name = clazz.getEnclosingClass().getSimpleName() + "." + name;
                }
                writer.write("#: Field from " + name + " enumeration\n");
                writer.write("msgid \"" + o + "\"\n");
                writer.write("msgstr \"\"\n\n");
            }
        }
        for (String string : PluginsPotGenerator.customStrings()) {
            writer.write("#: Custom String \n");
            writer.write("msgid \"" + string + "\"\n");
            writer.write("msgstr \"\"\n\n");
        }
        writer.close();
    }
}

