/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.i18n;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;

public class PoFile {
    protected static Pattern pattern = Pattern.compile("\"([^\"]*)\"");
    protected LinkedHashMap<String, String> translations = new LinkedHashMap();

    protected String getTranslation(String key) {
        return this.translations.get(key);
    }

    protected void addEntry(PoEntry entry) {
        if (entry.msgid == null || entry.msgid.isEmpty()) {
            return;
        }
        this.translations.put(entry.getKey(), entry.getTranslation());
    }

    protected void load(File location) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(location), "UTF-8"));
        PoEntry curEntry = new PoEntry();
        LAST_TYPE lastType = LAST_TYPE.CTXT;
        while ((line = reader.readLine()) != null) {
            Matcher matcher;
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            if (line.startsWith("msgid")) {
                lastType = LAST_TYPE.ID;
                if (curEntry.msgid != null) {
                    this.addEntry(curEntry);
                    curEntry = new PoEntry();
                }
                if ((matcher = pattern.matcher(line)).find()) {
                    curEntry.msgid = matcher.group(1);
                    continue;
                }
                curEntry.msgid = "";
                continue;
            }
            if (line.startsWith("msgstr")) {
                lastType = LAST_TYPE.STR;
                matcher = pattern.matcher(line);
                if (matcher.find()) {
                    curEntry.msgstr = matcher.group(1);
                    continue;
                }
                curEntry.msgstr = "";
                continue;
            }
            if (line.startsWith("msgctxt")) {
                lastType = LAST_TYPE.CTXT;
                if (curEntry.msgctxt != null || curEntry.msgid != null) {
                    this.addEntry(curEntry);
                    curEntry = new PoEntry();
                }
                if ((matcher = pattern.matcher(line)).find()) {
                    curEntry.msgctxt = matcher.group(1);
                    continue;
                }
                curEntry.msgctxt = "";
                continue;
            }
            if (!line.startsWith("\"")) continue;
            matcher = pattern.matcher(line);
            String text = "";
            if (matcher.find()) {
                text = matcher.group(1);
            }
            switch (lastType) {
                case CTXT: {
                    curEntry.msgctxt = curEntry.msgctxt + text;
                    break;
                }
                case STR: {
                    curEntry.msgstr = curEntry.msgstr + text;
                    break;
                }
                case ID: {
                    curEntry.msgid = curEntry.msgid + text;
                    break;
                }
            }
        }
        reader.close();
        NeptusLog.pub().info((Object)("Loaded " + this.translations.size() + " translations."));
    }

    public static void main(String[] args) throws Exception {
        PoFile file = new PoFile();
        file.load(new File("conf/i18n/neptus.pot"));
        for (String key : file.translations.keySet()) {
            NeptusLog.pub().info((Object)("<###> " + key + "=" + file.translations.get(key)));
        }
        NeptusLog.pub().info((Object)"<###>\n\n______________________________________________________________\n\n");
        file = new PoFile();
        file.load(new File("conf/i18n/pt/neptus.po"));
        for (String key : file.translations.keySet()) {
            NeptusLog.pub().info((Object)("<###> " + key + "=" + file.translations.get(key)));
        }
    }

    private class PoEntry
    implements Comparable<PoEntry> {
        public String msgid = null;
        public String msgstr = null;
        public String msgctxt = null;

        private PoEntry() {
        }

        public String getKey() {
            if (this.msgctxt != null) {
                return I18n.normalize(this.msgid) + I18n.normalize(this.msgctxt);
            }
            return I18n.normalize(this.msgid);
        }

        public String getTranslation() {
            if (this.msgstr == null || this.msgstr.isEmpty()) {
                return this.msgid;
            }
            return this.msgstr;
        }

        @Override
        public int compareTo(PoEntry o) {
            return this.getKey().compareTo(o.getKey());
        }

        public String toString() {
            return "key=" + this.getKey() + (this.msgctxt != null && this.msgctxt.length() > 0 ? "[" + this.msgctxt + "]" : "") + "\nenglish=" + this.msgid + "\ntranslation=" + this.msgstr + "\n";
        }
    }

    static enum LAST_TYPE {
        ID,
        STR,
        CTXT;

    }
}

