/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.i18n;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import pt.lsts.neptus.util.GuiUtils;

public class TranslationTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int COL_KEY = 0;
    public static final int COL_TRANSLATION = 1;
    public static final int COL_FILE = 2;
    protected File propsDir;
    protected LinkedHashMap<String, Properties> props = new LinkedHashMap();
    protected Vector<String> keys = new Vector();
    protected Vector<String> translations = new Vector();
    protected Vector<String> files = new Vector();

    public TranslationTableModel(File propsDir) {
        this.propsDir = propsDir;
        this.load();
    }

    protected void load() {
        for (File f : this.propsDir.listFiles()) {
            if (f.isDirectory()) continue;
            try {
                Properties p = new Properties();
                p.load(new FileInputStream(f));
                this.props.put(f.getName(), p);
                for (Object key : p.keySet()) {
                    this.keys.add(key.toString());
                    this.translations.add(p.get(key).toString());
                    this.files.add(f.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (rowIndex == 0) {
            return false;
        }
        switch (columnIndex) {
            case 0: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.keys.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.keys.get(rowIndex);
            }
            case 1: {
                return this.translations.get(rowIndex);
            }
            case 2: {
                return this.files.get(rowIndex);
            }
        }
        return "?";
    }

    public final Vector<Integer> search(String search) {
        search = search.toUpperCase();
        Vector<Integer> selection = new Vector<Integer>();
        for (int i = 0; i < this.keys.size(); ++i) {
            if (this.keys.get(i).toUpperCase().contains(search)) {
                selection.add(i);
                continue;
            }
            if (this.files.get(i).toUpperCase().contains(search)) {
                selection.add(i);
                continue;
            }
            if (!this.translations.get(i).toUpperCase().contains(search)) continue;
            selection.add(i);
        }
        return selection;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        File propsFile = new File(this.propsDir, this.files.get(rowIndex));
        this.props.get(propsFile.getName()).put(this.keys.get(rowIndex), aValue.toString());
        try {
            this.props.get(propsFile.getName()).store(new FileOutputStream(propsFile), "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.translations.set(rowIndex, aValue.toString());
    }

    public static void main(String[] args) {
        TranslationTableModel model = new TranslationTableModel(new File("conf/localization/pt"));
        JXTable table = new JXTable((TableModel)model);
        table.setRowSelectionAllowed(true);
        JScrollPane scroll = new JScrollPane((Component)table);
        GuiUtils.testFrame(scroll);
        Vector<Integer> searchResults = model.search("PLUGINNAME");
        for (int i : searchResults) {
            table.getSelectionModel().addSelectionInterval(i, i);
        }
    }
}

