/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.loader;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.fileeditor.RMFEditor;
import pt.lsts.neptus.gui.Loader;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.loader.FileHandler;
import pt.lsts.neptus.mc.Workspace;
import pt.lsts.neptus.mc.lauvconsole.LAUVConsole;
import pt.lsts.neptus.mra.NeptusMRA;
import pt.lsts.neptus.params.ConfigurationManager;
import pt.lsts.neptus.plugins.PluginsLoader;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.editors.EditorLauncher;
import pt.lsts.neptus.util.output.OutputMonitor;

public class NeptusMain {
    private static LinkedHashMap<String, String> appNames = new LinkedHashMap();
    private static LinkedHashMap<String, Class<?>> fileHandlers = new LinkedHashMap();
    private static Loader loader;

    private static void init() {
        GeneralPreferences.initialize();
        appNames.put("ws", I18n.text("Workspace"));
        appNames.put("mra", I18n.text("Mission Review & Analysis"));
        appNames.put("cl", I18n.text("Empty Console"));
        appNames.put("console", I18n.text("LAUV Console"));
        appNames.put("la", I18n.text("LAUV SE Console"));
        fileHandlers.put("nmis", Workspace.class);
        fileHandlers.put("nmisz", Workspace.class);
        fileHandlers.put("ncfg", EditorLauncher.class);
        fileHandlers.put("ncon", ConsoleParse.class);
        fileHandlers.put("nvcl", Workspace.class);
        fileHandlers.put("nchk", Workspace.class);
        fileHandlers.put("ini", EditorLauncher.class);
        fileHandlers.put("rmf", RMFEditor.class);
        fileHandlers.put("xml", EditorLauncher.class);
        fileHandlers.put("lsf", NeptusMRA.class);
        fileHandlers.put("lsf.gz", NeptusMRA.class);
    }

    public static void launch(String[] appargs) {
        ConfigFetch.initialize();
        if (appNames.isEmpty()) {
            NeptusMain.init();
        }
        NeptusMain.launch(new Loader(), appargs);
    }

    public static void launch(Loader loader, String[] appargs) {
        ConsoleLayout appC;
        ConfigFetch.initialize();
        long start = System.currentTimeMillis();
        NeptusMain.loader = loader;
        if (appNames.isEmpty()) {
            NeptusMain.init();
        }
        String app = appargs[0];
        loader.start();
        ConfigFetch.setSuperParentFrameForced(loader);
        boolean neptusLookAndFeel = true;
        NeptusMain.loadPreRequirementsDataExceptConfigFetch(loader, neptusLookAndFeel);
        String typ = loader.getTypedString();
        if (!typ.equalsIgnoreCase("")) {
            String appT;
            if (typ.startsWith(" ") || typ.startsWith("\u001b")) {
                loader.setText(I18n.text("Choose Application..."));
                LinkedHashMap<String, String> chooseApp = new LinkedHashMap<String, String>();
                for (String key : appNames.keySet()) {
                    String name = appNames.get(key);
                    chooseApp.put(name + " (" + key + ")", key);
                }
                String cApp = (String)JOptionPane.showInputDialog(loader, I18n.text("Choose one of the available applications"), I18n.text("Select application"), 3, new ImageIcon(ImageUtils.getImage("images/neptus-icon.png")), chooseApp.keySet().toArray(new String[0]), chooseApp.keySet().iterator().next());
                if (cApp != null) {
                    typ = (String)chooseApp.get(cApp);
                }
            }
            app = (appT = appNames.get(typ)) != null ? typ : "ws";
        } else if (app.equalsIgnoreCase("-f") && appargs.length >= 2) {
            loader.setText(I18n.text("Opening file..."));
            NeptusMain.handleFile(appargs[1]);
            loader.waitMoreAndEnd(1000);
            loader = null;
            return;
        }
        String appName = appNames.get(app);
        loader.setText(I18n.textf("Starting %appname...", appName != null ? appName : ""));
        if (app.equalsIgnoreCase("ws") || app.equalsIgnoreCase("mc")) {
            Workspace ws = new Workspace();
            ws.setDefaultCloseOperation(2);
            NeptusMain.wrapMainApplicationWindowWithCloseActionWindowAdapter(ws);
            NeptusLog.pub().info((Object)("workspace load finished in " + (double)(System.currentTimeMillis() - start) / 1000.0 + "s "));
        } else if (app.equalsIgnoreCase("mra")) {
            NeptusMRA mra = NeptusMRA.showApplication();
            NeptusMain.wrapMainApplicationWindowWithCloseActionWindowAdapter(mra);
            if (appargs.length > 1) {
                mra.openLog(appargs[1]);
            }
        } else if (app.equalsIgnoreCase("cl")) {
            ConfigFetch.initialize();
            appC = new ConsoleLayout();
            appC.setDefaultCloseOperation(2);
            appC.setVisible(true);
            NeptusMain.wrapMainApplicationWindowWithCloseActionWindowAdapter(appC);
        } else if (app.equalsIgnoreCase("console")) {
            ConfigFetch.initialize();
            appC = ConsoleLayout.forge("conf/consoles/lauv.ncon", loader);
            appC.setDefaultCloseOperation(2);
            appC.setVisible(true);
            NeptusMain.wrapMainApplicationWindowWithCloseActionWindowAdapter(appC);
        } else if (app.equalsIgnoreCase("la")) {
            try {
                LAUVConsole.setLoader(loader);
                ConsoleLayout cls = LAUVConsole.create(new String[0]);
                NeptusMain.wrapMainApplicationWindowWithCloseActionWindowAdapter(cls);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            loader.setText(I18n.text("Opening file..."));
            NeptusMain.handleFile(appargs[0]);
            loader.end();
            return;
        }
        loader.setText(I18n.text("Application started"));
        loader.end();
    }

    public static void loadPreRequirementsDataExceptConfigFetch(Loader loader) {
        NeptusMain.loadPreRequirementsDataExceptConfigFetch(loader, true);
    }

    public static void loadPreRequirementsDataExceptConfigFetch(Loader loader, boolean neptusLookAndFeelOrNative) {
        loader.setText(I18n.text("Loading Plug-ins..."));
        PluginsLoader.load();
        loader.setText(I18n.text("Loading Look&Feel..."));
        if (!neptusLookAndFeelOrNative) {
            GuiUtils.setSystemLookAndFeel();
        } else {
            GuiUtils.setLookAndFeel();
        }
        loader.setText(I18n.text("Loading Systems") + "...");
        if (!VehiclesHolder.loadVehicles()) {
            GuiUtils.errorMessage(loader, I18n.text("Loading Systems"), I18n.text("Error loading systems!"));
        }
        loader.setText(I18n.text("Loading Systems Parameters Files..."));
        Thread bg = new Thread("System parameters files loader"){

            @Override
            public void run() {
                ConfigurationManager.getInstance();
            }
        };
        bg.setDaemon(true);
        bg.start();
    }

    public static void wrapMainApplicationWindowWithCloseActionWindowAdapter(final Window callingWindow) {
        WindowAdapter wa = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Window[] openedWindows;
                for (Window wdow : openedWindows = Frame.getWindows()) {
                    if (callingWindow == wdow || wdow.getType() != Window.Type.NORMAL || !wdow.isVisible()) continue;
                    WindowEvent wev = new WindowEvent(wdow, 201);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
                }
                Thread t = new Thread("Neptus Shutdown"){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        System.out.println("Force close !");
                        System.exit(0);
                    }
                };
                t.setDaemon(true);
                t.start();
                OutputMonitor.end();
            }
        };
        callingWindow.addWindowListener(wa);
    }

    private static void handleFile(String filename) {
        File f = new File(filename);
        if (!f.canRead()) {
            GuiUtils.errorMessage(loader, I18n.text("Error opening file"), I18n.textf("Unable to read the file '%filename'", filename));
            System.exit(1);
        } else {
            try {
                filename = f.getCanonicalPath();
            }
            catch (IOException e1) {
                NeptusLog.pub().debug((Object)e1);
            }
            String extension = FileUtil.getFileExtension(f).toLowerCase();
            if (fileHandlers.containsKey(extension)) {
                try {
                    FileHandler fh = (FileHandler)fileHandlers.get(extension).newInstance();
                    loader.setText(I18n.textf("Starting %program %arg...", fh.getName(), f.getName()));
                    if (fh instanceof JFrame) {
                        ((JFrame)((Object)fh)).setDefaultCloseOperation(2);
                        NeptusMain.wrapMainApplicationWindowWithCloseActionWindowAdapter((JFrame)((Object)fh));
                    }
                    fh.handleFile(f);
                }
                catch (Exception e) {
                    GuiUtils.errorMessage(loader, e);
                    System.exit(1);
                }
            } else {
                GuiUtils.errorMessage(loader, I18n.text("Error opening file"), I18n.textf("File '%filename' of type '.%extension' is not supported.", filename, extension));
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            NeptusMain.launch(new Loader(), new String[]{"ws"});
        } else {
            NeptusMain.launch(new Loader(), args);
        }
    }
}

