/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.jdesktop.swingx.JXStatusBar;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMessageSenderPanel;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.MonitorIMCComms;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.actions.ExitAction;
import pt.lsts.neptus.events.NeptusEventHiddenMenus;
import pt.lsts.neptus.events.NeptusEvents;
import pt.lsts.neptus.gui.AboutPanel;
import pt.lsts.neptus.gui.ChronometerPanel;
import pt.lsts.neptus.gui.ConsoleFileChooser;
import pt.lsts.neptus.gui.DesktopIcon;
import pt.lsts.neptus.gui.HideMenusListener;
import pt.lsts.neptus.gui.IFrameOpener;
import pt.lsts.neptus.gui.LatLonConv;
import pt.lsts.neptus.gui.MenuScroller;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.StatusLed;
import pt.lsts.neptus.gui.VehicleInfo;
import pt.lsts.neptus.gui.checklist.ChecklistFileChooser;
import pt.lsts.neptus.gui.checklist.ChecklistPanel;
import pt.lsts.neptus.gui.swing.NeptusFileView;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.loader.FileHandler;
import pt.lsts.neptus.mra.NeptusMRA;
import pt.lsts.neptus.types.checklist.ChecklistType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.RecentlyOpenedFilesUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.editors.EditorLauncher;
import pt.lsts.neptus.util.gui.MouseRecorder;
import pt.lsts.neptus.util.output.OutputMonitor;
import pt.lsts.neptus.util.output.OutputPanel;
import pt.lsts.neptus.viewer3d.Viewer3D;

public class Workspace
extends JFrame
implements IFrameOpener,
FileHandler {
    private static final long serialVersionUID = -6345952229234111612L;
    private final HashMap<String, ImageIcon> vehIconPool = new HashMap();
    private int numFrames = 0;
    private final HashMap<String, JInternalFrame> internalFrames = new HashMap();
    private JFileChooser fileDialog = null;
    private final LinkedHashMap<JMenuItem, File> missionFilesOpened = new LinkedHashMap();
    private final LinkedHashMap<JMenuItem, File> miscFilesOpened = new LinkedHashMap();
    private final LinkedHashMap<JMenuItem, File> mapFilesOpened = new LinkedHashMap();
    private final LinkedHashMap<JMenuItem, File> checkFilesOpened = new LinkedHashMap();
    private final LinkedHashMap<JMenuItem, File> consoleFilesOpened = new LinkedHashMap();
    private JMenu recentlyOpenFilesMenu = null;
    private JMenu recentlyOpenMapMenu = null;
    private JMenu recentlyOpenedChecklistMenu = null;
    private JMenu recentlyOpenedConsoleMenu = null;
    public static final String RECENTLY_OPENED_MISSIONS = "conf/romissions.xml";
    public static final String RECENTLY_OPENED_MISC = "conf/romisc.xml";
    public static final String RECENTLY_OPENED_CHECKS = "conf/rocheck.xml";
    public static final String RECENTLY_OPENED_CONSOLES = "conf/roconsoles.xml";
    public static final short MISSIONS_FILES = 0;
    public static final short MISC_FILES = 1;
    public static final short MAPS_FILES = 2;
    public static final short CHECKS_FILES = 3;
    public static final short CONSOLES_FILES = 4;
    private static ImageIcon DISPLAY_ICON = ImageUtils.createImageIcon("images/menus/display.png");
    private static ImageIcon OPEN_ICON = ImageUtils.createImageIcon("images/menus/open.png");
    private static ImageIcon MRA_ICON = ImageUtils.createScaleImageIcon("images/mra-alt.png", 16, 16);
    private static ImageIcon GC_ICON = ImageUtils.createScaleImageIcon("images/buttons/gc.png", 16, 16);
    private static ImageIcon IMC_ICON = ImageUtils.createScaleImageIcon("images/imc.png", 16, 16);
    private static ImageIcon REC_MOUSE_ICON = ImageUtils.createScaleImageIcon("images/menus/recIcon16.png", 16, 16);
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenu editMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem editFileMenuItem = null;
    private JMenu vehiclesMenu = null;
    private JMenu consolesMenu = null;
    private JMenu toolsMenu = null;
    private JMenu commsMenu = null;
    private JMenu reviewMenu = null;
    private JDesktopPane jDesktopPane = null;
    private JMenu checklistsMenu = null;
    private JMenuItem openChecklistMenuItem = null;
    private JMenuItem newChecklistMenuItem = null;
    private JMenuItem viewer3DMenuItem = null;
    private JMenuItem dumpGeneralPropertiesDefaultsMenuItem = null;
    private JMenuItem snapShotMenuItem = null;
    private JXStatusBar statusBar = null;
    private JLabel messageBarLabel = null;
    private StatusLed statusLed = null;
    private JMenuItem openMRAMenuItem = null;
    private JMenuItem editGeneralPreferencesMenuItem = null;
    private JMenuItem callGcMenuItem = null;
    private JMenuItem showConsoleMenuItem = null;
    private JMenuItem latLonConvMenuItem = null;
    private JMenuItem chronometerPanelMenuItem = null;
    private JMenuItem imcMonitorMenuItem = null;
    private final MouseRecorder recorder = new MouseRecorder();
    private JCheckBoxMenuItem recordMouseMenuItem = null;
    private JMenuItem openConsoleMenuItem = null;
    private JMenuItem newConsoleMenuItem = null;
    private JPopupMenu.Separator hiddenMenuCommsSeparator = null;
    public static boolean STARTED = false;
    JMenuItem imcMsgSenderMenuItem = null;

    public Workspace() throws HeadlessException {
        STARTED = true;
        GuiUtils.setLookAndFeel();
        ConfigFetch.setSuperParentFrame(this);
        this.setTitle(I18n.textf("%Neptus Workspace", "Neptus"));
        this.setExtendedState(6);
        this.setPreferredSize(new Dimension(800, 600));
        this.setIconImages(ConfigFetch.getIconImagesForFrames());
        this.setJMenuBar(this.getJJMenuBar());
        this.setContentPane(this.getJContentPane());
        this.pack();
        this.setLocationRelativeTo(null);
        this.loadRecentlyOpenedFiles((short)0);
        this.loadRecentlyOpenedFiles((short)1);
        this.loadRecentlyOpenedFiles((short)3);
        this.loadRecentlyOpenedFiles((short)4);
        this.addDesktopIcons();
        this.initComponentListeners();
        this.setVisible(true);
    }

    private void initComponentListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                ConfigFetch.setSuperParentFrameForced(Workspace.this);
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                JFrame frame = (JFrame)e.getComponent();
                OutputMonitor.end();
                frame.setDefaultCloseOperation(2);
                for (JInternalFrame jif : Workspace.this.internalFrames.values()) {
                    try {
                        jif.setClosed(true);
                    }
                    catch (PropertyVetoException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        JRootPane rootPane = this.getRootPane();
        InputMap globalInputMap = rootPane.getInputMap(2);
        globalInputMap.put(KeyStroke.getKeyStroke("shift S"), "pressed");
        rootPane.getActionMap().put("pressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NeptusEvents.post(new NeptusEventHiddenMenus());
            }
        });
    }

    private JMenu getVehiclesMenu() {
        if (this.vehiclesMenu == null) {
            this.vehiclesMenu = new JMenu();
            this.vehiclesMenu.setText(I18n.text("Systems"));
            this.loadVehiclesMenuItem(this.vehiclesMenu);
        } else {
            this.vehiclesMenu.removeAll();
            this.loadVehiclesMenuItem(this.vehiclesMenu);
        }
        return this.vehiclesMenu;
    }

    private void loadVehiclesMenuItem(JMenu jMenu) {
        JMenu notOpSys = new JMenu(I18n.text("More").toLowerCase());
        int notOpSysNumber = 0;
        for (VehicleType ve : VehiclesHolder.getVehiclesList().values()) {
            ImageIcon vicon;
            JMenuItem vMItem = new JMenuItem();
            vMItem.setText(ve.getName());
            vMItem.setActionCommand(ve.getId());
            if (this.vehIconPool.containsKey(ve.getId())) {
                vicon = this.vehIconPool.get(ve.getId());
            } else {
                String imgFile = !ve.getPresentationImageHref().equalsIgnoreCase("") ? ve.getPresentationImageHref() : ve.getSideImageHref();
                Image vimg = new ImageIcon(imgFile).getImage();
                vicon = new ImageIcon(vimg.getScaledInstance(-1, 20, 4));
                this.vehIconPool.put(ve.getId(), vicon);
            }
            vMItem.setIcon(vicon);
            vMItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VehicleType ve = VehiclesHolder.getVehiclesList().get(e.getActionCommand());
                    Workspace.this.openVehicleType(ve);
                }
            });
            if (ve.isOperationalActive()) {
                jMenu.add(vMItem);
                continue;
            }
            notOpSys.add(vMItem);
            ++notOpSysNumber;
        }
        if (notOpSysNumber > 0) {
            MenuScroller.setScrollerFor(notOpSys, (Component)this, 150, 0, 0);
            jMenu.add(notOpSys);
        }
        MenuScroller.setScrollerFor(jMenu, (Component)this, 150, 0, 0);
    }

    protected void openVehicleType(VehicleType ve) {
        if (null != ve) {
            JInternalFrame ifrm = this.internalFrames.get("vehicle-" + ve.getId());
            if (ifrm != null) {
                ifrm.setVisible(true);
                try {
                    ifrm.setSelected(true);
                    ifrm.setIcon(false);
                }
                catch (PropertyVetoException e1) {
                    e1.printStackTrace();
                }
            } else {
                VehicleInfo vei = new VehicleInfo(ve);
                vei.setVehicleRefEditable(false);
                ifrm = this.createFrame(I18n.textf("%vehiclename - Vehicle Info", ve.getId()), I18n.textf("vehicle-%vehicleid", ve.getId()), vei);
                this.internalFrames.put("vehicle-" + ve.getId(), ifrm);
                ifrm.setSize(new Dimension(vei.getWidth() + 20, vei.getHeight() + 230));
                ifrm.setResizable(false);
                ifrm.setMaximizable(false);
            }
        }
    }

    protected void openVehicleTypeFile(File fx) {
        if (fx != null) {
            VehicleType ve = new VehicleType(fx.getAbsolutePath());
            this.openVehicleType(ve);
        }
    }

    private JMenu getToolsMenu() {
        if (this.toolsMenu == null) {
            this.toolsMenu = new JMenu();
            this.toolsMenu.setText(I18n.text("Tools"));
            JSeparator separator1 = new JSeparator();
            this.toolsMenu.add(separator1);
            this.toolsMenu.add(this.getViewer3DMenuItem());
            this.toolsMenu.setName("tools menu");
            JSeparator separator2 = new JSeparator();
            this.toolsMenu.add(separator2);
            this.toolsMenu.add(this.getEditFileMenuItem());
            this.toolsMenu.add(this.getRecentlyOpenFilesMenu());
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.getEditGeneralPreferencesMenuItem());
            this.toolsMenu.add(this.getDumpGeneralPropertiesDefaultsMenuItem());
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.getSnapShotMenuItem());
            this.toolsMenu.add(this.getMouseRecorderMenuItem());
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.getCallGcMenuItem());
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.getShowConsoleMenuItem());
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.getLatLonConvMenuItem());
            this.toolsMenu.add(this.getChronometerMenuItem());
            this.toolsMenu.addMenuListener(HideMenusListener.forge(new Component[]{separator1, separator2}, new JMenuItem[]{this.getViewer3DMenuItem()}));
        }
        return this.toolsMenu;
    }

    private JMenu getCommsMenu() {
        if (this.commsMenu == null) {
            this.commsMenu = new JMenu();
            this.commsMenu.setText(I18n.text("Communications"));
            this.commsMenu.add(this.getImcMonitorMenuItem());
            JSeparator separator1 = new JSeparator();
            this.commsMenu.add(separator1);
            this.commsMenu.add(this.getHiddenMenuCommsSeparator());
            this.commsMenu.add(this.getImcMsgSender());
        }
        return this.commsMenu;
    }

    private JPopupMenu.Separator getHiddenMenuCommsSeparator() {
        if (this.hiddenMenuCommsSeparator == null) {
            this.hiddenMenuCommsSeparator = new JPopupMenu.Separator();
        }
        return this.hiddenMenuCommsSeparator;
    }

    private JMenuItem getImcMsgSender() {
        if (this.imcMsgSenderMenuItem == null) {
            this.imcMsgSenderMenuItem = new JMenuItem();
            this.imcMsgSenderMenuItem.setIcon(IMC_ICON);
            this.imcMsgSenderMenuItem.setText(I18n.text("IMC Msg. Sender."));
            this.imcMsgSenderMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ImcMessageSenderPanel.getFrame();
                }
            });
        }
        return this.imcMsgSenderMenuItem;
    }

    private JDesktopPane getJDesktopPane() {
        if (this.jDesktopPane == null) {
            this.jDesktopPane = new JDesktopPane();
            this.jDesktopPane.setBackground(new Color(24, 58, 83));
            final ImageIcon icon = new ImageIcon(ImageUtils.getImage("images/lsts.png"));
            final JLabel lbl = new JLabel(icon){

                @Override
                public void paint(Graphics g) {
                    super.paint(g);
                    String txt = "Neptus " + ConfigFetch.getNeptusVersion();
                    Rectangle2D bounds = g.getFontMetrics().getStringBounds(txt, g);
                    g.drawString(txt, (int)((double)this.getWidth() - bounds.getWidth() - 3.0), this.getHeight() - 6);
                }
            };
            lbl.setBounds(this.jDesktopPane.getWidth() - icon.getIconWidth(), this.jDesktopPane.getHeight() - icon.getIconHeight(), icon.getIconWidth(), icon.getIconHeight());
            this.jDesktopPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    lbl.setBounds(e.getComponent().getWidth() - icon.getIconWidth(), e.getComponent().getHeight() - icon.getIconHeight(), icon.getIconWidth(), icon.getIconHeight());
                }
            });
            this.jDesktopPane.add((Component)lbl, Integer.MIN_VALUE);
        }
        return this.jDesktopPane;
    }

    private JFileChooser getFileDialog() {
        if (this.fileDialog == null) {
            this.fileDialog = new JFileChooser();
            this.fileDialog.setFileView(new NeptusFileView());
        }
        return this.fileDialog;
    }

    private JMenu getRecentlyOpenFilesMenu() {
        if (this.recentlyOpenFilesMenu == null) {
            this.recentlyOpenFilesMenu = new JMenu();
            this.recentlyOpenFilesMenu.setText(I18n.text("Recently opened"));
            this.recentlyOpenFilesMenu.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/menus/edit.png")));
            RecentlyOpenedFilesUtil.constructRecentlyFilesMenuItems(this.recentlyOpenFilesMenu, this.miscFilesOpened);
        } else {
            RecentlyOpenedFilesUtil.constructRecentlyFilesMenuItems(this.recentlyOpenFilesMenu, this.miscFilesOpened);
        }
        return this.recentlyOpenFilesMenu;
    }

    private JMenu getRecentlyOpenMapMenu() {
        if (this.recentlyOpenMapMenu == null) {
            this.recentlyOpenMapMenu = new JMenu();
            this.recentlyOpenMapMenu.setText(I18n.text("Recently opened"));
            this.recentlyOpenMapMenu.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/menus/mapeditor.png")));
            RecentlyOpenedFilesUtil.constructRecentlyFilesMenuItems(this.recentlyOpenMapMenu, this.mapFilesOpened);
        } else {
            RecentlyOpenedFilesUtil.constructRecentlyFilesMenuItems(this.recentlyOpenMapMenu, this.mapFilesOpened);
        }
        return this.recentlyOpenMapMenu;
    }

    private JMenu getChecklistsMenu() {
        if (this.checklistsMenu == null) {
            this.checklistsMenu = new JMenu();
            this.checklistsMenu.setText(I18n.text("Checklists"));
            this.checklistsMenu.add(this.getOpenChecklistMenuItem());
            this.checklistsMenu.add(this.getNewChecklistMenuItem());
            this.checklistsMenu.add(this.getRecentlyOpenedChecklistMenu());
        }
        return this.checklistsMenu;
    }

    private JMenuItem getOpenChecklistMenuItem() {
        if (this.openChecklistMenuItem == null) {
            this.openChecklistMenuItem = new JMenuItem();
            this.openChecklistMenuItem.setIcon(OPEN_ICON);
            this.openChecklistMenuItem.setText(I18n.text("Open"));
            this.openChecklistMenuItem.addActionListener(this.getActionOpenChecklist());
        }
        return this.openChecklistMenuItem;
    }

    private ActionListener getActionOpenChecklist() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        File fx = ChecklistFileChooser.showOpenDialog(Workspace.this, null);
                        Workspace.this.openChecklistTypeFile(fx);
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                    }
                };
                worker.execute();
            }
        };
    }

    private JMenu getRecentlyOpenedChecklistMenu() {
        if (this.recentlyOpenedChecklistMenu == null) {
            this.recentlyOpenedChecklistMenu = new JMenu();
            this.recentlyOpenedChecklistMenu.setText(I18n.text("Recently opened"));
            this.recentlyOpenedChecklistMenu.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/box_checked.png")));
            RecentlyOpenedFilesUtil.constructRecentlyFilesMenuItems(this.recentlyOpenedChecklistMenu, this.checkFilesOpened);
        } else {
            RecentlyOpenedFilesUtil.constructRecentlyFilesMenuItems(this.recentlyOpenedChecklistMenu, this.checkFilesOpened);
        }
        return this.recentlyOpenedChecklistMenu;
    }

    private JMenuItem getNewChecklistMenuItem() {
        if (this.newChecklistMenuItem == null) {
            this.newChecklistMenuItem = new JMenuItem();
            this.newChecklistMenuItem.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/menus/new.png")));
            this.newChecklistMenuItem.setText(I18n.text("New"));
            this.newChecklistMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String inputValue = JOptionPane.showInputDialog(Workspace.this, (Object)I18n.text("Please input a name for this checklist"));
                    if (inputValue != null && !inputValue.trim().equalsIgnoreCase("")) {
                        ChecklistType checklist = new ChecklistType();
                        checklist.setName(inputValue.trim());
                        Workspace.this.openChecklistTypeFile(checklist);
                    }
                }
            });
        }
        return this.newChecklistMenuItem;
    }

    private void loadRecentlyOpenedFiles(short type) {
        String recentlyOpenedFiles;
        Method methodUpdate = null;
        if (type == 3) {
            recentlyOpenedFiles = ConfigFetch.resolvePath(RECENTLY_OPENED_CHECKS);
            try {
                Class[] params = new Class[]{File.class};
                methodUpdate = this.getClass().getMethod("updateChecklistFilesOpened", params);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)(this + "loadRecentlyOpenedFiles"), (Throwable)e);
                return;
            }
        }
        if (type == 4) {
            recentlyOpenedFiles = ConfigFetch.resolvePath(RECENTLY_OPENED_CONSOLES);
            try {
                Class[] params = new Class[]{File.class};
                methodUpdate = this.getClass().getMethod("updateConsoleFilesOpened", params);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)(this + "loadRecentlyOpenedFiles"), (Throwable)e);
                return;
            }
        }
        recentlyOpenedFiles = ConfigFetch.resolvePath(RECENTLY_OPENED_MISC);
        try {
            Class[] params = new Class[]{File.class};
            methodUpdate = this.getClass().getMethod("updateMiscFilesOpened", params);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this + "loadRecentlyOpenedFiles"), (Throwable)e);
            return;
        }
        if (recentlyOpenedFiles == null) {
            return;
        }
        if (!new File(recentlyOpenedFiles).exists()) {
            return;
        }
        RecentlyOpenedFilesUtil.loadRecentlyOpenedFiles(recentlyOpenedFiles, methodUpdate, this);
    }

    private void storeRecentlyOpenedFiles(short type) {
        String header;
        LinkedHashMap<JMenuItem, File> hMap;
        String recentlyOpenedFiles;
        if (type == 0) {
            recentlyOpenedFiles = ConfigFetch.resolvePathBasedOnConfigFile(RECENTLY_OPENED_MISSIONS);
            hMap = this.missionFilesOpened;
            header = I18n.text("Recently opened mission files.");
        } else if (type == 3) {
            recentlyOpenedFiles = ConfigFetch.resolvePathBasedOnConfigFile(RECENTLY_OPENED_CHECKS);
            hMap = this.checkFilesOpened;
            header = I18n.text("Recently opened checklist files.");
        } else if (type == 4) {
            recentlyOpenedFiles = ConfigFetch.resolvePathBasedOnConfigFile(RECENTLY_OPENED_CONSOLES);
            hMap = this.consoleFilesOpened;
            header = I18n.text("Recently opened consoles files.");
        } else {
            recentlyOpenedFiles = ConfigFetch.resolvePathBasedOnConfigFile(RECENTLY_OPENED_MISC);
            hMap = this.miscFilesOpened;
            header = I18n.text("Recently opened misc files.");
        }
        RecentlyOpenedFilesUtil.storeRecentlyOpenedFiles(recentlyOpenedFiles, hMap, header);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJDesktopPane(), "Center");
            this.jContentPane.add((Component)this.getStatusBar(), "South");
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getEditMenu());
            this.jJMenuBar.add(this.getVehiclesMenu());
            this.jJMenuBar.add(this.getConsolesMenu());
            this.jJMenuBar.add(this.getChecklistsMenu());
            this.jJMenuBar.add(this.getReviewMenu());
            this.jJMenuBar.add(this.getCommsMenu());
            this.jJMenuBar.add(this.getToolsMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu(I18n.text("File"));
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setAction(new ExitAction());
            this.fileMenu.add(this.exitMenuItem);
        }
        return this.fileMenu;
    }

    private JMenu getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = new JMenu();
            this.editMenu.setText(I18n.text("Edit"));
            this.editMenu.setVisible(false);
        }
        return this.editMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText(I18n.text("Help"));
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText(I18n.text("About"));
            this.aboutMenuItem.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/menus/info.png")));
            this.aboutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutPanel ap = new AboutPanel();
                    ap.setVisible(true);
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JMenuItem getEditFileMenuItem() {
        if (this.editFileMenuItem == null) {
            this.editFileMenuItem = new JMenuItem();
            this.editFileMenuItem.setText(I18n.text("File editor"));
            this.editFileMenuItem.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/menus/edit.png")));
            this.editFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2, true));
            this.editFileMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File fx = Workspace.this.openFileAction();
                    Workspace.this.openMiscTypeFile(fx);
                }
            });
        }
        return this.editFileMenuItem;
    }

    @Override
    public JInternalFrame createFrame(String title, String name, final JComponent newComponent) {
        JInternalFrame jif = new JInternalFrame(title, true, true, true, true);
        jif.setName(name);
        if (newComponent instanceof ChecklistPanel) {
            jif.setFrameIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/box_checked.png"))));
            jif.setMaximizable(true);
        } else if (newComponent instanceof VehicleInfo) {
            VehicleType ve = ((VehicleInfo)newComponent).getVehicleMission().getVehicle();
            String imgFile = !ve.getPresentationImageHref().equalsIgnoreCase("") ? ve.getPresentationImageHref() : ve.getSideImageHref();
            Image vimg = new ImageIcon(imgFile).getImage();
            ImageIcon vicon = new ImageIcon(vimg.getScaledInstance(22, -1, 4));
            jif.setFrameIcon(vicon);
        } else if (newComponent instanceof Viewer3D) {
            jif = new MyIFrame(title, true, true, true, true);
            jif.setName(name);
            jif.setFrameIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/menus/3d.png"))));
        } else {
            jif.setFrameIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/neptus-icon.png"))));
        }
        jif.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                JInternalFrame ifrm = (JInternalFrame)e.getSource();
                Workspace.this.internalFrames.remove(ifrm.getName());
                ifrm.dispose();
                Workspace.this.numFrames--;
                if (newComponent instanceof ChronometerPanel) {
                    ((ChronometerPanel)newComponent).stop();
                }
            }
        });
        jif.getContentPane().add(newComponent);
        this.jDesktopPane.add(jif);
        jif.setSize(400, 340);
        if (newComponent instanceof LatLonConv) {
            jif.setSize(419, 224);
        }
        if (newComponent instanceof ChronometerPanel) {
            jif.setSize(400, 204);
        }
        jif.setVisible(true);
        jif.setLocation(180 + this.numFrames * 20, 5 + this.numFrames * 20);
        ++this.numFrames;
        return jif;
    }

    private File openFileActionWorker() {
        this.fileDialog = this.getFileDialog();
        this.fileDialog.setSelectedFile(new File(""));
        this.fileDialog.setCurrentDirectory(new File(ConfigFetch.getConfigFile()));
        this.fileDialog.setFileView(new NeptusFileView());
        int result = this.fileDialog.showOpenDialog(this);
        if (result == 1) {
            return null;
        }
        return this.fileDialog.getSelectedFile();
    }

    private File openFileAction() {
        this.fileDialog = this.getFileDialog();
        this.fileDialog.resetChoosableFileFilters();
        return this.openFileActionWorker();
    }

    public boolean updateMiscFilesOpened(File fx) {
        RecentlyOpenedFilesUtil.updateFilesOpenedMenuItems(fx, this.miscFilesOpened, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object key = e.getSource();
                Object value = Workspace.this.miscFilesOpened.get(key);
                if (!(value instanceof File)) {
                    return;
                }
                File fx = (File)value;
                Workspace.this.openMiscTypeFile(fx);
            }
        });
        this.getRecentlyOpenFilesMenu();
        this.storeRecentlyOpenedFiles((short)1);
        return true;
    }

    public boolean updateMapFilesOpened(File fx) {
        RecentlyOpenedFilesUtil.updateFilesOpenedMenuItems(fx, this.mapFilesOpened, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object key = e.getSource();
                Object value = Workspace.this.mapFilesOpened.get(key);
                if (!(value instanceof File)) {
                    return;
                }
                File fx = (File)value;
                Workspace.this.openMapTypeFile(fx);
            }
        });
        this.getRecentlyOpenMapMenu();
        this.storeRecentlyOpenedFiles((short)2);
        return true;
    }

    public boolean updateChecklistFilesOpened(File fx) {
        RecentlyOpenedFilesUtil.updateFilesOpenedMenuItems(fx, this.checkFilesOpened, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object key = e.getSource();
                Object value = Workspace.this.checkFilesOpened.get(key);
                if (!(value instanceof File)) {
                    return;
                }
                final File fx = (File)value;
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        Workspace.this.openChecklistTypeFile(fx);
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                    }
                };
                worker.execute();
            }
        });
        this.getRecentlyOpenedChecklistMenu();
        this.storeRecentlyOpenedFiles((short)3);
        return true;
    }

    protected void openConsoleTypeFile(File fx) {
        if (fx != null) {
            this.updateConsoleFilesOpened(fx);
            this.updateMiscFilesOpened(fx);
            this.startActivity(I18n.textf("Opening console (%consoleName)...", fx.getName()));
            File fxfinal = fx;
            ConsoleLayout consoleLayout = ConsoleLayout.forge(ConfigFetch.resolvePath(fxfinal.getAbsolutePath()));
        }
    }

    public boolean updateConsoleFilesOpened(File fx) {
        RecentlyOpenedFilesUtil.updateFilesOpenedMenuItems(fx, this.consoleFilesOpened, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object key = e.getSource();
                Object value = Workspace.this.consoleFilesOpened.get(key);
                if (!(value instanceof File)) {
                    return;
                }
                final File fx = (File)value;
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        Workspace.this.openConsoleTypeFile(fx);
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                            GuiUtils.errorMessage(I18n.text("Error"), I18n.textf("Error openning console '%file'", fx.getName()));
                        }
                        Workspace.this.endActivity("");
                    }
                };
                worker.execute();
            }
        });
        this.getRecentlyOpenedConsoleMenu();
        this.storeRecentlyOpenedFiles((short)4);
        return true;
    }

    protected void openMiscTypeFile(File fx) {
        if (fx == null) {
            return;
        }
        if (!fx.exists()) {
            JOptionPane.showMessageDialog(this.editFileMenuItem, I18n.text("The file doesn't exists!"));
            return;
        }
        if (fx.isDirectory()) {
            JOptionPane.showMessageDialog(this.editFileMenuItem, I18n.text("Cannot edit a directory!"));
            return;
        }
        this.updateMiscFilesOpened(fx);
        try {
            Desktop.getDesktop().edit(fx);
        }
        catch (Exception e) {
            EditorLauncher ed = new EditorLauncher();
            ed.getClass();
            short edType = 0;
            ed.editFile(fx.getAbsolutePath(), edType, false);
            NeptusLog.pub().error((Object)e.getStackTrace());
        }
    }

    protected void openMapTypeFile(File fx) {
    }

    protected void openChecklistTypeFile(File fx) {
        if (fx != null) {
            ChecklistType checklist = new ChecklistType(fx.getAbsolutePath());
            if (!checklist.isLoadOk()) {
                GuiUtils.errorMessage(this, I18n.text("Error Opening Checklist"), I18n.text("Not a valid checklist."));
                NeptusLog.pub().warn((Object)("Error Opening Checklist (" + fx.getAbsolutePath() + ")"));
                return;
            }
            this.updateChecklistFilesOpened(fx);
            this.updateMiscFilesOpened(fx);
            JInternalFrame ifrm = this.internalFrames.get("checklist-" + checklist.getName());
            if (ifrm != null) {
                ifrm.setVisible(true);
                try {
                    ifrm.setSelected(true);
                    ifrm.setIcon(false);
                }
                catch (PropertyVetoException e1) {
                    NeptusLog.pub().debug((Object)(this + " getOpenMapMenuItem"), (Throwable)e1);
                }
                return;
            }
            ChecklistPanel clPanel = new ChecklistPanel(checklist);
            clPanel.makeNameEditable();
            ifrm = this.createFrame(I18n.textf("%checklist - Checklist", checklist.getName()), "checklist-" + checklist.getName(), clPanel);
            this.internalFrames.put("checklist-" + checklist.getName(), ifrm);
            ifrm.setSize(new Dimension(clPanel.getWidth() + 100, clPanel.getHeight() + 150));
            ifrm.setResizable(true);
            ifrm.setMaximizable(true);
            ifrm.repaint();
            clPanel.setJInternalFrame(ifrm);
            ifrm.validate();
        }
    }

    protected void openChecklistTypeFile(ChecklistType checklist) {
        JInternalFrame ifrm;
        if (checklist != null && (ifrm = this.internalFrames.get("checklist-" + checklist.getName())) == null) {
            ChecklistPanel clPanel = new ChecklistPanel(checklist);
            clPanel.makeNameEditable();
            ifrm = this.createFrame(I18n.textf("%checklist - Checklist", checklist.getName()), "checklist-" + checklist.getName(), clPanel);
            clPanel.setJInternalFrame(ifrm);
            this.internalFrames.put("checklist-" + checklist.getName(), ifrm);
            ifrm.setSize(new Dimension(clPanel.getWidth() + 100, clPanel.getHeight() + 150));
            ifrm.setResizable(true);
            ifrm.setMaximizable(false);
        }
    }

    private JMenuItem getViewer3DMenuItem() {
        if (this.viewer3DMenuItem == null) {
            this.viewer3DMenuItem = new JMenuItem();
            this.viewer3DMenuItem.setText(I18n.text("3D Model Viewer"));
            this.viewer3DMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2, true));
            this.viewer3DMenuItem.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/menus/3d.png")));
            this.viewer3DMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Workspace.this.startActivity(I18n.text("Opening Viewer3D..."));
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            Viewer3D v3d = new Viewer3D();
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                            Workspace.this.endActivity("");
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.viewer3DMenuItem;
    }

    private JMenuItem getDumpGeneralPropertiesDefaultsMenuItem() {
        if (this.dumpGeneralPropertiesDefaultsMenuItem == null) {
            this.dumpGeneralPropertiesDefaultsMenuItem = new JMenuItem();
            this.dumpGeneralPropertiesDefaultsMenuItem.setText(I18n.text("Dump general preferences"));
            this.dumpGeneralPropertiesDefaultsMenuItem.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/menus/ark_extract.png")));
            this.dumpGeneralPropertiesDefaultsMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            int res = JOptionPane.showConfirmDialog(Workspace.this, I18n.textf("<html>The defaults of the general properties will be dumped to <br><i>%file</i> overwriting the ones already <br>modified in the existing file!<br><br> Do you want to do this?", "conf/general-properties.xml"), "Choose one", 0);
                            if (res == 0) {
                                GeneralPreferences.dumpGeneralPreferences();
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.dumpGeneralPropertiesDefaultsMenuItem;
    }

    private JMenuItem getSnapShotMenuItem() {
        if (this.snapShotMenuItem == null) {
            this.snapShotMenuItem = new JMenuItem();
            this.snapShotMenuItem.setIcon(new ImageIcon(ImageUtils.getImage("images/menus/snapshot.png")));
            this.snapShotMenuItem.setText("Snapshot");
            this.snapShotMenuItem.setAccelerator(KeyStroke.getKeyStroke(154, 2, true));
            this.snapShotMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            GuiUtils.takeSnapshot(Workspace.this, "MissionConsole");
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.snapShotMenuItem;
    }

    private JMenuItem getShowConsoleMenuItem() {
        if (this.showConsoleMenuItem == null) {
            this.showConsoleMenuItem = new JMenuItem();
            this.showConsoleMenuItem.setIcon(new ImageIcon(ImageUtils.getImage("images/menus/display.png")));
            this.showConsoleMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, true));
            this.showConsoleMenuItem.setText(I18n.text("Show Console"));
            this.showConsoleMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OutputPanel.showWindow();
                }
            });
        }
        return this.showConsoleMenuItem;
    }

    private JXStatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new JXStatusBar();
            this.statusBar.add((Component)this.getMessageBarLabel(), (Object)JXStatusBar.Constraint.ResizeBehavior.FILL);
            this.statusBar.add((Component)this.getStatusLed());
        }
        return this.statusBar;
    }

    private JLabel getMessageBarLabel() {
        if (this.messageBarLabel == null) {
            this.messageBarLabel = new JLabel();
            this.messageBarLabel.setText("");
        }
        return this.messageBarLabel;
    }

    private StatusLed getStatusLed() {
        if (this.statusLed == null) {
            this.statusLed = new StatusLed();
            this.statusLed.setLevel((short)-1);
        }
        return this.statusLed;
    }

    private void startActivity(String message) {
        this.setCursor(new Cursor(3));
        this.getMessageBarLabel().setText(message);
        this.getStatusLed().setLevel((short)1);
    }

    private void endActivity(String message) {
        this.setCursor(new Cursor(0));
        this.getMessageBarLabel().setText(message);
        this.getStatusLed().setLevel((short)-1);
    }

    private JMenuItem getOpenMRAMenuItem() {
        if (this.openMRAMenuItem == null) {
            this.openMRAMenuItem = new JMenuItem();
            this.openMRAMenuItem.setText("MRA");
            this.openMRAMenuItem.setIcon(MRA_ICON);
            this.openMRAMenuItem.addActionListener(this.getActionOpenMRA());
        }
        return this.openMRAMenuItem;
    }

    private ActionListener getActionOpenMRA() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workspace.this.startActivity(I18n.text("Opening MRA..."));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        NeptusMRA mra = new NeptusMRA();
                        mra.setDefaultCloseOperation(2);
                        Workspace.this.endActivity("");
                    }
                }, "MRAThread").run();
            }
        };
    }

    private JMenuItem getEditGeneralPreferencesMenuItem() {
        if (this.editGeneralPreferencesMenuItem == null) {
            this.editGeneralPreferencesMenuItem = new JMenuItem();
            this.editGeneralPreferencesMenuItem.setText(I18n.text("Edit general preferences"));
            this.editGeneralPreferencesMenuItem.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/menus/settings.png")));
            this.editGeneralPreferencesMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertiesEditor.editProperties((PropertiesProvider)new GeneralPreferences(), Workspace.this, true);
                    GeneralPreferences.saveProperties();
                }
            });
        }
        return this.editGeneralPreferencesMenuItem;
    }

    private JMenuItem getCallGcMenuItem() {
        if (this.callGcMenuItem == null) {
            this.callGcMenuItem = new JMenuItem();
            this.callGcMenuItem.setText(I18n.text("Invoke Garbage Collector"));
            this.callGcMenuItem.setIcon(GC_ICON);
            this.callGcMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Workspace.this.startActivity(I18n.text("Invoking Garbage Collector"));
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            long bytes = GuiUtils.callGC();
                            NeptusLog.pub().warn((Object)("Garbage Collector call freed " + bytes + " bytes"));
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            Workspace.this.endActivity("");
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.callGcMenuItem;
    }

    private JMenuItem getLatLonConvMenuItem() {
        if (this.latLonConvMenuItem == null) {
            this.latLonConvMenuItem = new JMenuItem();
            this.latLonConvMenuItem.setIcon(new ImageIcon(ImageUtils.getImage("images/menus/displaylatlon.png")));
            this.latLonConvMenuItem.setText(I18n.text("Lat/Lon Conv."));
            this.latLonConvMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LatLonConv latLonConv = new LatLonConv();
                    Workspace.this.createFrame(I18n.text("Lat/Lon Conv."), I18n.text("Lat/Lon Conv."), latLonConv);
                }
            });
        }
        return this.latLonConvMenuItem;
    }

    private JMenuItem getChronometerMenuItem() {
        if (this.chronometerPanelMenuItem == null) {
            this.chronometerPanelMenuItem = new JMenuItem();
            this.chronometerPanelMenuItem.setIcon(ImageUtils.getScaledIcon("images/buttons/clocksync2.png", 16, 16));
            this.chronometerPanelMenuItem.setText(I18n.text("Chronometer"));
            this.chronometerPanelMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChronometerPanel chronometerPanel = new ChronometerPanel();
                    Workspace.this.createFrame(I18n.text("Chronometer"), I18n.text("Chronometer"), chronometerPanel);
                }
            });
        }
        return this.chronometerPanelMenuItem;
    }

    @Override
    public void handleFile(File f) {
        File fx = new File(ConfigFetch.resolvePath(f.getAbsolutePath()));
        String extension = FileUtil.getFileExtension(fx);
        if (extension.equalsIgnoreCase("nmap")) {
            this.openMapTypeFile(fx);
        } else if (extension.equalsIgnoreCase("nchk")) {
            this.openChecklistTypeFile(fx);
        } else if (extension.equalsIgnoreCase("nvcl")) {
            this.openVehicleTypeFile(fx);
        } else if (extension.equalsIgnoreCase("ncon")) {
            ConsoleLayout console = ConsoleLayout.forge(ConfigFetch.resolvePath(fx.getAbsolutePath()));
        } else if (extension.equalsIgnoreCase("nwsn")) {
            this.openMiscTypeFile(fx);
        } else if (extension.equalsIgnoreCase("ncfg")) {
            this.openMiscTypeFile(fx);
        } else if (extension.equalsIgnoreCase("ini")) {
            this.openMiscTypeFile(fx);
        } else {
            this.openMiscTypeFile(fx);
        }
    }

    private ActionListener getActionEmptyConsole() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workspace.this.startActivity(I18n.text("Opening Empty Console..."));
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        ConsoleLayout empCon = new ConsoleLayout();
                        empCon.setDefaultCloseOperation(2);
                        empCon.setVisible(true);
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        Workspace.this.endActivity("");
                    }
                };
                worker.execute();
            }
        };
    }

    private JCheckBoxMenuItem getMouseRecorderMenuItem() {
        if (this.recordMouseMenuItem == null) {
            this.recordMouseMenuItem = new JCheckBoxMenuItem();
            this.recordMouseMenuItem.setIcon(REC_MOUSE_ICON);
            this.recordMouseMenuItem.setText(I18n.text("Record Mouse Actions"));
            this.recordMouseMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Workspace.this.recordMouseMenuItem.isSelected()) {
                        Workspace.this.recorder.startRecording();
                    } else {
                        Workspace.this.recorder.stopRecording();
                    }
                }
            });
        }
        this.recordMouseMenuItem.setSelected(false);
        return this.recordMouseMenuItem;
    }

    private JMenuItem getImcMonitorMenuItem() {
        if (this.imcMonitorMenuItem == null) {
            this.imcMonitorMenuItem = new JMenuItem();
            this.imcMonitorMenuItem.setIcon(IMC_ICON);
            this.imcMonitorMenuItem.setText(I18n.text("IMC Comm. Monitor"));
            this.imcMonitorMenuItem.addActionListener(this.getActionImcMonitor());
        }
        return this.imcMonitorMenuItem;
    }

    private ActionListener getActionImcMonitor() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workspace.this.startActivity(I18n.text("Opening IMC Monitor ..."));
                JInternalFrame ifrm = (JInternalFrame)Workspace.this.internalFrames.get("imc monitor");
                if (ifrm != null) {
                    ifrm.setVisible(true);
                    try {
                        ifrm.setSelected(true);
                        ifrm.setIcon(false);
                    }
                    catch (PropertyVetoException e1) {
                        NeptusLog.pub().debug((Object)(this + " open imc monitor"), (Throwable)e1);
                    }
                    Workspace.this.endActivity("");
                } else {
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            try {
                                final MonitorIMCComms imcPanel = new MonitorIMCComms(ImcMsgManager.getManager());
                                JInternalFrame ifrm = Workspace.this.createFrame(I18n.text("IMC Comm. Monitor"), I18n.text("IMC Comm. Monitor"), imcPanel);
                                ifrm.addInternalFrameListener(new InternalFrameAdapter(){

                                    @Override
                                    public void internalFrameClosing(InternalFrameEvent e) {
                                        Workspace.this.internalFrames.remove("imc monitor");
                                        imcPanel.cleanup();
                                    }
                                });
                                Workspace.this.internalFrames.put("imc monitor", ifrm);
                                ifrm.setSize(new Dimension(imcPanel.getWidth() + 60, imcPanel.getHeight() + 140 + 140));
                                ifrm.setResizable(true);
                                ifrm.setMaximizable(true);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            Workspace.this.endActivity("");
                        }
                    };
                    worker.execute();
                }
            }
        };
    }

    private JMenu getReviewMenu() {
        if (this.reviewMenu == null) {
            this.reviewMenu = new JMenu();
            this.reviewMenu.setText(I18n.text("Mission Review"));
            this.reviewMenu.add(this.getOpenMRAMenuItem());
        }
        return this.reviewMenu;
    }

    private JMenu getConsolesMenu() {
        if (this.consolesMenu == null) {
            this.consolesMenu = new JMenu();
            this.consolesMenu.setText(I18n.text("Consoles"));
            this.consolesMenu.add(this.getOpenConsoleMenuItem());
            this.consolesMenu.add(this.getNewConsoleMenuItem());
            this.consolesMenu.add(this.getRecentlyOpenedConsoleMenu());
        }
        return this.consolesMenu;
    }

    private JMenuItem getOpenConsoleMenuItem() {
        if (this.openConsoleMenuItem == null) {
            this.openConsoleMenuItem = new JMenuItem();
            this.openConsoleMenuItem.setIcon(OPEN_ICON);
            this.openConsoleMenuItem.setText(I18n.text("Open"));
            this.openConsoleMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            File fx = ConsoleFileChooser.showOpenDialog(Workspace.this, null);
                            Workspace.this.openConsoleTypeFile(fx);
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.openConsoleMenuItem;
    }

    private JMenu getRecentlyOpenedConsoleMenu() {
        if (this.recentlyOpenedConsoleMenu == null) {
            this.recentlyOpenedConsoleMenu = new JMenu();
            this.recentlyOpenedConsoleMenu.setText(I18n.text("Recently opened"));
            this.recentlyOpenedConsoleMenu.setIcon(DISPLAY_ICON);
            RecentlyOpenedFilesUtil.constructRecentlyFilesMenuItems(this.recentlyOpenedConsoleMenu, this.consoleFilesOpened);
        } else {
            RecentlyOpenedFilesUtil.constructRecentlyFilesMenuItems(this.recentlyOpenedConsoleMenu, this.consoleFilesOpened);
        }
        return this.recentlyOpenedConsoleMenu;
    }

    private JMenuItem getNewConsoleMenuItem() {
        if (this.newConsoleMenuItem == null) {
            this.newConsoleMenuItem = new JMenuItem();
            this.newConsoleMenuItem.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/menus/new.png")));
            this.newConsoleMenuItem.setText(I18n.text("New"));
            this.newConsoleMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Workspace.this.startActivity(I18n.text("Opening Empty Console..."));
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            ConsoleLayout empCon = new ConsoleLayout();
                            empCon.setDefaultCloseOperation(2);
                            empCon.setVisible(true);
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            Workspace.this.endActivity("");
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.newConsoleMenuItem;
    }

    private void addDesktopIcons() {
        int iconSize = 48;
        int iconSepSize = Math.min(iconSize + iconSize * 2 / 3, iconSize + 18);
        int posY = 30;
        DesktopIcon icon = new DesktopIcon(new ImageIcon(ImageUtils.getImage("images/apps/NeptusApps-MRA.png").getScaledInstance(iconSize, iconSize, 4)), I18n.text("Review & Analysis"), this.getActionOpenMRA());
        icon.setForeground(Color.WHITE);
        this.getJDesktopPane().add(icon);
        icon.setLocation(30, posY);
        icon = new DesktopIcon(new ImageIcon(ImageUtils.getImage("images/apps/NeptusApps-Console.png").getScaledInstance(iconSize, iconSize, 4)), I18n.text("Console Open/Builder"), this.getActionEmptyConsole());
        icon.setForeground(Color.WHITE);
        this.getJDesktopPane().add(icon);
        icon.setLocation(30, posY += iconSepSize);
        icon = new DesktopIcon(new ImageIcon(ImageUtils.getImage("images/apps/NeptusApps-Check.png").getScaledInstance(iconSize, iconSize, 4)), I18n.text("Checklist"), this.getActionOpenChecklist());
        icon.setForeground(Color.WHITE);
        this.getJDesktopPane().add(icon);
        icon.setLocation(30, posY += iconSepSize);
        icon = new DesktopIcon(new ImageIcon(ImageUtils.getImage("images/imc.png").getScaledInstance(iconSize, iconSize, 4)), I18n.text("IMC Monitor"), this.getActionImcMonitor());
        icon.setForeground(Color.WHITE);
        this.getJDesktopPane().add(icon);
        icon.setLocation(30, posY += iconSepSize);
        posY += iconSepSize;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigFetch.initialize();
                Workspace application = new Workspace();
                application.setVisible(true);
            }
        });
    }

    class MyIFrame
    extends JInternalFrame {
        private static final long serialVersionUID = -7355044261933465004L;

        public MyIFrame(String title, boolean b, boolean c, boolean d, boolean e) {
            super(title, b, c, d, e);
        }

        @Override
        public void paint(Graphics g) {
            System.err.println(g);
            if (g != null) {
                super.paint(g);
            }
        }
    }
}

