/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mc.lauvconsole;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.actions.LayoutEditConsoleAction;
import pt.lsts.neptus.console.actions.OpenConsoleAction;
import pt.lsts.neptus.console.actions.RunChecklistConsoleAction;
import pt.lsts.neptus.console.actions.SaveAsConsoleAction;
import pt.lsts.neptus.console.actions.SaveConsoleAction;
import pt.lsts.neptus.console.plugins.SettingsWindow;
import pt.lsts.neptus.gui.Loader;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.loader.NeptusMain;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.Dom4JUtil;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class LAUVConsole
extends ConsoleLayout {
    public static final int CLOSE_ACTION = 3;
    private static String consoleURL = "conf/consoles/lauv.ncon";
    public static String lauvVehicle = "lauv-dolphin-1";
    private static Loader loader = null;
    private static boolean editEnabled = false;

    @Override
    public void createMenuBar() {
        super.createMenuBar();
        this.removeJMenuAction(OpenConsoleAction.class);
        this.removeJMenuAction(SaveConsoleAction.class);
        this.removeJMenuAction(SaveAsConsoleAction.class);
        if (!editEnabled) {
            this.removeJMenuAction(LayoutEditConsoleAction.class);
        }
        this.removeJMenuAction(RunChecklistConsoleAction.class);
    }

    @Override
    public void cleanup() {
        if (this.getMaximizedPanel() != null) {
            this.minimizePanel(this.getMaximizedPanel());
        }
        try {
            Node n = this.getXmlDoc().getRootElement().selectSingleNode("@mission-file");
            n.setText(FileUtil.relativizeFilePathAsURI(this.fileName.getAbsolutePath(), this.getMission().getMissionFile().getAbsolutePath()));
            FileUtil.saveToFile(this.fileName.getAbsolutePath(), FileUtil.getAsPrettyPrintFormatedXMLString(Dom4JUtil.documentToDocumentCleanFormating(this.getXmlDoc())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.cleanup();
    }

    public static ConsoleLayout create(String[] args) {
        ConfigFetch.setOnLockedMode(true);
        ConfigFetch.setDistributionType(NeptusProperty.DistributionEnum.CLIENT);
        loader.setText(I18n.text("Loading console..."));
        NeptusLog.pub().info((Object)("Loading " + LAUVConsole.class.getSimpleName() + "."));
        LAUVConsole cls = new LAUVConsole();
        cls.imcOn();
        ConsoleParse.parseFile(ConfigFetch.resolvePath(consoleURL), cls);
        SettingsWindow settings = new SettingsWindow(cls);
        settings.init();
        cls.setConsoleChanged(false);
        GuiUtils.leftTopScreen(cls);
        if (args.length > 0) {
            String filename = args[0];
            loader.setText(I18n.textf("Opening mission: %missionfile...", filename));
            File f = new File(filename);
            if (!f.canRead()) {
                GuiUtils.errorMessage(loader, I18n.text("Error opening mission file"), I18n.textf("Unable to read the mission file '%missionfile'", filename));
            } else {
                MissionType mission;
                try {
                    filename = f.getCanonicalPath();
                }
                catch (IOException e1) {
                    NeptusLog.pub().error((Object)e1.getStackTrace());
                }
                String extension = FileUtil.getFileExtension(f).toLowerCase();
                if (("nmisz".equalsIgnoreCase(extension) || "nmis".equalsIgnoreCase(extension)) && (mission = new MissionType(f.getAbsolutePath())).isLoadOk()) {
                    cls.setMission(mission);
                }
            }
        }
        cls.getMainPanel().setRelayoutOnResize(true);
        cls.setResizable(true);
        String mainSysStr = cls.getMainSystem();
        if (mainSysStr == null) {
            VehicleType vehicle = VehiclesHolder.getVehicleById(lauvVehicle);
            if (vehicle != null) {
                cls.setMainSystem(lauvVehicle);
            } else {
                LinkedHashMap<String, VehicleType> val = VehiclesHolder.getVehiclesList();
                VehicleType dVeh = null;
                for (VehicleType veh : val.values()) {
                    if (veh.getName().startsWith("lauv")) {
                        cls.setMainSystem(veh.getName());
                        dVeh = null;
                        break;
                    }
                    if (dVeh != null || !veh.isOperationalActive() || !"auv".equalsIgnoreCase(veh.getType())) continue;
                    dVeh = veh;
                }
                if (dVeh != null) {
                    cls.setMainSystem(dVeh.getName());
                }
            }
        }
        cls.setVisible(true);
        return cls;
    }

    public static void setLoader(Loader loader) {
        LAUVConsole.loader = loader;
    }

    public static void main(String[] args) {
        GuiUtils.setLookAndFeel();
        loader = new Loader("images/neptus_loader_light.png");
        if (args.length == 1 && args[0].trim().equalsIgnoreCase("mra")) {
            NeptusMain.launch(loader, args);
        } else {
            NeptusMain.launch(loader, new String[]{"la"});
        }
    }
}

