/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mc.lauvconsole;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.dom4j.Document;
import pt.lsts.neptus.gui.SelectAllFocusListener;
import pt.lsts.neptus.gui.tablelayout.TableLayout;
import pt.lsts.neptus.mc.lauvconsole.LAUVConsole;
import pt.lsts.neptus.types.comm.CommMean;
import pt.lsts.neptus.types.comm.protocol.IMCArgs;
import pt.lsts.neptus.types.comm.protocol.ProtocolArgs;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.GeneralPreferences;

class VehicleCommsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField ipField = new JTextField(20);
    private JTextField portField = new JTextField(4);
    private JTextField localPortField = new JTextField(4);
    private JDialog mainFrame = null;
    private int port = 6002;
    private int localPort = 6001;
    private String hostname = "127.0.0.1";

    public VehicleCommsPanel(JDialog mainFrame) {
        this.mainFrame = mainFrame;
        this.init();
        this.setLayout(new TableLayout(new double[]{5.0, 100.0, 5.0, -1.0, 5.0}, new double[]{5.0, 25.0, 5.0, 25.0, 5.0, 25.0, 5.0, 35.0}));
        this.add((Component)new JLabel("remote hostname:", 4), "1,1");
        this.add((Component)new JLabel("remote port:", 4), "1,3");
        this.add((Component)new JLabel("local port:", 4), "1,5");
        this.ipField.addFocusListener(new SelectAllFocusListener());
        this.portField.addFocusListener(new SelectAllFocusListener());
        this.localPortField.addFocusListener(new SelectAllFocusListener());
        this.add((Component)this.ipField, "3,1");
        this.add((Component)this.portField, "3,3");
        this.add((Component)this.localPortField, "3,5");
        this.ipField.setText(this.hostname);
        this.portField.setText("" + this.port);
        this.localPortField.setText("" + this.localPort);
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int tmpport = Integer.parseInt(VehicleCommsPanel.this.portField.getText());
                    int tmpLocalPort = Integer.parseInt(VehicleCommsPanel.this.localPortField.getText());
                    if (tmpLocalPort != VehicleCommsPanel.this.localPort || !VehicleCommsPanel.this.hostname.equalsIgnoreCase(VehicleCommsPanel.this.ipField.getText()) || tmpport != VehicleCommsPanel.this.port) {
                        VehicleCommsPanel.this.hostname = VehicleCommsPanel.this.ipField.getText();
                        VehicleCommsPanel.this.port = tmpport;
                        VehicleCommsPanel.this.localPort = tmpLocalPort;
                        VehicleCommsPanel.this.save();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                VehicleCommsPanel.this.close();
            }
        });
        okButton.setPreferredSize(new Dimension(80, 25));
        buttonsPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VehicleCommsPanel.this.close();
            }
        });
        cancelButton.setPreferredSize(new Dimension(80, 25));
        buttonsPanel.add(cancelButton);
        this.add((Component)buttonsPanel, "1,7,3,7");
        GuiUtils.reactEnterKeyPress(okButton);
        GuiUtils.reactEscapeKeyPress(cancelButton);
    }

    private void close() {
        if (this.mainFrame == null) {
            return;
        }
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
    }

    private void init() {
        VehicleType vehicle = VehiclesHolder.getVehicleById(LAUVConsole.lauvVehicle);
        CommMean cm = vehicle.getCommunicationMeans().values().iterator().next();
        if (cm != null) {
            this.hostname = cm.getHostAddress();
            for (ProtocolArgs pArgs : cm.getProtocolsArgs().values()) {
                if (!(pArgs instanceof IMCArgs)) continue;
                IMCArgs nArgs = (IMCArgs)pArgs;
                this.port = nArgs.getPort();
                break;
            }
        }
        this.localPort = GeneralPreferences.commsLocalPortUDP;
    }

    private void save() {
        VehicleType vehicle = VehiclesHolder.getVehicleById(LAUVConsole.lauvVehicle);
        CommMean cm = vehicle.getCommunicationMeans().values().iterator().next();
        if (cm != null) {
            cm.setHostAddress(this.hostname);
            for (ProtocolArgs pArgs : cm.getProtocolsArgs().values()) {
                if (!(pArgs instanceof IMCArgs)) continue;
                IMCArgs nArgs = (IMCArgs)pArgs;
                nArgs.setPort(this.port);
                break;
            }
        }
        try {
            GeneralPreferences.saveProperties();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String filePath = vehicle.getOriginalFilePath();
        Document doc = vehicle.asDocument();
        String dataToSave = FileUtil.getAsPrettyPrintFormatedXMLString(doc);
        FileUtil.saveToFile(filePath, dataToSave);
    }
}

