/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mc.lauvconsole;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.dom4j.Document;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.types.comm.CommMean;
import pt.lsts.neptus.types.comm.protocol.IMCArgs;
import pt.lsts.neptus.types.comm.protocol.ProtocolArgs;
import pt.lsts.neptus.types.vehicle.TemplateFileVehicle;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.FileUtil;

public class VehicleIpPortEditor
implements PropertiesProvider {
    private VehicleType vehicle;

    public VehicleIpPortEditor(VehicleType vehicle) {
        this.vehicle = vehicle;
    }

    @Override
    public DefaultProperty[] getProperties() {
        LinkedList<DefaultProperty> propertiesList = new LinkedList<DefaultProperty>();
        for (CommMean cm : this.vehicle.getCommunicationMeans().values()) {
            String category = cm.getName();
            DefaultProperty comP = PropertiesEditor.getPropertyInstance("host name", category, String.class, new String(cm.getHostAddress()), true);
            comP.setShortDescription("Set the Vehicle's IP address.");
            propertiesList.add(comP);
            for (ProtocolArgs pArgs : cm.getProtocolsArgs().values()) {
                if (!(pArgs instanceof IMCArgs)) continue;
                IMCArgs nArgs = (IMCArgs)pArgs;
                comP = PropertiesEditor.getPropertyInstance("imc.port", category, Integer.class, new Integer(nArgs.getPort()), true);
                comP.setShortDescription("Set the Vehicle's port.");
                propertiesList.add(comP);
            }
        }
        DefaultProperty[] prop = new DefaultProperty[propertiesList.size()];
        return propertiesList.toArray(prop);
    }

    @Override
    public void setProperties(Property[] properties) {
        LinkedHashMap<String, String> transFilesList = new LinkedHashMap<String, String>();
        for (String id : this.vehicle.getTransformationXSLTTemplates().keySet()) {
            TemplateFileVehicle tfile = this.vehicle.getTransformationXSLTTemplates().get(id);
            String category = id + ":" + tfile.getName() + " parameters";
            transFilesList.put(category, id);
        }
        for (Property prop : properties) {
            String idTFile;
            String cat = prop.getCategory();
            CommMean cm = this.vehicle.getCommunicationMeans().get(cat);
            if (cm != null) {
                if (prop.getName().equals("host name")) {
                    cm.setHostAddress((String)prop.getValue());
                } else if (prop.getName().equals("user name")) {
                    cm.setUserName((String)prop.getValue());
                } else if (prop.getName().equals("is password saved")) {
                    cm.setPasswordSaved((Boolean)prop.getValue());
                } else {
                    for (String protocol : cm.getProtocols()) {
                        ProtocolArgs protoArgs;
                        if (!prop.getName().startsWith(protocol) || !protocol.equalsIgnoreCase("imc") || (protoArgs = cm.getProtocolsArgs().get(protocol)) == null) continue;
                        ((IMCArgs)protoArgs).setPort((Integer)prop.getValue());
                    }
                }
            }
            if ((idTFile = (String)transFilesList.get(cat)) == null) continue;
            TemplateFileVehicle tFile = this.vehicle.getTransformationXSLTTemplates().get(idTFile);
            tFile.getParametersToPassList().put(prop.getName(), (String)prop.getValue());
        }
        String filePath = this.vehicle.getOriginalFilePath();
        Document doc = this.vehicle.asDocument();
        String dataToSave = FileUtil.getAsPrettyPrintFormatedXMLString(doc);
        FileUtil.saveToFile(filePath, dataToSave);
    }

    @Override
    public String getPropertiesDialogTitle() {
        return "Vehicle properties";
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }
}

