/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.messages;

import java.util.LinkedHashMap;
import pt.lsts.neptus.NeptusLog;

public class Bitmask
extends Number
implements Comparable<Bitmask> {
    private static final long serialVersionUID = 1L;
    private LinkedHashMap<Long, String> possibleValues;
    private long currentValue;
    private String name;

    @Override
    public long longValue() {
        return this.currentValue;
    }

    @Override
    public double doubleValue() {
        return this.currentValue;
    }

    @Override
    public float floatValue() {
        return this.currentValue;
    }

    @Override
    public int intValue() {
        return (int)this.currentValue;
    }

    public Bitmask(LinkedHashMap<Long, String> possibleValues, long currentValue) {
        this.possibleValues = possibleValues;
        this.currentValue = currentValue;
    }

    @Override
    public int compareTo(Bitmask o) {
        return (int)(this.currentValue - o.currentValue);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bitmask) {
            return this.currentValue == ((Bitmask)obj).getCurrentValue();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.currentValue ^ this.currentValue >>> 32);
    }

    public long setBit(String bitName, boolean value) {
        if (this.possibleValues.containsValue(bitName)) {
            for (Long l : this.possibleValues.keySet()) {
                if (!this.possibleValues.get(l).equals(bitName)) continue;
                if (value) {
                    this.currentValue |= l.longValue();
                    continue;
                }
                long reverse = 0xFFFFFFFFFFFFFFFFL ^ l;
                this.currentValue &= reverse;
            }
        } else {
            System.err.println("Bitmask: bit not found: " + bitName);
        }
        return this.currentValue;
    }

    public boolean isSet(String bitName) {
        if (this.possibleValues.containsValue(bitName)) {
            for (Long l : this.possibleValues.keySet()) {
                if (!this.possibleValues.get(l).equals(bitName)) continue;
                return (this.currentValue & l) != 0L;
            }
        }
        return false;
    }

    public long flip(String bitName) {
        this.setBit(bitName, !this.isSet(bitName));
        return this.currentValue;
    }

    public String toString() {
        if (this.currentValue == 0L) {
            return " - ";
        }
        boolean hasTextBefore = false;
        StringBuilder sb = new StringBuilder();
        for (Long l : this.possibleValues.keySet()) {
            if ((l & this.currentValue) == 0L) continue;
            if (hasTextBefore) {
                sb.append(" | " + this.possibleValues.get(l));
                continue;
            }
            sb.append(this.possibleValues.get(l));
            hasTextBefore = true;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        LinkedHashMap<Long, String> posVals = new LinkedHashMap<Long, String>();
        posVals.put(1L, "Bit1");
        posVals.put(2L, "Bit2");
        posVals.put(4L, "Bit3");
        posVals.put(8L, "Bit4");
        Bitmask bm = new Bitmask(posVals, 6L);
        NeptusLog.pub().info((Object)("<###> " + bm));
        bm.setBit("Bit4", true);
        NeptusLog.pub().info((Object)("<###> " + bm));
        bm.setBit("Bit2", false);
        NeptusLog.pub().info((Object)("<###> " + bm));
    }

    public long getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(long currentValue) {
        this.currentValue = currentValue;
    }

    public Number getValueAs(String slzType) {
        Number slzNumber = slzType.equals("uint8_t") || slzType.equals("int8_t") || slzType.equals("int16_t") ? (Number)new Short((short)this.currentValue) : (Number)(slzType.equals("int32_t") || slzType.equals("uint16_t") ? (Number)new Integer((int)this.currentValue) : (Number)new Long(this.currentValue));
        return slzNumber;
    }

    public LinkedHashMap<Long, String> getPossibleValues() {
        return this.possibleValues;
    }

    public void setPossibleValues(LinkedHashMap<Long, String> possibleValues) {
        this.possibleValues = possibleValues;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

