/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.messages;

import java.util.LinkedHashMap;
import pt.lsts.neptus.messages.InvalidFieldValueException;

public class Enumerated
extends Number
implements Comparable<Enumerated> {
    private static final long serialVersionUID = 1L;
    private final LinkedHashMap<Long, String> possibleValues;
    private long currentValue;

    @Override
    public long longValue() {
        return this.currentValue;
    }

    @Override
    public double doubleValue() {
        return this.currentValue;
    }

    @Override
    public float floatValue() {
        return this.currentValue;
    }

    @Override
    public int intValue() {
        return (int)this.currentValue;
    }

    public Enumerated(LinkedHashMap<Long, String> possibleValues, long currentValue) {
        this.possibleValues = possibleValues;
        this.currentValue = currentValue;
    }

    @Override
    public int compareTo(Enumerated o) {
        return (int)(this.currentValue - o.currentValue);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Enumerated) {
            return this.currentValue == ((Enumerated)obj).getCurrentValue();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.currentValue ^ this.currentValue >>> 32);
    }

    public LinkedHashMap<Long, String> getPossibleValues() {
        return this.possibleValues;
    }

    public long getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(long value) throws InvalidFieldValueException {
        if (!this.possibleValues.containsKey(value)) {
            throw new InvalidFieldValueException("Enumeration does not hold the entered value: " + value);
        }
        this.currentValue = value;
    }

    public void setCurrentValue(String value) throws InvalidFieldValueException {
        if (this.possibleValues.containsValue(value)) {
            for (Long key : this.possibleValues.keySet()) {
                if (!this.possibleValues.get(key).equals(value)) continue;
                this.currentValue = key;
                break;
            }
        } else {
            throw new InvalidFieldValueException("Enumeration does not hold the entered (String) value: " + value);
        }
    }

    public String toString() {
        if (!this.possibleValues.containsKey(this.currentValue)) {
            return "" + this.currentValue + " (Unknown value)";
        }
        return this.possibleValues.get(this.currentValue);
    }

    public Number getValueAs(String slzType) {
        Number slzNumber = slzType.equals("uint8_t") || slzType.equals("int8_t") || slzType.equals("int16_t") ? (Number)new Short((short)this.currentValue) : (Number)(slzType.equals("int32_t") || slzType.equals("uint16_t") ? (Number)new Integer((int)this.currentValue) : (Number)new Long(this.currentValue));
        return slzNumber;
    }
}

