/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.messages;

import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.messages.InvalidFieldValueException;

public class TupleList
implements Comparable<TupleList> {
    private final LinkedHashMap<String, String> map = new LinkedHashMap();

    @Override
    public int compareTo(TupleList o) {
        return this.toString().compareTo(o.toString());
    }

    public TupleList() {
    }

    public TupleList(String spec) {
        this.parse(spec);
    }

    public void parse(String spec) {
        if (spec == null || spec.equals("")) {
            return;
        }
        for (String p : spec.split(";")) {
            String[] kv = p.split("=", 2);
            this.map.put(kv[0], kv[1]);
        }
    }

    public String toString() {
        String representation = "";
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            representation = representation + String.format("%s=%s;", entry.getKey(), entry.getValue());
        }
        return representation;
    }

    public int size() {
        return this.map.size();
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public void clear() {
        this.map.clear();
    }

    public void set(String key, Object value) {
        this.map.put(key, value.toString());
    }

    public <T extends Comparable<?>> T get(String key, Class<T> clazz) throws InvalidFieldValueException {
        try {
            String value = this.map.get(key);
            if (value == null) {
                return null;
            }
            Constructor<T> ctor = clazz.getDeclaredConstructor(String.class);
            return (T)((Comparable)ctor.newInstance(value));
        }
        catch (Exception e) {
            throw new InvalidFieldValueException(e);
        }
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public static void main(String[] args) throws InvalidFieldValueException {
        TupleList tl = new TupleList("x=0;y=abc;z=0.00;w=92.2;");
        NeptusLog.pub().info((Object)("<###> " + tl.get("z", Float.class)));
        tl.set("z", Float.valueOf(3.0f));
        tl.set("flag", true);
        NeptusLog.pub().info((Object)("<###> " + tl.get("z", Float.class)));
        NeptusLog.pub().info((Object)("<###> " + tl.get("flag", Boolean.class)));
        NeptusLog.pub().info((Object)("<###> " + tl));
    }
}

