/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mme.wms;

import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.MapRequest;
import com.vividsolutions.wms.WMService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;

public class FetcherWMS {
    private LocationType topLeft = new LocationType();
    private LocationType bottomRight = new LocationType();
    private int imageWidth = 500;
    private int imageHeight = 500;
    private String wmsServerURL = "http://www2.demis.nl/wms/wms.asp?Service=WMS&WMS=BlueMarble&";
    private String[] requestedLayers = new String[]{"Earth Image", "Borders"};

    public Image fetchImage() {
        Image resultingImage = null;
        WMService service = new WMService(this.wmsServerURL);
        try {
            service.initialize();
            MapRequest request = service.createMapRequest();
            double[] latLon2 = this.getTopLeft().getAbsoluteLatLonDepth();
            double[] latLon1 = this.getBottomRight().getAbsoluteLatLonDepth();
            BoundingBox bbox = new BoundingBox("EPSG:4326", (float)latLon2[1], (float)latLon1[0], (float)latLon1[1], (float)latLon2[0]);
            NeptusLog.pub().info((Object)("<###>minX:" + bbox.getMinX() + ", minY:" + bbox.getMinY() + ", maxX:" + bbox.getMaxX() + ", maxY:" + bbox.getMaxY()));
            request.setBoundingBox(bbox);
            LinkedList<String> layers = new LinkedList<String>();
            for (int i = 0; i < this.getRequestedLayers().length; ++i) {
                layers.add(this.getRequestedLayers()[i]);
            }
            request.setImageHeight(this.getImageHeight());
            request.setImageWidth(this.getImageWidth());
            request.setLayers(layers);
            request.setFormat("PNG");
            NeptusLog.pub().info((Object)("<###> " + request.getURL()));
            resultingImage = request.getImage();
        }
        catch (Exception e) {
            GuiUtils.errorMessage(new JFrame(), "Error ocurred while fetching image", "Error ocurred while fetching image: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        return resultingImage;
    }

    public LocationType getBottomRight() {
        return this.bottomRight;
    }

    public void setBottomRight(LocationType bottomRight) {
        this.bottomRight = bottomRight;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public String[] getRequestedLayers() {
        return this.requestedLayers;
    }

    public void setRequestedLayers(String[] requestedLayers) {
        this.requestedLayers = requestedLayers;
    }

    public LocationType getTopLeft() {
        return this.topLeft;
    }

    public void setTopLeft(LocationType topLeft) {
        this.topLeft = topLeft;
    }

    public String getWmsServerURL() {
        return this.wmsServerURL;
    }

    public void setWmsServerURL(String wmsServerURL) {
        this.wmsServerURL = wmsServerURL;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("WMS Test");
        FetcherWMS fetcher = new FetcherWMS();
        LocationType topLeft = new LocationType();
        LocationType bottomRight = new LocationType();
        topLeft.setLatitudeDegs(45.0);
        topLeft.setLongitudeDegs(-10.0);
        bottomRight.setLatitudeDegs(35.0);
        bottomRight.setLongitudeDegs(-5.0);
        fetcher.setBottomRight(bottomRight);
        fetcher.setTopLeft(topLeft);
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        JLabel jlabel = new JLabel(new ImageIcon(fetcher.fetchImage()));
        jlabel.setBackground(Color.RED);
        jlabel.setSize(400, 400);
        main.add((Component)jlabel, "Center");
        frame.setContentPane(main);
        frame.setSize(200, 300);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public Image fetchTerrainImage() {
        Image returned = null;
        return returned;
    }
}

