/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyEditor;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.table.TableCellRenderer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.editor.ComboEditor;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.actions.PlanActions;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.NameNormalizer;

public abstract class Maneuver
implements XmlOutputMethods,
PropertiesProvider,
Comparable<Maneuver> {
    public static final String CT_STRING = "String";
    public static final String CT_NUMBER = "Number";
    public static final String CT_BOOLEAN = "Boolean";
    public static final double circleDiam = 10.0;
    private static Random rnd = new Random(System.currentTimeMillis());
    private int maxTime = 10000;
    private int minTime = 0;
    protected LinkedHashMap<String, String> customSettings = new LinkedHashMap();
    protected LinkedHashMap<String, String> customSettingsTypeHint = new LinkedHashMap();
    private int xPosition = rnd.nextInt(500);
    private int yPosition = rnd.nextInt(300);
    private boolean ManeuverEnded = false;
    private boolean initialManeuver = false;
    public String id = NameNormalizer.getRandomID();
    private Hashtable<String, String> transitions = new Hashtable();
    private MissionType missionType = null;
    protected static final String DEFAULT_ROOT_ELEMENT = "node";
    protected PlanActions startActions = new PlanActions();
    protected PlanActions endActions = new PlanActions();
    GradientPaint paint1 = new GradientPaint(-10.0f, -10.0f, Color.gray, 10.0f, 10.0f, Color.white);
    GradientPaint paint2 = new GradientPaint(-10.0f, -10.0f, Color.blue, 10.0f, 10.0f, Color.white);
    GradientPaint paint3 = new GradientPaint(-12.0f, -12.0f, Color.yellow, 14.0f, 14.0f, Color.green);
    GradientPaint paint4 = new GradientPaint(-12.0f, -12.0f, Color.white, 14.0f, 14.0f, Color.red);
    Ellipse2D.Double ellis = new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0);
    Ellipse2D.Double biggerEllis = new Ellipse2D.Double(-7.0, -7.0, 14.0, 14.0);
    Rectangle2D.Double activeRect = new Rectangle2D.Double(-9.0, -9.0, 18.0, 18.0);

    public abstract void loadFromXML(String var1);

    public Maneuver[] getSamePositionManeuvers(PlanType plan, boolean includeThisManeuver) {
        if (!(this instanceof LocatedManeuver)) {
            return new Maneuver[0];
        }
        Vector<Maneuver> samePosMans = new Vector<Maneuver>();
        Maneuver[] allMans = plan.getGraph().getAllManeuvers();
        ManeuverLocation myPos = ((LocatedManeuver)((Object)this)).getManeuverLocation();
        for (Maneuver m : allMans) {
            double dist;
            if (!(m instanceof LocatedManeuver) || !includeThisManeuver && m.getId().equals(this.getId()) || !((double)((float)(dist = ((LocatedManeuver)((Object)m)).getManeuverLocation().getHorizontalDistanceInMeters(myPos))) < 0.01)) continue;
            samePosMans.add(m);
        }
        return samePosMans.toArray(new Maneuver[0]);
    }

    public void paintOnMap(Graphics2D g2d, PlanElement planElement, StateRenderer2D renderer) {
        Maneuver[] posMans;
        if (this instanceof LocatedManeuver) {
            if (planElement.isBeingEdited()) {
                g2d.setPaint(this.paint2);
                g2d.fill(this.ellis);
            } else {
                g2d.setPaint(this.paint1);
                g2d.fill(this.ellis);
            }
        } else {
            g2d.setPaint(this.paint1);
            g2d.fill(this.ellis);
        }
        if (planElement.getActiveManeuver() != null && planElement.getActiveManeuver().equals(this.getId())) {
            g2d.setColor(Color.yellow);
            g2d.fill(this.activeRect);
            g2d.setColor(new Color(150, 0, 0));
            g2d.draw(this.biggerEllis);
        }
        if (this.isInitialManeuver()) {
            if (planElement.isBeingEdited()) {
                g2d.setPaint(this.paint3);
                g2d.fill(this.biggerEllis);
                g2d.setColor(new Color(0, 150, 0));
                g2d.draw(this.biggerEllis);
            } else {
                g2d.setColor(Color.green.darker().darker());
                g2d.fill(this.biggerEllis);
            }
        }
        if (planElement.getSelectedManeuver() != null && planElement.getSelectedManeuver().equals(this.getId())) {
            g2d.setPaint(this.paint4);
            g2d.fill(this.biggerEllis);
            g2d.setColor(new Color(150, 0, 0));
            g2d.draw(this.biggerEllis);
        } else {
            g2d.setColor(Color.black);
            g2d.draw(this.ellis);
        }
        if (this instanceof LocatedManeuver) {
            ManeuverLocation loc = ((LocatedManeuver)((Object)this)).getManeuverLocation();
            g2d.setColor(Color.black);
            switch (loc.getZUnits()) {
                case ALTITUDE: {
                    g2d.fill(new Rectangle2D.Double(-8.0, 5.0, 16.0, 3.0));
                    g2d.setColor(Color.orange);
                    g2d.draw(new Line2D.Double(-6.0, 6.0, 6.0, 6.0));
                    break;
                }
                case DEPTH: {
                    if (loc.getZ() == 0.0) {
                        g2d.fill(new Rectangle2D.Double(-10.0, -1.0, 20.0, 2.0));
                        g2d.setColor(Color.white);
                        g2d.draw(new Line2D.Double(-8.0, 0.0, 8.0, 0.0));
                        break;
                    }
                    g2d.fill(new Rectangle2D.Double(-8.0, -8.0, 16.0, 3.0));
                    g2d.setColor(Color.cyan.brighter());
                    g2d.draw(new Line2D.Double(-6.0, -6.0, 6.0, -6.0));
                    break;
                }
                case HEIGHT: {
                    g2d.setColor(Color.white);
                    g2d.draw(new Line2D.Double(-6.0, 0.0, 6.0, 0.0));
                    break;
                }
            }
        }
        Font oldFont = g2d.getFont();
        g2d.setFont(new Font("Arial", 0, 11));
        String text = this.getId();
        String depthStr = "";
        if (planElement.getSelectedManeuver() != null && planElement.getSelectedManeuver().equals(this.getId()) && this instanceof LocatedManeuver) {
            ManeuverLocation loc = ((LocatedManeuver)((Object)this)).getManeuverLocation();
            double depth = loc.getZ();
            switch (loc.getZUnits()) {
                case ALTITUDE: {
                    depthStr = "[" + I18n.text("altitude") + ": " + depth + I18n.textc("m", "meters") + "]";
                    break;
                }
                case DEPTH: {
                    depthStr = "[" + I18n.text("depth") + ": " + depth + I18n.textc("m", "meters") + "]";
                    break;
                }
                case HEIGHT: {
                    depthStr = "[" + I18n.text("height") + ": " + depth + I18n.textc("m", "meters") + "]";
                    break;
                }
                default: {
                    depthStr = "[" + I18n.textc("z", "Maneuver's z value") + ": " + depth + I18n.textc("m", "meters") + "]";
                }
            }
            text = text + depthStr;
        }
        if ((posMans = this.getSamePositionManeuvers(planElement.getPlan(), true)).length > 1) {
            text = posMans[0].getId();
            if (this.getId().equals(posMans[0].getId())) {
                text = text + depthStr;
            }
            for (int i = 1; i < posMans.length && i < 3; ++i) {
                text = text + ", " + posMans[i].getId();
                if (!this.getId().equals(posMans[i].getId())) continue;
                text = text + depthStr;
            }
        }
        if (posMans.length > 3) {
            text = text + "..." + posMans[posMans.length - 1].getId();
            if (this.getId().equals(posMans[posMans.length - 1].getId())) {
                text = text + depthStr;
            }
        }
        Rectangle2D stringBounds = g2d.getFontMetrics().getStringBounds(text, g2d);
        int x = (int)(-stringBounds.getWidth() / 2.0);
        int y = (int)(stringBounds.getHeight() + 5.0);
        g2d.setColor(Color.BLACK);
        g2d.drawString(text, x + 1, y + 1);
        g2d.drawString(text, x - 1, y + 1);
        g2d.drawString(text, x + 1, y - 1);
        g2d.drawString(text, x - 1, y - 1);
        g2d.setColor(Color.WHITE);
        g2d.drawString(text, x, y);
        g2d.setFont(oldFont);
    }

    public static Maneuver createFromXML(String xml) {
        Random rnd = new Random(GregorianCalendar.getInstance().getTimeInMillis());
        new LinkedHashMap();
        new LinkedHashMap();
        int xPos = rnd.nextInt(300);
        int yPos = rnd.nextInt(250);
        Maneuver man = null;
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            String id = doc.selectSingleNode("./node/id").getText();
            Node nd = doc.selectSingleNode("./node/@xPos");
            if (nd != null) {
                xPos = Integer.parseInt(nd.getText());
            }
            if ((nd = doc.selectSingleNode("./node/@yPos")) != null) {
                yPos = Integer.parseInt(nd.getText());
            }
            boolean isInitial = false;
            nd = doc.selectSingleNode("./node/@start");
            if (nd != null && nd.getText().equals("true")) {
                isInitial = true;
            }
            Element maneuver = doc.getRootElement().element("maneuver");
            Iterator elementIterator = maneuver.elementIterator();
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            while (elementIterator.hasNext()) {
                Element element = (Element)elementIterator.next();
                if (element.getName().equals("custom-settings") || element.getName().equals("minTime") || element.getName().equals("maxTime")) continue;
                String manType = element.getName();
                try {
                    man = (Maneuver)cl.loadClass("pt.lsts.neptus.mp.maneuvers." + manType).newInstance();
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)("maneuver not found: " + manType + " (" + e.getMessage() + ")"));
                }
                if (man == null) {
                    return null;
                }
                man.setId(id);
                man.setInitialManeuver(isInitial);
                man.setXPosition(xPos);
                man.setYPosition(yPos);
                man.loadFromXML(element.asXML());
                man.loadFromXMLExtraParameters(element.getParent());
                nd = doc.selectSingleNode("./node/actions/start-actions");
                if (nd != null) {
                    man.startActions.load((Element)nd);
                }
                if ((nd = doc.selectSingleNode("./node/actions/end-actions")) == null) continue;
                man.endActions.load((Element)nd);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)System.err, (Throwable)e);
        }
        return man;
    }

    public void loadFromXMLExtraParameters(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            this.loadFromXMLExtraParameters(doc.getRootElement());
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)"Could not load extra parameters of maneuver");
        }
    }

    public void loadFromXMLExtraParameters(Element maneuver) {
        LinkedHashMap<String, String> custSettings = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> custSettingsTypeHint = new LinkedHashMap<String, String>();
        Iterator elementIterator = maneuver.elementIterator();
        while (elementIterator.hasNext()) {
            Element element = (Element)elementIterator.next();
            if (element.getName().equals("minTime")) {
                this.minTime = Integer.parseInt(element.getText());
                continue;
            }
            if (element.getName().equals("maxTime")) {
                this.maxTime = Integer.parseInt(element.getText());
                continue;
            }
            if (!element.getName().equals("custom-settings")) continue;
            List lst = element.selectNodes("setting");
            custSettings.clear();
            for (Object node : lst) {
                Element elem = (Element)node;
                elem.getText();
                Node n1 = elem.selectSingleNode("@name");
                if (n1 == null) continue;
                custSettings.put(n1.getText(), elem.getText());
                Node n2 = elem.selectSingleNode("@type-hint");
                if (n2 == null) continue;
                String typeHint = n2.getText();
                typeHint = CT_NUMBER.equalsIgnoreCase(typeHint) ? CT_NUMBER : (CT_BOOLEAN.equalsIgnoreCase(typeHint) ? CT_BOOLEAN : CT_STRING);
                custSettingsTypeHint.put(n1.getText(), typeHint);
            }
        }
        this.setCustomSettings(custSettings);
        this.setCustomSettingsTypeHint(custSettingsTypeHint);
    }

    public PlanActions getStartActions() {
        return this.startActions;
    }

    public PlanActions getEndActions() {
        return this.endActions;
    }

    public String getType() {
        return this.getClass().getSimpleName();
    }

    public abstract Object clone();

    public Object clone(Maneuver clone) {
        clone.setMaxTime(this.getMaxTime());
        clone.setMinTime(this.getMinTime());
        clone.setXPosition(this.getXPosition());
        clone.setYPosition(this.getYPosition());
        clone.setMissionType(this.getMissionType());
        clone.setId(this.getId());
        clone.setInitialManeuver(this.isInitialManeuver());
        clone.setCustomSettings(this.getCustomSettings());
        clone.setCustomSettingsTypeHint(this.getCustomSettingsTypeHint());
        clone.startActions = new PlanActions();
        clone.startActions.load(this.startActions.asElement("start-actions"));
        clone.endActions = new PlanActions();
        clone.endActions.load(this.endActions.asElement("end-actions"));
        return clone;
    }

    public void endManeuver() {
        this.ManeuverEnded = true;
    }

    public boolean hasEnded() {
        return this.ManeuverEnded;
    }

    public void addTransition(String target, String condition) {
        this.transitions.put(target, condition);
    }

    public void removeTransition(String target) {
        this.transitions.remove(target);
    }

    public String[] getReacheableManeuvers() {
        Object[] trans = this.transitions.keySet().toArray();
        String[] mans = new String[trans.length];
        for (int i = 0; i < trans.length; ++i) {
            mans[i] = (String)trans[i];
        }
        return mans;
    }

    public String getTransitionCondition(String targetManeuver) {
        return this.transitions.get(targetManeuver);
    }

    public String getManeuverXml() {
        return this.getManeuverAsDocument(this.getType()).asXML();
    }

    public void loadManeuverXml(String manXml) {
        this.loadFromXML(manXml);
    }

    @Override
    public String asXML() {
        String rootElementName = this.getType();
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = this.getType();
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        if (this.isInitialManeuver()) {
            root.addAttribute("start", "true");
        } else {
            root.addAttribute("start", "false");
        }
        Element id = root.addElement("id");
        id.setText(this.getId());
        root.addAttribute("xPos", String.valueOf(this.getXPosition()));
        root.addAttribute("yPos", String.valueOf(this.getYPosition()));
        Element manElement = root.addElement("maneuver");
        manElement.addElement("minTime").setText(String.valueOf(this.getMinTime()));
        manElement.addElement("maxTime").setText(String.valueOf(this.getMaxTime()));
        manElement.add(this.getManeuverAsDocument(this.getType()).getRootElement());
        if (!this.customSettings.isEmpty()) {
            Element customSettingsElem = manElement.addElement("custom-settings");
            for (String key : this.customSettings.keySet()) {
                Element setElem = customSettingsElem.addElement("setting");
                setElem.setText(this.customSettings.get(key));
                setElem.addAttribute("name", key);
                if (CT_NUMBER.equalsIgnoreCase(this.customSettingsTypeHint.get(key))) {
                    setElem.addAttribute("type-hint", CT_NUMBER);
                    continue;
                }
                if (CT_BOOLEAN.equalsIgnoreCase(this.customSettingsTypeHint.get(key))) {
                    setElem.addAttribute("type-hint", CT_BOOLEAN);
                    continue;
                }
                setElem.addAttribute("type-hint", CT_STRING);
            }
        }
        Element sActionsElm = this.startActions.asElement("start-actions");
        Element eActionsElm = this.endActions.asElement("end-actions");
        if (sActionsElm.hasContent() || eActionsElm.hasContent()) {
            Element acElm = root.addElement("actions");
            if (sActionsElm.hasContent()) {
                acElm.add(sActionsElm);
            }
            if (eActionsElm.hasContent()) {
                acElm.add(eActionsElm);
            }
        }
        return document;
    }

    public abstract Document getManeuverAsDocument(String var1);

    public String toString() {
        return this.getType();
    }

    public ImageIcon getIcon() {
        return GuiUtils.getLetterIcon(Character.valueOf(this.getClass().getSimpleName().charAt(0)), Color.white, Color.blue.darker(), 16);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isInitialManeuver() {
        return this.initialManeuver;
    }

    public void setInitialManeuver(boolean initialManeuver) {
        this.initialManeuver = initialManeuver;
    }

    public int getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(int position) {
        this.xPosition = position;
    }

    public int getYPosition() {
        return this.yPosition;
    }

    public void setYPosition(int position) {
        this.yPosition = position;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(int maxTime) {
        this.maxTime = maxTime;
    }

    public int getMinTime() {
        return this.minTime;
    }

    public void setMinTime(int minTime) {
        this.minTime = minTime;
    }

    public LinkedHashMap<String, String> getCustomSettings() {
        return this.customSettings;
    }

    public void setCustomSettings(LinkedHashMap<String, String> customSettings) {
        this.customSettings = customSettings;
    }

    public LinkedHashMap<String, String> getCustomSettingsTypeHint() {
        return this.customSettingsTypeHint;
    }

    public void setCustomSettingsTypeHint(LinkedHashMap<String, String> customSettingsTypeHint) {
        this.customSettingsTypeHint = customSettingsTypeHint;
    }

    public double interpolate(double currentValue, double desiredValue, double maxStep) {
        if (currentValue == desiredValue) {
            return desiredValue;
        }
        double diff = desiredValue - currentValue;
        if (Math.abs(diff) < maxStep) {
            return desiredValue;
        }
        if (diff > 0.0) {
            return currentValue + maxStep;
        }
        return currentValue - maxStep;
    }

    public MissionType getMissionType() {
        return this.missionType;
    }

    public void setMissionType(MissionType missionType) {
        this.missionType = missionType;
    }

    @Override
    public DefaultProperty[] getProperties() {
        TableCellRenderer tcr;
        PropertyEditor pe;
        Vector<DefaultProperty> props = new Vector<DefaultProperty>();
        DefaultProperty id = PropertiesEditor.getPropertyInstance("ID", I18n.text("Generic properties"), String.class, this.getId(), false);
        id.setDisplayName(I18n.text("ID"));
        id.setShortDescription(I18n.text("The identifier for this object"));
        props.add(id);
        DefaultProperty initialMan = PropertiesEditor.getPropertyInstance("Initial Maneuver", I18n.text("Generic properties"), Boolean.class, this.isInitialManeuver(), true);
        initialMan.setDisplayName(I18n.text("Initial Maneuver"));
        initialMan.setShortDescription(I18n.text("Whether this will be the first maneuver to be executed"));
        props.add(initialMan);
        if (this instanceof LocatedManeuver) {
            ManeuverLocation loc = ((LocatedManeuver)((Object)this)).getManeuverLocation().clone();
            loc.convertToAbsoluteLatLonDepth();
            DefaultProperty propertyLocation = PropertiesEditor.getPropertyInstance("Location", I18n.text("Location"), ManeuverLocation.class, loc, true, I18n.text("Maneuver's location"));
            propertyLocation.setDisplayName(I18n.text("Location"));
            props.add(propertyLocation);
            DefaultProperty propertyZ = PropertiesEditor.getPropertyInstance("Z", I18n.text("Location"), Double.class, loc.getZ(), true, I18n.text("Maneuver's z value"));
            propertyZ.setDisplayName(I18n.textc("Z", "Maneuver's z value"));
            props.add(propertyZ);
            DefaultProperty pz = PropertiesEditor.getPropertyInstance("Z-Units", I18n.text("Location"), ManeuverLocation.Z_UNITS.class, (Object)loc.getZUnits(), true, I18n.text("Maneuver's z units"));
            pz.setDisplayName(I18n.textc("Z-Units", "Maneuver's z units"));
            PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)pz, new ComboEditor<ManeuverLocation.Z_UNITS>(ManeuverLocation.Z_UNITS.values()));
            props.add(pz);
        }
        Vector<DefaultProperty> additionalProperties = this.additionalProperties();
        Vector<DefaultProperty> addProps = new Vector<DefaultProperty>();
        HashMap<String, PropertyEditor> peLList = new HashMap<String, PropertyEditor>();
        HashMap<String, TableCellRenderer> peRendererList = new HashMap<String, TableCellRenderer>();
        for (DefaultProperty p : additionalProperties) {
            pe = PropertiesEditor.getPropertyEditorRegistry().getEditor((Property)p);
            peLList.put(p.getName(), pe);
            tcr = PropertiesEditor.getPropertyRendererRegistry().getRenderer((Property)p);
            peRendererList.put(p.getName(), tcr);
        }
        PropertiesEditor.localizeProperties(additionalProperties, addProps);
        for (DefaultProperty p : addProps) {
            p.setCategory(I18n.textf("%s specific properties", this.getType()));
            pe = (PropertyEditor)peLList.get(p.getName());
            if (pe != null) {
                PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)p, pe);
            }
            if ((tcr = (TableCellRenderer)peRendererList.get(p.getName())) == null) continue;
            PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)p, tcr);
        }
        props.addAll(addProps);
        for (String key : this.customSettings.keySet()) {
            String value = this.customSettings.get(key);
            String typeHint = this.customSettingsTypeHint.get(key);
            Class clazz = CT_NUMBER.equalsIgnoreCase(typeHint) ? Double.class : (CT_BOOLEAN.equalsIgnoreCase(typeHint) ? Boolean.class : String.class);
            Object valObj = null;
            try {
                valObj = CT_NUMBER.equalsIgnoreCase(typeHint) ? new Double(value) : (CT_BOOLEAN.equalsIgnoreCase(typeHint) ? new Boolean(value) : new String(value));
            }
            catch (NumberFormatException e) {
                NeptusLog.pub().error((Object)(this.getType() + ": Error parsing custom setting '" + value + "' to '" + clazz.getSimpleName() + "'!"));
                clazz = String.class;
            }
            DefaultProperty custSet = PropertiesEditor.getPropertyInstance(key, I18n.textf("%s custom settings", this.getType()), clazz, valObj, true);
            props.add(custSet);
        }
        return props.toArray(new DefaultProperty[0]);
    }

    protected Vector<DefaultProperty> additionalProperties() {
        return new Vector<DefaultProperty>();
    }

    @Override
    public void setProperties(Property[] properties) {
        for (Property p : properties) {
            try {
                PlanActions value;
                String pName;
                ManeuverLocation manLoc;
                if (p.getName().equalsIgnoreCase("Initial Maneuver")) {
                    this.setInitialManeuver((Boolean)p.getValue());
                    continue;
                }
                if (p.getName().equalsIgnoreCase(I18n.text("Initial Maneuver"))) {
                    this.setInitialManeuver((Boolean)p.getValue());
                    continue;
                }
                if (p.getName().equalsIgnoreCase("Z") && this instanceof LocatedManeuver) {
                    manLoc = ((LocatedManeuver)((Object)this)).getManeuverLocation();
                    manLoc.setZ((Double)p.getValue());
                    ((LocatedManeuver)((Object)this)).setManeuverLocation(manLoc);
                    continue;
                }
                if (p.getName().equalsIgnoreCase("Z-Units") && this instanceof LocatedManeuver) {
                    manLoc = ((LocatedManeuver)((Object)this)).getManeuverLocation();
                    manLoc.setZUnits((ManeuverLocation.Z_UNITS)((Object)p.getValue()));
                    ((LocatedManeuver)((Object)this)).setManeuverLocation(manLoc);
                    continue;
                }
                if (p.getName().equalsIgnoreCase("Location") && this instanceof LocatedManeuver) {
                    ((LocatedManeuver)((Object)this)).getManeuverLocation().setLocation((LocationType)p.getValue());
                    continue;
                }
                if (p.getCategory() != null && p.getCategory().equalsIgnoreCase(I18n.textf("%s custom settings", this.getType()))) {
                    pName = p.getName();
                    for (String key : this.customSettings.keySet()) {
                        if (!pName.equalsIgnoreCase(key)) continue;
                        String value2 = p.getValue().toString();
                        this.customSettings.put(key, value2);
                    }
                    continue;
                }
                if (p.getCategory() != null && p.getCategory().equalsIgnoreCase(I18n.textf("%s start actions", this.getType()))) {
                    pName = p.getName();
                    if (!pName.equalsIgnoreCase("start-actions")) continue;
                    this.startActions = value = (PlanActions)p.getValue();
                    continue;
                }
                if (p.getCategory() == null || !p.getCategory().equalsIgnoreCase(I18n.textf("%s end actions", this.getType())) || !(pName = p.getName()).equalsIgnoreCase("end-actions")) continue;
                this.endActions = value = (PlanActions)p.getValue();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        Vector<String> errors = new Vector<String>();
        for (Property p : properties) {
            int val;
            if (p.getName().equals("Minimum time") && (val = ((Integer)p.getValue()).intValue()) < 0) {
                errors.add(I18n.text("The minimum time value must be greater or equal than 0"));
            }
            if (p.getName().equals(I18n.text("Maximum time")) && (val = ((Integer)p.getValue()).intValue()) <= 0) {
                errors.add(I18n.text("The maximum time value must be greater than 0"));
            }
            if (!p.getCategory().equalsIgnoreCase(I18n.textf("%s custom settings", this.getType()))) continue;
            String pName = p.getName();
            for (String key : this.customSettings.keySet()) {
                if (!pName.equalsIgnoreCase(key)) continue;
                Object valObj = p.getValue();
                String typeHint = this.customSettingsTypeHint.get(key);
                Class clazz = CT_NUMBER.equalsIgnoreCase(typeHint) ? Double.class : (CT_BOOLEAN.equalsIgnoreCase(typeHint) ? Boolean.class : String.class);
                try {
                    if (CT_NUMBER.equalsIgnoreCase(typeHint)) {
                        valObj = (Double)valObj;
                        continue;
                    }
                    if (CT_BOOLEAN.equalsIgnoreCase(typeHint)) {
                        valObj = (Boolean)valObj;
                        continue;
                    }
                    valObj = (String)valObj;
                }
                catch (NumberFormatException e) {
                    errors.add(I18n.textf("Error parsing custom setting '%s' to '%s'!", valObj.toString(), clazz.getSimpleName()));
                }
            }
        }
        String[] errorsExtra = PluginUtils.validatePluginProperties((Object)this, properties);
        errors.addAll(Arrays.asList(errorsExtra));
        return errors.toArray(new String[0]);
    }

    @Override
    public String getPropertiesDialogTitle() {
        return I18n.textf("%s properties", this.getId());
    }

    public void cloneActions(Maneuver otherMan) {
        this.startActions = new PlanActions();
        this.startActions.load(otherMan.getStartActions().asElement("start-actions"));
        this.endActions = new PlanActions();
        this.endActions.load(otherMan.getEndActions().asElement("end-actions"));
    }

    public String getTooltipText() {
        String tt = "";
        tt = !this.isInitialManeuver() ? "<html><b><font color='#0000CC'>" + this.getId() + "</font></b> " + I18n.text(this.getType()) : "<html><b><font color='#00CC00'>" + this.getId() + "</font></b> " + I18n.text(this.getType());
        if (!this.getStartActions().isEmpty() || !this.getEndActions().isEmpty()) {
            tt = tt + "<hr>" + (this.getStartActions().isEmpty() ? "" : I18n.text("payload actions")) + (this.getEndActions().isEmpty() ? "" : (this.getStartActions().isEmpty() ? "" : " | ") + I18n.text("end actions"));
        }
        return tt;
    }

    @Override
    public int compareTo(Maneuver o) {
        return this.getId().compareTo(o.getId());
    }

    public static enum SPEED_UNITS {
        METERS_PS(0, "Meters per second"),
        RPM(1, "RPM"),
        PERCENTAGE(2, "Percentage");

        private int value;
        private String name;

        private SPEED_UNITS(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getString() {
            return this.name;
        }
    }

    public static enum Z_UNITS {
        NONE(0, "None"),
        DEPTH(1, "Depth"),
        ALTITUDE(2, "Altitude"),
        HEIGHT(3, "Height (WGS84)");

        private int value;
        private String name;

        private Z_UNITS(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getString() {
            return this.name;
        }
    }
}

