/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp;

import java.awt.Color;
import java.util.LinkedHashMap;
import javax.swing.ImageIcon;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.maneuvers.DefaultManeuver;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.GuiUtils;

public class ManeuverFactory {
    private LinkedHashMap<String, Maneuver> availableManeuvers = new LinkedHashMap();
    double manAltitude = 0.0;
    boolean forceManeuverAltitude = false;

    public ManeuverFactory(VehicleType vehicle) {
        if (vehicle == null) {
            return;
        }
        for (String manName : vehicle.getFeasibleManeuvers().keySet()) {
            Maneuver man = ManeuverFactory.createManeuver(manName, vehicle.getFeasibleManeuvers().get(manName));
            if (man == null) {
                man = new DefaultManeuver();
            }
            this.availableManeuvers.put(man.getType(), man);
        }
    }

    public ImageIcon getManeuverIcon(String manName) {
        if (this.availableManeuvers.containsKey(manName)) {
            return this.availableManeuvers.get(manName).getIcon();
        }
        return GuiUtils.getLetterIcon(Character.valueOf('?'), Color.white, Color.red.darker(), 16);
    }

    public void putManeuver(Maneuver man) {
        this.availableManeuvers.put(man.getType(), man);
    }

    public String[] getAvailableManeuversIDs() {
        return this.availableManeuvers.keySet().toArray(new String[0]);
    }

    public Maneuver getManeuver(String maneuverName) {
        if (this.availableManeuvers.containsKey(maneuverName)) {
            Maneuver tmp = (Maneuver)this.availableManeuvers.get(maneuverName).clone();
            if (tmp instanceof LocatedManeuver && this.forceManeuverAltitude) {
                LocationType lt = new LocationType(((LocatedManeuver)((Object)tmp)).getManeuverLocation());
                lt.setHeight(this.manAltitude);
                lt.setOffsetDown(0.0);
                ((LocatedManeuver)((Object)tmp)).getManeuverLocation().setLocation(lt);
            }
            return tmp;
        }
        NeptusLog.pub().error((Object)(this + ": The maneuver " + maneuverName + " can't be created"));
        return null;
    }

    public boolean existsManeuver(String classFileName) {
        return ManeuverFactory.createManeuver("", classFileName) != null;
    }

    public static Maneuver createManeuver(String manName, String classFileName) {
        ClassLoader loader = new Goto().getClass().getClassLoader();
        Maneuver man = null;
        try {
            Class<?> clazz = loader.loadClass(classFileName);
            DefaultManeuver tmp = null;
            tmp = (DefaultManeuver)clazz.newInstance();
            if (tmp == null) {
                tmp = new DefaultManeuver();
            }
            if (tmp instanceof Maneuver) {
                man = tmp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            NeptusLog.pub().warn((Object)("class not found: " + classFileName));
        }
        return man;
    }

    public boolean isForceManeuverAltitude() {
        return this.forceManeuverAltitude;
    }

    public void setForceManeuverAltitude(boolean forceManeuverAltitude) {
        this.forceManeuverAltitude = forceManeuverAltitude;
    }

    public double getManAltitude() {
        return this.manAltitude;
    }

    public void setManAltitude(double manAltitude) {
        this.manAltitude = manAltitude;
    }
}

