/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp;

import org.dom4j.Document;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.coord.LocationType;

public class ManeuverLocation
extends LocationType {
    private static final long serialVersionUID = 1L;
    protected double z = 0.0;
    protected Z_UNITS zUnits = Z_UNITS.NONE;

    public ManeuverLocation() {
    }

    public ManeuverLocation(LocationType loc) {
        super(loc);
        if (loc instanceof ManeuverLocation) {
            ManeuverLocation mloc = (ManeuverLocation)loc;
            this.setZ(mloc.getZ());
            this.setZUnits(mloc.getZUnits());
        }
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public Z_UNITS getZUnits() {
        return this.zUnits;
    }

    public void setZUnits(Z_UNITS zUnits) {
        this.zUnits = zUnits;
    }

    @Override
    public ManeuverLocation clone() {
        ManeuverLocation loc = new ManeuverLocation();
        loc.setLocation(this);
        loc.setZ(this.getZ());
        loc.setZUnits(this.getZUnits());
        return loc;
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = super.asDocument(rootElementName);
        document.getRootElement().addElement("z").setText("" + this.getZ());
        document.getRootElement().addElement("zunits").setText(this.getZUnits().toString());
        return document;
    }

    @Override
    public boolean load(Document doc) {
        super.load(doc);
        Node node = doc.selectSingleNode("//depth");
        if (node != null) {
            this.setZ(Double.parseDouble(node.getText()));
            if (this.getZ() >= 0.0) {
                this.setZUnits(Z_UNITS.DEPTH);
            } else {
                this.setZUnits(Z_UNITS.ALTITUDE);
                this.setZ(-this.getZ());
            }
        }
        if ((node = doc.selectSingleNode("//height")) != null) {
            this.setZUnits(Z_UNITS.HEIGHT);
            this.setZ(Double.parseDouble(node.getText()));
        }
        if ((node = doc.selectSingleNode("//altitude")) != null) {
            this.setZUnits(Z_UNITS.ALTITUDE);
            this.setZ(Double.parseDouble(node.getText()));
        }
        if ((node = doc.selectSingleNode("//z")) != null) {
            this.setZ(Double.parseDouble(node.getText()));
        }
        if ((node = doc.selectSingleNode("//zunits")) != null) {
            this.setZUnits(Z_UNITS.valueOf(node.getText()));
        }
        return true;
    }

    public static void main(String[] args) {
        ManeuverLocation loc = new ManeuverLocation();
        loc.setZ(10.0);
        loc.setZUnits(Z_UNITS.ALTITUDE);
        String xml = loc.asXML();
        ManeuverLocation loc2 = new ManeuverLocation();
        loc2.load(xml);
        NeptusLog.pub().info((Object)("<###> " + loc2.asXML()));
    }

    public static enum Z_UNITS {
        NONE(0L),
        DEPTH(1L),
        ALTITUDE(2L),
        HEIGHT(3L);

        protected long value;

        public long value() {
            return this.value;
        }

        private Z_UNITS(long value) {
            this.value = value;
        }
    }
}

