/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.beans.editor.FixedButton;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pt.lsts.neptus.gui.SimpleLocationPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.types.coord.LocationType;

public class ManeuverLocationEditor
extends AbstractPropertyEditor {
    protected JTextField textField = new JTextField();
    private JButton button = new FixedButton();
    private ManeuverLocation location = new ManeuverLocation();

    public ManeuverLocationEditor() {
        this.textField.setEditable(false);
        this.editor = new JPanel(new BorderLayout(0, 0));
        ((JPanel)this.editor).add((Component)this.textField, "Center");
        ((JPanel)this.editor).add((Component)this.button, "East");
        this.textField.setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationType oldLoc = new LocationType();
                oldLoc.setLocation(ManeuverLocationEditor.this.location);
                LocationType newLoc = SimpleLocationPanel.showHorizontalLocationDialog(oldLoc, I18n.text("Change maneuver location"), true, ManeuverLocationEditor.this.editor);
                if (newLoc != null) {
                    ManeuverLocationEditor.this.setValue(newLoc);
                    ManeuverLocationEditor.this.firePropertyChange(oldLoc, newLoc);
                    ManeuverLocationEditor.this.textField.setText(ManeuverLocationEditor.this.location.toString());
                }
            }
        });
    }

    public Object getValue() {
        return this.location;
    }

    public void setValue(Object arg0) {
        double oldz = this.location.getZ();
        ManeuverLocation.Z_UNITS oldUnits = this.location.getZUnits();
        if (arg0 instanceof ManeuverLocation) {
            this.location.setLocation((ManeuverLocation)arg0);
            this.location.setZ(oldz);
            this.location.setZUnits(oldUnits);
            this.textField.setText(this.location.toString());
        }
    }

    public static void main(String[] args) {
    }
}

