/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlRootElement;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.ParallelepipedElement;

@XmlRootElement(name="OperationLimits")
@LayerPriority(priority=35)
public class OperationLimits
implements Renderer2DPainter {
    protected Double maxDepth = null;
    protected Double minAltitude = null;
    protected Double maxAltitude = null;
    protected Double maxSpeed = null;
    protected Double minSpeed = null;
    protected Double maxVertRate = null;
    protected Double opAreaWidth = null;
    protected Double opAreaLength = null;
    protected Double opAreaLat = null;
    protected Double opAreaLon = null;
    protected Double opRotationRads = null;
    protected boolean editing = false;

    public Double getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(Double maxDepth) {
        this.maxDepth = maxDepth;
    }

    public Double getMinAltitude() {
        return this.minAltitude;
    }

    public void setMinAltitude(Double minAltitude) {
        this.minAltitude = minAltitude;
    }

    public Double getMaxAltitude() {
        return this.maxAltitude;
    }

    public void setMaxAltitude(Double maxAltitude) {
        this.maxAltitude = maxAltitude;
    }

    public Double getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(Double maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public Double getMinSpeed() {
        return this.minSpeed;
    }

    public void setMinSpeed(Double minSpeed) {
        this.minSpeed = minSpeed;
    }

    public Double getMaxVertRate() {
        return this.maxVertRate;
    }

    public void setMaxVertRate(Double maxVertRate) {
        this.maxVertRate = maxVertRate;
    }

    public Double getOpAreaWidth() {
        return this.opAreaWidth;
    }

    public void setOpAreaWidth(Double opAreaWidth) {
        this.opAreaWidth = opAreaWidth;
    }

    public Double getOpAreaLength() {
        return this.opAreaLength;
    }

    public void setOpAreaLength(Double opAreaLength) {
        this.opAreaLength = opAreaLength;
    }

    public Double getOpAreaLat() {
        return this.opAreaLat;
    }

    public void setOpAreaLat(Double opAreaLat) {
        this.opAreaLat = opAreaLat;
    }

    public Double getOpAreaLon() {
        return this.opAreaLon;
    }

    public void setOpAreaLon(Double opAreaLon) {
        this.opAreaLon = opAreaLon;
    }

    public Double getOpRotationRads() {
        return this.opRotationRads;
    }

    public void setOpRotationRads(Double opRotationRads) {
        this.opRotationRads = opRotationRads;
    }

    public void setArea(ParallelepipedElement selection) {
        if (selection == null) {
            this.opRotationRads = null;
            this.opAreaWidth = null;
            this.opAreaLength = null;
            this.opAreaLon = null;
            this.opAreaLat = null;
        } else {
            double[] lld = selection.getCenterLocation().getAbsoluteLatLonDepth();
            this.opAreaLat = lld[0];
            this.opAreaLon = lld[1];
            this.opAreaLength = selection.getLength();
            this.opAreaWidth = selection.getWidth();
            this.opRotationRads = selection.getYawRad();
        }
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.opAreaLat != null && this.opAreaLength != null && this.opAreaLon != null && this.opAreaWidth != null && this.opRotationRads != null) {
            LocationType lt = new LocationType();
            lt.setLatitudeDegs(this.opAreaLat);
            lt.setLongitudeDegs(this.opAreaLon);
            Point2D pt = renderer.getScreenPosition(lt);
            g.translate(pt.getX(), pt.getY());
            g.scale(1.0, -1.0);
            g.rotate(renderer.getRotation());
            g.rotate(-this.opRotationRads.doubleValue() + 1.5707963267948966);
            g.setColor(Color.red.brighter());
            double length = this.opAreaLength * (double)renderer.getZoom();
            double width = this.opAreaWidth * (double)renderer.getZoom();
            g.draw(new Rectangle2D.Double(-length / 2.0, -width / 2.0, length, width));
        }
    }

    public boolean showDialog() {
        return false;
    }

    public String asXml() {
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)this, (Writer)writer);
        return writer.toString();
    }

    public static OperationLimits loadXml(String xml) {
        return (OperationLimits)JAXB.unmarshal((Reader)new StringReader(xml), OperationLimits.class);
    }

    public static void main(String[] args) {
        OperationLimits lims = new OperationLimits();
        lims.setMaxAltitude(200.0);
        lims.setMinAltitude(100.0);
        String xml = lims.asXml();
        NeptusLog.pub().info((Object)("<###> " + xml));
        OperationLimits lims2 = OperationLimits.loadXml(xml);
        NeptusLog.pub().info((Object)("<###> " + lims2.asXml()));
    }
}

