/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp;

import java.io.Serializable;
import pt.lsts.imc.EstimatedState;
import pt.lsts.neptus.types.coord.LocationType;

public class SystemPositionAndAttitude
implements Cloneable,
Comparable<SystemPositionAndAttitude>,
Serializable {
    private static final long serialVersionUID = -5241496476923632391L;
    private double roll = 0.0;
    private double pitch = 0.0;
    private double yaw = 0.0;
    private double altitude = 0.0;
    private Vector3Dimension pqr = new Vector3Dimension();
    private Vector3Dimension uvw = new Vector3Dimension();
    private Vector3Dimension vxyz = new Vector3Dimension();
    private long time = 0L;
    private LocationType position = new LocationType();
    private LocationType guine = new LocationType();

    public SystemPositionAndAttitude() {
    }

    public SystemPositionAndAttitude(LocationType position, double roll, double pitch, double yaw) {
        this.setPosition(position);
        this.setRoll(roll);
        this.setPitch(pitch);
        this.setYaw(yaw);
    }

    public EstimatedState toEstimatedState() {
        EstimatedState estate = new EstimatedState();
        LocationType loc = new LocationType(this.getPosition());
        loc.convertToAbsoluteLatLonDepth();
        estate.setLat(loc.getLatitudeRads());
        estate.setLon(loc.getLongitudeRads());
        estate.setDepth(loc.getDepth());
        estate.setAlt(this.getAltitude());
        estate.setPhi(this.getRoll());
        estate.setTheta(this.getPitch());
        estate.setPsi(this.getYaw());
        estate.setP(this.getP());
        estate.setQ(this.getQ());
        estate.setR(this.getR());
        estate.setU(this.getU());
        estate.setV(this.getV());
        estate.setW(this.getW());
        estate.setVx(this.getVx());
        estate.setVy(this.getVy());
        estate.setVz(this.getVz());
        return estate;
    }

    public SystemPositionAndAttitude(SystemPositionAndAttitude vs) {
        this.setPosition(new LocationType(vs.getPosition()));
        this.setRoll(vs.getRoll());
        this.setPitch(vs.getPitch());
        this.setYaw(vs.getYaw());
        this.setPQR(vs.getP(), vs.getQ(), vs.getR());
        this.setUVW(vs.getU(), vs.getV(), vs.getW());
        this.setVxyz(vs.getVx(), vs.getVy(), vs.getVz());
    }

    public SystemPositionAndAttitude(EstimatedState state) {
        LocationType loc = new LocationType();
        loc.setLatitudeRads(state.getLat());
        loc.setLongitudeRads(state.getLon());
        loc.setDepth(0.0);
        loc.translatePosition(state.getX(), state.getY(), 0.0);
        this.setPosition(loc);
        this.setRoll(state.getPhi());
        this.setPitch(state.getTheta());
        this.setYaw(state.getPsi());
        this.setPQR(state.getP(), state.getQ(), state.getR());
        this.setUVW(state.getU(), state.getV(), state.getW());
        this.setVxyz(state.getVx(), state.getVy(), state.getVz());
    }

    public void rotateXY(double radians) {
        this.setYaw(this.getYaw() + radians);
        if (this.getYaw() >= Math.PI * 2) {
            this.setYaw(this.getYaw() - Math.PI * 2);
        } else if (this.getYaw() <= Math.PI * -2) {
            this.setYaw(this.getYaw() + Math.PI * 2);
        }
    }

    public void addNEDOffsets(double n, double e, double d) {
        this.position.translatePosition(n, e, d);
    }

    public void moveForward(double meters) {
        this.getPosition().setOffsetEast(this.getPosition().getOffsetEast() + Math.sin(this.getYaw()) * meters);
        this.getPosition().setOffsetNorth(this.getPosition().getOffsetNorth() + Math.cos(this.getYaw()) * meters);
    }

    public void moveUp(float meters) {
        this.getPosition().setOffsetDown(this.getPosition().getOffsetDown() - (double)meters);
    }

    public SystemPositionAndAttitude clone() {
        SystemPositionAndAttitude cloneState = new SystemPositionAndAttitude(this.getPosition(), this.getRoll(), this.getPitch(), this.getYaw());
        LocationType lt = new LocationType();
        lt.setLocation(this.getPosition());
        cloneState.setPitch(this.getPitch());
        cloneState.setRoll(this.getRoll());
        cloneState.setYaw(this.getYaw());
        return cloneState;
    }

    public double[] getNEDPosition() {
        return this.getPosition().getOffsetFrom(this.guine);
    }

    public double getPitch() {
        return this.pitch;
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
    }

    public LocationType getPosition() {
        return this.position;
    }

    public void setPosition(LocationType position) {
        this.position.setLocation(position);
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public double getRoll() {
        return this.roll;
    }

    public void setRoll(double roll) {
        this.roll = roll;
    }

    public double getYaw() {
        return this.yaw;
    }

    public void setYaw(double yaw) {
        this.yaw = yaw;
    }

    public String toString() {
        return "System Position and Attitude State:\nNorth: " + this.getPosition().getOffsetNorth() + ", East: " + this.getPosition().getOffsetEast() + ", Down: " + this.getPosition().getOffsetDown() + "\n" + "Roll: " + this.getRoll() + ", Pitch: " + this.getPitch() + ", Yaw: " + this.getYaw();
    }

    public double getP() {
        return this.pqr.x;
    }

    public void setP(double p) {
        this.pqr.x = p;
    }

    public double getQ() {
        return this.pqr.y;
    }

    public void setQ(double q) {
        this.pqr.y = q;
    }

    public double getR() {
        return this.pqr.z;
    }

    public void setR(double r) {
        this.pqr.z = r;
    }

    public double getU() {
        return this.uvw.x;
    }

    public void setU(double u) {
        this.uvw.x = u;
    }

    public double getV() {
        return this.uvw.y;
    }

    public void setV(double v) {
        this.uvw.y = v;
    }

    public double getW() {
        return this.uvw.z;
    }

    public void setW(double w) {
        this.uvw.z = w;
    }

    public void setUVW(double u, double v, double w) {
        this.uvw.x = u;
        this.uvw.y = v;
        this.uvw.z = w;
    }

    public void setPQR(double p, double q, double r) {
        this.pqr.x = p;
        this.pqr.y = q;
        this.pqr.z = r;
    }

    public Vector3Dimension getPqr() {
        return this.pqr;
    }

    public void setPqr(Vector3Dimension pqr) {
        this.pqr = pqr;
    }

    public Vector3Dimension getUvw() {
        return this.uvw;
    }

    public void setUvw(Vector3Dimension uvw) {
        this.uvw = uvw;
    }

    public Vector3Dimension getVxyz() {
        return this.vxyz;
    }

    public void setVxyz(Vector3Dimension vxyz) {
        this.vxyz = vxyz;
    }

    public void setVxyz(double vx, double vy, double vz) {
        this.vxyz.x = vx;
        this.vxyz.y = vy;
        this.vxyz.z = vz;
    }

    public double getVx() {
        return this.vxyz.x;
    }

    public double getVy() {
        return this.vxyz.y;
    }

    public double getVz() {
        return this.vxyz.z;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public int compareTo(SystemPositionAndAttitude o) {
        return Long.valueOf(this.time).compareTo(o.time);
    }

    private static class Vector3Dimension
    implements Serializable {
        private static final long serialVersionUID = 3751192816949152977L;
        public double x = 0.0;
        public double y = 0.0;
        public double z = 0.0;

        private Vector3Dimension() {
        }
    }
}

