/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.actions;

import com.l2fprod.common.beans.editor.FixedButton;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.manager.imc.MessageEditorImc;

public class PlanActionElementConfig
extends JPanel {
    protected Element xmlImcNode = null;
    protected IMCMessage message = null;
    protected JTextField textField = new JTextField();
    protected JButton button = new FixedButton();

    public PlanActionElementConfig() {
        this.initialize();
    }

    protected void initialize() {
        this.textField.setEditable(false);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.textField, "Center");
        this.add((Component)this.button, "East");
        this.textField.setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanActionElementConfig.this.textField.setText(PlanActionElementConfig.this.message.asJSON());
                PlanActionElementConfig.this.getDialog(PlanActionElementConfig.this, "Plan Action");
            }
        });
    }

    public boolean load() {
        try {
            this.message = IMCMessage.parseXml((String)this.xmlImcNode.detach().asXML());
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName() + ":" + this.hashCode() + ": Creating a new message");
            this.message = null;
        }
        this.textField.setText(this.message != null ? this.message.asJSON() : "Error");
        return true;
    }

    public Element getXmlNode() {
        return this.xmlImcNode;
    }

    public void setXmlImcNode(Element xmlImcNode) {
        this.xmlImcNode = (Element)xmlImcNode.detach();
        this.load();
    }

    public IMCMessage getMessage() {
        return this.message;
    }

    public void setMessage(IMCMessage message) {
        this.message = message;
        try {
            this.xmlImcNode = (Element)DocumentHelper.parseText((String)message.asXml(false)).getRootElement().detach();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.textField.setText(message != null ? message.asJSON() : "Error");
    }

    public boolean getDialog(Component parent, String title) {
        boolean userCanceled = MessageEditorImc.showProperties(this.message, SwingUtilities.getWindowAncestor(parent), true);
        if (!userCanceled) {
            try {
                this.xmlImcNode = (Element)DocumentHelper.parseText((String)this.message.asXml(false)).getRootElement().detach();
            }
            catch (DocumentException e1) {
                e1.printStackTrace();
            }
            this.textField.setText(this.message.asJSON());
        } else {
            this.load();
        }
        return !userCanceled;
    }

    protected Object clone() {
        PlanActionElementConfig clone = new PlanActionElementConfig();
        clone.message = this.message.cloneMessage();
        clone.setXmlImcNode((Element)this.xmlImcNode.clone());
        return clone;
    }
}

