/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.actions;

import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.mp.actions.PlanActionElementConfig;

public class PlanActions {
    protected LinkedList<PlanActionElementConfig> actionMsgs = new LinkedList();

    public LinkedList<PlanActionElementConfig> getActionMsgs() {
        return this.actionMsgs;
    }

    public boolean load(Element nd) {
        List lst = nd.selectNodes("./messages/child::*");
        for (Object obj : lst) {
            Element pl = (Element)obj;
            PlanActionElementConfig plcfg = new PlanActionElementConfig();
            plcfg.setXmlImcNode(pl);
            if (plcfg.message == null) continue;
            this.actionMsgs.add(plcfg);
        }
        return true;
    }

    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        if (this.actionMsgs.size() > 0) {
            Element plActionsElement = root.addElement("messages");
            for (PlanActionElementConfig plcfg : this.actionMsgs) {
                Element ndcf = plcfg.getXmlNode();
                if (ndcf == null) continue;
                plActionsElement.add(((Node)ndcf.clone()).detach());
            }
        }
        return document;
    }

    public IMCMessage[] getAllMessages() {
        LinkedList<IMCMessage> msgs = new LinkedList<IMCMessage>();
        for (PlanActionElementConfig msgConfig : this.actionMsgs) {
            msgs.add(msgConfig.message);
        }
        return msgs.toArray(new IMCMessage[msgs.size()]);
    }

    public String toString() {
        String actStr = "Plan Actions: ";
        for (PlanActionElementConfig nm : this.actionMsgs) {
            actStr = actStr + " M[" + nm.message.getAbbrev() + "]";
        }
        return actStr;
    }

    public boolean isEmpty() {
        long count = this.getActionMsgs().size();
        return count == 0L;
    }

    public Object clone() {
        PlanActions clone = new PlanActions();
        for (PlanActionElementConfig am : this.actionMsgs) {
            clone.actionMsgs.add((PlanActionElementConfig)am.clone());
        }
        return clone;
    }

    public void parseMessages(Vector<IMCMessage> actionsMessages) {
        this.actionMsgs.clear();
        for (IMCMessage msg : actionsMessages) {
            PlanActionElementConfig paec = new PlanActionElementConfig();
            paec.setMessage(msg);
            this.actionMsgs.add(paec);
        }
    }
}

