/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.mp.actions.PlanActionElementConfig;
import pt.lsts.neptus.mp.actions.PlanActions;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class PlanActionsPanel
extends JPanel {
    public static ImageIcon ADD_ICON = ImageUtils.getScaledIcon("images/buttons/add.png", 30, 30);
    public static ImageIcon REMOVE_ICON = ImageUtils.getScaledIcon("images/buttons/remove.png", 30, 30);
    protected PlanActions actions = new PlanActions();
    protected JDialog dialog = null;
    private JPanel holderMessages;
    private JScrollPane scrollPaneMessages;
    private JPanel controlsMessages;
    private ToolbarButton addMessages;
    private ToolbarButton removeMessages;
    private AbstractAction actionAddMessages;
    private AbstractAction actionRemoveMessages;
    private boolean userCanceled = false;

    private PlanActionsPanel(PlanActions actions) {
        this.actions = actions;
        this.initializeActions();
        this.initialize();
    }

    private void initialize() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel("<html><b>Messages"));
        this.holderMessages = new JPanel(true);
        this.holderMessages.setLayout(new BoxLayout(this.holderMessages, 1));
        this.scrollPaneMessages = new JScrollPane();
        this.scrollPaneMessages.setVerticalScrollBarPolicy(20);
        this.scrollPaneMessages.setHorizontalScrollBarPolicy(30);
        this.scrollPaneMessages.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.scrollPaneMessages.setPreferredSize(new Dimension(600, 200));
        this.scrollPaneMessages.setViewportView(this.holderMessages);
        this.add(this.scrollPaneMessages);
        this.controlsMessages = new JPanel();
        this.controlsMessages.setLayout(new BoxLayout(this.controlsMessages, 0));
        this.addMessages = new ToolbarButton(this.actionAddMessages);
        this.removeMessages = new ToolbarButton(this.actionRemoveMessages);
        this.controlsMessages.add((Component)((Object)this.addMessages));
        this.controlsMessages.add((Component)((Object)this.removeMessages));
        this.add(this.controlsMessages);
        this.add(new JSeparator(0));
        this.refreshGUILists();
    }

    private void refreshGUILists() {
        this.holderMessages.removeAll();
        for (PlanActionElementConfig plCfg : this.actions.getActionMsgs()) {
            this.holderMessages.add(plCfg);
        }
    }

    private void initializeActions() {
        this.actionAddMessages = new AbstractAction("add message", ADD_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(PlanActionsPanel.this));
                dialog.setLayout(new BorderLayout());
                Vector<String> mValid = new Vector<String>();
                Collection mtypes = IMCDefinition.getInstance().getMessageNames();
                for (String mt : mtypes) {
                    mValid.add(mt);
                }
                final JComboBox<String> messagesComboBox = new JComboBox<String>(mValid.toArray(new String[0]));
                dialog.add(messagesComboBox, "Center");
                JButton okButton = new JButton("ok");
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String mName = (String)messagesComboBox.getSelectedItem();
                        IMCMessage sMsg = IMCDefinition.getInstance().create(mName, new Object[0]);
                        PlanActionElementConfig plActionCfg = new PlanActionElementConfig();
                        plActionCfg.message = sMsg;
                        try {
                            plActionCfg.setXmlImcNode((Element)DocumentHelper.parseText((String)sMsg.asXml(false)).getRootElement().detach());
                            PlanActionsPanel.this.actions.actionMsgs.add(plActionCfg);
                            PlanActionsPanel.this.holderMessages.add(plActionCfg);
                            PlanActionsPanel.this.holderMessages.repaint();
                        }
                        catch (DocumentException e1) {
                            e1.printStackTrace();
                        }
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                });
                dialog.add((Component)okButton, "South");
                dialog.setSize(200, 100);
                dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                GuiUtils.centerOnScreen(dialog);
                dialog.setVisible(true);
            }
        };
        this.actionRemoveMessages = new AbstractAction("remove message", REMOVE_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (PlanActionsPanel.this.holderMessages.getComponentCount() > 0) {
                        PlanActionElementConfig rem = PlanActionsPanel.this.actions.actionMsgs.removeLast();
                        PlanActionsPanel.this.holderMessages.remove(rem);
                        PlanActionsPanel.this.holderMessages.repaint();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        };
    }

    private boolean getDialog(Component parent, String title) {
        PlanActions changed;
        final PlanActions orig = this.actions;
        this.actions = changed = (PlanActions)this.actions.clone();
        this.refreshGUILists();
        this.dialog = parent instanceof Window ? new JDialog((Window)parent) : new JDialog(SwingUtilities.getWindowAncestor(parent));
        JButton okButton = new JButton(new AbstractAction("ok"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanActionsPanel.this.dialog.setVisible(false);
                PlanActionsPanel.this.dialog.dispose();
                PlanActionsPanel.this.setUserCanceled(false);
                orig.getActionMsgs().clear();
                orig.getActionMsgs().addAll(changed.getActionMsgs());
                PlanActionsPanel.this.actions = orig;
                PlanActionsPanel.this.refreshGUILists();
            }
        });
        okButton.setPreferredSize(new Dimension(80, 30));
        final JButton cancelButton = new JButton(new AbstractAction("cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanActionsPanel.this.setUserCanceled(true);
                PlanActionsPanel.this.dialog.setVisible(false);
                PlanActionsPanel.this.dialog.dispose();
                PlanActionsPanel.this.actions = orig;
                PlanActionsPanel.this.refreshGUILists();
            }
        });
        cancelButton.setPreferredSize(new Dimension(80, 30));
        GuiUtils.reactEscapeKeyPress(cancelButton);
        this.dialog.setTitle(title);
        this.dialog.setSize(600, 300);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)this, "Center");
        JPanel bPanel = new JPanel();
        bPanel.setLayout(new FlowLayout(2));
        bPanel.add(okButton);
        bPanel.add(cancelButton);
        this.dialog.getContentPane().add((Component)bPanel, "South");
        this.dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.dialog.setAlwaysOnTop(true);
        GuiUtils.centerOnScreen(this.dialog);
        this.dialog.setResizable(true);
        this.dialog.setVisible(true);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                cancelButton.doClick();
            }
        });
        return this.userCanceled;
    }

    private void setUserCanceled(boolean userCanceled) {
        this.userCanceled = userCanceled;
    }

    public static boolean showDialog(PlanActions planActions, Component parent, String title) {
        PlanActionsPanel plPanel = new PlanActionsPanel(planActions);
        return plPanel.getDialog(parent, title);
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        PlanActions pa = new PlanActions();
        PlanActionsPanel pap = new PlanActionsPanel(pa);
        pap.getDialog(new JFrame(), "eeeeeeeeeeee");
        Element eActionsElm = pa.asElement("end-actions");
        NeptusLog.pub().info((Object)("<###> " + eActionsElm.asXML()));
    }
}

