/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.util.Arrays;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.Header;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.CoverArea;
import pt.lsts.neptus.mp.maneuvers.DefaultManeuver;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.plugins.PluginProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public abstract class AbstractImcManeuver<T extends IMCMessage>
extends DefaultManeuver
implements LocatedManeuver,
PropertiesProvider,
IMCSerialization {
    protected T message = null;

    public AbstractImcManeuver() {
        try {
            this.message = (IMCMessage)this.message.getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setMessage((IMCMessage)this.message);
    }

    public AbstractImcManeuver(T message) {
        try {
            this.message = (IMCMessage)message.getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setMessage((IMCMessage)message);
    }

    public void setMessage(IMCMessage message) {
        try {
            message.copyFrom(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        this.setMessage(message);
    }

    @Override
    public IMCMessage serializeToIMC() {
        return this.message;
    }

    @Override
    public String getType() {
        if (this.message != null) {
            return this.message.getClass().getSimpleName();
        }
        return this.getClass().getSimpleName();
    }

    @Override
    public Object clone() {
        try {
            AbstractImcManeuver other = (AbstractImcManeuver)this.getClass().newInstance();
            this.clone(other);
            other.setMessage(this.message.cloneMessage());
            other.setManeuverLocation(this.getManeuverLocation());
            return other;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void loadFromXML(String XML) {
        if (this.message == null) {
            NeptusLog.pub().error((Object)("Invalid maneuver: " + this.message.getClass()));
            return;
        }
        try {
            Document doc = DocumentHelper.parseText((String)XML);
            PluginProperty[] props = IMCUtils.getProperties(this.message).toArray(new PluginProperty[0]);
            for (int i = 0; i < props.length; ++i) {
                Node node = doc.selectSingleNode("//" + props[i].getName().replaceAll(" ", ""));
                if (node == null) continue;
                props[i].unserialize(node.getText());
            }
            this.setProperties((Property[])props);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        Header header = IMCDefinition.getInstance().createHeader();
        for (DefaultProperty defaultProperty : IMCUtils.getProperties(this.message)) {
            if (header.getTypeOf(defaultProperty.getName()) != null || !(defaultProperty instanceof PluginProperty)) continue;
            root.addElement(defaultProperty.getName().replaceAll(" ", "")).setText(((PluginProperty)defaultProperty).serialize());
        }
        for (PluginProperty pluginProperty : PluginUtils.getProperties(this, false).values()) {
            root.addElement(pluginProperty.getName().replaceAll(" ", "")).setText(pluginProperty.serialize());
        }
        return document;
    }

    @Override
    public DefaultProperty[] getProperties() {
        Vector<DefaultProperty> props = new Vector<DefaultProperty>();
        props.addAll(Arrays.asList(super.getProperties()));
        props.addAll(IMCUtils.getProperties(this.message, true));
        props.addAll(PluginUtils.getProperties(this, true).values());
        return props.toArray(new DefaultProperty[0]);
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        IMCUtils.setProperties(properties, this.message);
        PluginUtils.setPluginProperties((Object)this, properties);
    }

    @Override
    public ManeuverLocation getStartLocation() {
        return this.getManeuverLocation();
    }

    @Override
    public ManeuverLocation getEndLocation() {
        return this.getManeuverLocation();
    }

    @Override
    public ManeuverLocation getManeuverLocation() {
        ManeuverLocation loc = new ManeuverLocation();
        try {
            loc.setLatitudeDegs(Math.toDegrees(this.message.getDouble("lat")));
            loc.setLongitudeDegs(Math.toDegrees(this.message.getDouble("lon")));
            String mode = this.message.getString("zunits");
            if (mode == null || mode.equals("NONE") || mode.equals("DEPTH")) {
                loc.setDepth(this.message.getDouble("z"));
            } else if (mode.equals("ALTITUDE") || mode.equals("HEIGHT")) {
                loc.setHeight(this.message.getDouble("z"));
            }
            return loc;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setManeuverLocation(ManeuverLocation location) {
        ManeuverLocation loc = location.clone();
        loc.convertToAbsoluteLatLonDepth();
        this.message.setValue("lat", (Object)Math.toRadians(loc.getLatitudeDegs()));
        this.message.setValue("lon", (Object)Math.toRadians(loc.getLongitudeDegs()));
        this.message.setValue("z", (Object)loc.getAllZ());
        this.message.setValue("zunits", (Object)"NONE");
    }

    @Override
    public void translate(double offsetNorth, double offsetEast, double offsetDown) {
        this.getManeuverLocation().translatePosition(offsetNorth, offsetEast, offsetDown);
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        CoverArea ca = new CoverArea();
        String xml = ca.asXML();
        NeptusLog.pub().info((Object)("<###> " + xml));
    }
}

