/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.beans.PropertyEditor;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.CommsRelay;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.editor.SpeedUnitsEditor;
import pt.lsts.neptus.gui.editor.renderer.I18nCellRenderer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.DefaultManeuver;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.NameNormalizer;

public class CommsRelay
extends DefaultManeuver
implements IMCSerialization,
LocatedManeuver {
    private double speed = 1000.0;
    private String units = "RPM";
    private int duration = 60;
    private String sys_a = "";
    private String sys_b = "";
    private ManeuverLocation startLoc = new ManeuverLocation();
    private double move_threshold = 30.0;
    protected static final String DEFAULT_ROOT_ELEMENT = "CommsRelay";
    public String id = NameNormalizer.getRandomID();

    @Override
    public String getType() {
        return DEFAULT_ROOT_ELEMENT;
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("kind", "automatic");
        Element system_a = root.addElement("sys_a");
        system_a.setText(String.valueOf(this.getSystemA()));
        Element system_b = root.addElement("sys_b");
        system_b.setText(String.valueOf(this.getSystemB()));
        Element duration = root.addElement("duration");
        duration.setText(String.valueOf(this.getDuration()));
        Element finalPoint = root.addElement("startPoint");
        finalPoint.addAttribute("type", "pointType");
        Element point = this.getManeuverLocation().asElement("point");
        finalPoint.add(point);
        Element move_thresh = root.addElement("move_threshold");
        move_thresh.setText(String.valueOf(this.getMoveThreshold()));
        Element velocity = root.addElement("speed");
        velocity.addAttribute("type", "float");
        velocity.addAttribute("unit", this.getUnits());
        velocity.setText(String.valueOf(this.getSpeed()));
        return document;
    }

    @Override
    public void loadFromXML(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Node node = doc.selectSingleNode("CommsRelay/startPoint/point");
            this.getManeuverLocation().load(node.asXML());
            this.setSystemA(doc.selectSingleNode("//sys_a").getText());
            this.setSystemB(doc.selectSingleNode("//sys_b").getText());
            this.setDuration(Integer.parseInt(doc.selectSingleNode("//duration").getText()));
            this.setMoveThreshold(Double.parseDouble(doc.selectSingleNode("//move_threshold").getText()));
            Node speedNode = doc.selectSingleNode("//speed");
            if (speedNode == null) {
                speedNode = doc.selectSingleNode("//velocity");
            }
            this.setSpeed(Double.parseDouble(speedNode.getText()));
            this.setUnits(speedNode.valueOf("@unit"));
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    public SystemPositionAndAttitude ManeuverFunction(SystemPositionAndAttitude lastVehicleState) {
        return lastVehicleState;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getSystemA() {
        return this.sys_a;
    }

    public void setSystemA(String system) {
        this.sys_a = system;
    }

    public String getSystemB() {
        return this.sys_b;
    }

    public void setSystemB(String system) {
        this.sys_b = system;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getMoveThreshold() {
        return this.move_threshold;
    }

    public void setMoveThreshold(double move_threshold) {
        this.move_threshold = move_threshold;
    }

    @Override
    public Object clone() {
        CommsRelay clone = new CommsRelay();
        super.clone(clone);
        clone.setSystemA(this.getSystemA());
        clone.setSystemB(this.getSystemB());
        clone.setDuration(this.getDuration());
        clone.setUnits(this.getUnits());
        clone.setSpeed(this.getSpeed());
        clone.setManeuverLocation(this.getStartLocation());
        clone.setMoveThreshold(this.getMoveThreshold());
        return clone;
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> properties = new Vector<DefaultProperty>();
        properties.add(PropertiesEditor.getPropertyInstance("System A", String.class, this.getSystemA(), true));
        properties.add(PropertiesEditor.getPropertyInstance("System B", String.class, this.getSystemB(), true));
        properties.add(PropertiesEditor.getPropertyInstance("Duration", Integer.class, this.getDuration(), true));
        properties.add(PropertiesEditor.getPropertyInstance("Move threshold", Double.class, this.getMoveThreshold(), true));
        DefaultProperty units = PropertiesEditor.getPropertyInstance("Speed units", String.class, this.getUnits(), true);
        units.setShortDescription("The speed units");
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)units, (PropertyEditor)((Object)new SpeedUnitsEditor()));
        PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)units, (TableCellRenderer)((Object)new I18nCellRenderer()));
        properties.add(PropertiesEditor.getPropertyInstance("Speed", Double.class, this.getSpeed(), true));
        properties.add(units);
        return properties;
    }

    @Override
    public String getPropertiesDialogTitle() {
        return this.getId() + " parameters";
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        for (Property p : properties) {
            if (p.getName().equals("Speed units")) {
                this.setUnits((String)p.getValue());
            }
            if (p.getName().equals("Speed")) {
                this.setSpeed((Double)p.getValue());
            }
            if (p.getName().equals("Duration")) {
                this.setDuration((Integer)p.getValue());
            }
            if (p.getName().equals("System A")) {
                this.setSystemA((String)p.getValue());
            }
            if (p.getName().equals("System B")) {
                this.setSystemB((String)p.getValue());
            }
            if (!p.getName().equals("Move threshold")) continue;
            this.setMoveThreshold((Double)p.getValue());
        }
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return super.getPropertiesErrors(properties);
    }

    @Override
    public String getTooltipText() {
        return super.getTooltipText() + "<hr>" + I18n.text("speed") + ": <b>" + this.getSpeed() + " " + I18n.text(this.getUnits()) + "</b>" + "<br>" + I18n.text("duration") + ": <b>" + this.getDuration() + " " + I18n.textc("s", "seconds") + "</b>" + "<br>" + I18n.text("system a") + ": <b>" + this.getSystemA() + "</b>" + "<br>" + I18n.text("system b") + ": <b>" + this.getSystemB() + "</b>";
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        this.setMaxTime((int)message.getDouble("timeout"));
        this.setSystemA(IMCUtils.translateImcIdToSystem((int)message.getDouble("sys_a")));
        this.setSystemB(IMCUtils.translateImcIdToSystem((int)message.getDouble("sys_b")));
        this.setDuration((int)message.getDouble("duration"));
        this.startLoc.convertToAbsoluteLatLonDepth();
        this.startLoc.setLatitudeRads(message.getDouble("lat"));
        this.startLoc.setLongitudeRads(message.getDouble("lon"));
        this.setMoveThreshold(message.getDouble("move_threshold"));
        this.setSpeed(message.getDouble("speed"));
        String speed_units = message.getString("speed_units");
        if (speed_units.equals("METERS_PS")) {
            this.setUnits("m/s");
        } else if (speed_units.equals("RPM")) {
            this.setUnits("RPM");
        } else {
            this.setUnits("%");
        }
        this.setMoveThreshold(message.getDouble("move_threshold"));
    }

    @Override
    public IMCMessage serializeToIMC() {
        pt.lsts.imc.CommsRelay msg = new pt.lsts.imc.CommsRelay();
        msg.setDuration(this.getDuration());
        int sys_a = -1;
        int sys_b = -1;
        try {
            sys_a = Integer.parseInt(this.getSystemA());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            sys_b = Integer.parseInt(this.getSystemB());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.getSystemA().equalsIgnoreCase("me") || this.getSystemA().equalsIgnoreCase("home") || this.getSystemA().equalsIgnoreCase("base")) {
            sys_a = ImcMsgManager.getManager().getLocalId().intValue();
        }
        if (this.getSystemB().equalsIgnoreCase("me") || this.getSystemB().equalsIgnoreCase("home") || this.getSystemB().equalsIgnoreCase("base")) {
            sys_b = ImcMsgManager.getManager().getLocalId().intValue();
        }
        if (sys_a == -1) {
            sys_a = IMCUtils.translateSystemToImcId(this.getSystemA()).intValue();
        }
        if (sys_b == -1) {
            sys_b = IMCUtils.translateSystemToImcId(this.getSystemB()).intValue();
        }
        msg.setSysA(sys_a);
        msg.setSysB(sys_b);
        this.startLoc.convertToAbsoluteLatLonDepth();
        msg.setLat(this.startLoc.getLatitudeRads());
        msg.setLon(this.startLoc.getLongitudeRads());
        msg.setSpeed(this.getSpeed());
        if ("m/s".equalsIgnoreCase(this.getUnits())) {
            msg.setSpeedUnits(CommsRelay.SPEED_UNITS.METERS_PS);
        } else if ("RPM".equalsIgnoreCase(this.getUnits())) {
            msg.setSpeedUnits(CommsRelay.SPEED_UNITS.RPM);
        } else if ("%".equalsIgnoreCase(this.getUnits())) {
            msg.setSpeedUnits(CommsRelay.SPEED_UNITS.PERCENTAGE);
        } else if ("percentage".equalsIgnoreCase(this.getUnits())) {
            msg.setSpeedUnits(CommsRelay.SPEED_UNITS.PERCENTAGE);
        }
        msg.setMoveThreshold(this.getMoveThreshold());
        return msg;
    }

    @Override
    public ManeuverLocation getStartLocation() {
        return this.getManeuverLocation();
    }

    @Override
    public ManeuverLocation getEndLocation() {
        return this.getManeuverLocation();
    }

    @Override
    public Collection<ManeuverLocation> getWaypoints() {
        return Collections.singleton(this.getStartLocation());
    }

    @Override
    public ManeuverLocation getManeuverLocation() {
        return this.startLoc;
    }

    @Override
    public void setManeuverLocation(ManeuverLocation location) {
        this.startLoc = location.clone();
    }

    @Override
    public void translate(double offsetNorth, double offsetEast, double offsetDown) {
        this.startLoc.translatePosition(offsetNorth, offsetEast, offsetDown);
    }

    public static void main(String[] args) {
        CommsRelay cr = new CommsRelay();
        cr.getManeuverLocation().setLocation(new LocationType(41.0, -8.0));
        cr.setDuration(3600);
        cr.setSystemA("lauv-xtreme-2");
        cr.setSystemB("lauv-seacon-1");
        cr.setSpeed(1000.0);
        cr.setUnits("RPM");
        cr.setMoveThreshold(30.0);
        IMCMessage msg = cr.serializeToIMC();
        NeptusLog.pub().info((Object)("<###> " + cr.asXML()));
        cr.serializeToIMC().dump((OutputStream)System.out);
        msg.dump((OutputStream)System.out);
    }
}

