/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.CompassCalibration;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.editor.SpeedUnitsEditor;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.maneuvers.StatisticsProvider;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.PlanElement;

public class CompassCalibration
extends Maneuver
implements LocatedManeuver,
IMCSerialization,
StatisticsProvider {
    protected static final String DEFAULT_ROOT_ELEMENT = "CompassCalibration";
    public ManeuverLocation location = new ManeuverLocation();
    @NeptusProperty(name="Speed", description="The speed to be used")
    public double speed = 1.3;
    @NeptusProperty(name="Speed units", description="The speed units", editorClass=SpeedUnitsEditor.class)
    public String speedUnits = "m/s";
    @NeptusProperty(name="Pitch", description="The Pitch angle used to perform the maneuver.")
    public double pitchDegs = 15.0;
    @NeptusProperty(name="Amplitude", description="Yoyo motion amplitude.")
    public double amplitude = 1.0;
    @NeptusProperty(name="Duration (s)", description="The duration in seconds of this maneuver. Use '0' for unlimited duration time.")
    public int duration = 300;
    @NeptusProperty(name="Radius (m)", description="Radius of the maneuver.")
    public float radius = 5.0f;
    @NeptusProperty(name="Direction", description="Direction of the maneuver.")
    public CompassCalibration.DIRECTION direction = CompassCalibration.DIRECTION.CLOCKW;

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        Element finalPoint = root.addElement("finalPoint");
        finalPoint.addAttribute("type", "pointType");
        Element point = this.getManeuverLocation().asElement("point");
        finalPoint.add(point);
        Element pitchEl = root.addElement("pitch");
        pitchEl.setText(String.valueOf(this.pitchDegs));
        Element amplitudeEl = root.addElement("amplitude");
        amplitudeEl.setText(String.valueOf(this.amplitude));
        Element durationEl = root.addElement("duration");
        durationEl.setText(String.valueOf(this.duration));
        Element speedEl = root.addElement("speed");
        speedEl.addAttribute("type", "float");
        speedEl.addAttribute("unit", this.speedUnits);
        speedEl.setText(String.valueOf(this.speed));
        Element radiusEl = root.addElement("radius");
        radiusEl.setText(String.valueOf(this.radius));
        Element directionEl = root.addElement("direction");
        directionEl.setText(String.valueOf(this.direction.value()));
        return document;
    }

    @Override
    public void loadFromXML(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Node node = doc.selectSingleNode("CompassCalibration/finalPoint/point");
            if (node == null) {
                node = doc.selectSingleNode("CompassCalibration/initialPoint/point");
            }
            ManeuverLocation loc = new ManeuverLocation();
            loc.load(node.asXML());
            this.setManeuverLocation(loc);
            Node pitchNode = doc.selectSingleNode("CompassCalibration/pitch");
            this.pitchDegs = Double.parseDouble(pitchNode.getText());
            Node amplitudeNode = doc.selectSingleNode("CompassCalibration/amplitude");
            this.amplitude = Double.parseDouble(amplitudeNode.getText());
            Node durationNode = doc.selectSingleNode("CompassCalibration/duration");
            this.duration = Integer.parseInt(durationNode.getText());
            Node speedNode = doc.selectSingleNode("CompassCalibration/speed");
            this.speed = Double.parseDouble(speedNode.getText());
            this.speedUnits = speedNode.valueOf("@unit");
            this.radius = Float.parseFloat(doc.selectSingleNode("CompassCalibration/radius").getText());
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    @Override
    public ManeuverLocation getManeuverLocation() {
        return this.location.clone();
    }

    @Override
    public ManeuverLocation getEndLocation() {
        return this.getManeuverLocation();
    }

    @Override
    public ManeuverLocation getStartLocation() {
        return this.getManeuverLocation();
    }

    @Override
    public void setManeuverLocation(ManeuverLocation loc) {
        this.location = loc.clone();
    }

    @Override
    public void translate(double offsetNorth, double offsetEast, double offsetDown) {
        this.getManeuverLocation().translatePosition(offsetNorth, offsetEast, offsetDown);
    }

    @Override
    public String getTooltipText() {
        return super.getTooltipText() + "<hr>" + I18n.text("speed") + ": <b>" + this.speed + " " + I18n.text(this.speedUnits) + "</b>" + "<br>" + I18n.text("cruise depth") + ": <b>" + (int)this.getStartLocation().getDepth() + " " + I18n.textc("m", "meters") + "</b>" + "<br>" + I18n.text("end z") + ": <b>" + this.getManeuverLocation().getZ() + " " + I18n.textc("m", "meters") + " (" + I18n.text(this.getManeuverLocation().getZUnits().toString()) + ")</b>" + "<br>" + I18n.text("pitch") + ": <b>" + this.pitchDegs + " " + I18n.textc("m", "meters") + "</b>" + "<br>" + I18n.text("amplitude") + ": <b>" + this.amplitude + " " + I18n.textc("m", "meters") + "</b>" + "<br>" + I18n.text("radius") + ": <b>" + this.radius + " " + I18n.textc("m", "meters") + "</b>" + "<br>" + I18n.text("duration") + ": <b>" + this.duration + " " + I18n.textc("m", "meters") + "</b>";
    }

    public String validatePitchDegs(double value) {
        NeptusLog.pub().info((Object)"<###>validate...");
        if (value < 0.0 || value > 45.0) {
            return I18n.text("Pitch angle shoud be bounded between [0\u00b0, 45\u00b0]");
        }
        return null;
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> properties = new Vector<DefaultProperty>();
        PluginProperty[] prop = PluginUtils.getPluginProperties(this);
        properties.addAll(Arrays.asList(prop));
        return properties;
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        PluginUtils.setPluginProperties((Object)this, properties);
    }

    @Override
    public IMCMessage serializeToIMC() {
        this.getManeuverLocation().convertToAbsoluteLatLonDepth();
        pt.lsts.imc.CompassCalibration man = new pt.lsts.imc.CompassCalibration();
        man.setTimeout(this.getMaxTime());
        ManeuverLocation loc = this.getManeuverLocation();
        loc.convertToAbsoluteLatLonDepth();
        man.setLat(loc.getLatitudeRads());
        man.setLon(loc.getLongitudeRads());
        man.setZ(this.getManeuverLocation().getZ());
        man.setZUnits(this.getManeuverLocation().getZUnits().toString());
        man.setPitch(Math.toRadians(this.pitchDegs));
        man.setAmplitude(this.amplitude);
        man.setDuration(this.duration);
        man.setRadius((double)this.radius);
        man.setSpeed(this.speed);
        man.setDirection(this.direction);
        man.setCustom(this.getCustomSettings());
        switch (this.speedUnits) {
            case "m/s": {
                man.setSpeedUnits(CompassCalibration.SPEED_UNITS.METERS_PS);
                break;
            }
            case "RPM": {
                man.setSpeedUnits(CompassCalibration.SPEED_UNITS.RPM);
                break;
            }
            default: {
                man.setSpeedUnits(CompassCalibration.SPEED_UNITS.PERCENTAGE);
            }
        }
        return man;
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        if (!DEFAULT_ROOT_ELEMENT.equalsIgnoreCase(message.getAbbrev())) {
            NeptusLog.pub().error((Object)("Unable to parse message of type " + message.getAbbrev()));
            return;
        }
        pt.lsts.imc.CompassCalibration man = null;
        try {
            man = pt.lsts.imc.CompassCalibration.clone((IMCMessage)message);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.setMaxTime(man.getTimeout());
        ManeuverLocation loc = new ManeuverLocation();
        loc.setLatitudeRads(man.getLat());
        loc.setLongitudeRads(man.getLon());
        loc.setZ(man.getZ());
        loc.setZUnits(ManeuverLocation.Z_UNITS.valueOf(man.getZUnits().toString()));
        this.setManeuverLocation(loc);
        this.pitchDegs = Math.toDegrees(man.getPitch());
        this.amplitude = man.getAmplitude();
        this.duration = man.getDuration();
        this.radius = (float)man.getRadius();
        this.speed = man.getSpeed();
        this.direction = man.getDirection();
        this.setCustomSettings(man.getCustom());
        switch (man.getSpeedUnits()) {
            case RPM: {
                this.speedUnits = "RPM";
                break;
            }
            case METERS_PS: {
                this.speedUnits = "m/s";
                break;
            }
            case PERCENTAGE: {
                this.speedUnits = "%";
                break;
            }
        }
    }

    @Override
    public Object clone() {
        CompassCalibration clone = new CompassCalibration();
        super.clone(clone);
        clone.setManeuverLocation(this.getManeuverLocation());
        clone.pitchDegs = this.pitchDegs;
        clone.amplitude = this.amplitude;
        clone.duration = this.duration;
        clone.radius = this.radius;
        clone.speed = this.speed;
        clone.speedUnits = this.speedUnits;
        clone.direction = this.direction;
        return clone;
    }

    @Override
    public void paintOnMap(Graphics2D g2d, PlanElement planElement, StateRenderer2D renderer) {
        super.paintOnMap(g2d, planElement, renderer);
        float radiusCorrected = this.radius * renderer.getZoom();
        Graphics2D g2 = (Graphics2D)g2d.create();
        g2.drawLine(-4, -4, 4, 4);
        g2.drawLine(-4, 4, 4, -4);
        g2.setColor(new Color(255, 255, 255, 100));
        g2.fill(new Ellipse2D.Double(-radiusCorrected, -radiusCorrected, radiusCorrected * 2.0f, radiusCorrected * 2.0f));
        g2.setColor(Color.blue.darker());
        g2.draw(new Ellipse2D.Double(-radiusCorrected, -radiusCorrected, radiusCorrected * 2.0f, radiusCorrected * 2.0f));
        g2.translate(0.0, -radiusCorrected);
        if (this.direction == CompassCalibration.DIRECTION.CCLOCKW) {
            g2.drawLine(5, 5, 0, 0);
            g2.drawLine(5, -5, 0, 0);
        } else {
            g2.drawLine(-5, 5, 0, 0);
            g2.drawLine(-5, -5, 0, 0);
        }
        g2.dispose();
    }

    @Override
    public double getCompletionTime(LocationType initialPosition) {
        double speed = this.speed;
        if (this.speedUnits.equalsIgnoreCase("RPM")) {
            speed /= 769.230769231;
        } else if (this.speedUnits.equalsIgnoreCase("%")) {
            speed /= 76.923076923;
        }
        return this.getDistanceTravelled(initialPosition) / speed;
    }

    @Override
    public double getDistanceTravelled(LocationType initialPosition) {
        double meters = this.getStartLocation().getDistanceInMeters(initialPosition);
        double depthDiff = initialPosition.getAllZ();
        return meters += depthDiff;
    }

    @Override
    public double getMaxDepth() {
        return this.getManeuverLocation().getAllZ();
    }

    @Override
    public double getMinDepth() {
        return this.getManeuverLocation().getAllZ();
    }

    @Override
    public Collection<ManeuverLocation> getWaypoints() {
        return Collections.singleton(this.getStartLocation());
    }

    public static void main(String[] args) {
        CompassCalibration compc = new CompassCalibration();
        String ccmanXML = compc.getManeuverAsDocument(DEFAULT_ROOT_ELEMENT).asXML();
        System.out.println(ccmanXML);
        CompassCalibration compc1 = new CompassCalibration();
        compc1.loadFromXML(ccmanXML);
        ccmanXML = compc.getManeuverAsDocument(DEFAULT_ROOT_ELEMENT).asXML();
        System.out.println(ccmanXML);
    }
}

