/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JPopupMenu;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.PolygonVertex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.AbstractImcManeuver;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.PlanElement;

public class CoverArea
extends AbstractImcManeuver<pt.lsts.imc.CoverArea>
implements StateRendererInteraction,
IMCSerialization {
    protected InteractionAdapter adapter = new InteractionAdapter(null);
    @NeptusProperty(name="polygon", editable=false)
    public String polygonPoints = "";
    protected Vector<LocationType> points = new Vector();

    public CoverArea() {
        super(new pt.lsts.imc.CoverArea());
    }

    @Override
    public void parseIMCMessage(IMCMessage msg) {
        super.parseIMCMessage(msg);
        try {
            this.points.clear();
            Vector vertices = ((pt.lsts.imc.CoverArea)this.message).getMessageList("polygon", PolygonVertex.class);
            for (PolygonVertex v : vertices) {
                this.points.add(new LocationType(Math.toDegrees(v.getLat()), Math.toDegrees(v.getLon())));
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("Error parsing message of type " + ((pt.lsts.imc.CoverArea)this.message).getAbbrev()), (Throwable)e);
            return;
        }
    }

    @Override
    public IMCMessage serializeToIMC() {
        Vector<PolygonVertex> vertices = new Vector<PolygonVertex>();
        for (LocationType pt : this.points) {
            vertices.add(PolygonVertex.create((Object[])new Object[]{"lat", pt.getLatitudeRads(), "lon", pt.getLongitudeRads()}));
        }
        ((pt.lsts.imc.CoverArea)this.message).setMessageList(vertices, "polygon");
        return super.serializeToIMC();
    }

    @Override
    public String getName() {
        return "CoverArea maneuver";
    }

    @Override
    public Image getIconImage() {
        return this.adapter.getIconImage();
    }

    @Override
    public Cursor getMouseCursor() {
        return this.adapter.getMouseCursor();
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public void paintOnMap(Graphics2D g2d, PlanElement planElement, StateRenderer2D renderer) {
        super.paintOnMap(g2d, planElement, renderer);
        ManeuverLocation man_loc = this.getStartLocation();
        Graphics2D g = (Graphics2D)g2d.create();
        g.translate(-renderer.getScreenPosition(man_loc).getX(), -renderer.getScreenPosition(man_loc).getY());
        ArrayList<Integer> x = new ArrayList<Integer>();
        ArrayList<Integer> y = new ArrayList<Integer>();
        x.add((int)renderer.getScreenPosition(man_loc).getX());
        y.add((int)renderer.getScreenPosition(man_loc).getY());
        for (LocationType loc : this.points) {
            Point2D pt = renderer.getScreenPosition(loc);
            Ellipse2D.Double corners = new Ellipse2D.Double(pt.getX() - 5.0, pt.getY() - 5.0, 10.0, 10.0);
            x.add((int)pt.getX());
            y.add((int)pt.getY());
            g.setColor(Color.black);
            g.fill(corners);
        }
        int[] xx = new int[x.size()];
        int[] yy = new int[x.size()];
        for (int i = 0; i < xx.length; ++i) {
            xx[i] = (Integer)x.get(i);
            yy[i] = (Integer)y.get(i);
        }
        g.drawPolygon(xx, yy, x.size());
        g.dispose();
    }

    @Override
    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        final StateRenderer2D r2d = source;
        if (event.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            popup.add("Clear polygon").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CoverArea.this.points.clear();
                    r2d.repaint();
                }
            });
            popup.add("Finish editing").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            popup.show(source, event.getX(), event.getY());
        } else if (event.getClickCount() == 1) {
            Point clicked = event.getPoint();
            LocationType curLoc = source.getRealWorldLocation(clicked);
            this.points.add(curLoc);
            source.repaint();
        }
        this.adapter.mouseClicked(event, source);
    }

    @Override
    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        this.adapter.mousePressed(event, source);
    }

    @Override
    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseDragged(event, source);
    }

    @Override
    public void mouseMoved(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseMoved(event, source);
    }

    @Override
    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseReleased(event, source);
    }

    @Override
    public void wheelMoved(MouseWheelEvent event, StateRenderer2D source) {
        this.adapter.wheelMoved(event, source);
    }

    @Override
    public void setAssociatedSwitch(ToolbarSwitch tswitch) {
        this.adapter.setAssociatedSwitch(tswitch);
    }

    @Override
    public void keyPressed(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyPressed(event, source);
    }

    @Override
    public void keyReleased(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyReleased(event, source);
    }

    @Override
    public void keyTyped(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyTyped(event, source);
    }

    @Override
    public void mouseExited(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseExited(event, source);
    }

    @Override
    public void setActive(boolean mode, StateRenderer2D source) {
        this.adapter.setActive(mode, source);
        NeptusLog.pub().info((Object)("<###>setActive: " + mode));
    }

    @Override
    public void focusGained(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusGained(event, source);
    }

    @Override
    public void focusLost(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusLost(event, source);
    }

    @Override
    public Collection<ManeuverLocation> getWaypoints() {
        return Collections.singleton(this.getStartLocation());
    }

    public static void main(String[] args) {
        CoverArea area = new CoverArea();
        NeptusLog.pub().info((Object)("<###> " + area.asXML()));
        CoverArea compc = new CoverArea();
        String ccmanXML = compc.getManeuverAsDocument("CoverArea").asXML();
        System.out.println(ccmanXML);
        CoverArea compc1 = new CoverArea();
        compc1.loadFromXML(ccmanXML);
        ccmanXML = compc.getManeuverAsDocument("CoverArea").asXML();
        System.out.println(ccmanXML);
    }

    @Override
    public void paintInteraction(Graphics2D g, StateRenderer2D source) {
    }
}

