/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Graphics2D;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import pt.lsts.imc.Dislodge;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.maneuvers.DefaultManeuver;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.ManeuversUtil;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.map.PlanElement;

public class Dislodge
extends DefaultManeuver
implements IMCSerialization {
    protected static final String DEFAULT_ROOT_ELEMENT = "Dislodge";
    @NeptusProperty(name="RPM", description="RPM to be used")
    private int rpm = 1200;
    @NeptusProperty(name="Direction", description="Direction to which the vehicle should attempt to unstuck.")
    private Dislodge.DIRECTION direction = Dislodge.DIRECTION.AUTO;

    public String validateRpm(int value) {
        if (value < 0) {
            return I18n.text("RPM should be positive");
        }
        return null;
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        return ManeuversUtil.getPropertiesFromManeuver(this);
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        ManeuversUtil.setPropertiesToManeuver(this, properties);
    }

    @Override
    public String getType() {
        return DEFAULT_ROOT_ELEMENT;
    }

    @Override
    public Object clone() {
        Dislodge clone = new Dislodge();
        super.clone(clone);
        clone.setRpm(this.getRpm());
        clone.setDirection(this.getDirection());
        return clone;
    }

    public int getRpm() {
        return this.rpm;
    }

    public void setRpm(int rpm) {
        this.rpm = rpm;
    }

    public Dislodge.DIRECTION getDirection() {
        return this.direction;
    }

    public void setDirection(Dislodge.DIRECTION direction) {
        this.direction = direction;
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("kind", "automatic");
        Element rpmElem = root.addElement("rpm");
        rpmElem.setText(String.valueOf(this.getRpm()));
        Element directionElem = root.addElement("direction");
        directionElem.setText(this.getDirection().toString());
        return document;
    }

    @Override
    public void loadFromXML(String xml) {
        super.loadFromXML(xml);
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            try {
                this.setRpm(Integer.parseInt(doc.selectSingleNode("//rpm").getText()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.setDirection(Dislodge.DIRECTION.valueOf((String)doc.selectSingleNode("//direction").getText()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    @Override
    public IMCMessage serializeToIMC() {
        pt.lsts.imc.Dislodge dislodge = new pt.lsts.imc.Dislodge();
        dislodge.setTimeout(this.getMaxTime());
        dislodge.setRpm((double)this.rpm);
        dislodge.setDirection(this.direction);
        dislodge.setCustom(this.getCustomSettings());
        return dislodge;
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        if (!DEFAULT_ROOT_ELEMENT.equalsIgnoreCase(message.getAbbrev())) {
            return;
        }
        pt.lsts.imc.Dislodge dislodge = null;
        try {
            dislodge = pt.lsts.imc.Dislodge.clone((IMCMessage)message);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.setMaxTime(dislodge.getTimeout());
        this.rpm = Double.valueOf(dislodge.getRpm()).intValue();
        this.direction = dislodge.getDirection();
        this.setCustomSettings(dislodge.getCustom());
    }

    @Override
    public void paintOnMap(Graphics2D g2d, PlanElement planElement, StateRenderer2D renderer) {
        super.paintOnMap(g2d, planElement, renderer);
        g2d = (Graphics2D)g2d.create();
        g2d.dispose();
    }
}

