/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.Elevator;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.editor.SpeedUnitsEditor;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.maneuvers.StatisticsProvider;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.PlanElement;

public class Elevator
extends Maneuver
implements LocatedManeuver,
IMCSerialization,
StatisticsProvider {
    protected static final String DEFAULT_ROOT_ELEMENT = "Elevator";
    public ManeuverLocation location = new ManeuverLocation();
    @NeptusProperty(name="Speed", description="The speed to be used")
    public double speed = 1000.0;
    @NeptusProperty(name="Speed units", description="The speed units", editorClass=SpeedUnitsEditor.class)
    public String speedUnits = "RPM";
    @NeptusProperty(name="Start from current position", description="Start from current position or use the location field")
    public boolean startFromCurrentPosition = false;
    @NeptusProperty(name="Start Z (m)")
    public float startZ = 0.0f;
    @NeptusProperty(name="Start Z Units")
    public ManeuverLocation.Z_UNITS startZUnits = ManeuverLocation.Z_UNITS.NONE;
    @NeptusProperty(name="Radius (m)")
    public float radius = 5.0f;
    double speedTolerance = 5.0;
    double radiusTolerance = 2.0;

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        Element finalPoint = root.addElement("finalPoint");
        finalPoint.addAttribute("type", "pointType");
        Element point = this.getManeuverLocation().asElement("point");
        finalPoint.add(point);
        Element radTolerance = finalPoint.addElement("radiusTolerance");
        radTolerance.setText("0");
        Element startZ = root.addElement("startZ");
        startZ.setText(String.valueOf(this.getStartZ()));
        Element startZUnits = root.addElement("startZUnits");
        startZUnits.setText(String.valueOf(this.getStartZUnits().toString()));
        Element radius = root.addElement("radius");
        radius.setText(String.valueOf(this.getRadius()));
        Element velocity = root.addElement("speed");
        velocity.addAttribute("tolerance", String.valueOf(this.speedTolerance));
        velocity.addAttribute("type", "float");
        velocity.addAttribute("unit", this.getSpeedUnits());
        velocity.setText(String.valueOf(this.getSpeed()));
        Element flags = root.addElement("flags");
        flags.addAttribute("useCurrentLocation", String.valueOf(this.isStartFromCurrentPosition()));
        return document;
    }

    @Override
    public void loadFromXML(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Node node = doc.selectSingleNode("Elevator/finalPoint/point");
            if (node == null) {
                node = doc.selectSingleNode("Elevator/initialPoint/point");
            }
            ManeuverLocation loc = new ManeuverLocation();
            loc.load(node.asXML());
            this.setManeuverLocation(loc);
            Node speedNode = doc.selectSingleNode("Elevator/speed");
            this.setSpeed(Double.parseDouble(speedNode.getText()));
            this.setSpeedUnits(speedNode.valueOf("@unit"));
            Node sz = doc.selectSingleNode("Elevator/startZ");
            if (sz == null) {
                doc.selectSingleNode("Elevator/endZ");
            }
            this.setStartZ(sz == null ? 0.0f : Float.parseFloat(sz.getText()));
            Node szu = doc.selectSingleNode("Elevator/startZUnits");
            this.setStartZUnits(szu == null ? ManeuverLocation.Z_UNITS.NONE : ManeuverLocation.Z_UNITS.valueOf(szu.getText()));
            this.setRadius(Float.parseFloat(doc.selectSingleNode("Elevator/radius").getText()));
            Element flags = (Element)doc.selectSingleNode("Elevator/flags");
            if (flags == null) {
                this.setStartFromCurrentPosition(false);
            } else {
                Node ucl = flags.selectSingleNode("@useCurrentLocation");
                if (ucl == null) {
                    this.setStartFromCurrentPosition(false);
                } else {
                    this.setStartFromCurrentPosition(Boolean.parseBoolean(ucl.getText()));
                }
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    public boolean isStartFromCurrentPosition() {
        return this.startFromCurrentPosition;
    }

    public void setStartFromCurrentPosition(boolean startFromCurrentPosition) {
        this.startFromCurrentPosition = startFromCurrentPosition;
    }

    @Override
    public ManeuverLocation getManeuverLocation() {
        return this.location.clone();
    }

    @Override
    public ManeuverLocation getEndLocation() {
        return this.getManeuverLocation();
    }

    @Override
    public ManeuverLocation getStartLocation() {
        return this.getManeuverLocation();
    }

    @Override
    public void setManeuverLocation(ManeuverLocation loc) {
        this.location = loc.clone();
        this.setStartZ((float)loc.getZ());
    }

    public float getEndZ() {
        return (float)this.getManeuverLocation().getZ();
    }

    public void setEndZ(float endZ) {
        this.location.setZ(endZ);
    }

    @Override
    public void translate(double offsetNorth, double offsetEast, double offsetDown) {
        this.getManeuverLocation().translatePosition(offsetNorth, offsetEast, offsetDown);
    }

    @Override
    public String getTooltipText() {
        return super.getTooltipText() + "<hr>" + I18n.text("speed") + ": <b>" + this.speed + " " + I18n.text(this.speedUnits) + "</b>" + (!this.startFromCurrentPosition ? "<br>" + I18n.text("cruise depth") + ": <b>" + (int)this.getStartLocation().getDepth() + " " + I18n.textc("m", "meters") + "</b>" : "") + "<br>" + I18n.text("start") + "" + ": <b>" + this.startZ + " " + I18n.textc("m", "meters") + " (" + I18n.text(this.startZUnits.toString()) + ")</b>" + "<br>" + I18n.text("end z") + ": <b>" + this.getManeuverLocation().getZ() + " " + I18n.textc("m", "meters") + " (" + I18n.text(this.getManeuverLocation().getZUnits().toString()) + ")</b>" + "<br>" + I18n.text("radius") + ": <b>" + this.radius + " " + I18n.textc("m", "meters") + "</b>";
    }

    public String validatePitchAngleDegrees(float value) {
        NeptusLog.pub().info((Object)"<###>validate...");
        if (value < 0.0f || value > 45.0f) {
            return I18n.text("Pitch angle shoud be bounded between [0\u00b0, 45\u00b0]");
        }
        return null;
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> properties = new Vector<DefaultProperty>();
        PluginProperty[] prop = PluginUtils.getPluginProperties(this);
        properties.addAll(Arrays.asList(prop));
        return properties;
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        PluginUtils.setPluginProperties((Object)this, properties);
    }

    @Override
    public IMCMessage serializeToIMC() {
        this.getManeuverLocation().convertToAbsoluteLatLonDepth();
        pt.lsts.imc.Elevator elevator = new pt.lsts.imc.Elevator();
        elevator.setTimeout(this.getMaxTime());
        elevator.setLat(this.getManeuverLocation().getLatitudeRads());
        elevator.setLon(this.getManeuverLocation().getLongitudeRads());
        elevator.setStartZ((double)this.startZ);
        elevator.setStartZUnits(this.startZUnits.toString());
        elevator.setEndZ(this.getManeuverLocation().getZ());
        elevator.setEndZUnits(this.getManeuverLocation().getZUnits().toString());
        elevator.setRadius((double)this.getRadius());
        elevator.setSpeed(this.getSpeed());
        elevator.setCustom(this.getCustomSettings());
        switch (this.getSpeedUnits()) {
            case "m/s": {
                elevator.setSpeedUnits(Elevator.SPEED_UNITS.METERS_PS);
                break;
            }
            case "RPM": {
                elevator.setSpeedUnits(Elevator.SPEED_UNITS.RPM);
                break;
            }
            default: {
                elevator.setSpeedUnits(Elevator.SPEED_UNITS.PERCENTAGE);
            }
        }
        if (this.isStartFromCurrentPosition()) {
            elevator.setFlags((short)1);
        } else {
            elevator.setFlags((short)0);
        }
        return elevator;
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        if (!DEFAULT_ROOT_ELEMENT.equalsIgnoreCase(message.getAbbrev())) {
            return;
        }
        pt.lsts.imc.Elevator elev = null;
        try {
            elev = pt.lsts.imc.Elevator.clone((IMCMessage)message);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.setMaxTime(elev.getTimeout());
        ManeuverLocation loc = new ManeuverLocation();
        loc.setLatitudeRads(elev.getLat());
        loc.setLongitudeRads(elev.getLon());
        loc.setZ(elev.getEndZ());
        NeptusLog.pub().info((Object)("<###> " + elev.getEndZUnits()));
        loc.setZUnits(ManeuverLocation.Z_UNITS.valueOf(message.getString("end_z_units").toString()));
        this.setManeuverLocation(loc);
        this.startZ = (float)elev.getStartZ();
        this.startZUnits = ManeuverLocation.Z_UNITS.valueOf(message.getString("start_z_units").toString());
        this.setRadius((float)elev.getRadius());
        this.setSpeed(elev.getSpeed());
        this.setStartFromCurrentPosition((elev.getFlags() & 1) != 0);
        this.setCustomSettings(elev.getCustom());
        switch (elev.getSpeedUnits()) {
            case RPM: {
                this.speedUnits = "RPM";
                break;
            }
            case METERS_PS: {
                this.speedUnits = "m/s";
                break;
            }
            case PERCENTAGE: {
                this.speedUnits = "%";
                break;
            }
        }
    }

    @Override
    public Object clone() {
        Elevator clone = new Elevator();
        super.clone(clone);
        clone.setManeuverLocation(this.getManeuverLocation());
        clone.startZ = this.startZ;
        clone.startZUnits = this.startZUnits;
        clone.setStartFromCurrentPosition(this.isStartFromCurrentPosition());
        clone.setRadius(this.getRadius());
        clone.setSpeed(this.getSpeed());
        clone.setSpeedUnits(this.getSpeedUnits());
        return clone;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public String getSpeedUnits() {
        return this.speedUnits;
    }

    public void setSpeedUnits(String units) {
        this.speedUnits = units;
    }

    public final float getStartZ() {
        return this.startZ;
    }

    public final void setStartZ(float startZ) {
        this.startZ = startZ;
    }

    public ManeuverLocation.Z_UNITS getStartZUnits() {
        return this.startZUnits;
    }

    public void setStartZUnits(ManeuverLocation.Z_UNITS startZUnits) {
        this.startZUnits = startZUnits;
    }

    @Override
    public void paintOnMap(Graphics2D g2d, PlanElement planElement, StateRenderer2D renderer) {
        super.paintOnMap(g2d, planElement, renderer);
        g2d = (Graphics2D)g2d.create();
        if (!this.isStartFromCurrentPosition()) {
            g2d.drawLine(-4, -4, 4, 4);
            g2d.drawLine(-4, 4, 4, -4);
        }
        double radius = this.getRadius() * renderer.getZoom();
        if (this.isStartFromCurrentPosition()) {
            g2d.setColor(new Color(255, 0, 0, 100));
        } else {
            g2d.setColor(new Color(255, 255, 255, 100));
        }
        g2d.fill(new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0));
        if (this.isStartFromCurrentPosition()) {
            g2d.setColor(Color.RED);
        } else {
            g2d.setColor(Color.GREEN);
        }
        g2d.draw(new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0));
        g2d.setColor(new Color(255, 0, 0, 200));
        for (double i = (double)(this.getRadius() - 2.0f); i > 0.0; i -= 2.0) {
            double r = i * (double)renderer.getZoom();
            g2d.draw(new Ellipse2D.Double(-r, -r, r * 2.0, r * 2.0));
        }
        g2d.translate(0, -14);
        g2d.setColor(Color.WHITE);
        g2d.setStroke(new BasicStroke(3.0f, 1, 1));
        if (this.isStartFromCurrentPosition()) {
            g2d.drawLine(-5, 0, 5, 0);
        } else {
            int m = 1;
            if (this.getManeuverLocation().getAllZ() < (double)this.getEndZ()) {
                m = -1;
            }
            g2d.drawLine(-5, m * -5, 5, m * -5);
            if (this.getManeuverLocation().getAllZ() < (double)this.getEndZ() || this.getManeuverLocation().getAllZ() > (double)this.getEndZ()) {
                g2d.drawLine(-5, m * 5, 0, 0);
                g2d.drawLine(5, m * 5, 0, 0);
            } else {
                g2d.drawLine(-5, m * 5, 5, m * 5);
            }
        }
        g2d.dispose();
    }

    @Override
    public double getCompletionTime(LocationType initialPosition) {
        double speed = this.speed;
        if (this.speedUnits.equalsIgnoreCase("RPM")) {
            speed /= 769.230769231;
        } else if (this.speedUnits.equalsIgnoreCase("%")) {
            speed /= 76.923076923;
        }
        return this.getDistanceTravelled(initialPosition) / speed;
    }

    @Override
    public double getDistanceTravelled(LocationType initialPosition) {
        double meters = this.startFromCurrentPosition ? 0.0 : this.getStartLocation().getDistanceInMeters(initialPosition);
        double depthDiff = this.startFromCurrentPosition ? initialPosition.getAllZ() : this.getStartLocation().getAllZ();
        return meters += depthDiff;
    }

    @Override
    public Collection<ManeuverLocation> getWaypoints() {
        return Collections.singleton(this.getStartLocation());
    }

    @Override
    public double getMaxDepth() {
        return this.getManeuverLocation().getAllZ();
    }

    @Override
    public double getMinDepth() {
        return this.getManeuverLocation().getAllZ();
    }
}

