/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import java.util.LinkedHashMap;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.CrossHatchPattern;
import pt.lsts.neptus.mp.maneuvers.FollowTrajectory;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.mp.maneuvers.RIPattern;
import pt.lsts.neptus.mp.maneuvers.RowsPattern;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.GraphType;
import pt.lsts.neptus.util.FileUtil;

public class FollowPath
extends FollowTrajectory {
    public FollowPath() {
        this.hasTime = false;
    }

    public FollowPath(GraphType gotoSequence) {
        Maneuver[] mans;
        this.hasTime = false;
        Goto gotoF = (Goto)gotoSequence.getManeuver(gotoSequence.getInitialManeuverId());
        ManeuverLocation trajectoryStart = gotoF.destination;
        this.setId(gotoSequence.getManeuver(gotoSequence.getInitialManeuverId()).getId());
        this.setSpeed(gotoF.getSpeed());
        this.setSpeedUnits(gotoF.getUnits());
        for (Maneuver m : mans = gotoSequence.getAllManeuvers()) {
            Goto g = (Goto)m;
            double[] ret = g.destination.getOffsetFrom(trajectoryStart);
            double[] point = new double[]{ret[0], ret[1], ret[2], -1.0};
            this.points.add(point);
        }
        this.getManeuverLocation().setLocation(trajectoryStart);
    }

    @Override
    public String getName() {
        return "FollowPath";
    }

    @Override
    public double getCompletionTime(LocationType initialPosition) {
        double speed = this.speed;
        if (this.speed_units.equalsIgnoreCase("RPM")) {
            speed /= 769.230769231;
        } else if (this.speed_units.equalsIgnoreCase("%")) {
            speed /= 76.923076923;
        }
        return this.getDistanceTravelled(initialPosition) / speed;
    }

    public static Maneuver createFollowPathOrPattern(IMCMessage message) {
        String customValues = (String)message.getValue("custom");
        if (customValues != null) {
            LinkedHashMap customValuesTL = IMCMessage.decodeTupleList((String)customValues);
            String pattern = (String)customValuesTL.get("Pattern");
            if (pattern == null || pattern.length() == 0) {
                return new FollowPath();
            }
            if ("RowsPatterns".equalsIgnoreCase(pattern)) {
                return new RowsPattern();
            }
            if ("RIPattern".equalsIgnoreCase(pattern)) {
                return new RIPattern();
            }
            if ("CrossHatchPattern".equalsIgnoreCase(pattern)) {
                return new CrossHatchPattern();
            }
            return new FollowPath();
        }
        return new FollowPath();
    }

    public static void main(String[] args) {
        FollowPath traj = new FollowPath();
        traj.loadFromXML("<FollowPath kind=\"automatic\"><basePoint type=\"pointType\"><point><id>id_53802104</id><name>id_53802104</name><coordinate><latitude>0N0'0''</latitude><longitude>0E0'0''</longitude><depth>0.0</depth></coordinate></point><radiusTolerance>0.0</radiusTolerance></basePoint><path><nedOffsets northOffset=\"0.0\" eastOffset=\"1.0\" depthOffset=\"2.0\" timeOffset=\"3.0\"/><nedOffsets northOffset=\"4.0\" eastOffset=\"5.0\" depthOffset=\"6.0\" timeOffset=\"7.0\"/></path><speed unit=\"RPM\">1000.0</speed></FollowPath>");
        traj.setSpeed(1.0);
        traj.setSpeedUnits("m/s");
        NeptusLog.pub().info((Object)("<###> " + FileUtil.getAsPrettyPrintFormatedXMLString(traj.getManeuverAsDocument("FollowPath"))));
        traj.setSpeed(2.0);
        traj.setSpeedUnits("m/s");
        NeptusLog.pub().info((Object)("<###> " + FileUtil.getAsPrettyPrintFormatedXMLString(traj.getManeuverAsDocument("FollowPath"))));
    }
}

