/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.beans.PropertyEditor;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.editor.SpeedUnitsEditor;
import pt.lsts.neptus.gui.editor.renderer.I18nCellRenderer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.DefaultManeuver;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.NameNormalizer;

public class FollowSystem
extends DefaultManeuver
implements IMCSerialization {
    private double speed = 1000.0;
    private double speedTolerance = 100.0;
    private String units = "RPM";
    private int duration = 60;
    private String system = "";
    private double xOffset = 1.0;
    private double yOffset = 1.0;
    private double zOffset = 1.0;
    protected static final String DEFAULT_ROOT_ELEMENT = "FollowSystem";
    public String id = NameNormalizer.getRandomID();

    @Override
    public String getType() {
        return DEFAULT_ROOT_ELEMENT;
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("kind", "automatic");
        Element system = root.addElement("system");
        system.setText(String.valueOf(this.getSystem()));
        Element duration = root.addElement("duration");
        duration.setText(String.valueOf(this.getDuration()));
        Element offsets = root.addElement("offsets");
        offsets.addAttribute("xOffset", Double.toString(this.getXOffset()));
        offsets.addAttribute("yOffset", Double.toString(this.getYOffset()));
        offsets.addAttribute("zOffset", Double.toString(this.getZOffset()));
        Element velocity = root.addElement("speed");
        velocity.addAttribute("tolerance", String.valueOf(this.getSpeedTolerance()));
        velocity.addAttribute("type", "float");
        velocity.addAttribute("unit", this.getUnits());
        velocity.setText(String.valueOf(this.getSpeed()));
        return document;
    }

    @Override
    public void loadFromXML(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            this.setSystem(doc.selectSingleNode("//system").getText());
            this.setDuration(Integer.parseInt(doc.selectSingleNode("//duration").getText()));
            Node offsetNode = doc.selectSingleNode("//offsets");
            this.setXOffset(Double.parseDouble(offsetNode.valueOf("@xOffset")));
            this.setYOffset(Double.parseDouble(offsetNode.valueOf("@yOffset")));
            this.setZOffset(Double.parseDouble(offsetNode.valueOf("@zOffset")));
            Node speedNode = doc.selectSingleNode("//speed");
            if (speedNode == null) {
                speedNode = doc.selectSingleNode("//velocity");
            }
            this.setSpeed(Double.parseDouble(speedNode.getText()));
            this.setUnits(speedNode.valueOf("@unit"));
            this.setSpeedTolerance(Double.parseDouble(speedNode.valueOf("@tolerance")));
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    public SystemPositionAndAttitude ManeuverFunction(SystemPositionAndAttitude lastVehicleState) {
        return lastVehicleState;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(double xOffset) {
        this.xOffset = xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(double yOffset) {
        this.yOffset = yOffset;
    }

    public double getZOffset() {
        return this.zOffset;
    }

    public void setZOffset(double zOffset) {
        this.zOffset = zOffset;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeedTolerance() {
        return this.speedTolerance;
    }

    public void setSpeedTolerance(double speedTolerance) {
        this.speedTolerance = speedTolerance;
    }

    @Override
    public Object clone() {
        FollowSystem clone = new FollowSystem();
        super.clone(clone);
        clone.setSystem(this.getSystem());
        clone.setDuration(this.getDuration());
        clone.setXOffset(this.getXOffset());
        clone.setYOffset(this.getYOffset());
        clone.setZOffset(this.getZOffset());
        clone.setUnits(this.getUnits());
        clone.setSpeed(this.getSpeed());
        clone.setSpeedTolerance(this.getSpeedTolerance());
        return clone;
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> properties = new Vector<DefaultProperty>();
        properties.add(PropertiesEditor.getPropertyInstance("System", String.class, this.getSystem(), true));
        properties.add(PropertiesEditor.getPropertyInstance("Duration", Integer.class, this.getDuration(), true));
        properties.add(PropertiesEditor.getPropertyInstance("x offset", Double.class, this.getXOffset(), true));
        properties.add(PropertiesEditor.getPropertyInstance("y offset", Double.class, this.getYOffset(), true));
        properties.add(PropertiesEditor.getPropertyInstance("z offset", Double.class, this.getZOffset(), true));
        DefaultProperty units = PropertiesEditor.getPropertyInstance("Speed units", String.class, this.getUnits(), true);
        units.setShortDescription("The speed units");
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)units, (PropertyEditor)((Object)new SpeedUnitsEditor()));
        PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)units, (TableCellRenderer)((Object)new I18nCellRenderer()));
        properties.add(PropertiesEditor.getPropertyInstance("Speed", Double.class, this.getSpeed(), true));
        properties.add(units);
        properties.add(PropertiesEditor.getPropertyInstance("Speed tolerance", Double.class, this.getSpeedTolerance(), true));
        return properties;
    }

    @Override
    public String getPropertiesDialogTitle() {
        return this.getId() + " parameters";
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        for (Property p : properties) {
            if (p.getName().equals("Speed units")) {
                this.setUnits((String)p.getValue());
            }
            if (p.getName().equals("Speed tolerance")) {
                this.setSpeedTolerance((Double)p.getValue());
            }
            if (p.getName().equals("Speed")) {
                this.setSpeed((Double)p.getValue());
            }
            if (p.getName().equals("Duration")) {
                this.setDuration((Integer)p.getValue());
            }
            if (p.getName().equals("System")) {
                this.setSystem((String)p.getValue());
            }
            if (p.getName().equals("x offset")) {
                this.setXOffset((Double)p.getValue());
            }
            if (p.getName().equals("y offset")) {
                this.setYOffset((Double)p.getValue());
            }
            if (!p.getName().equals("z offset")) continue;
            this.setZOffset((Double)p.getValue());
        }
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return super.getPropertiesErrors(properties);
    }

    @Override
    public String getTooltipText() {
        return super.getTooltipText() + "<hr>" + "speed" + ": <b>" + this.getSpeed() + " " + I18n.text(this.getUnits()) + "</b>" + "<br>" + I18n.text("duration") + ": <b>" + this.getDuration() + " " + I18n.textc("s", "seconds") + "</b>" + "<br>" + I18n.text("system") + ": <b>" + this.getSystem() + "</b>" + "<br>" + I18n.text("system") + ": <b>" + I18n.textc("nOff", "north offset") + "=</b>'" + MathMiscUtils.round(this.getXOffset(), 1) + "' <b>" + I18n.textc("eOff", "east offset") + "=</b>'" + MathMiscUtils.round(this.getYOffset(), 1) + "' <b>" + I18n.textc("dOff", "down offset") + "=</b>'" + MathMiscUtils.round(this.getZOffset(), 1) + " (" + I18n.textc("m", "meters") + ")'";
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        this.setMaxTime((int)message.getDouble("timeout"));
        this.setSystem(IMCUtils.translateImcIdToSystem((int)message.getDouble("system")));
        this.setDuration((int)message.getDouble("duration"));
        this.setXOffset(message.getDouble("x"));
        this.setYOffset(message.getDouble("y"));
        this.setZOffset(message.getDouble("z"));
        this.setSpeed(message.getDouble("speed"));
        String speed_units = message.getString("speed_units");
        if (speed_units.equals("METERS_PS")) {
            this.setUnits("m/s");
        } else if (speed_units.equals("RPM")) {
            this.setUnits("RPM");
        } else {
            this.setUnits("%");
        }
    }

    @Override
    public IMCMessage serializeToIMC() {
        IMCMessage msgManeuver = IMCDefinition.getInstance().create(DEFAULT_ROOT_ELEMENT, new Object[0]);
        msgManeuver.setValue("timeout", (Object)this.getMaxTime());
        msgManeuver.setValue("system", (Object)IMCUtils.translateSystemToImcId(this.getSystem()));
        msgManeuver.setValue("duration", (Object)this.getDuration());
        msgManeuver.setValue("x", (Object)this.getXOffset());
        msgManeuver.setValue("y", (Object)this.getYOffset());
        msgManeuver.setValue("z", (Object)this.getZOffset());
        msgManeuver.setValue("speed", (Object)this.getSpeed());
        String enumerated = "";
        String speedU = this.getUnits();
        try {
            if ("m/s".equalsIgnoreCase(speedU)) {
                enumerated = "METERS_PS";
            } else if ("RPM".equalsIgnoreCase(speedU)) {
                enumerated = "RPM";
            } else if ("%".equalsIgnoreCase(speedU)) {
                enumerated = "PERCENTAGE";
            } else if ("percentage".equalsIgnoreCase(speedU)) {
                enumerated = "PERCENTAGE";
            }
        }
        catch (Exception ex) {
            NeptusLog.pub().error((Object)this, (Throwable)ex);
        }
        msgManeuver.setValue("speed_units", (Object)enumerated);
        LinkedHashMap<String, String> tl = new LinkedHashMap<String, String>();
        for (String key : this.getCustomSettings().keySet()) {
            tl.put(key, this.getCustomSettings().get(key));
        }
        msgManeuver.setValue("custom", (Object)IMCMessage.encodeTupleList(tl));
        return msgManeuver;
    }
}

