/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyEditor;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.FollowPath;
import pt.lsts.imc.FollowTrajectory;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.PathPoint;
import pt.lsts.imc.TrajectoryPoint;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.gui.editor.SpeedUnitsEditor;
import pt.lsts.neptus.gui.editor.renderer.I18nCellRenderer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.FollowPath;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.maneuvers.ManeuversUtil;
import pt.lsts.neptus.mp.maneuvers.PathProvider;
import pt.lsts.neptus.mp.maneuvers.StatisticsProvider;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.util.AngleCalc;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;

public class FollowTrajectory
extends Maneuver
implements LocatedManeuver,
StatisticsProvider,
StateRendererInteraction,
IMCSerialization,
PathProvider {
    protected boolean hasTime = true;
    protected static final double RPM_MPS_CONVERSION = 769.2307692307692;
    protected static final double RPM_PERCENT_CONVERSION = 10.0;
    protected static final double PERCENT_MPS_CONVERSION = 76.92307692307692;
    protected ManeuverLocation startLoc = new ManeuverLocation();
    LocationType previousLoc = null;
    protected double speed = 1000.0;
    protected String speed_units = "RPM";
    protected Vector<double[]> points = new Vector();
    protected static final int X = 0;
    protected static final int Y = 1;
    protected static final int Z = 2;
    protected static final int T = 3;
    protected InteractionAdapter adapter = new InteractionAdapter(null);
    protected Point2D lastDragPoint = null;
    protected boolean editing = false;

    @Override
    public String getName() {
        return "FollowTrajectory";
    }

    public void setOffsets(Vector<double[]> coordinates) {
        this.points = coordinates;
    }

    @Override
    public void loadFromXML(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Node node = doc.selectSingleNode("//basePoint/point");
            ManeuverLocation loc = new ManeuverLocation();
            loc.load(node.asXML());
            this.setManeuverLocation(loc);
            Node speedNode = doc.selectSingleNode("//speed");
            this.speed = Double.parseDouble(speedNode.getText());
            this.speed_units = speedNode.valueOf("@unit");
            List list = doc.selectNodes("//*/nedOffsets");
            for (Object o : list) {
                Element el = (Element)o;
                double[] xyzt = new double[]{Double.parseDouble(el.selectSingleNode("@northOffset").getText()), Double.parseDouble(el.selectSingleNode("@eastOffset").getText()), Double.parseDouble(el.selectSingleNode("@depthOffset").getText()), this.hasTime ? Double.parseDouble(el.selectSingleNode("@timeOffset").getText()) : -1.0};
                this.points.add(xyzt);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("kind", "automatic");
        Element basePoint = root.addElement("basePoint");
        Element point = this.getManeuverLocation().asElement("point");
        basePoint.add(point);
        Element radTolerance = basePoint.addElement("radiusTolerance");
        radTolerance.setText(String.valueOf(this.getRadiusTolerance()));
        basePoint.addAttribute("type", "pointType");
        Element points = root.addElement(this.hasTime ? "trajectory" : "path");
        for (double[] pt : this.points) {
            Element tmp = points.addElement("nedOffsets");
            tmp.addAttribute("northOffset", "" + pt[0]);
            tmp.addAttribute("eastOffset", "" + pt[1]);
            tmp.addAttribute("depthOffset", "" + pt[2]);
            if (!this.hasTime) continue;
            tmp.addAttribute("timeOffset", "" + pt[3]);
        }
        Element velocity = root.addElement("speed");
        velocity.addAttribute("unit", this.speed_units);
        velocity.setText("" + this.speed);
        return document;
    }

    @Override
    public Object clone() {
        FollowTrajectory clone;
        try {
            clone = (FollowTrajectory)this.getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            clone = this.hasTime ? new FollowTrajectory() : new FollowPath();
        }
        super.clone(clone);
        clone.speed = this.speed;
        clone.speed_units = this.speed_units;
        clone.setManeuverLocation(this.startLoc);
        for (double[] val : this.points) {
            clone.points.add(Arrays.copyOf(val, val.length));
        }
        return clone;
    }

    @Override
    public Image getIconImage() {
        return this.adapter.getIconImage();
    }

    @Override
    public Cursor getMouseCursor() {
        return this.adapter.getMouseCursor();
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public void paintOnMap(Graphics2D g2d, PlanElement planElement, StateRenderer2D renderer) {
        super.paintOnMap(g2d, planElement, renderer);
        g2d.rotate(-renderer.getRotation());
        g2d.rotate(-1.5707963267948966);
        ManeuversUtil.paintPointLineList(g2d, renderer.getZoom(), this.points, false, 0.0, this.editing);
        g2d.rotate(1.5707963267948966);
        g2d.rotate(renderer.getRotation());
    }

    protected void editPointsDialog(Window parent) {
        String times = "";
        NumberFormat nf = GuiUtils.getNeptusDecimalFormat(2);
        for (double[] pt : this.points) {
            times = times + nf.format(pt[0]) + ", " + nf.format(pt[1]) + ", " + nf.format(pt[2]) + (this.hasTime ? ", " + nf.format(pt[3]) : "") + "\n";
        }
        final JEditorPane epane = new JEditorPane();
        epane.setText(times);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(new JScrollPane(epane));
        final JDialog dialog = new JDialog(parent);
        dialog.getContentPane().add(mainPanel);
        dialog.setDefaultCloseOperation(0);
        dialog.setTitle((this.hasTime ? "Trajectory" : "Path") + " points (N, E, D" + (this.hasTime ? ", T" : "") + ")");
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int opt = JOptionPane.showConfirmDialog(dialog, "Do you want to save changes?", "Edit points", 1);
                if (opt == 0) {
                    String[] lines = epane.getText().split("\n");
                    Vector<double[]> pts = new Vector<double[]>();
                    for (int i = 0; i < lines.length; ++i) {
                        String[] parts = lines[i].split(",");
                        try {
                            double[] pt = new double[]{Double.parseDouble(parts[0].trim()), Double.parseDouble(parts[1].trim()), Double.parseDouble(parts[2].trim()), FollowTrajectory.this.hasTime ? Double.parseDouble(parts[3].trim()) : -1.0};
                            pts.add(pt);
                            continue;
                        }
                        catch (Exception ex) {
                            GuiUtils.errorMessage(dialog, "Error parsing text", "Invalid syntax on line " + (i + 1));
                            ex.printStackTrace();
                        }
                    }
                    FollowTrajectory.this.points = pts;
                    dialog.setVisible(false);
                    dialog.dispose();
                } else if (opt == 1) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            }
        });
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setSize(500, 600);
        GuiUtils.centerParent(dialog, parent);
        dialog.setVisible(true);
    }

    @Override
    public void mouseClicked(MouseEvent event, final StateRenderer2D source) {
        final StateRenderer2D r2d = source;
        if (event.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            popup.add("Clear " + (this.hasTime ? "trajectory" : "path")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FollowTrajectory.this.points.clear();
                    r2d.repaint();
                }
            });
            popup.add("Edit points as text").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FollowTrajectory.this.editPointsDialog(SwingUtilities.getWindowAncestor(source));
                }
            });
            popup.show(source, event.getX(), event.getY());
        } else if (event.getClickCount() == 1) {
            Point clicked = event.getPoint();
            LocationType curLoc = source.getRealWorldLocation(clicked);
            double _speed = this.speed;
            if (this.speed_units.equalsIgnoreCase("RPM")) {
                _speed /= 769.2307692307692;
            } else if (this.speed_units.equalsIgnoreCase("%")) {
                _speed /= 76.92307692307692;
            }
            double[] offsets = source.getRealWorldLocation(clicked).getOffsetFrom(this.startLoc);
            double[] xyzt = new double[4];
            for (int i = 0; i < 3; ++i) {
                xyzt[i] = offsets[i];
            }
            if (this.hasTime) {
                double distance = this.previousLoc != null ? curLoc.getDistanceInMeters(this.previousLoc) : curLoc.getDistanceInMeters(this.startLoc);
                xyzt[3] = distance / _speed;
            } else {
                xyzt[3] = -1.0;
            }
            boolean skip = false;
            if (!event.isAltDown() && !event.isAltGraphDown()) {
                if (this.points.size() == 0) {
                    this.points.add(new double[]{0.0, 0.0, 0.0, this.hasTime ? 0.0 : -1.0});
                }
            } else if (this.points.size() > 0) {
                this.points.remove(this.points.size() - 1);
                skip = true;
            }
            if (!skip) {
                this.points.add(xyzt);
                this.previousLoc = curLoc;
            }
            source.repaint();
        }
        this.adapter.mouseClicked(event, source);
    }

    @Override
    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        this.adapter.mousePressed(event, source);
    }

    @Override
    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        if (this.lastDragPoint == null) {
            this.adapter.mouseDragged(event, source);
            this.lastDragPoint = event.getPoint();
            return;
        }
        double yammount = event.getPoint().getY() - this.lastDragPoint.getY();
        yammount = -yammount;
        if (event.isShiftDown()) {
            double bearingRad;
            for (bearingRad = Math.toRadians(yammount / 10.0); bearingRad > Math.PI * 2; bearingRad -= Math.PI * 2) {
            }
            while (bearingRad < 0.0) {
                bearingRad += Math.PI * 2;
            }
            for (double[] pt : this.points) {
                double[] ret = AngleCalc.rotate(bearingRad, pt[0], pt[1], false);
                pt[0] = ret[0];
                pt[1] = ret[1];
            }
        } else {
            this.adapter.mouseDragged(event, source);
        }
        this.lastDragPoint = event.getPoint();
    }

    @Override
    public void mouseMoved(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseMoved(event, source);
    }

    @Override
    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseReleased(event, source);
        this.lastDragPoint = null;
    }

    @Override
    public void wheelMoved(MouseWheelEvent event, StateRenderer2D source) {
        this.adapter.wheelMoved(event, source);
    }

    @Override
    public void keyPressed(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyPressed(event, source);
    }

    @Override
    public void keyReleased(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyReleased(event, source);
    }

    @Override
    public void keyTyped(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyTyped(event, source);
    }

    @Override
    public void mouseExited(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseExited(event, source);
    }

    @Override
    public void focusGained(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusGained(event, source);
    }

    @Override
    public void focusLost(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusLost(event, source);
    }

    @Override
    public void setActive(boolean mode, StateRenderer2D source) {
        this.editing = mode;
        source.setLockedVehicle(null);
        source.setRotation(0.0);
        this.previousLoc = null;
    }

    @Override
    public void setAssociatedSwitch(ToolbarSwitch tswitch) {
    }

    @Override
    public double getCompletionTime(LocationType initialPosition) {
        double initialDistance = this.startLoc.getDistanceInMeters(initialPosition);
        double speed = this.speed;
        if (this.speed_units.equalsIgnoreCase("RPM")) {
            speed /= 769.2307692307692;
        } else if (this.speed_units.equalsIgnoreCase("%")) {
            speed /= 76.92307692307692;
        }
        double time = initialDistance / speed;
        for (double[] p : this.points) {
            time += p[3];
        }
        return time;
    }

    @Override
    public double getDistanceTravelled(LocationType initialPosition) {
        double sum = this.startLoc.getDistanceInMeters(initialPosition);
        double[] l = new double[]{0.0, 0.0, 0.0, 0.0};
        for (double[] p : this.points) {
            sum += Math.sqrt((p[0] - l[0]) * (p[0] - l[0]) + (p[1] - l[1]) * (p[1] - l[1]) + (p[2] - l[2]) * (p[2] - l[2]));
            l = p;
        }
        return sum;
    }

    @Override
    public double getMaxDepth() {
        double maxDepth;
        double curDepth = maxDepth = this.startLoc.getAllZ();
        for (double[] p : this.points) {
            if (!((curDepth += p[2]) > maxDepth)) continue;
            maxDepth = curDepth;
        }
        return maxDepth;
    }

    @Override
    public double getMinDepth() {
        double minDepth;
        double curDepth = minDepth = this.startLoc.getAllZ();
        for (double[] p : this.points) {
            if (!((curDepth += p[2]) < minDepth)) continue;
            minDepth = curDepth;
        }
        return minDepth;
    }

    @Override
    public ManeuverLocation getManeuverLocation() {
        return this.startLoc.clone();
    }

    @Override
    public ManeuverLocation getStartLocation() {
        return this.getManeuverLocation();
    }

    @Override
    public ManeuverLocation getEndLocation() {
        ManeuverLocation loc = this.startLoc.clone();
        if (!this.points.isEmpty()) {
            loc.translatePosition(this.points.lastElement());
        }
        return loc;
    }

    @Override
    public void setManeuverLocation(ManeuverLocation location) {
        this.startLoc = location.clone();
    }

    @Override
    public void translate(double offsetNorth, double offsetEast, double offsetDown) {
        this.startLoc.translatePosition(offsetNorth, offsetEast, offsetDown);
    }

    @Override
    public List<double[]> getPathPoints() {
        return Collections.unmodifiableList(this.points);
    }

    @Override
    public List<LocationType> getPathLocations() {
        Vector<LocationType> locs = new Vector<LocationType>();
        List<double[]> lst = Collections.unmodifiableList(this.points);
        LocationType start = new LocationType(this.getManeuverLocation());
        for (double[] ds : lst) {
            LocationType loc = new LocationType(start);
            loc.translatePosition(ds);
            loc.convertToAbsoluteLatLonDepth();
            locs.add(loc);
        }
        return locs;
    }

    @Override
    public Collection<ManeuverLocation> getWaypoints() {
        Vector<ManeuverLocation> locs = new Vector<ManeuverLocation>();
        List<double[]> lst = Collections.unmodifiableList(this.points);
        ManeuverLocation start = new ManeuverLocation(this.getManeuverLocation());
        for (double[] ds : lst) {
            ManeuverLocation loc = new ManeuverLocation(start);
            loc.translatePosition(ds);
            loc.convertToAbsoluteLatLonDepth();
            locs.add(loc);
        }
        return locs;
    }

    public SystemPositionAndAttitude ManeuverFunction(SystemPositionAndAttitude lastVehicleState) {
        return null;
    }

    public double getRadiusTolerance() {
        return 0.0;
    }

    @Override
    public IMCMessage serializeToIMC() {
        double[] lld = this.startLoc.getAbsoluteLatLonDepth();
        double[] absoluteTimes = new double[this.points.size()];
        double lastTime = 0.0;
        for (int i = 0; i < this.points.size(); ++i) {
            try {
                lastTime += this.points.get(i)[3];
            }
            catch (Exception e) {
                e.printStackTrace();
                lastTime += -1.0;
            }
            absoluteTimes[i] = lastTime;
        }
        if (this.hasTime) {
            Vector<TrajectoryPoint> pointMessages = new Vector<TrajectoryPoint>();
            for (int i = 0; i < this.points.size(); ++i) {
                double[] p = this.points.get(i);
                TrajectoryPoint point = new TrajectoryPoint();
                point.setX(p[0]);
                point.setY(p[1]);
                point.setZ(p[2]);
                point.setT(absoluteTimes[i]);
                pointMessages.add(point);
            }
            pt.lsts.imc.FollowTrajectory trajMessage = new pt.lsts.imc.FollowTrajectory();
            trajMessage.setPoints(pointMessages);
            trajMessage.setLat(Math.toRadians(lld[0]));
            trajMessage.setLon(Math.toRadians(lld[1]));
            trajMessage.setZ(this.getManeuverLocation().getZ());
            trajMessage.setZUnits(this.getManeuverLocation().getZUnits().toString());
            trajMessage.setSpeed(this.speed);
            try {
                String speedU = this.getUnits();
                if ("m/s".equalsIgnoreCase(speedU)) {
                    trajMessage.setSpeedUnits(FollowTrajectory.SPEED_UNITS.METERS_PS);
                } else if ("RPM".equalsIgnoreCase(speedU)) {
                    trajMessage.setSpeedUnits(FollowTrajectory.SPEED_UNITS.RPM);
                } else if ("%".equalsIgnoreCase(speedU)) {
                    trajMessage.setSpeedUnits(FollowTrajectory.SPEED_UNITS.PERCENTAGE);
                } else if ("percentage".equalsIgnoreCase(speedU)) {
                    trajMessage.setSpeedUnits(FollowTrajectory.SPEED_UNITS.PERCENTAGE);
                }
            }
            catch (Exception ex) {
                NeptusLog.pub().error((Object)this, (Throwable)ex);
            }
            trajMessage.setCustom(this.getCustomSettings());
            trajMessage.setTimeout(this.getMaxTime());
            return trajMessage;
        }
        Vector<PathPoint> pointMessages = new Vector<PathPoint>();
        for (int i = 0; i < this.points.size(); ++i) {
            double[] p = this.points.get(i);
            PathPoint point = new PathPoint();
            point.setX(p[0]);
            point.setY(p[1]);
            point.setZ(p[2]);
            pointMessages.add(point);
        }
        pt.lsts.imc.FollowPath pathMessage = new pt.lsts.imc.FollowPath();
        pathMessage.setPoints(pointMessages);
        pathMessage.setLat(Math.toRadians(lld[0]));
        pathMessage.setLon(Math.toRadians(lld[1]));
        pathMessage.setZ(this.getManeuverLocation().getZ());
        pathMessage.setZUnits(this.getManeuverLocation().getZUnits().toString());
        pathMessage.setSpeed(this.speed);
        try {
            String speedU = this.getUnits();
            if ("m/s".equalsIgnoreCase(speedU)) {
                pathMessage.setSpeedUnits(FollowPath.SPEED_UNITS.METERS_PS);
            } else if ("RPM".equalsIgnoreCase(speedU)) {
                pathMessage.setSpeedUnits(FollowPath.SPEED_UNITS.RPM);
            } else if ("%".equalsIgnoreCase(speedU)) {
                pathMessage.setSpeedUnits(FollowPath.SPEED_UNITS.PERCENTAGE);
            } else if ("percentage".equalsIgnoreCase(speedU)) {
                pathMessage.setSpeedUnits(FollowPath.SPEED_UNITS.PERCENTAGE);
            }
        }
        catch (Exception ex) {
            NeptusLog.pub().error((Object)this, (Throwable)ex);
        }
        pathMessage.setCustom(this.getCustomSettings());
        pathMessage.setTimeout(this.getMaxTime());
        return pathMessage;
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        this.setMaxTime(message.getAsNumber("timeout").intValue());
        this.startLoc = new ManeuverLocation();
        this.startLoc.setLatitudeRads(message.getDouble("lat"));
        this.startLoc.setLongitudeRads(message.getDouble("lon"));
        this.startLoc.setZ(message.getDouble("z"));
        String units = message.getString("z_units");
        if (units != null) {
            this.startLoc.setZUnits(ManeuverLocation.Z_UNITS.valueOf(units));
        }
        this.speed = message.getDouble("speed");
        this.customSettings = message.getTupleList("custom");
        String speed_units = message.getString("speed_units");
        this.speed_units = speed_units.equals("METERS_PS") ? "m/s" : (speed_units.equals("RPM") ? "RPM" : "%");
        this.points.clear();
        Vector pts = message.getMessageList("points");
        for (IMCMessage pt : pts) {
            if (this.hasTime) {
                this.points.add(new double[]{pt.getDouble("x"), pt.getDouble("y"), pt.getDouble("z"), pt.getDouble("t")});
                continue;
            }
            this.points.add(new double[]{pt.getDouble("x"), pt.getDouble("y"), pt.getDouble("z"), -1.0});
        }
        if (this.hasTime) {
            double lastPTime = 0.0;
            for (double[] ptt : this.points) {
                double aux = ptt[3];
                ptt[3] = ptt[3] - lastPTime;
                lastPTime = aux;
            }
        }
    }

    public String getUnits() {
        return this.speed_units;
    }

    public void setSpeedUnits(String units) {
        this.speed_units = units;
        this.recalculateTimes();
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    protected void recalculateTimes() {
        if (!this.hasTime) {
            return;
        }
        double _speed = this.speed;
        if (this.speed_units.equalsIgnoreCase("RPM")) {
            _speed /= 769.2307692307692;
        } else if (this.speed_units.equalsIgnoreCase("%")) {
            _speed /= 76.92307692307692;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            double dist = i == 0 ? Math.sqrt(this.points.get(0)[0] * this.points.get(0)[0] + this.points.get(0)[1] * this.points.get(0)[1] + this.points.get(0)[2] * this.points.get(0)[2]) : Math.sqrt(Math.pow(this.points.get(i)[0] - this.points.get(i - 1)[0], 2.0) + Math.pow(this.points.get(i)[1] - this.points.get(i - 1)[1], 2.0) + Math.pow(this.points.get(i)[2] - this.points.get(i - 1)[2], 2.0));
            this.points.get((int)i)[3] = dist / _speed;
        }
    }

    @Override
    public String getTooltipText() {
        NumberFormat nf = GuiUtils.getNeptusDecimalFormat(2);
        return super.getTooltipText() + "<hr>" + I18n.text("speed") + ": <b>" + nf.format(this.speed) + " " + I18n.text(this.speed_units) + "</b>" + "<br>" + I18n.text("points") + ": <b>" + this.points.size() + "</b>";
    }

    protected static void test1() {
        FollowTrajectory traj = new FollowTrajectory();
        traj.points.add(new double[]{0.0, 1.0, 2.0, 3.0});
        traj.points.add(new double[]{4.0, 5.0, 6.0, 7.0});
        String xml = traj.getManeuverAsDocument("FollowTrajectory").asXML();
        NeptusLog.pub().info((Object)("<###> " + traj.getManeuverAsDocument("FollowTrajectory").asXML()));
        FollowTrajectory other = new FollowTrajectory();
        other.loadFromXML(xml);
        NeptusLog.pub().info((Object)("<###> " + other.getManeuverAsDocument("FollowTrajectory").asXML()));
        other.serializeToIMC().dump((OutputStream)System.out);
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> properties = new Vector<DefaultProperty>();
        DefaultProperty units = PropertiesEditor.getPropertyInstance("Speed units", String.class, this.getUnits(), true);
        units.setShortDescription("The speed units");
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)units, (PropertyEditor)((Object)new SpeedUnitsEditor()));
        PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)units, (TableCellRenderer)((Object)new I18nCellRenderer()));
        properties.add(PropertiesEditor.getPropertyInstance("Speed", Double.class, this.getSpeed(), true));
        properties.add(units);
        return properties;
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        for (Property p : properties) {
            if (p.getName().equals("Speed units")) {
                this.setSpeedUnits((String)p.getValue());
                continue;
            }
            if (!p.getName().equals("Speed")) continue;
            this.setSpeed((Double)p.getValue());
        }
    }

    @Override
    public void paintInteraction(Graphics2D g, StateRenderer2D source) {
    }

    public static void main(String[] args) {
        FollowTrajectory traj = new FollowTrajectory();
        traj.loadFromXML("<FollowTrajectory kind=\"automatic\"><basePoint type=\"pointType\"><point><id>id_53802104</id><name>id_53802104</name><coordinate><latitude>0N0'0''</latitude><longitude>0E0'0''</longitude><depth>0.0</depth></coordinate></point><radiusTolerance>0.0</radiusTolerance></basePoint><trajectory><nedOffsets northOffset=\"0.0\" eastOffset=\"1.0\" depthOffset=\"2.0\" timeOffset=\"3.0\"/><nedOffsets northOffset=\"4.0\" eastOffset=\"5.0\" depthOffset=\"6.0\" timeOffset=\"7.0\"/></trajectory><speed unit=\"RPM\">1000.0</speed></FollowTrajectory>");
        traj.setSpeed(1.0);
        traj.setSpeedUnits("m/s");
        NeptusLog.pub().info((Object)("<###> " + FileUtil.getAsPrettyPrintFormatedXMLString(traj.getManeuverAsDocument("FollowTrajectory"))));
        traj.setSpeed(2.0);
        traj.setSpeedUnits("m/s");
        NeptusLog.pub().info((Object)("<###> " + FileUtil.getAsPrettyPrintFormatedXMLString(traj.getManeuverAsDocument("FollowTrajectory"))));
    }
}

