/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.beans.PropertyEditor;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.Goto;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.GotoParameters;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.editor.SpeedUnitsEditor;
import pt.lsts.neptus.gui.editor.renderer.I18nCellRenderer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.NameNormalizer;

public class Goto
extends Maneuver
implements IMCSerialization,
LocatedManeuver {
    double speed = 1000.0;
    double speedTolerance = 0.0;
    double radiusTolerance = 2.0;
    String units = "RPM";
    ManeuverLocation destination = new ManeuverLocation();
    protected static final String DEFAULT_ROOT_ELEMENT = "Goto";
    private GotoParameters params = new GotoParameters();
    private final int ANGLE_CALCULATION = -1;
    private final int FIRST_ROTATE = 0;
    private final int HORIZONTAL_MOVE = 1;
    int current_state = -1;
    private double targetAngle;
    private double rotateIncrement;
    private double roll;
    private double pitch;
    private double yaw;
    public String id = NameNormalizer.getRandomID();
    LinkedHashMap<String, String> custom = new LinkedHashMap();
    private int count = 0;

    @Override
    public String getType() {
        return DEFAULT_ROOT_ELEMENT;
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("kind", "automatic");
        Element finalPoint = root.addElement("finalPoint");
        finalPoint.addAttribute("type", "pointType");
        Element point = this.destination.asElement("point");
        finalPoint.add(point);
        Element radTolerance = finalPoint.addElement("radiusTolerance");
        radTolerance.setText(String.valueOf(this.getRadiusTolerance()));
        Element velocity = root.addElement("speed");
        velocity.addAttribute("tolerance", String.valueOf(this.getSpeedTolerance()));
        velocity.addAttribute("type", "float");
        velocity.addAttribute("unit", this.getUnits());
        velocity.setText(String.valueOf(this.getSpeed()));
        Element trajectoryTolerance = root.addElement("trajectoryTolerance");
        Element radiusTolerance = trajectoryTolerance.addElement("radiusTolerance");
        radiusTolerance.setText(String.valueOf(this.getRadiusTolerance()));
        return document;
    }

    @Override
    public void loadFromXML(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Node node = doc.selectSingleNode("Goto/finalPoint/point");
            ManeuverLocation loc = new ManeuverLocation();
            loc.load(node.asXML());
            this.setManeuverLocation(loc);
            this.setRadiusTolerance(Double.parseDouble(doc.selectSingleNode("Goto/finalPoint/radiusTolerance").getText()));
            Node speedNode = doc.selectSingleNode("Goto/speed");
            if (speedNode == null) {
                speedNode = doc.selectSingleNode("Goto/velocity");
            }
            this.setSpeed(Double.parseDouble(speedNode.getText()));
            String speedUnit = speedNode.valueOf("@unit");
            this.setSpeedUnits(speedUnit);
            this.setSpeedTolerance(Double.parseDouble(speedNode.valueOf("@tolerance")));
        }
        catch (Exception e) {
            NeptusLog.pub().info((Object)("<###> " + I18n.text("Error while loading the XML:") + "{" + xml + "}"));
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    public SystemPositionAndAttitude ManeuverFunction(SystemPositionAndAttitude lastVehicleState) {
        SystemPositionAndAttitude nextVehicleState = lastVehicleState.clone();
        switch (this.current_state) {
            case -1: {
                double angleDiff;
                this.targetAngle = lastVehicleState.getPosition().getXYAngle(this.destination);
                for (angleDiff = this.targetAngle - lastVehicleState.getYaw(); angleDiff < 0.0; angleDiff += Math.PI * 2) {
                }
                while (angleDiff > Math.PI * 2) {
                    angleDiff -= Math.PI * 2;
                }
                if (angleDiff > Math.PI) {
                    angleDiff -= Math.PI * 2;
                }
                this.rotateIncrement = angleDiff / 3.0;
                this.count = 0;
                this.current_state = 0;
                nextVehicleState = this.ManeuverFunction(lastVehicleState);
                break;
            }
            case 0: {
                if (this.count++ < 3) {
                    nextVehicleState.rotateXY(this.rotateIncrement);
                    break;
                }
                nextVehicleState.setYaw(this.targetAngle);
                this.current_state = 1;
                break;
            }
            case 1: {
                double calculatedSpeed = 1.0;
                if (this.units.equals("m/s")) {
                    calculatedSpeed = this.speed;
                } else if (this.units.equals("RPM")) {
                    calculatedSpeed = this.speed / 500.0;
                }
                double dist = nextVehicleState.getPosition().getHorizontalDistanceInMeters(this.destination);
                if (dist <= calculatedSpeed) {
                    nextVehicleState.setPosition(this.destination);
                    this.endManeuver();
                    break;
                }
                nextVehicleState.moveForward(calculatedSpeed);
                double depthDiff = this.destination.getDepth() - nextVehicleState.getPosition().getDepth();
                double depthIncr = depthDiff / (dist / calculatedSpeed);
                double curDepth = nextVehicleState.getPosition().getDepth();
                nextVehicleState.getPosition().setDepth(curDepth + depthIncr);
                break;
            }
            default: {
                this.endManeuver();
            }
        }
        return nextVehicleState;
    }

    @Override
    public Object clone() {
        Goto clone = new Goto();
        super.clone(clone);
        clone.params = this.params;
        clone.setManeuverLocation(this.getManeuverLocation());
        clone.setRadiusTolerance(this.getRadiusTolerance());
        clone.setSpeedUnits(this.getUnits());
        clone.setSpeed(this.getSpeed());
        clone.setSpeedTolerance(this.getSpeedTolerance());
        return clone;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public double getRadiusTolerance() {
        return this.radiusTolerance;
    }

    public void setRadiusTolerance(double radiusTolerance) {
        this.radiusTolerance = radiusTolerance;
    }

    public String getUnits() {
        return this.units;
    }

    public void setSpeedUnits(String units) {
        this.units = units;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeedTolerance() {
        return this.speedTolerance;
    }

    public void setSpeedTolerance(double speedTolerance) {
        this.speedTolerance = speedTolerance;
    }

    @Override
    public void translate(double offsetNorth, double offsetEast, double offsetDown) {
        this.destination.translatePosition(offsetNorth, offsetEast, offsetDown);
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> properties = new Vector<DefaultProperty>();
        DefaultProperty units = PropertiesEditor.getPropertyInstance("Speed units", String.class, this.getUnits(), true);
        units.setDisplayName(I18n.text("Speed units"));
        units.setShortDescription(I18n.text("The speed units"));
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)units, (PropertyEditor)((Object)new SpeedUnitsEditor()));
        PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)units, (TableCellRenderer)((Object)new I18nCellRenderer()));
        DefaultProperty propertySpeed = PropertiesEditor.getPropertyInstance("Speed", Double.class, this.getSpeed(), true);
        propertySpeed.setDisplayName(I18n.text("Speed"));
        properties.add(propertySpeed);
        properties.add(units);
        return properties;
    }

    @Override
    public String getPropertiesDialogTitle() {
        return this.getId() + " parameters";
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        for (Property p : properties) {
            if (p.getName().equals("Speed units")) {
                this.setSpeedUnits((String)p.getValue());
                continue;
            }
            if (p.getName().equals("Speed tolerance")) {
                this.setSpeedTolerance((Double)p.getValue());
                continue;
            }
            if (p.getName().equals("Speed")) {
                this.setSpeed((Double)p.getValue());
                continue;
            }
            if (p.getName().equals("Radius tolerance")) {
                this.setRadiusTolerance((Double)p.getValue());
                continue;
            }
            NeptusLog.pub().debug((Object)("Property " + p.getName() + " ignored."));
        }
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return super.getPropertiesErrors(properties);
    }

    @Override
    public ManeuverLocation getManeuverLocation() {
        return this.destination.clone();
    }

    @Override
    public ManeuverLocation getStartLocation() {
        return this.destination.clone();
    }

    @Override
    public ManeuverLocation getEndLocation() {
        return this.destination.clone();
    }

    @Override
    public void setManeuverLocation(ManeuverLocation location) {
        this.destination = location.clone();
    }

    @Override
    public String getTooltipText() {
        NumberFormat nf = GuiUtils.getNeptusDecimalFormat(2);
        return super.getTooltipText() + "<hr>" + I18n.text("speed") + ": <b>" + nf.format(this.getSpeed()) + " " + I18n.text(this.getUnits()) + "</b>" + "<br>" + I18n.text(this.destination.getZUnits().toString()) + ": <b>" + nf.format(this.destination.getZ()) + " " + I18n.textc("m", "meters") + "</b>";
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        try {
            pt.lsts.imc.Goto msg = pt.lsts.imc.Goto.clone((IMCMessage)message);
            this.setMaxTime(msg.getTimeout());
            this.setSpeed(msg.getSpeed());
            switch (msg.getSpeedUnits()) {
                case METERS_PS: {
                    this.setSpeedUnits("m/s");
                    break;
                }
                case PERCENTAGE: {
                    this.setSpeedUnits("%");
                    break;
                }
                case RPM: {
                    this.setSpeedUnits("RPM");
                }
            }
            ManeuverLocation pos = new ManeuverLocation();
            pos.setLatitudeRads(msg.getLat());
            pos.setLongitudeRads(msg.getLon());
            pos.setZ(msg.getZ());
            pos.setZUnits(ManeuverLocation.Z_UNITS.valueOf(msg.getZUnits().toString()));
            this.setManeuverLocation(pos);
            this.roll = msg.getRoll();
            this.pitch = msg.getPitch();
            this.yaw = msg.getYaw();
            this.setCustomSettings(msg.getCustom());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public IMCMessage serializeToIMC() {
        pt.lsts.imc.Goto gotoManeuver = new pt.lsts.imc.Goto();
        gotoManeuver.setTimeout(this.getMaxTime());
        ManeuverLocation l = this.getManeuverLocation();
        l.convertToAbsoluteLatLonDepth();
        gotoManeuver.setLat(l.getLatitudeRads());
        gotoManeuver.setLon(l.getLongitudeRads());
        gotoManeuver.setZ(this.getManeuverLocation().getZ());
        gotoManeuver.setZUnits((short)this.getManeuverLocation().getZUnits().value());
        gotoManeuver.setSpeed(this.getSpeed());
        switch (this.getUnits()) {
            case "m/s": {
                gotoManeuver.setSpeedUnits(Goto.SPEED_UNITS.METERS_PS);
                break;
            }
            case "RPM": {
                gotoManeuver.setSpeedUnits(Goto.SPEED_UNITS.RPM);
                break;
            }
            case "%": {
                gotoManeuver.setSpeedUnits(Goto.SPEED_UNITS.PERCENTAGE);
                break;
            }
            default: {
                gotoManeuver.setSpeedUnits(Goto.SPEED_UNITS.RPM);
            }
        }
        gotoManeuver.setRoll(this.roll);
        gotoManeuver.setPitch(this.pitch);
        gotoManeuver.setYaw(this.yaw);
        gotoManeuver.setCustom(this.getCustomSettings());
        return gotoManeuver;
    }

    @Override
    public Collection<ManeuverLocation> getWaypoints() {
        return Collections.singleton(this.getStartLocation());
    }

    public static void main(String[] args) {
        Goto g = new Goto();
        PropertiesEditor.editProperties(g, true);
        PropertiesEditor.editProperties(g, true);
    }
}

