/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.editor.ComboEditor;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.messages.Bitmask;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.DefaultManeuver;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.util.NameNormalizer;

public class HeadingSpeedDepth
extends DefaultManeuver
implements IMCSerialization {
    double speed = 1000.0;
    double speedTolerance = 100.0;
    double depth = 1.5;
    double heading = -1.0;
    int duration = 10;
    String units = "RPM";
    boolean useHeading = true;
    boolean useSpeed = true;
    boolean useDepth = true;
    protected static final String DEFAULT_ROOT_ELEMENT = "HeadingSpeedDepth";
    private final int ANGLE_CALCULATION = -1;
    private final int FIRST_ROTATE = 0;
    private final int HORIZONTAL_MOVE = 1;
    int current_state = -1;
    private double targetAngle;
    private double rotateIncrement;
    private double startTime = -1.0;
    public String id = NameNormalizer.getRandomID();
    private int count = 0;

    @Override
    public String getType() {
        return DEFAULT_ROOT_ELEMENT;
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("kind", "automatic");
        if (!this.isUseHeading()) {
            root.addAttribute("useHeading", "false");
        }
        if (!this.isUseSpeed()) {
            root.addAttribute("useSpeed", "false");
        }
        if (!this.isUseDepth()) {
            root.addAttribute("useDepth", "false");
        }
        Element depth = root.addElement("depth");
        depth.setText(String.valueOf(this.getDepth()));
        Element duration = root.addElement("duration");
        duration.setText(String.valueOf(this.getDuration()));
        Element velocity = root.addElement("speed");
        velocity.addAttribute("tolerance", String.valueOf(this.getSpeedTolerance()));
        velocity.addAttribute("type", "float");
        velocity.addAttribute("unit", this.getUnits());
        velocity.setText(String.valueOf(this.getSpeed()));
        Element heading = root.addElement("heading");
        heading.setText(String.valueOf(this.getHeading()));
        return document;
    }

    @Override
    public void loadFromXML(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Node rootMnv = doc.selectSingleNode(DEFAULT_ROOT_ELEMENT);
            boolean speedFound = true;
            if (rootMnv == null) {
                doc.selectSingleNode("HeadingVelocityDepth");
                speedFound = false;
            } else {
                speedFound = true;
            }
            this.setDepth(Double.parseDouble(rootMnv.selectSingleNode("depth").getText()));
            this.setHeading(Double.parseDouble(rootMnv.selectSingleNode("heading").getText()));
            Node speedNode = speedFound ? rootMnv.selectSingleNode("speed") : rootMnv.selectSingleNode("velocity");
            Node durNode = rootMnv.selectSingleNode("duration");
            if (durNode != null) {
                this.setDuration(Integer.parseInt(durNode.getText()));
            }
            this.setSpeed(Double.parseDouble(speedNode.getText()));
            this.setUnits(speedNode.valueOf("@unit"));
            this.setSpeedTolerance(Double.parseDouble(speedNode.valueOf("@tolerance")));
            Node flagNode = rootMnv.selectSingleNode("@useHeading");
            if (flagNode != null) {
                this.setUseHeading(Boolean.parseBoolean(flagNode.getText()));
            } else {
                this.setUseHeading(true);
            }
            Node node = flagNode = speedFound ? rootMnv.selectSingleNode("@useSpeed") : rootMnv.selectSingleNode("@useVelocity");
            if (flagNode != null) {
                this.setUseSpeed(Boolean.parseBoolean(flagNode.getText()));
            } else {
                this.setUseSpeed(true);
            }
            flagNode = rootMnv.selectSingleNode("@useDepth");
            if (flagNode != null) {
                this.setUseDepth(Boolean.parseBoolean(flagNode.getText()));
            } else {
                this.setUseDepth(true);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    public SystemPositionAndAttitude ManeuverFunction(SystemPositionAndAttitude lastVehicleState) {
        SystemPositionAndAttitude nextVehicleState = lastVehicleState.clone();
        switch (this.current_state) {
            case -1: {
                double angleDiff;
                if (this.getHeading() < 0.0) {
                    this.count = 0;
                    this.current_state = 1;
                    nextVehicleState = this.ManeuverFunction(lastVehicleState);
                    break;
                }
                this.targetAngle = Math.toRadians(this.getHeading());
                for (angleDiff = this.targetAngle - lastVehicleState.getYaw(); angleDiff < 0.0; angleDiff += Math.PI * 2) {
                }
                while (angleDiff > Math.PI * 2) {
                    angleDiff -= Math.PI * 2;
                }
                if (angleDiff > Math.PI) {
                    angleDiff -= Math.PI * 2;
                }
                this.rotateIncrement = angleDiff / 3.0;
                this.count = 0;
                this.current_state = 0;
                this.startTime = (double)System.currentTimeMillis() / 1000.0;
                nextVehicleState = this.ManeuverFunction(lastVehicleState);
                break;
            }
            case 0: {
                if (this.count++ < 3) {
                    nextVehicleState.rotateXY(this.rotateIncrement);
                    break;
                }
                nextVehicleState.setYaw(this.targetAngle);
                this.current_state = 1;
                break;
            }
            case 1: {
                double calculatedVelocity = 1.0;
                if (this.units.equals("m/s")) {
                    calculatedVelocity = this.speed;
                } else if (this.units.equals("RPM")) {
                    calculatedVelocity = this.speed / 500.0;
                }
                double deltaTime = (double)System.currentTimeMillis() / 1000.0 - this.startTime;
                if (deltaTime >= (double)this.getDuration()) {
                    nextVehicleState.setPosition(lastVehicleState.getPosition());
                    this.endManeuver();
                    break;
                }
                nextVehicleState.moveForward(calculatedVelocity);
                double depthDiff = this.getDepth() - nextVehicleState.getPosition().getDepth();
                double depthIncr = Math.min(depthDiff, calculatedVelocity);
                double curDepth = nextVehicleState.getPosition().getDepth();
                nextVehicleState.getPosition().setDepth(curDepth + depthIncr);
                break;
            }
            default: {
                this.endManeuver();
            }
        }
        return nextVehicleState;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public boolean isUseHeading() {
        return this.useHeading;
    }

    public void setUseHeading(boolean useHeading) {
        this.useHeading = useHeading;
    }

    public boolean isUseSpeed() {
        return this.useSpeed;
    }

    public void setUseSpeed(boolean useSpeed) {
        this.useSpeed = useSpeed;
    }

    public boolean isUseDepth() {
        return this.useDepth;
    }

    public void setUseDepth(boolean useDepth) {
        this.useDepth = useDepth;
    }

    public double getDepth() {
        return this.depth;
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeedTolerance() {
        return this.speedTolerance;
    }

    public void setSpeedTolerance(double speedTolerance) {
        this.speedTolerance = speedTolerance;
    }

    public double getHeading() {
        return this.heading;
    }

    public void setHeading(double heading) {
        this.heading = heading;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public Object clone() {
        HeadingSpeedDepth clone = new HeadingSpeedDepth();
        super.clone(clone);
        clone.setDepth(this.getDepth());
        clone.setDuration(this.getDuration());
        clone.setHeading(this.getHeading());
        clone.setUnits(this.getUnits());
        clone.setSpeed(this.getSpeed());
        clone.setSpeedTolerance(this.getSpeedTolerance());
        clone.setUseHeading(this.isUseHeading());
        clone.setUseSpeed(this.isUseSpeed());
        clone.setUseDepth(this.isUseDepth());
        return clone;
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> properties = new Vector<DefaultProperty>();
        DefaultProperty units = PropertiesEditor.getPropertyInstance("Speed units", String.class, this.getUnits(), true);
        units.setShortDescription(I18n.text("The speed units"));
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)units, new ComboEditor<String>(new String[]{"RPM", "m/s", "%"}));
        properties.add(PropertiesEditor.getPropertyInstance("Use Speed", Boolean.class, this.isUseHeading(), true));
        properties.add(PropertiesEditor.getPropertyInstance("Speed", Double.class, this.getSpeed(), true));
        properties.add(units);
        properties.add(PropertiesEditor.getPropertyInstance("Speed tolerance", Double.class, this.getSpeedTolerance(), true));
        properties.add(PropertiesEditor.getPropertyInstance("Use Depth", Boolean.class, this.isUseDepth(), true));
        properties.add(PropertiesEditor.getPropertyInstance("Depth", Double.class, this.getDepth(), true));
        DefaultProperty heading = PropertiesEditor.getPropertyInstance("Heading (degrees)", Double.class, this.getHeading(), true);
        properties.add(PropertiesEditor.getPropertyInstance("Use Heading", Boolean.class, this.isUseHeading(), true));
        properties.add(heading);
        properties.add(PropertiesEditor.getPropertyInstance("Duration", "", Integer.class, this.getDuration(), true, I18n.text("Use 0 for infinity")));
        return properties;
    }

    @Override
    public String getPropertiesDialogTitle() {
        return this.getId() + " parameters";
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        for (Property p : properties) {
            if (p.getName().equals("Use Speed")) {
                this.setUseSpeed((Boolean)p.getValue());
            }
            if (p.getName().equals("Speed units")) {
                this.setUnits((String)p.getValue());
            }
            if (p.getName().equals("Speed tolerance")) {
                this.setSpeedTolerance((Double)p.getValue());
            }
            if (p.getName().equals("Speed")) {
                this.setSpeed((Double)p.getValue());
            }
            if (p.getName().equals("Use Depth")) {
                this.setUseDepth((Boolean)p.getValue());
            }
            if (p.getName().equals("Depth")) {
                this.setDepth((Double)p.getValue());
            }
            if (p.getName().equals("Use Heading")) {
                this.setUseHeading((Boolean)p.getValue());
            }
            if (p.getName().equals("Heading (degrees)")) {
                this.setHeading((Double)p.getValue());
            }
            if (!p.getName().equals("Duration")) continue;
            this.setDuration((Integer)p.getValue());
        }
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return super.getPropertiesErrors(properties);
    }

    @Override
    public String getTooltipText() {
        return super.getTooltipText() + "<hr>" + "heading: <b>" + (int)this.getHeading() + " \u00b0</b>" + "<br>speed: <b>" + this.getSpeed() + " " + this.getUnits() + "</b>" + "<br>depth: <b>" + (int)this.getDepth() + " m</b>" + "<br>duration: <b>" + this.getDuration() + " s</b>" + "<br>using: <b>" + (this.isUseHeading() ? " heading" : "") + (this.isUseSpeed() ? " speed" : "") + (this.isUseDepth() ? " depth" : "") + "</b>";
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        this.setMaxTime((int)message.getDouble("timeout"));
        this.setDepth(message.getDouble("z"));
        this.setSpeed(message.getDouble("speed"));
        this.setHeading(message.getDouble("heading"));
        this.setDuration((int)message.getDouble("duration"));
        String speed_units = message.getString("speed_units");
        if (speed_units.equals("METERS_PS")) {
            this.setUnits("m/s");
        } else if (speed_units.equals("RPM")) {
            this.setUnits("RPM");
        } else {
            this.setUnits("%");
        }
        LinkedHashMap indValue = message.getBitmask("ind");
        if (((Boolean)indValue.get("HEADING")).booleanValue()) {
            this.setUseHeading(true);
        } else {
            this.setUseHeading(false);
        }
        if (((Boolean)indValue.get("Z")).booleanValue()) {
            this.setUseDepth(true);
        } else {
            this.setUseDepth(false);
        }
        if (((Boolean)indValue.get("SPEED")).booleanValue()) {
            this.setUseSpeed(true);
        } else {
            this.setUseSpeed(false);
        }
    }

    @Override
    public IMCMessage serializeToIMC() {
        IMCMessage msgManeuver = IMCDefinition.getInstance().create("LowLevelControl", new Object[0]);
        msgManeuver.setValue("duration", (Object)this.getDuration());
        msgManeuver.setValue("z", (Object)this.getDepth());
        msgManeuver.setValue("velocity", (Object)this.getSpeed());
        msgManeuver.setValue("speed", (Object)this.getSpeed());
        String enumerated = "";
        String speedU = this.getUnits();
        try {
            if ("m/s".equalsIgnoreCase(speedU)) {
                enumerated = "METERS_PS";
            } else if ("RPM".equalsIgnoreCase(speedU)) {
                enumerated = "RPM";
            } else if ("%".equalsIgnoreCase(speedU)) {
                enumerated = "PERCENTAGE";
            } else if ("percentage".equalsIgnoreCase(speedU)) {
                enumerated = "PERCENTAGE";
            }
        }
        catch (Exception ex) {
            NeptusLog.pub().error((Object)this, (Throwable)ex);
        }
        msgManeuver.setValue("speed_units", (Object)enumerated);
        msgManeuver.setValue("heading", (Object)Math.toRadians(this.getHeading()));
        LinkedHashMap<String, String> tl = new LinkedHashMap<String, String>();
        for (String key : this.getCustomSettings().keySet()) {
            tl.put(key, this.getCustomSettings().get(key));
        }
        msgManeuver.setValue("custom", (Object)IMCMessage.encodeTupleList(tl));
        long currentValue = 7L;
        LinkedHashMap<Long, String> possibleValues = new LinkedHashMap<Long, String>();
        possibleValues.put(1L, "HEADING");
        possibleValues.put(2L, "Z");
        possibleValues.put(4L, "SPEED");
        Bitmask bm = new Bitmask(possibleValues, currentValue);
        bm.setBit("HEADING", this.isUseHeading());
        bm.setBit("Z", this.isUseDepth());
        bm.setBit("SPEED", this.isUseSpeed());
        msgManeuver.setValue("ind", (Object)bm);
        return msgManeuver;
    }
}

