/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Loiter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.editor.AngleEditorRads;
import pt.lsts.neptus.gui.editor.ComboEditor;
import pt.lsts.neptus.gui.editor.SpeedUnitsEditor;
import pt.lsts.neptus.gui.editor.renderer.I18nCellRenderer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.maneuvers.StatisticsProvider;
import pt.lsts.neptus.renderer2d.LoiterPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.PlanElement;

public class Loiter
extends Maneuver
implements LocatedManeuver,
StatisticsProvider,
IMCSerialization {
    public static final int INFINITY_DURATION = -1;
    private int loiterDuration = 60;
    private double radius = 15.0;
    private double radiusTolerance = 5.0;
    private double length = 1.0;
    private double bearing = 0.0;
    private double speed = 30.0;
    private double speedTolerance = 5.0;
    private String direction = "Clockwise";
    private String loiterType = "Circular";
    private String speedUnits = "m/s";
    private ManeuverLocation location = new ManeuverLocation();
    protected static final LinkedHashMap<Long, String> wpLoiterTypeConstantsMap = new LinkedHashMap();
    protected static final LinkedHashMap<Long, String> loiterDirectionConstantsMap = new LinkedHashMap();
    private static LoiterPainter painter;

    @Override
    public Object clone() {
        Loiter l = new Loiter();
        super.clone(l);
        l.setBearing(this.getBearing());
        l.setDirection(this.getDirection());
        l.setLength(this.getLength());
        l.setLoiterDuration(this.getLoiterDuration());
        l.setLoiterType(this.getLoiterType());
        l.setManeuverLocation(this.getManeuverLocation());
        l.setRadius(this.getRadius());
        l.setRadiusTolerance(this.getRadiusTolerance());
        l.setSpeed(this.getSpeed());
        l.setSpeedTolerance(this.getSpeedTolerance());
        l.setSpeedUnits(this.getSpeedUnits());
        return l;
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("kind", "automatic");
        Element basePoint = root.addElement("basePoint");
        Element point = this.getManeuverLocation().asElement("point");
        basePoint.add(point);
        Element radTolerance = basePoint.addElement("radiusTolerance");
        radTolerance.setText(String.valueOf(this.getRadiusTolerance()));
        basePoint.addAttribute("type", "pointType");
        root.addElement("duration").setText("" + this.getLoiterDuration());
        Element trajectory = root.addElement("trajectory");
        Element trajRadius = trajectory.addElement("radius");
        trajRadius.setText(String.valueOf(this.getRadius()));
        trajRadius.addAttribute("type", "float");
        Element trajRadiusTolerance = trajectory.addElement("radiusTolerance");
        trajRadiusTolerance.setText(String.valueOf(this.getRadiusTolerance()));
        trajRadiusTolerance.addAttribute("type", "float");
        trajectory.addElement("type").setText(this.getLoiterType());
        Element trajLength = trajectory.addElement("length");
        trajLength.setText(String.valueOf(this.getLength()));
        trajLength.addAttribute("type", "float");
        Element trajBearing = trajectory.addElement("bearing");
        trajBearing.setText(String.valueOf(this.getBearing()));
        trajBearing.addAttribute("type", "float");
        trajectory.addElement("direction").setText(this.getDirection());
        Element velocity = root.addElement("speed");
        velocity.addAttribute("tolerance", String.valueOf(this.getSpeedTolerance()));
        velocity.addAttribute("type", "float");
        velocity.addAttribute("unit", this.getSpeedUnits());
        velocity.setText(String.valueOf(this.getSpeed()));
        return document;
    }

    @Override
    public String getType() {
        return "Loiter";
    }

    @Override
    public void loadFromXML(String XML) {
        try {
            Document doc = DocumentHelper.parseText((String)XML);
            Node node = doc.selectSingleNode("Loiter/basePoint/point");
            ManeuverLocation loc = new ManeuverLocation();
            loc.load(node.asXML());
            this.setManeuverLocation(loc);
            this.setRadiusTolerance(Double.parseDouble(doc.selectSingleNode("Loiter/basePoint/radiusTolerance").getText()));
            Node speedNode = doc.selectSingleNode("Loiter/speed");
            if (speedNode == null) {
                speedNode = doc.selectSingleNode("Loiter/velocity");
            }
            this.setSpeed(Double.parseDouble(speedNode.getText()));
            this.setSpeedUnits(speedNode.valueOf("@unit"));
            this.setSpeedTolerance(Double.parseDouble(speedNode.valueOf("@tolerance")));
            this.setLoiterDuration(Integer.parseInt(doc.selectSingleNode("Loiter/duration").getText()));
            this.setRadius(Double.parseDouble(doc.selectSingleNode("Loiter/trajectory/radius").getText()));
            this.setRadiusTolerance(Double.parseDouble(doc.selectSingleNode("Loiter/trajectory/radiusTolerance").getText()));
            this.setLoiterType(doc.selectSingleNode("Loiter/trajectory/type").getText());
            this.setDirection(doc.selectSingleNode("Loiter/trajectory/direction").getText());
            this.setBearing(Double.parseDouble(doc.selectSingleNode("Loiter/trajectory/bearing").getText()));
            if (doc.selectSingleNode("Loiter/trajectory/length") != null) {
                this.setLength(Double.parseDouble(doc.selectSingleNode("Loiter/trajectory/length").getText()));
            }
            if (doc.selectSingleNode("Loiter/trajectory/lenght") != null) {
                this.setLength(Double.parseDouble(doc.selectSingleNode("Loiter/trajectory/lenght").getText()));
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    @Override
    public ManeuverLocation getManeuverLocation() {
        return this.location.clone();
    }

    @Override
    public ManeuverLocation getStartLocation() {
        return this.location.clone();
    }

    @Override
    public ManeuverLocation getEndLocation() {
        return this.location.clone();
    }

    @Override
    public void setManeuverLocation(ManeuverLocation location) {
        this.location = location.clone();
    }

    @Override
    public void translate(double offsetNorth, double offsetEast, double offsetDown) {
        this.location.translatePosition(offsetNorth, offsetEast, offsetDown);
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> props = new Vector<DefaultProperty>();
        DefaultProperty duration = PropertiesEditor.getPropertyInstance("Duration", Integer.class, this.loiterDuration, true);
        duration.setShortDescription("The Loiter's duration, in seconds (0 means +Infinity)");
        props.add(duration);
        DefaultProperty direction = PropertiesEditor.getPropertyInstance("Direction", String.class, this.direction, true);
        direction.setShortDescription("The direction the vehicle should take when performing this maneuver");
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)direction, new ComboEditor<String>(loiterDirectionConstantsMap.values().toArray(new String[0])));
        PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)direction, (TableCellRenderer)((Object)new I18nCellRenderer()));
        props.add(direction);
        DefaultProperty type = PropertiesEditor.getPropertyInstance("Loiter Type", String.class, this.loiterType, true);
        type.setShortDescription("How to perform this maneuver. Note that some parameters only make sense in some Loiter types.");
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)type, new ComboEditor<String>(wpLoiterTypeConstantsMap.values().toArray(new String[0])));
        PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)type, (TableCellRenderer)((Object)new I18nCellRenderer()));
        props.add(type);
        DefaultProperty speed = PropertiesEditor.getPropertyInstance("Speed", Double.class, this.speed, true);
        speed.setShortDescription("The vehicle's desired speed when loitering");
        props.add(speed);
        DefaultProperty speedUnits = PropertiesEditor.getPropertyInstance("Speed Units", String.class, this.speedUnits, true);
        speedUnits.setShortDescription("The units to consider in the speed parameters");
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)speedUnits, (PropertyEditor)((Object)new SpeedUnitsEditor()));
        PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)speedUnits, (TableCellRenderer)((Object)new I18nCellRenderer()));
        props.add(speedUnits);
        DefaultProperty radius = PropertiesEditor.getPropertyInstance("Radius", Double.class, this.radius, true);
        radius.setShortDescription("If its not a hover loiter, sets the radius of the trajectory");
        props.add(radius);
        DefaultProperty length = PropertiesEditor.getPropertyInstance("Length", Double.class, this.length, true);
        length.setShortDescription("If its a 'racetrack' or 'figure8' loiter, sets the distance between the focuses");
        props.add(length);
        DefaultProperty bearing = PropertiesEditor.getPropertyInstance("Bearing", Double.class, this.bearing, true);
        bearing.setShortDescription("The angle to bear when loitering. 0 = Absolute North");
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)bearing, AngleEditorRads.class);
        props.add(bearing);
        return props;
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        for (Property p : properties) {
            if (p.getName().equals("Duration")) {
                this.setLoiterDuration((Integer)p.getValue());
                continue;
            }
            if (p.getName().equals("Direction")) {
                this.setDirection((String)p.getValue());
                continue;
            }
            if (p.getName().equals("Loiter Type")) {
                this.setLoiterType((String)p.getValue());
                continue;
            }
            if (p.getName().equals("Speed")) {
                this.setSpeed((Double)p.getValue());
                continue;
            }
            if (p.getName().equalsIgnoreCase("Speed Tolerance")) {
                this.setSpeedTolerance((Double)p.getValue());
                continue;
            }
            if (p.getName().equalsIgnoreCase("Speed Units")) {
                this.setSpeedUnits((String)p.getValue());
                continue;
            }
            if (p.getName().equals("Radius")) {
                this.setRadius((Double)p.getValue());
                continue;
            }
            if (p.getName().equalsIgnoreCase("Radius Tolerance")) {
                this.setRadiusTolerance((Double)p.getValue());
                continue;
            }
            if (p.getName().equals("Length")) {
                this.setLength((Double)p.getValue());
                continue;
            }
            if (!p.getName().equals("Bearing")) continue;
            this.setBearing((Double)p.getValue());
        }
    }

    @Override
    public String getTooltipText() {
        return super.getTooltipText() + "<hr>" + I18n.text("loiter type") + ": <b>" + I18n.text(this.loiterType) + "</b>" + "<br>" + I18n.text(this.location.getZUnits().toString()) + ": <b>" + this.location.getZ() + " " + I18n.textc("m", "meters") + "</b>" + "<br>" + I18n.text("speed") + ": <b>" + (int)this.speed + " " + I18n.text(this.speedUnits) + "</b>" + "<br>" + I18n.text("radius") + ": <b>" + this.radius + " " + I18n.textc("m", "meters") + "</b>" + "<br>" + I18n.text("length") + ": <b>" + this.length + " " + I18n.textc("m", "meters") + "</b>" + "<br>" + I18n.text("direction") + ": <b>" + I18n.text(this.direction) + "</b>" + "<br>" + I18n.text("duration") + ": <b>" + this.loiterDuration + " " + I18n.textc("s", "seconds") + "</b><br>";
    }

    public double getBearing() {
        return this.bearing;
    }

    public void setBearing(double bearing) {
        this.bearing = bearing;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public LocationType getLocation() {
        return this.location;
    }

    public int getLoiterDuration() {
        return this.loiterDuration;
    }

    public void setLoiterDuration(int loiterDuration) {
        this.loiterDuration = loiterDuration;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getRadiusTolerance() {
        return this.radiusTolerance;
    }

    public void setRadiusTolerance(double radiusTolerance) {
        this.radiusTolerance = radiusTolerance;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeedTolerance() {
        return this.speedTolerance;
    }

    public void setSpeedTolerance(double speedTolerance) {
        this.speedTolerance = speedTolerance;
    }

    public String getSpeedUnits() {
        return this.speedUnits;
    }

    public void setSpeedUnits(String speedUnits) {
        this.speedUnits = speedUnits;
    }

    public void setLoiterType(String loiterType) {
        this.loiterType = loiterType;
    }

    public String getLoiterType() {
        return this.loiterType;
    }

    protected double getVelocityInMetersPerSeconds() {
        if (this.speedUnits.equals("m/s")) {
            return this.speed;
        }
        if (this.speedUnits.equalsIgnoreCase("Km/h")) {
            return this.speed * 0.2777777777777778;
        }
        if (this.speedUnits.equalsIgnoreCase("MPH")) {
            return this.speed * 0.4471;
        }
        return 0.0;
    }

    @Override
    public void paintOnMap(Graphics2D g2d, PlanElement planElement, StateRenderer2D renderer) {
        super.paintOnMap(g2d, planElement, renderer);
        AffineTransform at = g2d.getTransform();
        painter.setLoiterManeuver(this);
        painter.paint(g2d, renderer);
        g2d.setTransform(at);
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        this.setMaxTime((int)message.getDouble("timeout"));
        this.setSpeed(message.getDouble("speed"));
        this.setLoiterDuration(message.getInteger("duration"));
        this.setRadiusTolerance(Double.isNaN(message.getDouble("radius_tolerance")) ? 2.0 : message.getDouble("radius_tolerance"));
        ManeuverLocation pos = new ManeuverLocation();
        pos.setLatitudeRads(message.getDouble("lat"));
        pos.setLongitudeRads(message.getDouble("lon"));
        pos.setZ(message.getDouble("z"));
        String zunits = message.getString("z_units");
        if (zunits != null) {
            pos.setZUnits(ManeuverLocation.Z_UNITS.valueOf(zunits));
        }
        this.setManeuverLocation(pos);
        String speed_units = message.getString("speed_units");
        if (speed_units.equals("METERS_PS")) {
            this.setSpeedUnits("m/s");
        } else if (speed_units.equals("RPM")) {
            this.setSpeedUnits("RPM");
        } else {
            this.setSpeedUnits("%");
        }
        this.setBearing(message.getDouble("bearing"));
        this.setLoiterDuration((int)message.getDouble("duration"));
        this.setLength(message.getDouble("length"));
        this.setRadius(message.getDouble("radius"));
        String type = message.getString("type");
        if (type.equals("EIGHT")) {
            this.setLoiterType("Figure 8");
        } else {
            this.setLoiterType(type.substring(0, 1).toUpperCase() + type.substring(1).toLowerCase());
        }
        String direction = message.getString("direction");
        if (direction.equals("VDEP")) {
            this.setDirection("Vehicle Dependent");
        } else if (direction.equals("CLOCKW")) {
            this.setDirection("Clockwise");
        } else if (direction.equals("CCLOCKW")) {
            this.setDirection("Counter Clockwise");
        } else if (direction.equals("IWINDCURR")) {
            this.setDirection("Into the wind");
        }
        this.setCustomSettings(message.getTupleList("custom"));
    }

    @Override
    public IMCMessage serializeToIMC() {
        pt.lsts.imc.Loiter loiter = new pt.lsts.imc.Loiter();
        loiter.setTimeout(this.getMaxTime());
        ManeuverLocation loc = this.getManeuverLocation();
        loc.convertToAbsoluteLatLonDepth();
        loiter.setLat(loc.getLatitudeRads());
        loiter.setLon(loc.getLongitudeRads());
        loiter.setZ(this.getManeuverLocation().getZ());
        loiter.setZUnits((short)this.getManeuverLocation().getZUnits().value());
        loiter.setSpeed(this.getSpeed());
        loiter.setDuration(this.getLoiterDuration());
        switch (this.getSpeedUnits()) {
            case "m/s": {
                loiter.setSpeedUnits(Loiter.SPEED_UNITS.METERS_PS);
                break;
            }
            case "RPM": {
                loiter.setSpeedUnits(Loiter.SPEED_UNITS.RPM);
                break;
            }
            case "PERCENTAGE": {
                loiter.setSpeedUnits(Loiter.SPEED_UNITS.PERCENTAGE);
                break;
            }
        }
        String loiterType = this.getLoiterType();
        try {
            if ("Default".equalsIgnoreCase(loiterType)) {
                loiter.setType(Loiter.TYPE.DEFAULT);
            } else if ("Circular".equalsIgnoreCase(loiterType)) {
                loiter.setType(Loiter.TYPE.CIRCULAR);
            } else if ("Racetrack".equalsIgnoreCase(loiterType)) {
                loiter.setType(Loiter.TYPE.RACETRACK);
            } else if ("Figure 8".equalsIgnoreCase(loiterType)) {
                loiter.setType(Loiter.TYPE.EIGHT);
            } else if ("Hover".equalsIgnoreCase(loiterType)) {
                loiter.setType(Loiter.TYPE.HOVER);
            }
        }
        catch (Exception ex) {
            NeptusLog.pub().error((Object)this, (Throwable)ex);
        }
        loiter.setRadius(this.getRadius());
        loiter.setLength(this.getLength());
        loiter.setBearing(this.getBearing());
        String lDirection = this.getDirection();
        try {
            if ("Vehicle Dependent".equalsIgnoreCase(lDirection)) {
                loiter.setDirection(Loiter.DIRECTION.VDEP);
            } else if ("Clockwise".equalsIgnoreCase(lDirection)) {
                loiter.setDirection(Loiter.DIRECTION.CLOCKW);
            } else if ("Counter Clockwise".equalsIgnoreCase(lDirection)) {
                loiter.setDirection(Loiter.DIRECTION.CCLOCKW);
            } else if ("Counter-Clockwise".equalsIgnoreCase(lDirection)) {
                loiter.setDirection(Loiter.DIRECTION.CCLOCKW);
            } else if (lDirection.startsWith("Into the wind")) {
                loiter.setDirection(Loiter.DIRECTION.IWINDCURR);
            }
        }
        catch (Exception ex) {
            NeptusLog.pub().error((Object)this, (Throwable)ex);
        }
        loiter.setCustom(this.getCustomSettings());
        return loiter;
    }

    @Override
    public double getCompletionTime(LocationType initialPosition) {
        double speed = this.speed;
        if (this.speedUnits.equalsIgnoreCase("RPM")) {
            speed /= 769.230769231;
        } else if (this.speedUnits.equalsIgnoreCase("%")) {
            speed /= 76.923076923;
        }
        double time = this.getDistanceTravelled(initialPosition) / speed;
        return (double)this.getLoiterDuration() + time;
    }

    @Override
    public double getDistanceTravelled(LocationType initialPosition) {
        double meters = this.getStartLocation().getDistanceInMeters(initialPosition);
        return meters;
    }

    @Override
    public double getMaxDepth() {
        return this.getManeuverLocation().getAllZ();
    }

    @Override
    public double getMinDepth() {
        return this.getManeuverLocation().getAllZ();
    }

    @Override
    public Collection<ManeuverLocation> getWaypoints() {
        return Collections.singleton(this.getStartLocation());
    }

    static {
        wpLoiterTypeConstantsMap.put(1L, I18n.textmark("Circular"));
        wpLoiterTypeConstantsMap.put(2L, I18n.textmark("Racetrack"));
        wpLoiterTypeConstantsMap.put(3L, I18n.textmark("Figure 8"));
        loiterDirectionConstantsMap.put(0L, I18n.textmark("Vehicle Dependent"));
        loiterDirectionConstantsMap.put(1L, I18n.textmark("Clockwise"));
        loiterDirectionConstantsMap.put(2L, I18n.textmark("Counter-Clockwise"));
        loiterDirectionConstantsMap.put(3L, I18n.textmark("Into the Wind"));
        painter = new LoiterPainter();
    }
}

