/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Arrays;
import java.util.Vector;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.preview.SpeedConversion;
import pt.lsts.neptus.plugins.PluginProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.AngleCalc;

public class ManeuversUtil {
    protected static final int X = 0;
    protected static final int Y = 1;
    protected static final int Z = 2;
    protected static final int T = 3;

    private ManeuversUtil() {
    }

    public static Vector<double[]> calcRIPatternPoints(double width, double hstep, double alternationPercent, double curvOff, boolean squareCurve, double bearingRad) {
        Vector<double[]> newPoints = new Vector<double[]>();
        double length = width;
        double[] pointBaseB = new double[]{-length / 2.0, -width / 2.0, 0.0, -1.0};
        double[] res = AngleCalc.rotate(bearingRad, pointBaseB[0], pointBaseB[1], false);
        double[] pointBase1 = new double[]{res[0], res[1], 0.0, -1.0};
        res = AngleCalc.rotate(bearingRad + Math.toRadians(-60.0), pointBaseB[0], pointBaseB[1], false);
        double[] pointBase2 = new double[]{res[0], res[1], 0.0, -1.0};
        res = AngleCalc.rotate(bearingRad + Math.toRadians(-120.0), pointBaseB[0], pointBaseB[1], false);
        double[] pointBase3 = new double[]{res[0], res[1], 0.0, -1.0};
        Vector<double[]> points1 = ManeuversUtil.calcRowsPoints(width, width, hstep, 2.0 - alternationPercent, curvOff, squareCurve, bearingRad, 0.0);
        for (double[] pt : points1) {
            pt[0] = pt[0] + pointBase1[0];
            pt[1] = pt[1] + pointBase1[1];
        }
        Vector<double[]> points2 = ManeuversUtil.calcRowsPoints(width, width, hstep, 2.0 - alternationPercent, curvOff, squareCurve, bearingRad + Math.toRadians(-60.0), 0.0);
        for (double[] pt : points2) {
            pt[0] = pt[0] + pointBase2[0];
            pt[1] = pt[1] + pointBase2[1];
        }
        Vector<double[]> points3 = ManeuversUtil.calcRowsPoints(width, width, hstep, 2.0 - alternationPercent, curvOff, squareCurve, bearingRad + Math.toRadians(-120.0), 0.0);
        for (double[] pt : points3) {
            pt[0] = pt[0] + pointBase3[0];
            pt[1] = pt[1] + pointBase3[1];
        }
        newPoints.addAll(points1);
        newPoints.addAll(points2);
        newPoints.addAll(points3);
        return newPoints;
    }

    public static Vector<double[]> calcCrossHatchPatternPoints(double width, double hstep, double curvOff, boolean squareCurve, double bearingRad) {
        Vector<double[]> newPoints = new Vector<double[]>();
        double length = width;
        double[] pointBase1 = new double[]{-length / 2.0, -width / 2.0, 0.0, -1.0};
        double[] pointBase2 = new double[]{-length / 2.0, width / 2.0, 0.0, -1.0};
        double[] res = AngleCalc.rotate(bearingRad, pointBase1[0], pointBase1[1], false);
        pointBase1 = new double[]{res[0], res[1], 0.0, -1.0};
        res = AngleCalc.rotate(bearingRad, pointBase2[0], pointBase2[1], false);
        pointBase2 = new double[]{res[0], res[1], 0.0, -1.0};
        Vector<double[]> points1 = ManeuversUtil.calcRowsPoints(width, width, hstep, 1.0, curvOff, squareCurve, bearingRad, 0.0);
        for (double[] pt : points1) {
            pt[0] = pt[0] + pointBase1[0];
            pt[1] = pt[1] + pointBase1[1];
        }
        Vector<double[]> points2 = ManeuversUtil.calcRowsPoints(width, width, hstep, 1.0, curvOff, squareCurve, bearingRad + Math.toRadians(-90.0), 0.0);
        for (double[] pt : points2) {
            pt[0] = pt[0] + pointBase2[0];
            pt[1] = pt[1] + pointBase2[1];
        }
        newPoints.addAll(points1);
        newPoints.addAll(points2);
        return newPoints;
    }

    public static Vector<double[]> calcRowsPoints(double width, double length, double hstep, double alternationPercent, double curvOff, boolean squareCurve, double bearingRad, double crossAngleRadians) {
        return ManeuversUtil.calcRowsPoints(width, length, hstep, alternationPercent, curvOff, squareCurve, bearingRad, crossAngleRadians, false);
    }

    public static Vector<double[]> calcRowsPoints(double width, double length, double hstep, double alternationPercent, double curvOff, boolean squareCurve, double bearingRad, double crossAngleRadians, boolean invertY) {
        width = Math.abs(width);
        length = Math.abs(length);
        hstep = Math.abs(hstep);
        boolean direction = true;
        Vector<double[]> newPoints = new Vector<double[]>();
        double[] point = new double[]{-curvOff, 0.0, 0.0, -1.0};
        newPoints.add(point);
        for (double y = 0.0; y <= width; y += hstep) {
            double x2 = direction ? length + curvOff : -curvOff;
            direction = !direction;
            double hstepDelta = 0.0;
            if (direction) {
                hstepDelta = hstep * (1.0 - alternationPercent);
            }
            point = new double[]{x2, y - hstepDelta, 0.0, -1.0};
            newPoints.add(point);
            if (!(y + hstep <= width)) continue;
            double hstepAlt = hstep;
            if (!direction) {
                hstepAlt = hstep * alternationPercent;
            }
            point = new double[]{x2 + (double)(!squareCurve ? 1 : 0) * (direction ? curvOff : -curvOff), y + hstepAlt, 0.0, -1.0};
            newPoints.add(point);
        }
        for (double[] pt : newPoints) {
            double[] res = AngleCalc.rotate(-crossAngleRadians, pt[0], 0.0, false);
            pt[0] = res[0];
            pt[1] = pt[1] + res[1];
            if (invertY) {
                pt[1] = -pt[1];
            }
            res = AngleCalc.rotate(bearingRad + (double)(!invertY ? -1 : 1) * -crossAngleRadians, pt[0], pt[1], false);
            pt[0] = res[0];
            pt[1] = res[1];
        }
        return newPoints;
    }

    public static void paintPointLineList(Graphics2D g2d, double zoom, Vector<double[]> points, boolean paintSSRange, double sRange) {
        ManeuversUtil.paintPointLineList(g2d, zoom, points, paintSSRange, sRange, false);
    }

    public static void paintPointLineList(Graphics2D g2d, double zoom, Vector<double[]> points, boolean paintSSRange, double sRange, boolean editMode) {
        Color oColor = g2d.getColor();
        Stroke sO = g2d.getStroke();
        BasicStroke s1 = new BasicStroke(1.0f);
        BasicStroke s2 = new BasicStroke(2.0f);
        BasicStroke s3 = new BasicStroke(3.0f);
        BasicStroke sR = new BasicStroke((float)(2.0 * sRange * zoom), 0, 0);
        for (int i = 0; i < points.size(); i += 2) {
            double[] pointN;
            double[] pointF;
            double[] pointI = points.get(i);
            try {
                pointF = points.get(i + 1);
            }
            catch (Exception e1) {
                pointF = null;
            }
            try {
                pointN = points.get(i + 2);
            }
            catch (Exception e) {
                pointN = null;
            }
            int ellisRadius = !editMode ? 3 : 4;
            Ellipse2D.Double el = new Ellipse2D.Double(-ellisRadius, -ellisRadius, ellisRadius * 2, ellisRadius * 2);
            if (i == 0) {
                g2d.translate(pointI[0] * zoom, pointI[1] * zoom);
                g2d.setColor(new Color(0, 255, 0));
                g2d.fill(el);
                g2d.translate(-pointI[0] * zoom, -pointI[1] * zoom);
            }
            if (pointF == null) continue;
            Line2D.Double l = new Line2D.Double(pointI[0] * zoom, pointI[1] * zoom, pointF[0] * zoom, pointF[1] * zoom);
            if (paintSSRange) {
                g2d.setColor(new Color(0, 0, 0, 30));
                g2d.setStroke(sR);
                g2d.draw(l);
            }
            g2d.setColor(!editMode ? Color.yellow : Color.orange);
            g2d.setStroke(!editMode ? s2 : s3);
            g2d.draw(l);
            g2d.setColor(Color.black);
            g2d.setStroke(s1);
            if (!editMode) {
                g2d.draw(l);
            }
            g2d.setStroke(sO);
            g2d.translate(pointF[0] * zoom, pointF[1] * zoom);
            g2d.setColor(new Color(255, 0, 0));
            g2d.fill(el);
            g2d.translate(-pointF[0] * zoom, -pointF[1] * zoom);
            if (pointN == null) continue;
            l = new Line2D.Double(pointF[0] * zoom, pointF[1] * zoom, pointN[0] * zoom, pointN[1] * zoom);
            g2d.setColor(!editMode ? Color.yellow : Color.orange);
            g2d.setStroke(!editMode ? s2 : s3);
            g2d.draw(l);
            g2d.setColor(Color.black);
            g2d.setStroke(s1);
            if (!editMode) {
                g2d.draw(l);
            }
            g2d.setStroke(sO);
            g2d.translate(pointN[0] * zoom, pointN[1] * zoom);
            g2d.setColor(new Color(0, 255, 0));
            g2d.fill(el);
            g2d.translate(-pointN[0] * zoom, -pointN[1] * zoom);
        }
        g2d.setColor(oColor);
    }

    public static void paintBox(Graphics2D g2d, double zoom, double width, double length, double x0, double y0, double bearingRad, double crossAngleRadians, boolean editMode) {
        ManeuversUtil.paintBox(g2d, zoom, width, length, x0, y0, bearingRad, crossAngleRadians, false, editMode);
    }

    public static void paintBox(Graphics2D g2d, double zoom, double width, double length, double x0, double y0, double bearingRad, double crossAngleRadians, boolean invertY, boolean editMode) {
        double mult = !invertY ? 1.0 : -1.0;
        GeneralPath sp = new GeneralPath();
        sp.moveTo(x0 * zoom, y0 * zoom);
        double[] resT = AngleCalc.rotate(-crossAngleRadians, length, 0.0, false);
        sp.lineTo(x0 * zoom + resT[0] * zoom, mult * (y0 * zoom + resT[1] * zoom));
        sp.lineTo(x0 * zoom + resT[0] * zoom, mult * (y0 * zoom + (width + resT[1]) * zoom));
        sp.lineTo(x0 * zoom, mult * (y0 * zoom + width * zoom));
        sp.closePath();
        g2d.setColor(!editMode ? new Color(255, 255, 255, 100) : new Color(255, 125, 255, 200));
        g2d.rotate(bearingRad + (double)(!invertY ? -1 : 1) * -crossAngleRadians);
        Stroke sO = g2d.getStroke();
        BasicStroke s1 = new BasicStroke(1.0f);
        BasicStroke s3 = new BasicStroke(2.0f);
        g2d.setStroke(!editMode ? s1 : s3);
        g2d.draw(sp);
        g2d.setStroke(sO);
        g2d.rotate(-bearingRad + (double)(!invertY ? 1 : -1) * -crossAngleRadians);
    }

    public static double getSpeedMps(Maneuver man) {
        DefaultProperty speedProp = null;
        DefaultProperty unitsProp = null;
        for (DefaultProperty dp : man.getProperties()) {
            if (dp.getName().equalsIgnoreCase("Speed")) {
                speedProp = dp;
                continue;
            }
            if (!dp.getName().equalsIgnoreCase("Speed units")) continue;
            unitsProp = dp;
        }
        if (speedProp == null || unitsProp == null) {
            return Double.NaN;
        }
        switch ("" + unitsProp.getValue()) {
            case "m/s": {
                return Double.parseDouble("" + speedProp.getValue());
            }
            case "RPM": {
                return SpeedConversion.convertRpmtoMps(Double.parseDouble("" + speedProp.getValue()));
            }
            case "%": {
                return SpeedConversion.convertPercentageToMps(Double.parseDouble("" + speedProp.getValue()));
            }
        }
        NeptusLog.pub().error((Object)("Unrecognized speed units: " + unitsProp.getValue()));
        return Double.NaN;
    }

    public static Vector<DefaultProperty> getPropertiesFromManeuver(Maneuver man) {
        Vector<DefaultProperty> properties = new Vector<DefaultProperty>();
        PluginProperty[] prop = PluginUtils.getPluginProperties(man);
        properties.addAll(Arrays.asList(prop));
        return properties;
    }

    public static void setPropertiesToManeuver(Maneuver man, Property[] properties) {
        PluginUtils.setPluginProperties((Object)man, properties);
    }
}

