/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.beans.PropertyEditor;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.PopUp;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.editor.SpeedUnitsEditor;
import pt.lsts.neptus.gui.editor.renderer.I18nCellRenderer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.util.NameNormalizer;

public class PopUp
extends Maneuver
implements LocatedManeuver,
IMCSerialization {
    double speed = 1000.0;
    double speedTolerance = 100.0;
    double radiusTolerance = 2.0;
    int duration = 5;
    String units = "RPM";
    ManeuverLocation destination = new ManeuverLocation();
    protected static final String DEFAULT_ROOT_ELEMENT = "PopUp";
    private final int ANGLE_CALCULATION = -1;
    private final int FIRST_ROTATE = 0;
    private final int HORIZONTAL_MOVE = 1;
    int current_state = -1;
    private double targetAngle;
    private double rotateIncrement;
    private boolean currPos = false;
    private boolean waitAtSurface = true;
    private boolean stationKeep = true;
    public String id = NameNormalizer.getRandomID();
    private int count = 0;

    @Override
    public String getType() {
        return DEFAULT_ROOT_ELEMENT;
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("kind", "automatic");
        Element finalPoint = root.addElement("finalPoint");
        finalPoint.addAttribute("type", "pointType");
        Element point = this.destination.asElement("point");
        finalPoint.add(point);
        Element radTolerance = finalPoint.addElement("radiusTolerance");
        radTolerance.setText(String.valueOf(this.getRadiusTolerance()));
        Element duration = root.addElement("duration");
        duration.setText(String.valueOf(this.getDuration()));
        Element velocity = root.addElement("speed");
        velocity.addAttribute("tolerance", String.valueOf(this.getSpeedTolerance()));
        velocity.addAttribute("type", "float");
        velocity.addAttribute("unit", this.getUnits());
        velocity.setText(String.valueOf(this.getSpeed()));
        Element flags = root.addElement("flags");
        flags.addAttribute("CurrPos", "" + this.isCurrPos());
        return document;
    }

    @Override
    public void loadFromXML(String xml) {
        try {
            Node speedNode;
            Document doc = DocumentHelper.parseText((String)xml);
            Node node = doc.selectSingleNode("PopUp/finalPoint/point");
            ManeuverLocation loc = new ManeuverLocation();
            loc.load(node.asXML());
            this.setManeuverLocation(loc);
            this.setRadiusTolerance(Double.parseDouble(doc.selectSingleNode("PopUp/finalPoint/radiusTolerance").getText()));
            Node durNode = doc.selectSingleNode("PopUp/duration");
            if (durNode != null) {
                this.setDuration(Integer.parseInt(durNode.getText()));
            }
            if ((speedNode = doc.selectSingleNode("PopUp/speed")) == null) {
                speedNode = doc.selectSingleNode("PopUp/velocity");
            }
            this.setSpeed(Double.parseDouble(speedNode.getText()));
            this.setSpeedUnits(speedNode.valueOf("@unit"));
            this.setSpeedTolerance(Double.parseDouble(speedNode.valueOf("@tolerance")));
            Node flagsNode = doc.selectSingleNode("PopUp/flags");
            this.setCurrPos(Boolean.parseBoolean(flagsNode.valueOf("@CurrPos")));
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    public SystemPositionAndAttitude ManeuverFunction(SystemPositionAndAttitude lastVehicleState) {
        SystemPositionAndAttitude nextVehicleState = lastVehicleState.clone();
        switch (this.current_state) {
            case -1: {
                double angleDiff;
                this.targetAngle = lastVehicleState.getPosition().getXYAngle(this.destination);
                for (angleDiff = this.targetAngle - lastVehicleState.getYaw(); angleDiff < 0.0; angleDiff += Math.PI * 2) {
                }
                while (angleDiff > Math.PI * 2) {
                    angleDiff -= Math.PI * 2;
                }
                if (angleDiff > Math.PI) {
                    angleDiff -= Math.PI * 2;
                }
                this.rotateIncrement = angleDiff / 3.0;
                this.count = 0;
                this.current_state = 0;
                nextVehicleState = this.ManeuverFunction(lastVehicleState);
                break;
            }
            case 0: {
                if (this.count++ < 3) {
                    nextVehicleState.rotateXY(this.rotateIncrement);
                    break;
                }
                nextVehicleState.setYaw(this.targetAngle);
                this.current_state = 1;
                break;
            }
            case 1: {
                double calculatedSpeed = 1.0;
                if (this.units.equals("m/s")) {
                    calculatedSpeed = this.speed;
                } else if (this.units.equals("RPM")) {
                    calculatedSpeed = this.speed / 500.0;
                }
                double dist = nextVehicleState.getPosition().getHorizontalDistanceInMeters(this.destination);
                if (dist <= calculatedSpeed) {
                    nextVehicleState.setPosition(this.destination);
                    this.endManeuver();
                    break;
                }
                nextVehicleState.moveForward(calculatedSpeed);
                double depthDiff = this.destination.getDepth() - nextVehicleState.getPosition().getDepth();
                double depthIncr = depthDiff / (dist / calculatedSpeed);
                double curDepth = nextVehicleState.getPosition().getDepth();
                nextVehicleState.getPosition().setDepth(curDepth + depthIncr);
                break;
            }
            default: {
                this.endManeuver();
            }
        }
        return nextVehicleState;
    }

    @Override
    public Object clone() {
        PopUp clone = new PopUp();
        super.clone(clone);
        clone.setManeuverLocation(this.destination.clone());
        clone.setDuration(this.getDuration());
        clone.setRadiusTolerance(this.getRadiusTolerance());
        clone.setSpeedUnits(this.getUnits());
        clone.setSpeed(this.getSpeed());
        clone.setSpeedTolerance(this.getSpeedTolerance());
        clone.setCurrPos(this.isCurrPos());
        return clone;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public double getRadiusTolerance() {
        return this.radiusTolerance;
    }

    public void setRadiusTolerance(double radiusTolerance) {
        this.radiusTolerance = radiusTolerance;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public String getUnits() {
        return this.units;
    }

    public void setSpeedUnits(String units) {
        this.units = units;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeedTolerance() {
        return this.speedTolerance;
    }

    public void setSpeedTolerance(double speedTolerance) {
        this.speedTolerance = speedTolerance;
    }

    @Override
    public void translate(double offsetNorth, double offsetEast, double offsetDown) {
        this.destination.translatePosition(offsetNorth, offsetEast, offsetDown);
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> properties = new Vector<DefaultProperty>();
        DefaultProperty units = PropertiesEditor.getPropertyInstance("Speed units", String.class, this.getUnits(), true);
        units.setShortDescription("The speed units");
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)units, (PropertyEditor)((Object)new SpeedUnitsEditor()));
        PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)units, (TableCellRenderer)((Object)new I18nCellRenderer()));
        properties.add(PropertiesEditor.getPropertyInstance("Speed", Double.class, this.getSpeed(), true));
        properties.add(units);
        properties.add(PropertiesEditor.getPropertyInstance("Radius", Double.class, this.getRadiusTolerance(), true));
        properties.add(PropertiesEditor.getPropertyInstance("Duration", Integer.class, this.getDuration(), true));
        properties.add(PropertiesEditor.getPropertyInstance("CURR_POS", "Flags", Boolean.class, this.isCurrPos(), true));
        properties.add(PropertiesEditor.getPropertyInstance("STATION_KEEP", "Flags", Boolean.class, this.isStationKeep(), false));
        properties.add(PropertiesEditor.getPropertyInstance("WAIT_AT_SURFACE", "Flags", Boolean.class, this.isWaitAtSurface(), false));
        return properties;
    }

    @Override
    public String getPropertiesDialogTitle() {
        return this.getId() + " parameters";
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        for (Property p : properties) {
            if (p.getName().equals("Speed units")) {
                this.setSpeedUnits((String)p.getValue());
            }
            if (p.getName().equals("Speed")) {
                this.setSpeed((Double)p.getValue());
            }
            if (p.getName().equals("Radius")) {
                this.setRadiusTolerance((Double)p.getValue());
            }
            if (p.getName().equals("Duration")) {
                this.setDuration((Integer)p.getValue());
            }
            if (!p.getName().equals("CURR_POS")) continue;
            this.setCurrPos((Boolean)p.getValue());
        }
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return super.getPropertiesErrors(properties);
    }

    @Override
    public ManeuverLocation getManeuverLocation() {
        return this.destination.clone();
    }

    @Override
    public ManeuverLocation getStartLocation() {
        return this.destination.clone();
    }

    @Override
    public ManeuverLocation getEndLocation() {
        return this.destination.clone();
    }

    @Override
    public void setManeuverLocation(ManeuverLocation location) {
        this.destination = location.clone();
    }

    public boolean isCurrPos() {
        return this.currPos;
    }

    public void setCurrPos(boolean currPos) {
        this.currPos = currPos;
    }

    public boolean isWaitAtSurface() {
        return this.waitAtSurface;
    }

    public boolean isStationKeep() {
        return this.stationKeep;
    }

    @Override
    public String getTooltipText() {
        return super.getTooltipText() + "<hr>" + I18n.text("speed") + ": <b>" + this.getSpeed() + " " + I18n.text(this.getUnits()) + "</b>" + "<br>" + I18n.text("cruise depth") + ": <b>" + (int)this.destination.getDepth() + " " + I18n.textc("m", "meters") + "</b>" + "<br>" + I18n.text("duration") + ": <b>" + this.getDuration() + " " + I18n.textc("s", "seconds") + "</b>";
    }

    @Override
    public void paintOnMap(Graphics2D g2d, PlanElement planElement, StateRenderer2D renderer) {
        super.paintOnMap(g2d, planElement, renderer);
        AffineTransform at = g2d.getTransform();
        g2d.drawLine(-4, -4, 4, 4);
        g2d.drawLine(-4, 4, 4, -4);
        double radius = this.getRadiusTolerance() * (double)renderer.getZoom();
        g2d.setColor(new Color(255, 255, 255, 100));
        g2d.fill(new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0));
        g2d.setStroke(new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{3.0f, 3.0f}, 0.0f));
        g2d.setColor(Color.blue.darker());
        g2d.draw(new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0));
        g2d.setStroke(new BasicStroke());
        g2d.setTransform(at);
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        pt.lsts.imc.PopUp msgPopup = null;
        try {
            msgPopup = pt.lsts.imc.PopUp.clone((IMCMessage)message);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.setMaxTime(msgPopup.getTimeout());
        this.setSpeed(msgPopup.getSpeed());
        switch (msgPopup.getSpeedUnits()) {
            case METERS_PS: {
                this.setSpeedUnits("m/s");
                break;
            }
            case RPM: {
                this.setSpeedUnits("RPM");
                break;
            }
            case PERCENTAGE: {
                this.setSpeedUnits("%");
                break;
            }
        }
        this.setRadiusTolerance(msgPopup.getRadius());
        this.setDuration(msgPopup.getDuration());
        ManeuverLocation pos = new ManeuverLocation();
        pos.setLatitudeRads(msgPopup.getLat());
        pos.setLongitudeRads(msgPopup.getLon());
        pos.setZ(msgPopup.getZ());
        pos.setZUnits(ManeuverLocation.Z_UNITS.valueOf(msgPopup.getZUnits().toString()));
        this.setManeuverLocation(pos);
        this.setCurrPos((msgPopup.getFlags() & 1) == 1);
    }

    @Override
    public IMCMessage serializeToIMC() {
        pt.lsts.imc.PopUp msg = new pt.lsts.imc.PopUp();
        msg.setTimeout(this.getMaxTime());
        ManeuverLocation loc = this.getManeuverLocation();
        loc.convertToAbsoluteLatLonDepth();
        msg.setLat(loc.getLatitudeRads());
        msg.setLon(loc.getLongitudeRads());
        msg.setZ(this.getManeuverLocation().getZ());
        msg.setZUnits(this.getManeuverLocation().getZUnits().toString());
        msg.setDuration(this.getDuration());
        msg.setSpeed(this.speed);
        switch (this.units) {
            case "RPM": {
                msg.setSpeedUnits(PopUp.SPEED_UNITS.RPM);
                break;
            }
            case "%": {
                msg.setSpeedUnits(PopUp.SPEED_UNITS.PERCENTAGE);
                break;
            }
            case "m/s": {
                msg.setSpeedUnits(PopUp.SPEED_UNITS.METERS_PS);
                break;
            }
        }
        msg.setRadius(this.getRadiusTolerance());
        LinkedHashMap<String, String> tl = new LinkedHashMap<String, String>();
        for (String key : this.getCustomSettings().keySet()) {
            tl.put(key, this.getCustomSettings().get(key));
        }
        msg.setCustom(this.getCustomSettings());
        short flags = 0;
        if (this.isStationKeep()) {
            flags = (short)(flags | 4);
        }
        if (this.isCurrPos()) {
            flags = (short)(flags | 1);
        }
        if (this.isWaitAtSurface()) {
            flags = (short)(flags | 2);
        }
        msg.setFlags(flags);
        return msg;
    }

    @Override
    public Collection<ManeuverLocation> getWaypoints() {
        return Collections.singleton(this.getStartLocation());
    }

    public static void main(String[] args) {
        PopUp popup = new PopUp();
        popup.setRadiusTolerance(10.0);
        popup.setSpeed(1.2);
        popup.setSpeedUnits("m/s");
        popup.setDuration(300);
        popup.setCurrPos(true);
        ManeuverLocation loc = new ManeuverLocation();
        loc.setLatitudeDegs(0.0);
        loc.setLongitudeDegs(0.0);
        loc.setDepth(3.0);
        popup.setManeuverLocation(loc);
        String xml1 = popup.asXML();
        IMCMessage msg1 = popup.serializeToIMC();
        msg1.dump((OutputStream)System.out);
        popup.parseIMCMessage(msg1);
        String xml2 = popup.asXML();
        popup.loadFromXML(xml2);
        popup.serializeToIMC().dump((OutputStream)System.out);
        System.out.println(xml1);
        System.out.println(xml2);
        System.out.println(popup.asXML());
    }
}

