/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import java.awt.Graphics2D;
import java.util.Vector;
import pt.lsts.neptus.mp.maneuvers.ManeuversUtil;
import pt.lsts.neptus.mp.maneuvers.RowsManeuver;
import pt.lsts.neptus.mp.maneuvers.RowsPattern;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;

public class RIPattern
extends RowsPattern {
    public RIPattern() {
        this.ignoreLength = true;
        this.ignoreCrossAngle = true;
        this.ignoreFirstCurveRight = true;
        this.paintOnlyBasePoint = true;
    }

    @Override
    public String getName() {
        return "RIPattern";
    }

    @Override
    public void paintOnMap(Graphics2D g2d, PlanElement planElement, StateRenderer2D renderer) {
        double zoom = renderer.getZoom();
        g2d.rotate(-renderer.getRotation());
        g2d.rotate(-1.5707963267948966);
        ManeuversUtil.paintBox(g2d, zoom, this.width, this.width, -this.width / 2.0, -this.width / 2.0, this.bearingRad, this.crossAngleRadians, this.editing);
        ManeuversUtil.paintBox(g2d, zoom, this.width, this.width, -this.width / 2.0, -this.width / 2.0, this.bearingRad + Math.toRadians(-60.0), this.crossAngleRadians, this.editing);
        ManeuversUtil.paintBox(g2d, zoom, this.width, this.width, -this.width / 2.0, -this.width / 2.0, this.bearingRad + Math.toRadians(-120.0), this.crossAngleRadians, this.editing);
        g2d.rotate(1.5707963267948966);
        g2d.rotate(renderer.getRotation());
        super.paintOnMap(g2d, planElement, renderer);
    }

    @Override
    protected void recalcPoints() {
        Vector<double[]> newPoints;
        this.points = newPoints = ManeuversUtil.calcRIPatternPoints(this.width, this.hstep, this.alternationPercentage, this.curvOff, this.squareCurve, this.bearingRad);
    }

    @Override
    public void setParams(double width, double hstep, double alternationPercent, double curvOff, boolean squareCurve, double bearingRad, double crossAngleRadians, boolean firstCurveRight) {
        this.width = width;
        this.hstep = hstep;
        this.alternationPercentage = (float)alternationPercent;
        this.curvOff = curvOff;
        this.squareCurve = squareCurve;
        this.bearingRad = bearingRad;
        this.crossAngleRadians = crossAngleRadians;
        this.firstCurveRight = firstCurveRight;
        this.recalcPoints();
    }

    public static void main(String[] args) {
        RIPattern man = new RIPattern();
        man.setSpeed(1.0);
        man.setSpeedUnits("m/s");
        man.setSpeed(2.0);
        man.setSpeedUnits("m/s");
        MissionType mission = new MissionType("./missions/rep10/rep10.nmisz");
        StateRenderer2D r2d = new StateRenderer2D(MapGroup.getMapGroupInstance(mission));
        PlanElement pelem = new PlanElement(MapGroup.getMapGroupInstance(mission), null);
        PlanType plan = new PlanType(mission);
        man.getManeuverLocation().setLocation(r2d.getCenter());
        plan.getGraph().addManeuver(man);
        pelem.setPlan(plan);
        r2d.addPostRenderPainter(pelem, "Plan");
        GuiUtils.testFrame(r2d);
        RowsManeuver.unblockNewRows = true;
    }
}

