/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyEditor;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Rows;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.gui.editor.SpeedUnitsEditor;
import pt.lsts.neptus.gui.editor.renderer.I18nCellRenderer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.maneuvers.ManeuversUtil;
import pt.lsts.neptus.mp.maneuvers.PathProvider;
import pt.lsts.neptus.mp.maneuvers.StatisticsProvider;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.MathMiscUtils;

public class RowsManeuver
extends Maneuver
implements LocatedManeuver,
StateRendererInteraction,
IMCSerialization,
StatisticsProvider,
PathProvider {
    static boolean unblockNewRows = false;
    protected double latRad = 0.0;
    protected double lonRad = 0.0;
    protected double z = 2.0;
    protected double speed = 1000.0;
    protected double bearingRad = 0.0;
    protected double width = 100.0;
    protected double length = 200.0;
    protected double hstep = 27.0;
    protected double ssRangeShadow = 30.0;
    protected double crossAngleRadians = 0.0;
    protected double curvOff = 15.0;
    protected float alternationPercentage = 1.0f;
    protected boolean squareCurve = true;
    protected boolean firstCurveRight = true;
    protected boolean paintSSRangeShadow = true;
    protected String speed_units = "RPM";
    protected ManeuverLocation.Z_UNITS zunits = ManeuverLocation.Z_UNITS.NONE;
    protected InteractionAdapter adapter = new InteractionAdapter(null);
    protected Point2D lastDragPoint = null;
    protected boolean editing = false;
    protected Vector<double[]> points = new Vector();
    protected static final int X = 0;
    protected static final int Y = 1;
    protected static final int Z = 2;
    protected static final int T = 3;

    public RowsManeuver() {
        this.recalcPoints();
    }

    protected ManeuverLocation calculatePosition() {
        ManeuverLocation loc = new ManeuverLocation();
        loc.setLatitudeDegs(Math.toDegrees(this.latRad));
        loc.setLongitudeDegs(Math.toDegrees(this.lonRad));
        loc.setZ(this.z);
        loc.setZUnits(this.zunits);
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromXML(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Node node = doc.selectSingleNode("//basePoint/point");
            ManeuverLocation loc = new ManeuverLocation();
            loc.load(node.asXML());
            this.setManeuverLocation(loc);
            this.latRad = this.getManeuverLocation().getLatitudeRads();
            this.lonRad = this.getManeuverLocation().getLongitudeRads();
            this.z = this.getManeuverLocation().getZ();
            this.zunits = this.getManeuverLocation().getZUnits();
            Node speedNode = doc.selectSingleNode("//speed");
            this.speed = Double.parseDouble(speedNode.getText());
            this.speed_units = speedNode.valueOf("@unit");
            this.bearingRad = Math.toRadians(Double.parseDouble(doc.selectSingleNode("//bearing").getText()));
            this.width = Double.parseDouble(doc.selectSingleNode("//width").getText());
            node = doc.selectSingleNode("//length");
            this.length = node != null ? Double.parseDouble(node.getText()) : this.width;
            this.hstep = Double.parseDouble(doc.selectSingleNode("//hstep").getText());
            node = doc.selectSingleNode("//crossAngle");
            this.crossAngleRadians = node != null ? Math.toRadians(Double.parseDouble(node.getText())) : 0.0;
            node = doc.selectSingleNode("//alternationPercentage");
            this.alternationPercentage = node != null ? (float)Short.parseShort(node.getText()) / 100.0f : 1.0f;
            node = doc.selectSingleNode("//curveOffset");
            this.curvOff = node != null ? Double.parseDouble(node.getText()) : 15.0;
            node = doc.selectSingleNode("//squareCurve");
            this.squareCurve = node != null ? Boolean.parseBoolean(node.getText()) : true;
            node = doc.selectSingleNode("//firstCurveRight");
            this.firstCurveRight = node != null ? Boolean.parseBoolean(node.getText()) : true;
            node = doc.selectSingleNode("//ssRangeShadow");
            if (node != null) {
                try {
                    this.ssRangeShadow = Short.parseShort(node.getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.ssRangeShadow = 30.0;
                }
            } else {
                this.ssRangeShadow = 30.0;
            }
            this.paintSSRangeShadow = (node = doc.selectSingleNode("//paintSSRangeShadow")) != null ? Boolean.parseBoolean(node.getText()) : true;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
        finally {
            this.recalcPoints();
        }
    }

    @Override
    public Object clone() {
        RowsManeuver clone = new RowsManeuver();
        super.clone(clone);
        clone.latRad = this.latRad;
        clone.lonRad = this.lonRad;
        clone.z = this.z;
        clone.zunits = this.zunits;
        clone.bearingRad = this.bearingRad;
        clone.hstep = this.hstep;
        clone.length = this.length;
        clone.speed = this.speed;
        clone.speed_units = this.speed_units;
        clone.width = this.width;
        clone.alternationPercentage = this.alternationPercentage;
        clone.crossAngleRadians = this.crossAngleRadians;
        clone.curvOff = this.curvOff;
        clone.squareCurve = this.squareCurve;
        clone.ssRangeShadow = this.ssRangeShadow;
        clone.paintSSRangeShadow = this.paintSSRangeShadow;
        clone.firstCurveRight = this.firstCurveRight;
        clone.recalcPoints();
        return clone;
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("kind", "automatic");
        Element basePoint = root.addElement("basePoint");
        Element point = this.getManeuverLocation().asElement("point");
        basePoint.add(point);
        Element radTolerance = basePoint.addElement("radiusTolerance");
        radTolerance.setText("0");
        basePoint.addAttribute("type", "pointType");
        root.addElement("width").setText("" + this.width);
        root.addElement("length").setText("" + this.length);
        root.addElement("hstep").setText("" + this.hstep);
        root.addElement("bearing").setText("" + Math.toDegrees(this.bearingRad));
        if (this.crossAngleRadians != 0.0) {
            root.addElement("crossAngle").setText("" + Math.toDegrees(this.crossAngleRadians));
        }
        if ((short)(this.alternationPercentage * 100.0f) != 100) {
            root.addElement("alternationPercentage").setText("" + (short)(this.alternationPercentage * 100.0f));
        }
        if (this.curvOff != 15.0) {
            root.addElement("curveOffset").setText("" + this.curvOff);
        }
        if (!this.squareCurve) {
            root.addElement("squareCurve").setText("" + this.squareCurve);
        }
        if (!this.firstCurveRight) {
            root.addElement("firstCurveRight").setText("" + this.firstCurveRight);
        }
        Element speedElem = root.addElement("speed");
        speedElem.addAttribute("unit", this.speed_units);
        speedElem.setText("" + this.speed);
        if (!this.paintSSRangeShadow) {
            root.addElement("paintSSRangeShadow").setText("" + this.paintSSRangeShadow);
        }
        if (this.ssRangeShadow != 30.0) {
            root.addElement("ssRangeShadow").setText("" + Double.valueOf(this.ssRangeShadow).shortValue());
        }
        return document;
    }

    @Override
    public String getName() {
        return "Rows";
    }

    @Override
    public Image getIconImage() {
        return this.adapter.getIconImage();
    }

    @Override
    public Cursor getMouseCursor() {
        return this.adapter.getMouseCursor();
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseClicked(event, source);
    }

    @Override
    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        this.adapter.mousePressed(event, source);
        this.lastDragPoint = event.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        if (this.lastDragPoint == null) {
            this.adapter.mouseDragged(event, source);
            this.lastDragPoint = event.getPoint();
            return;
        }
        double xammount = event.getPoint().getX() - this.lastDragPoint.getX();
        double yammount = event.getPoint().getY() - this.lastDragPoint.getY();
        yammount = -yammount;
        if (event.isControlDown()) {
            this.width += xammount / (double)(Math.abs(xammount) < 30.0 ? 10 : 2);
            this.length += yammount / (double)(Math.abs(yammount) < 30.0 ? 10 : 2);
            this.width = Math.max(1.0, this.width);
            this.length = Math.max(1.0, this.length);
            this.recalcPoints();
        } else if (event.isShiftDown()) {
            this.bearingRad += Math.toRadians(yammount / (double)(Math.abs(yammount) < 30.0 ? 10 : 2));
            while (this.bearingRad > Math.PI * 2) {
                this.bearingRad -= Math.PI * 2;
            }
            while (this.bearingRad < 0.0) {
                this.bearingRad += Math.PI * 2;
            }
            this.recalcPoints();
        } else {
            this.adapter.mouseDragged(event, source);
        }
        this.lastDragPoint = event.getPoint();
    }

    @Override
    public void mouseMoved(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseMoved(event, source);
    }

    @Override
    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseReleased(event, source);
        this.lastDragPoint = null;
    }

    @Override
    public void wheelMoved(MouseWheelEvent event, StateRenderer2D source) {
        this.adapter.wheelMoved(event, source);
    }

    @Override
    public void keyPressed(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyPressed(event, source);
    }

    @Override
    public void keyReleased(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyReleased(event, source);
    }

    @Override
    public void keyTyped(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyTyped(event, source);
    }

    @Override
    public void mouseExited(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseExited(event, source);
    }

    @Override
    public void focusGained(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusGained(event, source);
    }

    @Override
    public void focusLost(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusLost(event, source);
    }

    @Override
    public void setActive(boolean mode, StateRenderer2D source) {
        this.editing = mode;
        this.adapter.setActive(mode, source);
    }

    @Override
    public ManeuverLocation getManeuverLocation() {
        return this.calculatePosition();
    }

    @Override
    public ManeuverLocation getStartLocation() {
        try {
            double[] first = this.points.firstElement();
            ManeuverLocation loc = this.getManeuverLocation().clone();
            loc.translatePosition(first[0], first[1], first[2]);
            return loc;
        }
        catch (Exception e) {
            return this.getManeuverLocation();
        }
    }

    @Override
    public ManeuverLocation getEndLocation() {
        try {
            double[] last = this.points.lastElement();
            ManeuverLocation loc = this.getManeuverLocation().clone();
            loc.translatePosition(last[0], last[1], last[2]);
            return loc;
        }
        catch (Exception e) {
            return this.getManeuverLocation();
        }
    }

    @Override
    public void setManeuverLocation(ManeuverLocation location) {
        double[] absoluteLatLonDepth = location.getAbsoluteLatLonDepth();
        this.latRad = Math.toRadians(absoluteLatLonDepth[0]);
        this.lonRad = Math.toRadians(absoluteLatLonDepth[1]);
        this.z = location.getZ();
        this.zunits = location.getZUnits();
        this.recalcPoints();
    }

    @Override
    public void translate(double offsetNorth, double offsetEast, double offsetDown) {
        ManeuverLocation loc = this.calculatePosition();
        loc.translatePosition(offsetNorth, offsetEast, offsetDown);
        this.setManeuverLocation(loc);
    }

    @Override
    public List<double[]> getPathPoints() {
        return Collections.unmodifiableList(this.points);
    }

    @Override
    public List<LocationType> getPathLocations() {
        Vector<LocationType> locs = new Vector<LocationType>();
        List<double[]> lst = Collections.unmodifiableList(this.points);
        LocationType start = new LocationType(this.getManeuverLocation());
        if (this.getManeuverLocation().getZUnits() == ManeuverLocation.Z_UNITS.DEPTH) {
            start.setDepth(this.getManeuverLocation().getZ());
        } else if (this.getManeuverLocation().getZUnits() == ManeuverLocation.Z_UNITS.DEPTH) {
            start.setDepth(-this.getManeuverLocation().getZ());
        }
        for (double[] ds : lst) {
            LocationType loc = new LocationType(start);
            loc.translatePosition(ds);
            loc.convertToAbsoluteLatLonDepth();
            locs.add(loc);
        }
        return locs;
    }

    public double getBearingRad() {
        return this.bearingRad;
    }

    public void setBearingRad(double bearingRad) {
        this.bearingRad = bearingRad;
        this.recalcPoints();
    }

    public void setParams(double width, double length, double hstep, double alternationPercent, double curvOff, boolean squareCurve, double bearingRad, double crossAngleRadians, boolean firstCurveRight, boolean paintSSRangeShadow, short ssRangeShadow) {
        this.width = width;
        this.length = length;
        this.hstep = hstep;
        this.alternationPercentage = Double.valueOf(alternationPercent).floatValue();
        this.curvOff = curvOff;
        this.squareCurve = squareCurve;
        this.bearingRad = bearingRad;
        this.crossAngleRadians = crossAngleRadians;
        this.firstCurveRight = firstCurveRight;
        this.paintSSRangeShadow = paintSSRangeShadow;
        this.ssRangeShadow = ssRangeShadow;
        this.recalcPoints();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHstep() {
        return this.hstep;
    }

    public float getAlternationPercent() {
        return this.alternationPercentage;
    }

    public double getCurvOff() {
        return this.curvOff;
    }

    public boolean isSquareCurve() {
        return this.squareCurve;
    }

    public double getCrossAngleRadians() {
        return this.crossAngleRadians;
    }

    public boolean isPaintSSRangeShadow() {
        return this.paintSSRangeShadow;
    }

    public void setPaintSSRangeShadow(boolean paintSSRangeShadow) {
        this.paintSSRangeShadow = paintSSRangeShadow;
    }

    public double getSsRangeShadow() {
        return this.ssRangeShadow;
    }

    public void setSsRangeShadow(double ssRangeShadow) {
        this.ssRangeShadow = ssRangeShadow;
    }

    @Override
    public void paintOnMap(Graphics2D g2d, PlanElement planElement, StateRenderer2D renderer) {
        super.paintOnMap(g2d, planElement, renderer);
        g2d.setColor(Color.white);
        double zoom = renderer.getZoom();
        g2d.rotate(-renderer.getRotation());
        g2d.rotate(-1.5707963267948966);
        ManeuversUtil.paintBox(g2d, zoom, this.width, this.length, 0.0, 0.0, this.bearingRad, this.crossAngleRadians, !this.firstCurveRight, this.editing);
        ManeuversUtil.paintPointLineList(g2d, zoom, this.points, this.paintSSRangeShadow, this.ssRangeShadow, this.editing);
        g2d.rotate(1.5707963267948966);
    }

    private void recalcPoints() {
        Vector<double[]> newPoints = ManeuversUtil.calcRowsPoints(this.width, this.length, this.hstep, this.alternationPercentage, this.curvOff, this.squareCurve, this.bearingRad, this.crossAngleRadians, !this.firstCurveRight);
        this.points = newPoints;
    }

    @Override
    public IMCMessage serializeToIMC() {
        Rows man = new Rows();
        man.setTimeout(this.getMaxTime());
        man.setLat(this.latRad);
        man.setLon(this.lonRad);
        man.setZ(this.z);
        man.setZUnits(this.zunits.toString());
        man.setSpeed(this.speed);
        man.setWidth(this.width);
        man.setLength(this.length);
        man.setBearing(this.bearingRad);
        man.setHstep(this.hstep);
        man.setCrossAngle(this.crossAngleRadians);
        man.setCoff((short)this.curvOff);
        man.setAlternation((short)(this.alternationPercentage * 100.0f));
        man.setCustom(this.getCustomSettings());
        man.setFlags((short)((this.squareCurve ? 1 : 0) + (this.firstCurveRight ? 2 : 0)));
        String speedU = this.getUnits();
        if ("m/s".equalsIgnoreCase(speedU)) {
            man.setSpeedUnits(Rows.SPEED_UNITS.METERS_PS);
        } else if ("RPM".equalsIgnoreCase(speedU)) {
            man.setSpeedUnits(Rows.SPEED_UNITS.RPM);
        } else if ("%".equalsIgnoreCase(speedU)) {
            man.setSpeedUnits(Rows.SPEED_UNITS.PERCENTAGE);
        } else if ("percentage".equalsIgnoreCase(speedU)) {
            man.setSpeedUnits(Rows.SPEED_UNITS.PERCENTAGE);
        }
        return man;
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        Rows man = null;
        try {
            man = Rows.clone((IMCMessage)message);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.setMaxTime(man.getTimeout());
        this.latRad = man.getLat();
        this.lonRad = man.getLon();
        this.z = man.getZ();
        this.zunits = ManeuverLocation.Z_UNITS.valueOf(man.getZUnits().toString());
        this.speed = man.getSpeed();
        this.width = man.getWidth();
        this.length = man.getLength();
        this.bearingRad = man.getBearing();
        this.hstep = man.getHstep();
        switch (man.getSpeedUnits()) {
            case METERS_PS: {
                this.speed_units = "m/s";
                break;
            }
            case RPM: {
                this.speed_units = "RPM";
                break;
            }
            default: {
                this.speed_units = "%";
            }
        }
        this.crossAngleRadians = man.getCrossAngle();
        this.curvOff = man.getCoff();
        this.alternationPercentage = (float)man.getAlternation() / 100.0f;
        this.firstCurveRight = (man.getFlags() & 2) != 0;
        this.squareCurve = (man.getFlags() & 1) != 0;
        this.setCustomSettings(man.getCustom());
        this.recalcPoints();
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        for (Property p : properties) {
            if (p.getName().equals("Width")) {
                this.width = (Double)p.getValue();
                continue;
            }
            if (p.getName().equals("Length")) {
                this.length = (Double)p.getValue();
                continue;
            }
            if (p.getName().equals("Horizontal Alternation")) {
                this.alternationPercentage = (float)((Short)p.getValue()).shortValue() / 100.0f;
                continue;
            }
            if (p.getName().equals("Speed")) {
                this.speed = (Double)p.getValue();
                continue;
            }
            if (p.getName().equalsIgnoreCase("Speed Units")) {
                this.speed_units = (String)p.getValue();
                continue;
            }
            if (p.getName().equals("Bearing")) {
                this.bearingRad = Math.toRadians((Double)p.getValue());
                continue;
            }
            if (p.getName().equals("Cross Angle")) {
                this.crossAngleRadians = Math.toRadians((Double)p.getValue());
                continue;
            }
            if (p.getName().equals("Horizontal Step")) {
                this.hstep = (Double)p.getValue();
                continue;
            }
            if (p.getName().equalsIgnoreCase("Curve Offset")) {
                this.curvOff = (Double)p.getValue();
                continue;
            }
            if (p.getName().equalsIgnoreCase("Square Curve")) {
                this.squareCurve = (Boolean)p.getValue();
                continue;
            }
            if (p.getName().equalsIgnoreCase("First Curve Right")) {
                this.firstCurveRight = (Boolean)p.getValue();
                continue;
            }
            if (p.getName().equalsIgnoreCase("Payload Shadow")) {
                this.paintSSRangeShadow = (Boolean)p.getValue();
                continue;
            }
            if (!p.getName().equalsIgnoreCase("Shadow Size")) continue;
            this.ssRangeShadow = ((Short)p.getValue()).shortValue();
        }
        this.recalcPoints();
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> props = new Vector<DefaultProperty>();
        DefaultProperty length = PropertiesEditor.getPropertyInstance("Length", Double.class, this.length, true);
        length.setShortDescription("The length of the volume to cover, in meters");
        props.add(length);
        DefaultProperty width = PropertiesEditor.getPropertyInstance("Width", Double.class, this.width, true);
        width.setShortDescription("Width of the volume to cover, in meters");
        props.add(width);
        DefaultProperty halt = PropertiesEditor.getPropertyInstance("Horizontal Alternation", Short.class, (short)(this.alternationPercentage * 100.0f), unblockNewRows);
        halt.setShortDescription("Horizontal alternation in percentage. 100 will make all rows separated by the Horizontal Step");
        props.add(halt);
        DefaultProperty hstep = PropertiesEditor.getPropertyInstance("Horizontal Step", Double.class, this.hstep, true);
        hstep.setShortDescription("Horizontal distance between rows, in meters");
        props.add(hstep);
        DefaultProperty direction = PropertiesEditor.getPropertyInstance("Bearing", Double.class, Math.toDegrees(this.bearingRad), true);
        direction.setShortDescription("The outgoing bearing (from starting location) in degrees");
        props.add(direction);
        DefaultProperty cross = PropertiesEditor.getPropertyInstance("Cross Angle", Double.class, Math.toDegrees(this.crossAngleRadians), unblockNewRows);
        cross.setShortDescription("The tilt angle of the search box in degrees");
        props.add(cross);
        DefaultProperty speed = PropertiesEditor.getPropertyInstance("Speed", Double.class, this.speed, true);
        speed.setShortDescription("The vehicle's desired speed");
        props.add(speed);
        DefaultProperty speedUnits = PropertiesEditor.getPropertyInstance("Speed Units", String.class, this.speed_units, true);
        speedUnits.setShortDescription("The units to consider in the speed parameters");
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)speedUnits, (PropertyEditor)((Object)new SpeedUnitsEditor()));
        PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)speedUnits, (TableCellRenderer)((Object)new I18nCellRenderer()));
        props.add(speedUnits);
        DefaultProperty curvOffset = PropertiesEditor.getPropertyInstance("Curve Offset", Double.class, this.curvOff, true);
        curvOffset.setShortDescription("The extra length to use for the curve");
        props.add(curvOffset);
        DefaultProperty squareCurveP = PropertiesEditor.getPropertyInstance("Square Curve", Boolean.class, this.squareCurve, unblockNewRows);
        squareCurveP.setShortDescription("If the curve should be square or direct");
        props.add(squareCurveP);
        DefaultProperty firstCurveRightP = PropertiesEditor.getPropertyInstance("First Curve Right", Boolean.class, this.firstCurveRight, unblockNewRows);
        firstCurveRightP.setShortDescription("If the first curve should be to the right or left");
        props.add(firstCurveRightP);
        DefaultProperty paintSSRangeShadowP = PropertiesEditor.getPropertyInstance("Payload Shadow", Boolean.class, this.paintSSRangeShadow, unblockNewRows);
        paintSSRangeShadowP.setShortDescription("If the sidescan range shadow is painted");
        props.add(paintSSRangeShadowP);
        DefaultProperty ssRangeShadowtP = PropertiesEditor.getPropertyInstance("Shadow Size", Short.class, Double.valueOf(this.ssRangeShadow).shortValue(), unblockNewRows);
        ssRangeShadowtP.setShortDescription("The sidescan range");
        props.add(ssRangeShadowtP);
        return props;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public String getUnits() {
        return this.speed_units;
    }

    public void setSpeedUnits(String speed_units) {
        this.speed_units = speed_units;
    }

    @Override
    public double getCompletionTime(LocationType initialPosition) {
        double speed = this.speed;
        if (this.speed_units.equalsIgnoreCase("RPM")) {
            speed /= 769.230769231;
        } else if (this.speed_units.equalsIgnoreCase("%")) {
            speed /= 76.923076923;
        }
        return this.getDistanceTravelled(initialPosition) / speed;
    }

    @Override
    public double getDistanceTravelled(LocationType initialPosition) {
        double meters = this.getStartLocation().getDistanceInMeters(initialPosition);
        if (this.points.size() == 0) {
            int numrows = (int)Math.floor(this.width / this.hstep);
            double planeDistance = (double)numrows * this.length + (double)numrows * this.hstep;
            return meters += planeDistance;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            double[] pointF;
            double[] pointI = this.points.get(i);
            try {
                pointF = this.points.get(i + 1);
            }
            catch (Exception e) {
                break;
            }
            double[] offsets = new double[]{pointF[0] - pointI[0], pointF[1] - pointI[1]};
            double sum = offsets[0] * offsets[0] + offsets[1] * offsets[1];
            double planeDistance = Math.sqrt(sum);
            meters += planeDistance;
        }
        return meters;
    }

    @Override
    public double getMaxDepth() {
        return this.z;
    }

    @Override
    public double getMinDepth() {
        return this.z;
    }

    @Override
    public String getTooltipText() {
        NumberFormat nf = GuiUtils.getNeptusDecimalFormat(2);
        return super.getTooltipText() + "<hr/>" + I18n.text("length") + ": <b>" + nf.format(this.length) + " " + I18n.textc("m", "meters") + "</b><br/>" + I18n.text("width") + ": <b>" + nf.format(this.width) + " " + I18n.textc("m", "meters") + "</b><br/>" + I18n.text("alt") + ": <b>" + (short)(this.alternationPercentage * 100.0f) + " %</b><br/>" + I18n.text("hstep") + ": <b>" + nf.format(this.hstep) + " " + I18n.textc("m", "meters") + "</b><br/>" + I18n.text("bearing") + ": <b>" + nf.format(Math.toDegrees(this.bearingRad)) + " \u00b0</b><br/>" + I18n.text("cross angle") + ": <b>" + nf.format(Math.toDegrees(this.crossAngleRadians)) + " \u00b0</b><br/>" + I18n.text("speed") + ": <b>" + nf.format(this.getSpeed()) + " " + this.getUnits() + "</b><br/>" + I18n.text("distance") + ": <b>" + MathMiscUtils.parseToEngineeringNotation(this.getDistanceTravelled(this.getStartLocation()), 2) + I18n.textc("m", "meters") + "</b><br/>" + (this.paintSSRangeShadow ? I18n.textc("ss range", "sidescan range") + ": <b>" + (short)this.ssRangeShadow + " " + I18n.textc("m", "meters") + "</b><br/>" : "") + "<br>" + I18n.text("depth") + ": <b>" + nf.format(this.z) + " " + I18n.textc("m", "meters") + "</b>";
    }

    @Override
    public void setAssociatedSwitch(ToolbarSwitch tswitch) {
    }

    @Override
    public void paintInteraction(Graphics2D g, StateRenderer2D source) {
    }

    @Override
    public Collection<ManeuverLocation> getWaypoints() {
        Vector<ManeuverLocation> locs = new Vector<ManeuverLocation>();
        List<double[]> lst = Collections.unmodifiableList(this.points);
        ManeuverLocation start = new ManeuverLocation(this.getManeuverLocation());
        for (double[] ds : lst) {
            ManeuverLocation loc = new ManeuverLocation(start);
            loc.translatePosition(ds);
            loc.convertToAbsoluteLatLonDepth();
            locs.add(loc);
        }
        return locs;
    }

    public static void main(String[] args) {
        RowsManeuver rows = new RowsManeuver();
        NeptusLog.pub().info((Object)("<###> " + rows.getManeuverLocation()));
        NeptusLog.pub().info((Object)("<###> " + rows.getStartLocation()));
        NeptusLog.pub().info((Object)("<###> " + rows.getEndLocation()));
        RowsManeuver man = new RowsManeuver();
        String xml = man.getManeuverAsDocument("Rows").asXML();
        NeptusLog.pub().info((Object)("<###> " + FileUtil.getAsPrettyPrintFormatedXMLString(xml)));
        unblockNewRows = true;
        ConsoleParse.consoleLayoutLoader("./conf/consoles/seacon-basic.ncon");
    }

    static {
        if (IMCDefinition.getInstance().create("Rows", new Object[0]) != null) {
            unblockNewRows = true;
        }
    }
}

