/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.editor.SpeedUnitsEditor;
import pt.lsts.neptus.gui.editor.renderer.I18nCellRenderer;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.FollowPath;
import pt.lsts.neptus.mp.maneuvers.ManeuversUtil;
import pt.lsts.neptus.mp.maneuvers.RowsManeuver;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;

public class RowsPattern
extends FollowPath {
    protected double bearingRad = 0.0;
    protected double width = 100.0;
    protected double length = 200.0;
    protected double hstep = 27.0;
    protected double sRange = 30.0;
    protected double crossAngleRadians = 0.0;
    protected double curvOff = 15.0;
    protected float alternationPercentage = 1.0f;
    protected boolean squareCurve = true;
    protected boolean firstCurveRight = true;
    protected boolean ignoreLength = false;
    protected boolean ignoreCrossAngle = false;
    protected boolean ignoreAlternationPercentage = false;
    protected boolean ignoreFirstCurveRight = false;
    protected boolean paintOnlyBasePoint = false;

    public RowsPattern() {
        this.recalcPoints();
    }

    @Override
    public String getName() {
        return "RowsPattern";
    }

    @Override
    public void paintOnMap(Graphics2D g2d, PlanElement planElement, StateRenderer2D renderer) {
        super.paintOnMap(g2d, planElement, renderer);
        if (this.paintOnlyBasePoint) {
            return;
        }
        double zoom = renderer.getZoom();
        g2d.rotate(-renderer.getRotation());
        g2d.rotate(-1.5707963267948966);
        ManeuversUtil.paintBox(g2d, zoom, this.width, this.length, 0.0, 0.0, this.bearingRad, this.crossAngleRadians, !this.firstCurveRight, this.editing);
        ManeuversUtil.paintPointLineList(g2d, zoom, this.points, true, this.sRange, this.editing);
        g2d.rotate(1.5707963267948966);
        g2d.rotate(renderer.getRotation());
    }

    protected void recalcPoints() {
        Vector<double[]> newPoints;
        this.points = newPoints = ManeuversUtil.calcRowsPoints(this.width, this.length, this.hstep, this.alternationPercentage, this.curvOff, this.squareCurve, this.bearingRad, this.crossAngleRadians, !this.firstCurveRight);
    }

    @Override
    public ManeuverLocation getStartLocation() {
        try {
            double[] first = (double[])this.points.firstElement();
            ManeuverLocation loc = this.getManeuverLocation().clone();
            loc.translatePosition(first[0], first[1], first[2]);
            return loc;
        }
        catch (Exception e) {
            return this.getManeuverLocation();
        }
    }

    @Override
    public ManeuverLocation getEndLocation() {
        try {
            double[] last = (double[])this.points.lastElement();
            ManeuverLocation loc = this.getManeuverLocation().clone();
            loc.translatePosition(last[0], last[1], last[2]);
            return loc;
        }
        catch (Exception e) {
            return this.getManeuverLocation();
        }
    }

    @Override
    public void setManeuverLocation(ManeuverLocation location) {
        super.setManeuverLocation(location);
        this.recalcPoints();
    }

    public void setParams(double width, double hstep, double alternationPercent, double curvOff, boolean squareCurve, double bearingRad, double crossAngleRadians, boolean firstCurveRight) {
        this.width = width;
        this.hstep = hstep;
        this.alternationPercentage = Double.valueOf(alternationPercent).floatValue();
        this.curvOff = curvOff;
        this.squareCurve = squareCurve;
        this.bearingRad = bearingRad;
        this.crossAngleRadians = crossAngleRadians;
        this.firstCurveRight = firstCurveRight;
        this.recalcPoints();
    }

    @Override
    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseClicked(event, source);
    }

    @Override
    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        if (this.lastDragPoint == null) {
            this.adapter.mouseDragged(event, source);
            this.lastDragPoint = event.getPoint();
            return;
        }
        double xammount = event.getPoint().getX() - this.lastDragPoint.getX();
        double yammount = event.getPoint().getY() - this.lastDragPoint.getY();
        yammount = -yammount;
        if (event.isControlDown()) {
            this.width += xammount / (double)(Math.abs(yammount) < 30.0 ? 10 : 2);
            this.width = Math.max(1.0, this.width);
            if (!this.ignoreLength) {
                this.length += yammount / (double)(Math.abs(yammount) < 30.0 ? 10 : 2);
                this.length = Math.max(1.0, this.length);
            }
            this.recalcPoints();
        } else if (event.isShiftDown()) {
            this.bearingRad += Math.toRadians(yammount / (double)(Math.abs(yammount) < 30.0 ? 10 : 2));
            while (this.bearingRad > Math.PI * 2) {
                this.bearingRad -= Math.PI * 2;
            }
            while (this.bearingRad < 0.0) {
                this.bearingRad += Math.PI * 2;
            }
            this.recalcPoints();
        } else {
            this.adapter.mouseDragged(event, source);
        }
        this.lastDragPoint = event.getPoint();
    }

    @Override
    public void translate(double offsetNorth, double offsetEast, double offsetDown) {
        super.translate(offsetNorth, offsetEast, offsetDown);
        this.recalcPoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromXML(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Node node = doc.selectSingleNode("//basePoint/point");
            ManeuverLocation loc = new ManeuverLocation();
            loc.load(node.asXML());
            this.setManeuverLocation(loc);
            Node speedNode = doc.selectSingleNode("//speed");
            this.speed = Double.parseDouble(speedNode.getText());
            this.speed_units = speedNode.valueOf("@unit");
            this.bearingRad = Math.toRadians(Double.parseDouble(doc.selectSingleNode("//bearing").getText()));
            this.width = Double.parseDouble(doc.selectSingleNode("//width").getText());
            if (!this.ignoreLength) {
                node = doc.selectSingleNode("//length");
                this.length = node != null ? Double.parseDouble(node.getText()) : this.width;
            }
            this.hstep = Double.parseDouble(doc.selectSingleNode("//hstep").getText());
            this.crossAngleRadians = !this.ignoreCrossAngle ? ((node = doc.selectSingleNode("//crossAngle")) != null ? Math.toRadians(Double.parseDouble(node.getText())) : 0.0) : 0.0;
            node = doc.selectSingleNode("//alternationPercentage");
            this.alternationPercentage = node != null ? (float)Short.parseShort(node.getText()) / 100.0f : 1.0f;
            node = doc.selectSingleNode("//curveOffset");
            this.curvOff = node != null ? Double.parseDouble(node.getText()) : 15.0;
            node = doc.selectSingleNode("//squareCurve");
            this.squareCurve = node != null ? Boolean.parseBoolean(node.getText()) : true;
            node = doc.selectSingleNode("//firstCurveRight");
            this.firstCurveRight = node != null ? Boolean.parseBoolean(node.getText()) : true;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
        finally {
            this.recalcPoints();
        }
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("kind", "automatic");
        Element basePoint = root.addElement("basePoint");
        Element point = this.getManeuverLocation().asElement("point");
        basePoint.add(point);
        Element radTolerance = basePoint.addElement("radiusTolerance");
        radTolerance.setText(String.valueOf(this.getRadiusTolerance()));
        basePoint.addAttribute("type", "pointType");
        root.addElement("width").setText("" + this.width);
        if (!this.ignoreLength) {
            root.addElement("length").setText("" + this.length);
        }
        root.addElement("hstep").setText("" + this.hstep);
        root.addElement("bearing").setText("" + Math.toDegrees(this.bearingRad));
        if (!this.ignoreCrossAngle && this.crossAngleRadians != 0.0) {
            root.addElement("crossAngle").setText("" + Math.toDegrees(this.crossAngleRadians));
        }
        if ((short)(this.alternationPercentage * 100.0f) != 100) {
            root.addElement("alternationPercentage").setText("" + (short)(this.alternationPercentage * 100.0f));
        }
        if (this.curvOff != 15.0) {
            root.addElement("curveOffset").setText("" + this.curvOff);
        }
        if (!this.squareCurve) {
            root.addElement("squareCurve").setText("" + this.squareCurve);
        }
        if (!this.ignoreFirstCurveRight && !this.firstCurveRight) {
            root.addElement("firstCurveRight").setText("" + this.firstCurveRight);
        }
        Element speedElem = root.addElement("speed");
        speedElem.addAttribute("unit", this.speed_units);
        speedElem.setText("" + this.speed);
        return document;
    }

    @Override
    public IMCMessage serializeToIMC() {
        IMCMessage msg = super.serializeToIMC();
        LinkedHashMap<String, Object> customValues = new LinkedHashMap<String, Object>();
        customValues.put("Pattern", this.getName());
        customValues.put("bearingRad", this.bearingRad);
        customValues.put("width", this.width);
        if (!this.ignoreLength) {
            customValues.put("length", this.length);
        }
        customValues.put("hstep", this.hstep);
        customValues.put("sRange", this.sRange);
        if (!this.ignoreCrossAngle) {
            customValues.put("crossAngleRadians", this.crossAngleRadians);
        }
        customValues.put("curvOff", this.curvOff);
        if (!this.ignoreAlternationPercentage) {
            customValues.put("alternationPercentage", Float.valueOf(this.alternationPercentage));
        }
        customValues.put("squareCurve", this.squareCurve);
        if (!this.ignoreFirstCurveRight) {
            customValues.put("firstCurveRight", this.firstCurveRight);
        }
        String customValuesTL = IMCMessage.encodeTupleList(customValues);
        msg.setValue("custom", (Object)customValuesTL);
        return msg;
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        super.parseIMCMessage(message);
        LinkedHashMap customValues = message.getTupleList("custom");
        String pattern = (String)customValues.get("Pattern");
        if (!this.getName().equalsIgnoreCase(pattern)) {
            return;
        }
        String value = (String)customValues.get("bearingRad");
        try {
            this.bearingRad = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        value = (String)customValues.get("width");
        try {
            this.width = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (!this.ignoreLength) {
            value = (String)customValues.get("length");
            try {
                this.length = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        value = (String)customValues.get("hstep");
        try {
            this.hstep = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        value = (String)customValues.get("sRange");
        try {
            this.sRange = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (!this.ignoreCrossAngle) {
            value = (String)customValues.get("crossAngleRadians");
            try {
                this.crossAngleRadians = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        value = (String)customValues.get("curvOff");
        try {
            this.curvOff = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (!this.ignoreAlternationPercentage) {
            value = (String)customValues.get("alternationPercentage");
            try {
                this.alternationPercentage = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        value = (String)customValues.get("squareCurve");
        this.squareCurve = Boolean.parseBoolean(value);
        if (!this.ignoreFirstCurveRight) {
            value = (String)customValues.get("firstCurveRight");
            this.firstCurveRight = Boolean.parseBoolean(value);
        }
        this.recalcPoints();
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        for (Property p : properties) {
            if (p.getName().equals("Width")) {
                this.width = (Double)p.getValue();
                continue;
            }
            if (!this.ignoreLength && p.getName().equals("Length")) {
                this.length = (Double)p.getValue();
                continue;
            }
            if (p.getName().equals("Horizontal Alternation")) {
                this.alternationPercentage = (float)((Short)p.getValue()).shortValue() / 100.0f;
                continue;
            }
            if (p.getName().equals("Speed")) {
                this.speed = (Double)p.getValue();
                continue;
            }
            if (p.getName().equalsIgnoreCase("Speed Units")) {
                this.speed_units = (String)p.getValue();
                continue;
            }
            if (p.getName().equals("Bearing")) {
                this.bearingRad = Math.toRadians((Double)p.getValue());
                continue;
            }
            if (p.getName().equals("Cross Angle")) {
                this.crossAngleRadians = Math.toRadians((Double)p.getValue());
                continue;
            }
            if (p.getName().equals("Horizontal Step")) {
                this.hstep = (Double)p.getValue();
                continue;
            }
            if (p.getName().equalsIgnoreCase("Curve Offset")) {
                this.curvOff = (Double)p.getValue();
                continue;
            }
            if (p.getName().equalsIgnoreCase("Square Curve")) {
                this.squareCurve = (Boolean)p.getValue();
                continue;
            }
            if (this.ignoreFirstCurveRight || !p.getName().equalsIgnoreCase("First Curve Right")) continue;
            this.firstCurveRight = (Boolean)p.getValue();
        }
        this.recalcPoints();
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> props = new Vector<DefaultProperty>();
        if (!this.ignoreLength) {
            DefaultProperty length = PropertiesEditor.getPropertyInstance("Length", Double.class, this.length, true);
            length.setShortDescription("The length of the volume to cover, in meters");
            props.add(length);
        }
        DefaultProperty width = PropertiesEditor.getPropertyInstance("Width", Double.class, this.width, true);
        width.setShortDescription("Width of the volume to cover, in meters");
        props.add(width);
        DefaultProperty halt = PropertiesEditor.getPropertyInstance("Horizontal Alternation", Short.class, (short)(this.alternationPercentage * 100.0f), true);
        halt.setShortDescription("Horizontal alternation in percentage. 100 will make all rows separated by the Horizontal Step");
        props.add(halt);
        DefaultProperty hstep = PropertiesEditor.getPropertyInstance("Horizontal Step", Double.class, this.hstep, true);
        hstep.setShortDescription("Horizontal distance between rows, in meters");
        props.add(hstep);
        DefaultProperty direction = PropertiesEditor.getPropertyInstance("Bearing", Double.class, Math.toDegrees(this.bearingRad), true);
        direction.setShortDescription("The outgoing bearing (from starting location) in degrees");
        props.add(direction);
        if (!this.ignoreCrossAngle) {
            DefaultProperty cross = PropertiesEditor.getPropertyInstance("Cross Angle", Double.class, Math.toDegrees(this.crossAngleRadians), true);
            cross.setShortDescription("The tilt angle of the search box in degrees");
            props.add(cross);
        }
        DefaultProperty speed = PropertiesEditor.getPropertyInstance("Speed", Double.class, this.speed, true);
        speed.setShortDescription("The vehicle's desired speed");
        props.add(speed);
        DefaultProperty speedUnits = PropertiesEditor.getPropertyInstance("Speed Units", String.class, this.speed_units, true);
        speedUnits.setShortDescription("The units to consider in the speed parameters");
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)speedUnits, (PropertyEditor)((Object)new SpeedUnitsEditor()));
        PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)speedUnits, (TableCellRenderer)((Object)new I18nCellRenderer()));
        props.add(speedUnits);
        DefaultProperty curvOffset = PropertiesEditor.getPropertyInstance("Curve Offset", Double.class, this.curvOff, true);
        curvOffset.setShortDescription("The extra length to use for the curve");
        props.add(curvOffset);
        DefaultProperty squareCurveP = PropertiesEditor.getPropertyInstance("Square Curve", Boolean.class, this.squareCurve, true);
        squareCurveP.setShortDescription("If the curve should be square or direct");
        props.add(squareCurveP);
        if (!this.ignoreFirstCurveRight) {
            DefaultProperty firstCurveRightP = PropertiesEditor.getPropertyInstance("First Curve Right", Boolean.class, this.firstCurveRight, true);
            firstCurveRightP.setShortDescription("If the first curve should be to the right or left");
            props.add(firstCurveRightP);
        }
        return props;
    }

    @Override
    public Object clone() {
        RowsPattern clone = (RowsPattern)super.clone();
        clone.bearingRad = this.bearingRad;
        clone.width = this.width;
        clone.length = this.length;
        clone.hstep = this.hstep;
        clone.alternationPercentage = this.alternationPercentage;
        clone.crossAngleRadians = this.crossAngleRadians;
        clone.curvOff = this.curvOff;
        clone.squareCurve = this.squareCurve;
        clone.sRange = this.sRange;
        clone.firstCurveRight = this.firstCurveRight;
        clone.recalcPoints();
        return clone;
    }

    public static void main(String[] args) {
        RowsPattern man = new RowsPattern();
        man.setSpeed(1.0);
        man.setSpeedUnits("m/s");
        man.setSpeed(2.0);
        man.setSpeedUnits("m/s");
        MissionType mission = new MissionType("./missions/rep10/rep10.nmisz");
        StateRenderer2D r2d = new StateRenderer2D(MapGroup.getMapGroupInstance(mission));
        PlanElement pelem = new PlanElement(MapGroup.getMapGroupInstance(mission), null);
        PlanType plan = new PlanType(mission);
        man.getManeuverLocation().setLocation(r2d.getCenter());
        plan.getGraph().addManeuver(man);
        pelem.setPlan(plan);
        r2d.addPostRenderPainter(pelem, "Plan");
        GuiUtils.testFrame(r2d);
        RowsManeuver.unblockNewRows = true;
    }
}

