/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.StationKeeping;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.editor.SpeedUnitsEditor;
import pt.lsts.neptus.gui.editor.renderer.I18nCellRenderer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.maneuvers.StatisticsProvider;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.PlanElement;

public class StationKeeping
extends Maneuver
implements LocatedManeuver,
IMCSerialization,
StatisticsProvider {
    public static final int INFINITY_DURATION = -1;
    public static final double MINIMUM_SK_RADIUS = 20.0;
    private int duration = 60;
    private double radius = 20.0;
    private double speed = 30.0;
    private String speedUnits = "m/s";
    private ManeuverLocation location = new ManeuverLocation();

    @Override
    public Object clone() {
        StationKeeping l = new StationKeeping();
        super.clone(l);
        l.setDuration(this.getDuration());
        l.setManeuverLocation(this.getManeuverLocation().clone());
        l.setRadius(this.getRadius());
        l.setSpeed(this.getSpeed());
        l.setSpeedUnits(this.getSpeedUnits());
        return l;
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("kind", "automatic");
        Element basePoint = root.addElement("basePoint");
        Element point = this.getManeuverLocation().asElement("point");
        basePoint.add(point);
        Element radTolerance = basePoint.addElement("radiusTolerance");
        radTolerance.setText("0");
        basePoint.addAttribute("type", "pointType");
        root.addElement("duration").setText("" + this.getDuration());
        Element trajectory = root.addElement("trajectory");
        Element trajRadius = trajectory.addElement("radius");
        trajRadius.setText(String.valueOf(this.getRadius()));
        trajRadius.addAttribute("type", "float");
        Element velocity = root.addElement("speed");
        velocity.addAttribute("type", "float");
        velocity.addAttribute("unit", this.getSpeedUnits());
        velocity.setText(String.valueOf(this.getSpeed()));
        return document;
    }

    @Override
    public String getType() {
        return "StationKeeping";
    }

    @Override
    public void loadFromXML(String XML) {
        try {
            Document doc = DocumentHelper.parseText((String)XML);
            Node node = doc.selectSingleNode("StationKeeping/basePoint/point");
            ManeuverLocation loc = new ManeuverLocation();
            loc.load(node.asXML());
            this.setManeuverLocation(loc);
            Node speedNode = doc.selectSingleNode("StationKeeping/speed");
            this.setSpeed(Double.parseDouble(speedNode.getText()));
            this.setSpeedUnits(speedNode.valueOf("@unit"));
            this.setDuration(Integer.parseInt(doc.selectSingleNode("StationKeeping/duration").getText()));
            this.setRadius(Double.parseDouble(doc.selectSingleNode("StationKeeping/trajectory/radius").getText()));
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    @Override
    public ManeuverLocation getManeuverLocation() {
        return this.location.clone();
    }

    @Override
    public ManeuverLocation getStartLocation() {
        return this.location.clone();
    }

    @Override
    public ManeuverLocation getEndLocation() {
        return this.location.clone();
    }

    @Override
    public void setManeuverLocation(ManeuverLocation location) {
        this.location = location.clone();
    }

    @Override
    public void translate(double offsetNorth, double offsetEast, double offsetDown) {
        this.location.translatePosition(offsetNorth, offsetEast, offsetDown);
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> props = new Vector<DefaultProperty>();
        if (this.radius < 20.0) {
            this.radius = 20.0;
        }
        DefaultProperty duration = PropertiesEditor.getPropertyInstance("Duration", Integer.class, this.duration, true);
        duration.setShortDescription("The Station Keeping's duration, in seconds (0 means +Infinity)");
        props.add(duration);
        DefaultProperty speed = PropertiesEditor.getPropertyInstance("Speed", Double.class, this.speed, true);
        speed.setShortDescription("The vehicle's desired speed when Station Keeping");
        props.add(speed);
        DefaultProperty speedUnits = PropertiesEditor.getPropertyInstance("Speed Units", String.class, this.speedUnits, true);
        speedUnits.setShortDescription("The units to consider in the speed parameters");
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)speedUnits, (PropertyEditor)((Object)new SpeedUnitsEditor()));
        PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)speedUnits, (TableCellRenderer)((Object)new I18nCellRenderer()));
        props.add(speedUnits);
        DefaultProperty radius = PropertiesEditor.getPropertyInstance("Radius", Double.class, this.radius, true);
        radius.setShortDescription("Radius of the Station Keeping circle. Lower values default to 20.0 meters.");
        props.add(radius);
        return props;
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        for (Property p : properties) {
            if (p.getName().equals("Duration")) {
                this.setDuration((Integer)p.getValue());
                continue;
            }
            if (p.getName().equals("Speed")) {
                this.setSpeed((Double)p.getValue());
                continue;
            }
            if (p.getName().equalsIgnoreCase("Speed Units")) {
                this.setSpeedUnits((String)p.getValue());
                continue;
            }
            if (!p.getName().equals("Radius")) continue;
            this.setRadius(Math.max(20.0, (Double)p.getValue()));
        }
    }

    @Override
    public String getTooltipText() {
        return super.getTooltipText() + "<hr>" + "<br>" + I18n.text("speed") + ": <b>" + (int)this.speed + " " + I18n.text(this.speedUnits) + "</b>" + "<br>" + I18n.text("radius") + ": <b>" + this.radius + " " + I18n.textc("m", "meters") + "</b>" + "<br>" + I18n.text("duration") + ": <b>" + this.duration + " " + I18n.textc("s", "seconds") + "</b><br>";
    }

    public LocationType getLocation() {
        return this.location;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = Math.max(20.0, radius);
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public String getSpeedUnits() {
        return this.speedUnits;
    }

    public void setSpeedUnits(String speedUnits) {
        this.speedUnits = speedUnits;
    }

    protected double getVelocityInMetersPerSeconds() {
        if (this.speedUnits.equals("m/s")) {
            return this.speed;
        }
        if (this.speedUnits.equalsIgnoreCase("Km/h")) {
            return this.speed * 0.2777777777777778;
        }
        if (this.speedUnits.equalsIgnoreCase("MPH")) {
            return this.speed * 0.4471;
        }
        return 0.0;
    }

    @Override
    public void paintOnMap(Graphics2D g2d, PlanElement planElement, StateRenderer2D renderer) {
        super.paintOnMap(g2d, planElement, renderer);
        AffineTransform at = g2d.getTransform();
        g2d.drawLine(-4, -4, 4, 4);
        g2d.drawLine(-4, 4, 4, -4);
        double radius = Math.max(20.0, this.getRadius()) * (double)renderer.getZoom();
        g2d.setColor(new Color(255, 255, 255, 100));
        g2d.fill(new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0));
        g2d.setColor(Color.blue.darker());
        g2d.draw(new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0));
        g2d.setTransform(at);
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        this.setMaxTime((int)message.getDouble("timeout"));
        this.setSpeed(message.getDouble("speed"));
        ManeuverLocation pos = new ManeuverLocation();
        pos.setLatitudeRads(message.getDouble("lat"));
        pos.setLongitudeRads(message.getDouble("lon"));
        pos.setZ(message.getDouble("z"));
        String zunits = message.getString("z_units");
        if (zunits != null) {
            pos.setZUnits(ManeuverLocation.Z_UNITS.valueOf(zunits));
        }
        this.setManeuverLocation(pos);
        String speed_units = message.getString("speed_units");
        if (speed_units.equals("METERS_PS")) {
            this.setSpeedUnits("m/s");
        } else if (speed_units.equals("RPM")) {
            this.setSpeedUnits("RPM");
        } else {
            this.setSpeedUnits("%");
        }
        this.setDuration((int)message.getDouble("duration"));
        this.setRadius(message.getDouble("radius"));
        this.setCustomSettings(message.getTupleList("custom"));
    }

    @Override
    public IMCMessage serializeToIMC() {
        pt.lsts.imc.StationKeeping message = new pt.lsts.imc.StationKeeping();
        ManeuverLocation loc = this.getManeuverLocation();
        loc.convertToAbsoluteLatLonDepth();
        message.setLat(loc.getLatitudeRads());
        message.setLon(loc.getLongitudeRads());
        message.setZ(this.getManeuverLocation().getZ());
        message.setZUnits(this.getManeuverLocation().getZUnits().toString());
        message.setDuration(this.getDuration());
        message.setSpeed(this.getSpeed());
        String speedU = this.getSpeedUnits();
        try {
            if ("m/s".equalsIgnoreCase(speedU)) {
                message.setSpeedUnits(StationKeeping.SPEED_UNITS.METERS_PS);
            } else if ("RPM".equalsIgnoreCase(speedU)) {
                message.setSpeedUnits(StationKeeping.SPEED_UNITS.RPM);
            } else if ("%".equalsIgnoreCase(speedU)) {
                message.setSpeedUnits(StationKeeping.SPEED_UNITS.PERCENTAGE);
            } else if ("percentage".equalsIgnoreCase(speedU)) {
                message.setSpeedUnits(StationKeeping.SPEED_UNITS.PERCENTAGE);
            }
        }
        catch (Exception ex) {
            NeptusLog.pub().error((Object)this, (Throwable)ex);
        }
        message.setRadius(this.getRadius());
        message.setCustom(this.getCustomSettings());
        return message;
    }

    @Override
    public double getCompletionTime(LocationType initialPosition) {
        double speed = this.speed;
        if (this.speedUnits.equalsIgnoreCase("RPM")) {
            speed /= 769.230769231;
        } else if (this.speedUnits.equalsIgnoreCase("%")) {
            speed /= 76.923076923;
        }
        double time = this.getDistanceTravelled(initialPosition) / speed;
        return (double)this.getDuration() + time;
    }

    @Override
    public double getDistanceTravelled(LocationType initialPosition) {
        double meters = this.getStartLocation().getDistanceInMeters(initialPosition);
        return meters;
    }

    @Override
    public double getMaxDepth() {
        return this.getManeuverLocation().getAllZ();
    }

    @Override
    public double getMinDepth() {
        return this.getManeuverLocation().getAllZ();
    }

    @Override
    public Collection<ManeuverLocation> getWaypoints() {
        return Collections.singleton(this.getStartLocation());
    }
}

