/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.types.mission.plan.PlanType;

public class SubPlan
extends Maneuver
implements IMCSerialization {
    protected String planId = "";
    protected String startNodeId = "";
    protected boolean drawSubPlan = true;
    protected PlanElement subplan;

    @Override
    public void loadFromXML(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            this.setPlanId(doc.selectSingleNode("SubPlan/@planId").getText());
            this.setStartNodeId(doc.selectSingleNode("SubPlan/@startNodeId").getText());
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    @Override
    public void paintOnMap(Graphics2D g2d, PlanElement planElement, StateRenderer2D renderer) {
        NeptusLog.pub().info((Object)("<###> " + this.subplan));
        if (this.drawSubPlan) {
            PlanType plan;
            if (this.subplan == null && (plan = planElement.getMissionType().getIndividualPlansList().get(this.planId)) != null) {
                this.subplan = new PlanElement(planElement.getMapGroup(), planElement.getParentMap());
                this.subplan.setPlan(plan);
                this.subplan.setTransp2d(0.6);
            }
            if (this.subplan != null) {
                Graphics2D g2 = (Graphics2D)g2d.create();
                g2.setTransform(new AffineTransform());
                this.subplan.paint(g2, renderer);
            }
        }
        super.paintOnMap(g2d, planElement, renderer);
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> properties = new Vector<DefaultProperty>();
        DefaultProperty plan_id = PropertiesEditor.getPropertyInstance("Plan to execute", String.class, this.getPlanId(), true);
        NeptusLog.pub().info((Object)("<###> " + this.getMissionType()));
        properties.add(plan_id);
        DefaultProperty man_id = PropertiesEditor.getPropertyInstance("Starting Maneuver", String.class, this.getStartNodeId(), true);
        man_id.setShortDescription("Select starting maneuver inside the plan or leave empty for default");
        properties.add(man_id);
        return properties;
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        for (Property p : properties) {
            if (p.getName().equals("Plan to execute")) {
                this.setPlanId((String)p.getValue());
                this.subplan = null;
                continue;
            }
            if (!p.getName().equals("Starting Maneuver")) continue;
            this.setStartNodeId((String)p.getValue());
        }
    }

    @Override
    public String getType() {
        return "SubPlan";
    }

    @Override
    public Object clone() {
        SubPlan u = new SubPlan();
        super.clone(u);
        u.setPlanId(this.getPlanId());
        u.setStartNodeId(this.getStartNodeId());
        return u;
    }

    public SystemPositionAndAttitude ManeuverFunction(SystemPositionAndAttitude lastVehicleState) {
        this.endManeuver();
        return lastVehicleState;
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("kind", "automatic");
        root.addAttribute("planId", this.planId);
        root.addAttribute("startNodeId", this.startNodeId);
        return document;
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        this.setPlanId(message.getAsString("plan_id"));
        this.setStartNodeId(message.getAsString("node_id"));
    }

    @Override
    public IMCMessage serializeToIMC() {
        IMCMessage man = IMCDefinition.getInstance().create("SubPlan", new Object[0]);
        man.setValue("plan_id", (Object)this.getPlanId());
        man.setValue("node_id", (Object)this.getStartNodeId());
        return man;
    }

    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public String getStartNodeId() {
        return this.startNodeId;
    }

    public void setStartNodeId(String startNodeId) {
        this.startNodeId = startNodeId;
    }
}

