/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.TrajectoryPoint;
import pt.lsts.imc.VehicleFormation;
import pt.lsts.imc.VehicleFormationParticipant;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.gui.SelectAllFocusListener;
import pt.lsts.neptus.gui.VehicleChooser;
import pt.lsts.neptus.mp.maneuvers.FollowTrajectory;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;

public class VehicleFormation
extends FollowTrajectory {
    protected Vector<VehicleType> participants = new Vector();
    protected Vector<Double[]> participantOffsets = new Vector();
    protected long startTime = 0L;

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public Vector<Double[]> getParticipantOffsets() {
        return this.participantOffsets;
    }

    public void setParticipantOffsets(Vector<Double[]> participantOffsets) {
        this.participantOffsets = participantOffsets;
    }

    public Vector<VehicleType> getParticipants() {
        return this.participants;
    }

    public void setParticipants(Vector<VehicleType> participants) {
        this.participants = participants;
    }

    @Override
    public Object clone() {
        VehicleFormation clone = new VehicleFormation();
        super.clone(clone);
        clone.speed = this.speed;
        clone.speed_units = this.speed_units;
        clone.setManeuverLocation(this.getManeuverLocation());
        clone.points.addAll(this.points);
        clone.setStartTime(this.getStartTime());
        clone.getParticipants().addAll(this.getParticipants());
        clone.getParticipantOffsets().addAll(this.getParticipantOffsets());
        return clone;
    }

    private Vector<VehicleFormationParticipant> getParticipantsIMC() {
        Vector<VehicleFormationParticipant> msgParticipants = new Vector<VehicleFormationParticipant>();
        if (this.getManeuverLocation() == null || this.points.isEmpty() || this.participants.size() != this.participantOffsets.size()) {
            return msgParticipants;
        }
        for (int i = 0; i < this.participants.size(); ++i) {
            VehicleType participant = this.participants.get(i);
            Double[] offsets = this.participantOffsets.get(i);
            if (offsets.length < 3) continue;
            VehicleFormationParticipant msg = new VehicleFormationParticipant();
            msg.setVid(participant.getImcId().intValue());
            msg.setOffX(offsets[0].doubleValue());
            msg.setOffY(offsets[1].doubleValue());
            msg.setOffZ(offsets[2].doubleValue());
            msgParticipants.add(msg);
        }
        return msgParticipants;
    }

    @Override
    public IMCMessage serializeToIMC() {
        double[] lld = this.getManeuverLocation().getAbsoluteLatLonDepth();
        pt.lsts.imc.VehicleFormation vfMessage = new pt.lsts.imc.VehicleFormation();
        vfMessage.setLat(Math.toRadians(lld[0]));
        vfMessage.setLon(Math.toRadians(lld[1]));
        vfMessage.setZ(this.getManeuverLocation().getZ());
        vfMessage.setZUnits(this.getManeuverLocation().getZUnits().toString());
        vfMessage.setStartTime((double)this.startTime / 1000.0);
        vfMessage.setParticipants(this.getParticipantsIMC());
        vfMessage.setSpeed(this.speed);
        String s_units = this.speed_units;
        if (s_units.equalsIgnoreCase("%")) {
            vfMessage.setSpeedUnits(VehicleFormation.SPEED_UNITS.PERCENTAGE);
        } else if (s_units.equalsIgnoreCase("m/s")) {
            vfMessage.setSpeedUnits(VehicleFormation.SPEED_UNITS.METERS_PS);
        } else {
            vfMessage.setSpeedUnits(VehicleFormation.SPEED_UNITS.RPM);
        }
        double[] absoluteTimes = new double[this.points.size()];
        double lastTime = 0.0;
        for (int i = 0; i < this.points.size(); ++i) {
            absoluteTimes[i] = lastTime += ((double[])this.points.get(i))[3];
        }
        Vector<TrajectoryPoint> trajPoints = new Vector<TrajectoryPoint>();
        for (int i = 0; i < this.points.size(); ++i) {
            TrajectoryPoint point = new TrajectoryPoint();
            point.setX(((double[])this.points.get(i))[0]);
            point.setY(((double[])this.points.get(i))[1]);
            point.setZ(((double[])this.points.get(i))[2]);
            point.setT(((double[])this.points.get(i))[3]);
            trajPoints.add(point);
        }
        vfMessage.setCustom(this.getCustomSettings());
        vfMessage.setPoints(trajPoints);
        return vfMessage;
    }

    @Override
    public void parseIMCMessage(IMCMessage msg) {
        pt.lsts.imc.VehicleFormation formation = null;
        try {
            formation = pt.lsts.imc.VehicleFormation.clone((IMCMessage)msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        super.parseIMCMessage(msg);
        this.setStartTime((long)(formation.getStartTime() * 1000.0));
        Vector msgParticipants = formation.getParticipants();
        this.participants.clear();
        this.participantOffsets.clear();
        for (VehicleFormationParticipant participant : msgParticipants) {
            try {
                VehicleType vt = VehiclesHolder.getVehicleWithImc(new ImcId16(participant.getValue("vid")));
                Double[] offsets = new Double[]{participant.getDouble("off_x"), participant.getDouble("off_y"), participant.getDouble("off_z")};
                NeptusLog.pub().info((Object)("<###> " + vt));
                if (vt == null) continue;
                this.participants.add(vt);
                this.participantOffsets.add(offsets);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document doc = super.getManeuverAsDocument(rootElementName);
        Element root = doc.getRootElement();
        root.addElement("startTime").setText("" + this.startTime);
        Element parts = root.addElement("participants");
        for (int i = 0; i < this.participants.size(); ++i) {
            String veh = this.participants.get(i).toString();
            Element part = parts.addElement("participant");
            part.setText(veh);
            Double[] offs = this.participantOffsets.get(i);
            part.addAttribute("xOffset", offs[0].toString());
            part.addAttribute("yOffset", offs[1].toString());
            part.addAttribute("zOffset", offs[2].toString());
        }
        return doc;
    }

    @Override
    public void loadFromXML(String xml) {
        super.loadFromXML(xml);
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Node node = doc.selectSingleNode("//startTime");
            this.startTime = Long.parseLong(node.getText());
            List list = doc.selectNodes("//participants/participant");
            for (Object o : list) {
                Element el = (Element)o;
                Double[] xyz = new Double[]{Double.parseDouble(el.selectSingleNode("@xOffset").getText()), Double.parseDouble(el.selectSingleNode("@yOffset").getText()), Double.parseDouble(el.selectSingleNode("@zOffset").getText())};
                this.participantOffsets.add(xyz);
                this.participants.add(VehiclesHolder.getVehicleById(el.getText()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected JFormattedTextField getOffsetTextField() {
        JFormattedTextField tfield = new JFormattedTextField(new DecimalFormat("#0.00"));
        tfield.addFocusListener(new SelectAllFocusListener());
        tfield.setText("0.0");
        return tfield;
    }

    @Override
    public void mouseClicked(MouseEvent event, final StateRenderer2D source) {
        final StateRenderer2D r2d = source;
        final Vector editedVehicles = new Vector();
        if (event.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            popup.add("Edit participants").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(r2d), "Edit participants");
                    final JPanel main = new JPanel(new GridLayout(0, 5, 2, 2));
                    JPanel panel = new JPanel(new BorderLayout());
                    final Vector<JFormattedTextField> xOffsetsFields = new Vector<JFormattedTextField>();
                    final Vector<JFormattedTextField> yOffsetsFields = new Vector<JFormattedTextField>();
                    final Vector<JFormattedTextField> zOffsetsFields = new Vector<JFormattedTextField>();
                    final Vector<JLabel> vehicleIds = new Vector<JLabel>();
                    final Vector<JButton> removeBtns = new Vector<JButton>();
                    main.add(new JLabel());
                    main.add(new JLabel("Along-track offset", 0));
                    main.add(new JLabel("Cross-track offset", 0));
                    main.add(new JLabel("Depth offset", 0));
                    main.add(new JLabel());
                    for (int i = 0; i < VehicleFormation.this.participants.size(); ++i) {
                        String vid = VehicleFormation.this.participants.get(i).getId();
                        editedVehicles.add(VehicleFormation.this.participants.get(i));
                        vehicleIds.add(new JLabel(vid));
                        xOffsetsFields.add(VehicleFormation.this.getOffsetTextField());
                        ((JFormattedTextField)xOffsetsFields.lastElement()).setText("" + VehicleFormation.this.participantOffsets.get(i)[0]);
                        yOffsetsFields.add(VehicleFormation.this.getOffsetTextField());
                        ((JFormattedTextField)yOffsetsFields.lastElement()).setText("" + VehicleFormation.this.participantOffsets.get(i)[1]);
                        zOffsetsFields.add(VehicleFormation.this.getOffsetTextField());
                        ((JFormattedTextField)zOffsetsFields.lastElement()).setText("" + VehicleFormation.this.participantOffsets.get(i)[2]);
                        JButton rmBtn = new JButton("remove");
                        rmBtn.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                int id = removeBtns.indexOf(e.getSource());
                                main.remove((Component)vehicleIds.get(id));
                                main.remove((Component)xOffsetsFields.get(id));
                                main.remove((Component)yOffsetsFields.get(id));
                                main.remove((Component)zOffsetsFields.get(id));
                                main.remove((JButton)e.getSource());
                                editedVehicles.remove(id);
                                removeBtns.remove(id);
                                xOffsetsFields.remove(id);
                                yOffsetsFields.remove(id);
                                zOffsetsFields.remove(id);
                                vehicleIds.remove(id);
                                main.invalidate();
                                main.revalidate();
                            }
                        });
                        removeBtns.add(rmBtn);
                        main.add((Component)vehicleIds.lastElement());
                        main.add((Component)xOffsetsFields.lastElement());
                        main.add((Component)yOffsetsFields.lastElement());
                        main.add((Component)zOffsetsFields.lastElement());
                        main.add(rmBtn);
                    }
                    JPanel controls = new JPanel(new FlowLayout(2, 2, 2));
                    JButton btn1 = new JButton("Add Participant");
                    btn1.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            VehicleType vt = VehicleChooser.showVehicleDialog(editedVehicles, null, null);
                            if (vt != null) {
                                editedVehicles.add(vt);
                                vehicleIds.add(new JLabel(vt.getId()));
                                xOffsetsFields.add(VehicleFormation.this.getOffsetTextField());
                                yOffsetsFields.add(VehicleFormation.this.getOffsetTextField());
                                zOffsetsFields.add(VehicleFormation.this.getOffsetTextField());
                                JButton rmBtn = new JButton("remove");
                                rmBtn.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        int id = removeBtns.indexOf(e.getSource());
                                        main.remove((Component)vehicleIds.get(id));
                                        main.remove((Component)xOffsetsFields.get(id));
                                        main.remove((Component)yOffsetsFields.get(id));
                                        main.remove((Component)zOffsetsFields.get(id));
                                        main.remove((JButton)e.getSource());
                                        editedVehicles.remove(id);
                                        removeBtns.remove(id);
                                        xOffsetsFields.remove(id);
                                        yOffsetsFields.remove(id);
                                        zOffsetsFields.remove(id);
                                        vehicleIds.remove(id);
                                        main.invalidate();
                                        main.revalidate();
                                    }
                                });
                                removeBtns.add(rmBtn);
                                main.add((Component)vehicleIds.lastElement());
                                main.add((Component)xOffsetsFields.lastElement());
                                main.add((Component)yOffsetsFields.lastElement());
                                main.add((Component)zOffsetsFields.lastElement());
                                main.add(rmBtn);
                                main.invalidate();
                                main.revalidate();
                            }
                        }
                    });
                    controls.add(btn1);
                    JButton btn2 = new JButton("Cancel");
                    btn2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            SwingUtilities.getWindowAncestor((JButton)arg0.getSource()).setVisible(false);
                        }
                    });
                    controls.add(btn2);
                    JButton btn3 = new JButton("OK");
                    btn3.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            VehicleFormation.this.participants.clear();
                            VehicleFormation.this.participantOffsets.clear();
                            for (int i = 0; i < editedVehicles.size(); ++i) {
                                double x = 0.0;
                                double y = 0.0;
                                double z = 0.0;
                                VehicleFormation.this.participants.add((VehicleType)editedVehicles.get(i));
                                try {
                                    x = Double.parseDouble(((JFormattedTextField)xOffsetsFields.get(i)).getText().replace(',', '.'));
                                    y = Double.parseDouble(((JFormattedTextField)yOffsetsFields.get(i)).getText().replace(',', '.'));
                                    z = Double.parseDouble(((JFormattedTextField)zOffsetsFields.get(i)).getText().replace(',', '.'));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                VehicleFormation.this.participantOffsets.add(new Double[]{x, y, z});
                            }
                            SwingUtilities.getWindowAncestor((JButton)arg0.getSource()).setVisible(false);
                        }
                    });
                    controls.add(btn3);
                    panel.add((Component)main, "Center");
                    panel.add((Component)controls, "South");
                    dialog.getContentPane().add(panel);
                    dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                    dialog.setSize(600, 180);
                    GuiUtils.centerParent(dialog, SwingUtilities.getWindowAncestor(r2d));
                    dialog.setVisible(true);
                }
            });
            popup.addSeparator();
            popup.add("Edit points as text").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VehicleFormation.this.editPointsDialog(SwingUtilities.getWindowAncestor(source));
                }
            });
            popup.add("Clear trajectory").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VehicleFormation.this.points.clear();
                    r2d.repaint();
                }
            });
            popup.add("Stop editing " + this.getId()).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    r2d.setActiveInteraction(null);
                }
            });
            popup.show(source, event.getX(), event.getY());
        } else if (event.getClickCount() == 1) {
            Point clicked = event.getPoint();
            LocationType curLoc = source.getRealWorldLocation(clicked);
            double _speed = this.speed;
            if (this.speed_units.equalsIgnoreCase("RPM")) {
                _speed /= 769.2307692307692;
            } else if (this.speed_units.equalsIgnoreCase("%")) {
                _speed /= 76.92307692307692;
            }
            double[] offsets = source.getRealWorldLocation(clicked).getOffsetFrom(this.startLoc);
            double[] xyzt = new double[4];
            for (int i = 0; i < 3; ++i) {
                xyzt[i] = offsets[i];
            }
            if (this.hasTime) {
                double distance = this.previousLoc != null ? curLoc.getDistanceInMeters(this.previousLoc) : curLoc.getDistanceInMeters(this.startLoc);
                xyzt[3] = distance / _speed;
            } else {
                xyzt[3] = -1.0;
            }
            boolean skip = false;
            if (!event.isAltDown() && !event.isAltGraphDown()) {
                if (this.points.size() == 0) {
                    this.points.add(new double[]{0.0, 0.0, 0.0, this.hasTime ? 0.0 : -1.0});
                }
            } else if (this.points.size() > 0) {
                this.points.remove(this.points.size() - 1);
                skip = true;
            }
            if (!skip) {
                this.points.add(xyzt);
                this.previousLoc = curLoc;
            }
            source.repaint();
        }
        this.adapter.mouseClicked(event, source);
    }

    public static void main(String[] args) {
        VehicleFormation formation = new VehicleFormation();
        NeptusLog.pub().info((Object)("<###> " + FileUtil.getAsPrettyPrintFormatedXMLString(formation.getManeuverAsDocument("VehicleFormation"))));
    }
}

