/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.maneuvers;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.beans.PropertyEditor;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.YoYo;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.GotoParameters;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.editor.AngleEditorRads;
import pt.lsts.neptus.gui.editor.SpeedUnitsEditor;
import pt.lsts.neptus.gui.editor.renderer.I18nCellRenderer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.NameNormalizer;

public class YoYo
extends Maneuver
implements IMCSerialization,
LocatedManeuver {
    double speed = 1000.0;
    double speedTolerance = 100.0;
    double amplitude = 2.0;
    float pitchAngle = 0.7853982f;
    String units = "RPM";
    ManeuverLocation destination = new ManeuverLocation();
    protected static final String DEFAULT_ROOT_ELEMENT = "YoYo";
    private GotoParameters params = new GotoParameters();
    private final int ANGLE_CALCULATION = -1;
    private final int FIRST_ROTATE = 0;
    private final int HORIZONTAL_MOVE = 1;
    int current_state = -1;
    private double targetAngle;
    private double rotateIncrement;
    public String id = NameNormalizer.getRandomID();
    private int count = 0;

    @Override
    public String getType() {
        return DEFAULT_ROOT_ELEMENT;
    }

    @Override
    public Document getManeuverAsDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("kind", "automatic");
        Element finalPoint = root.addElement("finalPoint");
        finalPoint.addAttribute("type", "pointType");
        Element point = this.destination.asElement("point");
        finalPoint.add(point);
        Element radTolerance = finalPoint.addElement("radiusTolerance");
        radTolerance.setText("0");
        Element velocity = root.addElement("speed");
        velocity.addAttribute("tolerance", String.valueOf(this.getSpeedTolerance()));
        velocity.addAttribute("type", "float");
        velocity.addAttribute("unit", this.getUnits());
        velocity.setText(String.valueOf(this.getSpeed()));
        Element amplitude = root.addElement("amplitude");
        amplitude.setText(String.valueOf(this.getAmplitude()));
        Element pitchAngle = root.addElement("pitch");
        pitchAngle.setText(String.valueOf(this.getPitchAngle()));
        return document;
    }

    @Override
    public void loadFromXML(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Node node = doc.selectSingleNode("YoYo/finalPoint/point");
            ManeuverLocation loc = new ManeuverLocation();
            loc.load(node.asXML());
            this.setManeuverLocation(loc);
            this.setAmplitude(Double.parseDouble(doc.selectSingleNode("YoYo/amplitude").getText()));
            this.setPitchAngle(Float.parseFloat(doc.selectSingleNode("YoYo/pitch").getText()));
            Node speedNode = doc.selectSingleNode("YoYo/speed");
            if (speedNode == null) {
                speedNode = doc.selectSingleNode("YoYo/velocity");
            }
            this.setSpeed(Double.parseDouble(speedNode.getText()));
            String speedUnit = speedNode.valueOf("@unit");
            this.setSpeedUnits(speedUnit);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return;
        }
    }

    public SystemPositionAndAttitude ManeuverFunction(SystemPositionAndAttitude lastVehicleState) {
        SystemPositionAndAttitude nextVehicleState = lastVehicleState.clone();
        switch (this.current_state) {
            case -1: {
                double angleDiff;
                this.targetAngle = lastVehicleState.getPosition().getXYAngle(this.destination);
                for (angleDiff = this.targetAngle - lastVehicleState.getYaw(); angleDiff < 0.0; angleDiff += Math.PI * 2) {
                }
                while (angleDiff > Math.PI * 2) {
                    angleDiff -= Math.PI * 2;
                }
                if (angleDiff > Math.PI) {
                    angleDiff -= Math.PI * 2;
                }
                this.rotateIncrement = angleDiff / 3.0;
                this.count = 0;
                this.current_state = 0;
                nextVehicleState = this.ManeuverFunction(lastVehicleState);
                break;
            }
            case 0: {
                if (this.count++ < 3) {
                    nextVehicleState.rotateXY(this.rotateIncrement);
                    break;
                }
                nextVehicleState.setYaw(this.targetAngle);
                this.current_state = 1;
                break;
            }
            case 1: {
                double calculatedSpeed = 1.0;
                if (this.units.equals("m/s")) {
                    calculatedSpeed = this.speed;
                } else if (this.units.equals("RPM")) {
                    calculatedSpeed = this.speed / 500.0;
                }
                double dist = nextVehicleState.getPosition().getHorizontalDistanceInMeters(this.destination);
                if (dist <= calculatedSpeed) {
                    nextVehicleState.setPosition(this.destination);
                    this.endManeuver();
                    break;
                }
                nextVehicleState.moveForward(calculatedSpeed);
                double depthDiff = this.destination.getDepth() - nextVehicleState.getPosition().getDepth();
                double depthIncr = depthDiff / (dist / calculatedSpeed);
                double curDepth = nextVehicleState.getPosition().getDepth();
                nextVehicleState.getPosition().setDepth(curDepth + depthIncr);
                break;
            }
            default: {
                this.endManeuver();
            }
        }
        return nextVehicleState;
    }

    @Override
    public Object clone() {
        YoYo clone = new YoYo();
        super.clone(clone);
        clone.params = this.params;
        clone.setManeuverLocation(this.destination.clone());
        clone.setAmplitude(this.getAmplitude());
        clone.setPitchAngle(this.getPitchAngle());
        clone.setSpeedUnits(this.getUnits());
        clone.setSpeed(this.getSpeed());
        clone.setSpeedTolerance(this.getSpeedTolerance());
        return clone;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(double amplitude) {
        this.amplitude = amplitude;
    }

    public float getPitchAngle() {
        return this.pitchAngle;
    }

    public void setPitchAngle(float pitchAngle) {
        this.pitchAngle = pitchAngle;
    }

    public String getUnits() {
        return this.units;
    }

    public void setSpeedUnits(String units) {
        this.units = units;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeedTolerance() {
        return this.speedTolerance;
    }

    public void setSpeedTolerance(double speedTolerance) {
        this.speedTolerance = speedTolerance;
    }

    @Override
    public void translate(double offsetNorth, double offsetEast, double offsetDown) {
        this.destination.translatePosition(offsetNorth, offsetEast, offsetDown);
    }

    @Override
    protected Vector<DefaultProperty> additionalProperties() {
        Vector<DefaultProperty> properties = new Vector<DefaultProperty>();
        DefaultProperty units = PropertiesEditor.getPropertyInstance("Speed units", String.class, this.getUnits(), true);
        units.setShortDescription("The speed units");
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)units, (PropertyEditor)((Object)new SpeedUnitsEditor()));
        PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)units, (TableCellRenderer)((Object)new I18nCellRenderer()));
        properties.add(PropertiesEditor.getPropertyInstance("Speed", Double.class, this.getSpeed(), true));
        properties.add(units);
        properties.add(PropertiesEditor.getPropertyInstance("Amplitude", Double.class, this.getAmplitude(), true));
        DefaultProperty ap = PropertiesEditor.getPropertyInstance("Pitch angle", Float.class, Float.valueOf(this.getPitchAngle()), true);
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)ap, AngleEditorRads.class);
        properties.add(ap);
        return properties;
    }

    @Override
    public String getPropertiesDialogTitle() {
        return this.getId() + " parameters";
    }

    @Override
    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        for (Property p : properties) {
            if (p.getName().equals("Speed units")) {
                this.setSpeedUnits((String)p.getValue());
            }
            if (p.getName().equals("Speed tolerance")) {
                this.setSpeedTolerance((Double)p.getValue());
            }
            if (p.getName().equals("Speed")) {
                this.setSpeed((Double)p.getValue());
            }
            if (p.getName().equals("Amplitude")) {
                this.setAmplitude((Double)p.getValue());
            }
            if (!p.getName().equals("Pitch angle")) continue;
            this.setPitchAngle(((Float)p.getValue()).floatValue());
        }
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return super.getPropertiesErrors(properties);
    }

    @Override
    public ManeuverLocation getManeuverLocation() {
        return this.destination.clone();
    }

    @Override
    public ManeuverLocation getStartLocation() {
        return this.destination.clone();
    }

    @Override
    public ManeuverLocation getEndLocation() {
        return this.destination.clone();
    }

    @Override
    public void setManeuverLocation(ManeuverLocation location) {
        this.destination = location.clone();
    }

    @Override
    public String getTooltipText() {
        NumberFormat nf = GuiUtils.getNeptusDecimalFormat(2);
        return super.getTooltipText() + "<hr>" + I18n.text("speed") + ": <b>" + nf.format(this.getSpeed()) + " " + this.getUnits() + "</b>" + "<br>" + I18n.text(this.destination.getZUnits().toString()) + ": <b>" + nf.format(this.destination.getZ()) + " " + I18n.textc("m", "meters") + "</b>" + "<br>" + I18n.text("amplitude") + ": <b>" + nf.format(this.getAmplitude()) + " " + I18n.textc("m", "meters") + "</b>" + "<br>" + I18n.text("pitch") + ": <b>" + nf.format(Math.toDegrees(this.getPitchAngle())) + " \u00b0</b>";
    }

    @Override
    public void parseIMCMessage(IMCMessage message) {
        this.setMaxTime((int)message.getDouble("timeout"));
        this.setSpeed(message.getDouble("speed"));
        this.setAmplitude(message.getDouble("amplitude"));
        this.setPitchAngle((float)message.getDouble("pitch"));
        ManeuverLocation pos = new ManeuverLocation();
        pos.setLatitudeRads(message.getDouble("lat"));
        pos.setLongitudeRads(message.getDouble("lon"));
        pos.setZ(message.getDouble("z"));
        pos.setZUnits(ManeuverLocation.Z_UNITS.valueOf(message.getString("z_units")));
        this.setManeuverLocation(pos);
        String speed_units = message.getString("speed_units");
        if (speed_units.equals("METERS_PS")) {
            this.setSpeedUnits("m/s");
        } else if (speed_units.equals("RPM")) {
            this.setSpeedUnits("RPM");
        } else {
            this.setSpeedUnits("%");
        }
        this.setCustomSettings(message.getTupleList("custom"));
    }

    @Override
    public IMCMessage serializeToIMC() {
        pt.lsts.imc.YoYo yoyo = new pt.lsts.imc.YoYo();
        ManeuverLocation loc = this.getManeuverLocation();
        loc.convertToAbsoluteLatLonDepth();
        yoyo.setTimeout(this.getMaxTime());
        yoyo.setLat(loc.getLatitudeRads());
        yoyo.setLon(loc.getLongitudeRads());
        yoyo.setZ(this.getManeuverLocation().getZ());
        yoyo.setZUnits(this.getManeuverLocation().getZUnits().toString());
        yoyo.setSpeed(this.getSpeed());
        yoyo.setAmplitude(this.getAmplitude());
        yoyo.setPitch((double)this.getPitchAngle());
        String speedU = this.getUnits();
        try {
            if ("m/s".equalsIgnoreCase(speedU)) {
                yoyo.setSpeedUnits(YoYo.SPEED_UNITS.METERS_PS);
            } else if ("RPM".equalsIgnoreCase(speedU)) {
                yoyo.setSpeedUnits(YoYo.SPEED_UNITS.RPM);
            } else if ("%".equalsIgnoreCase(speedU)) {
                yoyo.setSpeedUnits(YoYo.SPEED_UNITS.PERCENTAGE);
            } else if ("percentage".equalsIgnoreCase(speedU)) {
                yoyo.setSpeedUnits(YoYo.SPEED_UNITS.PERCENTAGE);
            }
        }
        catch (Exception ex) {
            NeptusLog.pub().error((Object)this, (Throwable)ex);
        }
        yoyo.setCustom(this.getCustomSettings());
        return yoyo;
    }

    public static void main(String[] args) {
        YoYo g = new YoYo();
        PropertiesEditor.editProperties(g, true);
        PropertiesEditor.editProperties(g, true);
    }

    @Override
    public Collection<ManeuverLocation> getWaypoints() {
        return Collections.singleton(this.getStartLocation());
    }
}

