/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview;

import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.Elevator;
import pt.lsts.neptus.mp.preview.IManeuverPreview;
import pt.lsts.neptus.mp.preview.SpeedConversion;
import pt.lsts.neptus.mp.preview.UnicycleModel;
import pt.lsts.neptus.types.coord.LocationType;

public class ElevatorPreview
implements IManeuverPreview<Elevator> {
    protected ManeuverLocation destination;
    protected double speed;
    protected double radius;
    protected double startZ;
    protected double endZ;
    protected boolean finished = false;
    protected boolean clockwise = true;
    protected String loiterType;
    UnicycleModel model = new UnicycleModel();

    @Override
    public boolean init(String vehicleId, Elevator man, SystemPositionAndAttitude state, Object manState) {
        if (man.startFromCurrentPosition) {
            LocationType loc = new LocationType(state.getPosition());
            loc.translatePosition(0.0, man.getRadius() + 5.0f, 0.0);
            this.destination = new ManeuverLocation();
            this.destination.setLocation(loc);
            this.destination.setZ(man.getEndLocation().getZ());
            this.destination.setZUnits(man.getEndLocation().getZUnits());
            this.startZ = this.endZ = (double)man.getEndZ();
        } else {
            this.destination = man.getEndLocation().clone();
            this.startZ = man.getStartZ();
            this.endZ = man.getEndZ();
        }
        if (this.destination.getZUnits() == ManeuverLocation.Z_UNITS.DEPTH) {
            this.destination.setDepth(this.startZ);
        } else if (this.destination.getZUnits() == ManeuverLocation.Z_UNITS.ALTITUDE) {
            this.destination.setDepth(-this.startZ);
        } else {
            this.destination.setDepth(0.0);
        }
        this.clockwise = true;
        this.radius = man.getRadius();
        this.speed = man.getSpeed();
        if (man.getSpeedUnits().equals("RPM")) {
            this.speed = SpeedConversion.convertRpmtoMps(this.speed);
        } else if (man.getSpeedUnits().equals("%")) {
            this.speed = SpeedConversion.convertPercentageToMps(this.speed);
        }
        this.speed = Math.min(this.speed, 2.0);
        this.model.setState(state);
        return true;
    }

    @Override
    public SystemPositionAndAttitude step(SystemPositionAndAttitude state, double timestep) {
        this.model.setState(state);
        double distToDestination = state.getPosition().getHorizontalDistanceInMeters(this.destination);
        if (distToDestination - 2.0 > this.radius) {
            this.model.guide(this.destination, this.speed, this.destination.getDepth() >= 0.0 ? null : Double.valueOf(-this.destination.getDepth()));
        } else {
            double perpend = state.getPosition().getXYAngle(this.destination) + 1.5707963267948966;
            LocationType loc = new LocationType(state.getPosition());
            loc.setDepth(this.endZ);
            loc.translatePosition(Math.cos(perpend) * -20.0, Math.sin(perpend) * -20.0, 0.0);
            this.model.guide(loc, this.speed, this.destination.getDepth() >= 0.0 ? null : Double.valueOf(-this.destination.getDepth()));
        }
        this.model.advance(timestep);
        if (Math.abs(state.getPosition().getDepth() - this.endZ) < 0.5) {
            this.finished = true;
        }
        return this.model.getState();
    }

    @Override
    public Object getState() {
        return null;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void reset(SystemPositionAndAttitude state) {
        this.model.setState(state);
    }
}

