/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mp.preview;

import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.Loiter;
import pt.lsts.neptus.mp.preview.IManeuverPreview;
import pt.lsts.neptus.mp.preview.SpeedConversion;
import pt.lsts.neptus.mp.preview.UnicycleModel;
import pt.lsts.neptus.types.coord.LocationType;

public class LoiterPreview
implements IManeuverPreview<Loiter> {
    protected LocationType destination;
    protected double speed;
    protected double radius;
    protected double duration;
    protected boolean finished = false;
    protected boolean clockwise = true;
    protected String loiterType;
    protected double loiterTime = 0.0;
    protected boolean enteredLoiter = false;
    UnicycleModel model = new UnicycleModel();

    @Override
    public boolean init(String vehicleId, Loiter man, SystemPositionAndAttitude state, Object manState) {
        this.enteredLoiter = false;
        this.destination = new LocationType(man.getManeuverLocation());
        if (man.getManeuverLocation().getZUnits() == ManeuverLocation.Z_UNITS.DEPTH) {
            this.destination.setDepth(man.getManeuverLocation().getZ());
        } else if (man.getManeuverLocation().getZUnits() == ManeuverLocation.Z_UNITS.ALTITUDE) {
            this.destination.setDepth(-man.getManeuverLocation().getZ());
        } else {
            this.destination.setDepth(0.0);
        }
        this.clockwise = man.getDirection().equalsIgnoreCase("Clockwise");
        this.radius = man.getRadius();
        this.loiterType = man.getLoiterType();
        this.duration = man.getLoiterDuration();
        this.speed = man.getSpeed();
        if (man.getSpeedUnits().equals("RPM")) {
            this.speed = SpeedConversion.convertRpmtoMps(this.speed);
        } else if (man.getSpeedUnits().equals("%")) {
            this.speed = SpeedConversion.convertPercentageToMps(this.speed);
        }
        this.speed = Math.min(this.speed, 2.0);
        if (manState != null && manState instanceof Double) {
            this.loiterTime = (Double)manState;
        }
        this.model.setState(state);
        return true;
    }

    @Override
    public SystemPositionAndAttitude step(SystemPositionAndAttitude state, double timestep) {
        this.model.setState(state);
        double distToDestination = state.getPosition().getDistanceInMeters(this.destination);
        if (this.loiterType.equalsIgnoreCase("circular")) {
            if (distToDestination - 2.0 > this.radius) {
                this.model.guide(this.destination, this.speed, this.destination.getDepth() >= 0.0 ? null : Double.valueOf(-this.destination.getDepth()));
                if (!this.enteredLoiter) {
                    this.loiterTime = 0.0;
                }
            } else {
                this.enteredLoiter = true;
                double perpend = state.getPosition().getXYAngle(this.destination) + 1.5707963267948966;
                LocationType loc = new LocationType(state.getPosition());
                loc.setDepth(this.destination.getDepth());
                if (this.clockwise) {
                    loc.translatePosition(Math.cos(perpend) * -20.0, Math.sin(perpend) * -20.0, 0.0);
                } else {
                    loc.translatePosition(Math.cos(perpend) * 20.0, Math.sin(perpend) * 20.0, 0.0);
                }
                this.model.guide(loc, this.speed, this.destination.getDepth() >= 0.0 ? null : Double.valueOf(-this.destination.getDepth()));
                this.loiterTime += timestep;
            }
        } else if (distToDestination < this.speed * 2.0) {
            this.loiterTime += timestep;
        } else {
            this.model.guide(this.destination, this.speed, this.destination.getDepth() >= 0.0 ? null : Double.valueOf(-this.destination.getDepth()));
        }
        this.model.advance(timestep);
        if (this.loiterTime > this.duration) {
            this.finished = true;
        }
        return this.model.getState();
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void reset(SystemPositionAndAttitude state) {
        this.model.setState(state);
    }

    @Override
    public Object getState() {
        return new Double(this.loiterTime);
    }
}

